<?php
// $Id: test_form_class.php,v 1.7 2007/09/24 07:06:10 ohwada Exp $

// 2007-09-20 K.OHWADA
// geust modify link

// 2007-09-01 K.OHWADA
// get_form_values()

// 2007-05-18 K.OHWADA
// XC 2.1

// 2007-02-20 K.OHWADA
// admin_add_cat_add_cat()
// performance mode

// 2006-12-10 K.OHWADA
// use build_link_record

//=========================================================
// WebLinks Module
// 2006-09-20 K.OHWADA
//=========================================================

//---------------------------------------------------------
// TODO
// cannot parse textarea tag from result
//---------------------------------------------------------

//=========================================================
// class weblinks_test_form
//=========================================================
class weblinks_test_form extends weblinks_gen_record
{
	var $_UNAME_ADMIN  = 'admin';
	var $_PASS_ADMIN   = 'admin';
	var $_UNAME_USER   = 'tester';
	var $_PASS_USER    = 'tester';
	var $_UNAME_OTHER  = 'tester2';
	var $_PASS_OTHER   = 'tester2';

	var $_snoopy;

	var $_user_submit_url;
	var $_user_modify_url;

	var $_lid   = null;
	var $_newid = null;
	var $_build_form_array = null;

	var $_flag_print_body = true;

	var $_DEBUG_PRINT_SUBMIT     = false;
	var $_DEBUG_PRINT_RESULT     = false;
	var $_DEBUG_PRINT_FORM       = false;
	var $_DEBUG_PRINT_FORM_VALUE = false;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_test_form()
{
	$this->weblinks_gen_record();

	$this->_snoopy   =& new Snoopy();

	$this->_user_submit_url = WEBLINKS_URL.'/submit.php';
	$this->_user_modify_url = WEBLINKS_URL.'/modlink.php';

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_test_form();
	}
	return $instance;
}

//---------------------------------------------------------
// login
//---------------------------------------------------------
function login_admin()
{
	$ret = $this->login($this->_UNAME_ADMIN, $this->_PASS_ADMIN);
	return $ret;
}

function login_user()
{
	$ret = $this->login($this->_UNAME_USER, $this->_PASS_USER);
	return $ret;
}

function login_other()
{
	$ret = $this->login($this->_UNAME_OTHER, $this->_PASS_OTHER);
	return $ret;
}

function login($uname, $pass)
{
	$url = XOOPS_URL.'/user.php';

	$form = array(
		'uname' => $uname,
		'pass'  => $pass,
		'op'    => 'login',
	);

	$ret = $this->_snoopy->submit($url, $form);
	if ( !$ret )
	{
		echo "Error: cannnot connect login form: $url <br />\n";
		$this->print_body();
		return false;
	}

	$ret = $this->match_result( _US_INCORRECTLOGIN );
	if ( $ret )
	{
		echo "Error: user name is worng: <b>$uname</b> <br />\n";
		$this->print_body();
		return false;
	}

	$ret = $this->get_cookies();
	return $ret;
}

function logout( $flag=true )
{
	$url = XOOPS_URL.'/user.php?op=logout';
	$this->fetch($url);

	if ( $flag )
	{
		$ret = $this->match_result( _US_LOGGEDOUT );
		if ( !$ret )
		{
			echo "Error: cannot logout <br />\n";
			$this->print_body();
			return false;
		}
	}

	$ret = $this->get_cookies();
	return $ret;
}

function get_cookies()
{
	$this->_snoopy->setcookies();
	$cookies = $this->_snoopy->cookies;
	if ( !is_array($cookies) || (count($cookies) == 0) )
	{
		echo "Error: login failed: cannot get cookie <br />\n";
		$this->print_body();
		return false;
	}
	return $cookies;
}

//---------------------------------------------------------
// fetch_form
//---------------------------------------------------------
function fetch($url)
{
	$ret = $this->_snoopy->fetch($url);
	if ( !$ret )
	{
		echo "Error: cannnot fetch : $url <br />\n";
		$this->print_body();
		return false;
	}
	return true;
}

function fetch_form($url)
{
	$this->print_debug( "fetch_form($url)" );

	$ret = $this->_snoopy->fetchform($url);
	if ( !$ret )
	{
		echo "Error: cannnot fetch form: $url <br />\n";
		$this->print_body();
		return false;
	}
	return true;
}

//---------------------------------------------------------
// get_form_values
//---------------------------------------------------------
function get_form_values( $result=null )
{
	$arr = array();
	$cid_arr = array();

	if (empty($result))
	{
		$result = $this->_snoopy->results;
	}

	if ( $this->_DEBUG_PRINT_RESULT )
	{
		echo "<hr />\n";
		echo "<b>result</b><br />\n";
		echo $result;
		echo "<hr />\n";
	}

	$pattern11 = '/<form.*action="([\w|\/|\.]+)".*>(.*)<\/form>/Usi';
	$pattern21 = '|<.*name="(\w+)".*value="(.*)".*/>|Usi';
	$pattern31 = '|<select.*name="(\w+)".*>(.*)</select>|Usi';
	$pattern32 = '|<option(.*)>.*</option>|Usi';
	$pattern33 = '|value="(\w+)".*selected|i';
	$pattern41 = '|<.*type="radio"(.*)/>|Usi';
	$pattern42 = '|name="(\w+)".*value="(\w+)".*checked|i';
	$pattern51 = '|<.*type="checkbox"(.*)/>|Usi';
	$pattern61 = '/<textarea.*name=["|\'](\w+)["|\'].*>(.*)<\/textarea>/Usi';
	$pattern71 = '|<select.*name="cid\[\]".*>(.*)</select>|Usi';

// form
	$form = null;
	if ( preg_match( $pattern11, $result, $match11 ) )
	{
		$arr['action'] = $match11[1];
		$form          = $match11[2];
	}

	if ( $this->_DEBUG_PRINT_FORM )
	{
		echo "<hr />\n";
		echo "<b>form</b><br />\n";
		echo $form;
		echo "<hr />\n";
	}

// input
	preg_match_all( $pattern21, $form, $matches21, PREG_SET_ORDER );
	for ($i=0; $i< count($matches21); $i++) 
	{
		if ( isset($matches21[$i][1]) && isset($matches21[$i][2]) )
		{
			$arr[ $matches21[$i][1] ] = happy_linux_undo_htmlspecialchars( $matches21[$i][2] );
		}
	}

// select
	preg_match_all( $pattern31, $form, $matches31, PREG_SET_ORDER );
	for ($i=0; $i< count($matches31); $i++) 
	{
		preg_match_all( $pattern32, $matches31[$i][2], $matches32, PREG_SET_ORDER );
		for ($j=0; $j< count($matches32); $j++) 
		{
			if ( preg_match( $pattern33, $matches32[$j][1], $match33 ) )
			{
				$arr[ $matches31[$i][1] ] = $match33[1];
			}
		}
	}

// radio
	preg_match_all( $pattern41, $form, $matches41, PREG_SET_ORDER );
	for ($i=0; $i< count($matches41); $i++) 
	{
		if ( preg_match( $pattern42, $matches41[$i][1], $match42 ) )
		{
			$arr[ $match42[1] ] = trim( $match42[2] );
		}
	}

// checkbox
	preg_match_all( $pattern51, $form, $matches51, PREG_SET_ORDER );
	for ($i=0; $i< count($matches51); $i++) 
	{
		if ( preg_match( $pattern42, $matches51[$i][1], $match42 ) )
		{
			$arr[ $match42[1] ] = trim( $match42[2] );
		}
	}

// textarea
	preg_match_all( $pattern61, $form, $matches61, PREG_SET_ORDER );
	for ($i=0; $i< count($matches61); $i++) 
	{
		if ( isset($matches61[$i][1]) && isset($matches61[$i][2]) )
		{
			$arr[ $matches61[$i][1] ] = trim( $matches61[$i][2] );
		}
	}

// cid
	preg_match_all( $pattern71, $form, $matches71, PREG_SET_ORDER );
	for ($i=0; $i< count($matches71); $i++) 
	{
		preg_match_all( $pattern32, $matches71[$i][1], $matches32, PREG_SET_ORDER );
		for ($j=0; $j< count($matches32); $j++) 
		{
			if ( preg_match( $pattern33, $matches32[$j][1], $match33 ) )
			{
				$cid_arr[] = $match33[1];
			}
		}
		$arr['cid_arr'] = $cid_arr;
	}

	if ( $this->_DEBUG_PRINT_FORM_VALUE )
	{
		echo "<b>get_form_values</b><br />\n";
		$this->print_msg( $arr );
		echo "<br />\n";
	}

	return $arr;
}

//---------------------------------------------------------
// get ticket
// < input type="hidden" name="XOOPS_G_TICKET" value="e1c3d9c1ece8114441b7ac68e90e429b" />
//---------------------------------------------------------
function get_ticket( $result=null )
{
	$val = $this->get_hidden_value( 'XOOPS_G_TICKET', $result );
	if ( !$val )
	{
		echo "Error: cannot get ticket <br />\n";
		$this->print_body();
		return false;
	}
	return $val;
}

//---------------------------------------------------------
// get_hidden_value
// < input type="hidden" name="lid" id="lid" value="155" />
//---------------------------------------------------------
function get_hidden_value( $name, $result=null )
{
	if (empty($result))
	{
		$result = $this->_snoopy->results;
	}

	$pattern = '<\/?input[\s+]type="hidden"[\s+]name="'.$name.'".*value="(\w+)"[\s+]/>';
	$pattern = "'$pattern'Usi";

	preg_match($pattern, $result, $match);

	if ( isset($match[1]) && $match[1] )
	{
		$val = $match[1];
		return $val;
	}

	return false;
}

//---------------------------------------------------------
// submit_form
//---------------------------------------------------------
function submit_form( $url, $form )
{
	if ( $this->_DEBUG_PRINT_SUBMIT )
	{
		echo "submit_form: $url <br />\n";
		$this->print_msg( $form );
		echo "<br />\n";
	}

	$this->_snoopy->referer = $url;

	$ret = $this->_snoopy->submit($url, $form);
	if ( !$ret )
	{
		echo "Error: cannnot submit form: $url <br />\n";
		$this->print_body();
		return false;
	}
	return true;
}

//---------------------------------------------------------
// get_results
//---------------------------------------------------------
function get_results()
{
	return $this->_snoopy->results;
}

function get_body( $result=null )
{
	if (empty($result))
	{
		$result = $this->_snoopy->results;
	}

	$str = eregi_replace("^.*<body[^>]*>", "", $result);
	$str = eregi_replace("</body>.*$",     "", $str);
	return $str;
}

function print_body( $flag_print=false, $result=null )
{
	if ( $flag_print || $this->_flag_print_body )
	{
		echo "<hr />\n";
		echo $this->get_body( $result );
		echo "<hr />\n";
	}
}

function match_result($str, $result=null)
{
	if (empty($result))
	{
		$result = $this->_snoopy->results;
	}

	$pattern = '/' . preg_quote($str) . '/';
	if ( preg_match( $pattern, $result ) )
	{
		return true;
	}
	return false;
}

function match_return_msg($str, $result=null)
{
	if (empty($result))
	{
		$result = $this->_snoopy->results;
	}

	list( $msg, $newid ) = $this->get_return_msg( $result );

	$pattern = '/' . preg_quote($str) . '/';

	if ( preg_match( $pattern, $msg ) )
	{
		if ( $newid )
		{
			$this->_newid = $newid;
		}
		return true;
	}

	return false;
}

function get_return_msg( $result=null )
{
	if (empty($result))
	{
		$result = $this->_snoopy->results;
	}

	$msg   = null;
	$newid = null;

	$pattern1 = '/<!-- weblinks : (.*) \[(\d+)\] -->/';
	$pattern2 = '/<!-- weblinks : (.*) -->/';

	if ( preg_match( $pattern1, $result, $match1 ) )
	{
		$msg   = $match1[1];
		$newid = $match1[2];
	}
	elseif ( preg_match( $pattern2, $result, $match2 ) )
	{
		$msg = $match2[1];
	}

	return array( $msg, $newid );
}

function get_newid()
{
	return $this->_newid;
}

//---------------------------------------------------------
// set param
//---------------------------------------------------------
function set_admin_uname_pass( $uname, $pass )
{
	$this->_UNAME_ADMIN = $uname;
	$this->_PASS_ADMIN  = $pass;
}

function set_user_uname_pass( $uname, $pass )
{
	$this->_UNAME_USER = $uanme;
	$this->_PASS_USER  = $pass;
}

function get_admin_uname()
{
	return $this->_UNAME_ADMIN;
}

function get_user_uname()
{
	return $this->_UNAME_USER;
}

function get_other_uname()
{
	return $this->_UNAME_OTHER;
}

function set_debug_print_submit( $val)
{
	$this->_DEBUG_PRINT_SUBMIT = (bool)$val;
}

function set_debug_print_result( $val )
{
	$this->_DEBUG_PRINT_RESULT = (bool)$val;
}

function set_debug_print_form( $val )
{
	$this->_DEBUG_PRINT_FORM = (bool)$val;
}

function set_debug_print_form_value( $val )
{
	$this->_DEBUG_PRINT_FORM_VALUE = (bool)$val;
}

//---------------------------------------------------------
// user submit
//---------------------------------------------------------
function user_submit_link_with_login( $param )
{
	$ret = $this->login_user();
	if ( !$ret )	{	return false;	}

	$ret = $this->user_submit_link( $param );
	if ( !$ret )	{	return false;	}

	$ret = $this->logout();
	if ( !$ret )	{	return false;	}

	return true;
}

function user_submit_link( &$param )
{
	$ret = $this->fetch_form( $this->_user_submit_url );
	if ( !$ret )	{	return false;	}

	$param['lid'] = 0;
	$form = $this->build_link_form( $param );

	$ret = $this->submit_form( $this->_user_submit_url, $form );
	if ( !$ret )	{	return false;	}

	$this->_newid = null;
	if ( isset($param['return']) )
	{
		if ( !$this->match_return_msg( $param['return'] ) )
		{
			echo "Error: submit link failed: <br /><hr />\n";
			echo $this->get_body() ."<br /><br />\n";
			return false;
		}
		if ( empty( $this->_newid ) )
		{
			echo "Error: submit link failed: cannot get newid <br /><hr />\n";
			echo $this->get_body() ."<br /><br />\n";
			return false;
		}
	}

	return true;
}

//---------------------------------------------------------
// user modify
//---------------------------------------------------------
function user_modify_link_with_login( $param )
{
	$ret = $this->login_user();
	if ( !$ret )	{	return false;	}

	$ret = $this->user_modify_link( $param );
	if ( !$ret )	{	return false;	}

	$ret = $this->logout();
	if ( !$ret )	{	return false;	}

	return true;
}

function user_modify_link( &$param )
{
	$lid = isset($param['lid']) ? $param['lid'] : 0;

	$this->_lid = $lid;

	$link_form_url = $this->_user_modify_url.'?lid='.$lid;
	$ret = $this->fetch_form($link_form_url);
	if ( !$ret )	{	return false;	}

	$form = $this->build_link_form( $param );

	$ret = $this->submit_form($this->_user_modify_url, $form);
	if ( !$ret )	{	return false;	}

	$this->_newid = null;
	if ( isset($param['return']) )
	{
		if ( !$this->match_return_msg( $param['return'] ) )
		{
			echo "Error: modify link failed: <br /><hr />\n";
			echo $this->get_body() ."<br /><br />\n";
			return false;
		}
		if ( empty( $this->_newid ) )
		{
			echo "Error: modify link failed: cannot get newid <br /><hr />\n";
			echo $this->get_body() ."<br /><br />\n";
			return false;
		}
	}

	return true;
}

function user_modify_password( &$param )
{
	$lid = isset($param['lid']) ? $param['lid'] : 0;

	$this->_lid = $lid;

	$link_form_url = $this->_user_modify_url.'?lid='.$lid;
	$ret = $this->fetch_form($link_form_url);
	if ( !$ret )	{	return false;	}

	$form = $this->build_form_password( $param );

	$ret = $this->submit_form($this->_user_modify_url, $form);
	if ( !$ret )	{	return false;	}

	$form = $this->build_link_form( $param );

	$ret = $this->submit_form($this->_user_modify_url, $form);
	if ( !$ret )	{	return false;	}

	return true;
}

function is_link_owner_other($lid, $uname=null)
{
	if ( empty($uname) )
	{
		$uname = $this->_UNAME_OTHER;
	}
	$ret = $this->is_link_owner($lid, $uname);
	return $ret;
}

function is_link_owner($lid, $uname=null)
{
	$link_uid = 0;
	$row =& $this->get_link($lid);
	if ( is_array($row) && isset($row['uid']) )
	{
		$link_uid = $row['uid'];
	}

	if ( empty($uname) )
	{
		$uname = $this->_UNAME_USER;
	}

	$user =& $this->_system->get_user_by_uname( $uname );
	$uname_uid = $user['uid'];

	if ( $link_uid && ( $link_uid == $uname_uid ) )
	{
		return true;
	}
	return false;
}

function get_post_lid()
{
	$lid = null;
	if ( isset($_POST['lid']) )
	{
		$lid = intval($_POST['lid']);
	}
	return $lid;
}

function get_post_passwd()
{
	$passwd = null;
	if ( isset($_POST['passwd']) )
	{
		$passwd = $_POST['passwd'];
	}
	return $passwd;
}

function print_form_lid( $flag_pass=false )
{
	echo '<form method="post">';
	echo 'lid <input type="text" name="lid"> ';

	if ( $flag_pass )
	{
		echo '<br />';
		echo 'passwd <input type="text" name="passwd"> ';
		echo '<br />';
	}

	echo '<input type="submit" name="submit">';
	echo '</form>';
}

//---------------------------------------------------------
// user delete
//---------------------------------------------------------
function user_delete_link_with_login( $param )
{
	$ret = $this->login_user();
	if ( !$ret )	{	return false;	}

	$ret = $this->user_delete_link( $param );
	if ( !$ret )	{	return false;	}

	$ret = $this->user_delete_reason();
	if ( !$ret )	{	return false;	}

	$this->_newid = null;
	if ( isset($param['return']) )
	{
		if ( !$this->match_return_msg( $param['return'] ) )
		{
			echo "Error: delete link failed: msg unmatch <br /><hr />\n";
			echo $this->get_body() ."<br /><br />\n";
			return false;
		}
		if ( empty( $this->_newid ) )
		{
			echo "Error: delete link failed: cannot get newid <br /><hr />\n";
			echo $this->get_body() ."<br /><br />\n";
			return false;
		}
	}

	$ret = $this->logout();
	if ( !$ret )	{	return false;	}

	return true;
}

function user_delete_link( &$param )
{
	$lid = isset($param['lid']) ? $param['lid'] : 0;

	$this->_lid = $lid;

	$link_form_url = $this->_user_modify_url.'?lid='.$lid;

	$ret = $this->fetch_form($link_form_url);
	if ( !$ret )	{	return false;	}

	$form_values = $this->get_form_values();
	if ( !isset($form_values['lid']) )
	{
		echo "Error: cannot get lid <br />\n";
		echo $this->get_body() ."<br /><br />\n";
		return false;
	}

// post op=delete
	$form = $this->build_form_del( $form_values );

	$ret = $this->submit_form( $form['action'], $form );
	if ( !$ret )	{	return false;	}

	return true;
}

function user_delete_reason()
{
	$form_values = $this->get_form_values();
	if ( !isset($form_values['lid']) )
	{
		echo "Error: cannot get lid <br />\n";
		echo $this->get_body() ."<br /><br />\n";
		return false;
	}

	$form = $this->build_form_del_reason( $form_values );

	$ret = $this->submit_form( $form['action'], $form );
	if ( !$ret )	{	return false;	}

	return true;
}

function user_delete_confirm()
{
	$form_values = $this->get_form_values();
	if ( !isset($form_values['lid']) )
	{
		echo "Error: cannot get lid <br />\n";
		echo $this->get_body() ."<br /><br />\n";
		return false;
	}

	$form = $this->build_form_del_confirm( $form_values );

	$ret = $this->submit_form( $form['action'], $form );
	if ( !$ret )	{	return false;	}

	return true;
}

function user_delete_password( &$param )
{
	$lid = isset($param['lid']) ? $param['lid'] : 0;

	$this->_lid = $lid;

	$link_form_url = $this->_user_modify_url.'?lid='.$lid;
	$ret = $this->fetch_form($link_form_url);
	if ( !$ret )	{	return false;	}

	$form = $this->build_form_password( $param );

	$ret = $this->submit_form( $this->_user_modify_url, $form );
	if ( !$ret )	{	return false;	}

// post op=delete
	$form = $this->build_form_del_password( $param );

	$ret = $this->submit_form( $this->_user_modify_url, $form );
	if ( !$ret )	{	return false;	}

	return true;
}

//---------------------------------------------------------
// build_link_form
//---------------------------------------------------------
function &build_link_form( &$param )
{
	$op       = isset($param['op'])       ? $param['op']       : null;
	$lid      = isset($param['lid'])      ? $param['lid']      : 0;
	$name     = isset($param['name'])     ? $param['name']     : null;
	$title    = isset($param['title'])    ? $param['title']    : null;
	$banner   = isset($param['banner'])   ? $param['banner']   : null;
	$rss_flag = isset($param['rss_flag']) ? $param['rss_flag'] : 0;
	$rss_url  = isset($param['rss_url'])  ? $param['rss_url']  : null;
	$passwd   = isset($param['passwd'])   ? $param['passwd']   : null;
	$notify   = isset($param['notify'])   ? $param['notify']   : 0;

	$param['flag_uid']      = 0;	// system param;
	$param['mode_dhtml']    = 1;	// all 1
	$param['flag_rssc_lid'] = 0;	// not update

	$arr =& $this->build_link_record_from_param( $param );

	$arr['submit']         = 'submit';
	$arr['request']        = 1;
	$arr['XOOPS_G_TICKET'] = $this->get_ticket();

	$arr['op']         = $op;
	$arr['lid']        = $lid;
	$arr['banner']     = $banner;
	$arr['rss_url']    = $rss_url;
	$arr['rss_flag']   = $rss_flag;
	$arr['notify']     = $notify;

	if ( $passwd )
	{
    	$arr['passwd_new'] = $passwd;
    	$arr['passwd_2']   = $passwd;
    	$arr['passwd_old'] = $passwd;
	}
	else
	{
    	$arr['passwd_new'] = $arr['passwd'];
    	$arr['passwd_2']   = $arr['passwd'];
    	$arr['passwd_old'] = $arr['passwd'];
	}

	$this->_build_form_array =& $arr;
	return $arr;
}

function &build_form_del( $v )
{
	$notify   = isset($v['notify'])   ? $v['notify']   : 0;

	$arr = array(
		'action'          => 'http://localhost' . $v['action'],
		'XOOPS_G_TICKET'  => $v['XOOPS_G_TICKET'],
		'delete'          => 'delete',
		'lid'             => $v['lid'],
		'notify'          => $notify,
	);

	return $arr;
}

function &build_form_del_reason( $v )
{
	$notify     = isset($v['notify'])     ? $v['notify']     : 0;
	$confirm    = isset($v['confirm'])    ? $v['confirm']    : 0;
	$passwd_old = isset($v['passwd_old']) ? $v['passwd_old'] : null;
	$request    = isset($v['request'])    ? $v['request']    : 0;

	$reason  = "reason\n".$this->get_randum_title();

	$arr = array(
		'action'          => 'http://localhost' . $v['action'],
		'XOOPS_G_TICKET'  => $v['XOOPS_G_TICKET'],
		'op'              => $v['op'],
		'lid'             => $v['lid'],
		'confirm'         => $confirm,
		'notify'          => $notify,
		'reason'          => $reason,
		'passwd_old'      => $passwd_old,
		'request'         => $request,
	);

	return $arr;
}

function &build_form_del_confirm( $v )
{
	$passwd_old = isset($v['passwd_old']) ? $v['passwd_old'] : null;
	$request    = isset($v['request'])    ? $v['request']    : 0;

	$arr = array(
		'action'          => 'http://localhost' . $v['action'],
		'XOOPS_G_TICKET'  => $v['XOOPS_G_TICKET'],
		'op'              => $v['op'],
		'lid'             => $v['lid'],
		'confirm'         => $v['confirm'],
		'passwd_old'      => $passwd_old,
		'request'         => $request,
	);

	return $arr;
}

function &build_form_password( &$param )
{
	$lid      = isset($param['lid'])      ? $param['lid']      : 0;
	$passwd   = isset($param['passwd'])   ? $param['passwd']   : null;

	$arr = array(
		'lid'             => $lid,
		'passwd_old'      => $passwd,
		'request'         => 1,
	);

	return $arr;
}

function &build_form_del_password( &$param )
{
	$lid      = isset($param['lid'])      ? $param['lid']      : 0;
	$passwd   = isset($param['passwd'])   ? $param['passwd']   : null;

	$arr = array(
		'XOOPS_G_TICKET'  => $this->get_ticket(),
		'delete'          => 'delete',
		'lid'             => $lid,
		'passwd_old'      => $passwd,
		'request'         => 1,
		'notify'          => 0,
	);

	return $arr;
}

function build_rss_url( $id )
{
	$text =  WEBLINKS_URL.'/dev/rss.php?id='.$id;
	return $text;
}

//---------------------------------------------------------
// compare check
//---------------------------------------------------------
function check_msg_and_new_link( $str )
{
	if ( $this->match_return_msg( $str ) )
	{
// newid is set by match_return_msg()
		return $this->check_link( $this->_newid, $this->_build_form_array );
	}

	echo "ummatch return msg : ". $str ."<br />\n";
}

function check_msg_and_link( $str )
{
	if ( $this->match_return_msg( $str ) )
	{
		return $this->check_link( $this->_lid, $this->_build_form_array );
	}

	echo "ummatch return msg : ". $str ."<br />\n";
	return false;
}

function check_link( $lid, $expect )
{
	$row =& $this->get_link( $lid );
	if ( is_array($row) )
	{
		if ( $row['title'] != $expect['title']  )
		{
			echo "ummatch title: ".$row['title']." != ". $expect['title'] . "<br />\n";
			return false;
		}
		if ( $row['banner'] != $expect['banner']  )
		{
			echo "ummatch banner: ".$row['banner']." != ". $expect['banner'] . "<br />\n";
			return false;
		}
		if ( $this->is_exist_rssc_module() && $expect['rss_flag'] )
		{
			return $this->check_rssc_link( $row['rssc_lid'], $expect );
		}
		return true;
	}

	echo "no link : lid = ". $lid ."<br />\n";
	return false;
}

function check_rssc_link( $rssc_lid, $expect )
{
	$row =& $this->get_rssc_link( $rssc_lid );
	if ( is_array($row) )
	{
		if ( $row['rss_url'] != $expect['rss_url']  )
		{
			echo "ummatch title: ".$row['rss_url']." != ". $expect['rss_url'] . "<br />\n";
			return false;
		}
		return $this->check_rssc_feed( $rssc_lid );
	}

	echo "no rssc link : rssc_lid = ". $rssc_lid ."<br />\n";
	return false;
}

function check_rssc_feed( $rssc_lid )
{
	if ( $this->get_rssc_feed_count_by_rssc_link( $rssc_lid ) )
	{
		return true;
	}
	echo "no rssc feed : rssc_lid = ". $rssc_lid ."<br />\n";
	return false;
}

function check_link_title( $lid, $title )
{
	$row =& $this->get_link( $lid );
	if ( is_array($row) )
	{
		if ( $title == $row['title'] )
		{
			return true;
		}
	}
	return false;
}

//---------------------------------------------------------
// permission
//---------------------------------------------------------
function has_guest_perm()
{
	global $xoopsModule;
	$mid = $xoopsModule->getVar('mid');

	$groups_guest = array( XOOPS_GROUP_ANONYMOUS );

	$groupperm_handler =& xoops_gethandler( 'groupperm' );
	if ( $groupperm_handler->checkRight( 'module_read', $mid, $groups_guest ) )
	{
		return true;
	}
	return false;
}

//---------------------------------------------------------
// RSSC module
//---------------------------------------------------------
function is_exist_rssc_module()
{
	return $this->is_exist_module( $this->get_config_by_name( 'rss_dirname' ) );
}

// --- class end ---
}

?>