<?php
// $Id: weblinks_link_edit_handler.php,v 1.12 2007/09/01 02:10:31 ohwada Exp $

// 2007-09-01 K.OHWADA
// BUG 4693: not notify "New Link Submitted"
// notification to each category
// build_tags_newlink()

// 2007-06-01 K.OHWADA
// link_catlink_basic_handler

// 2007-03-01 K.OHWADA
// update_category_link_count()
// build_comment()

// 2006-12-10 K.OHWADA
// use link_save modify_save

// 2006-10-12 K.OHWADA
// BUG 4318: cannot register bulk links.
// add create_add_link_by_arr()

// 2006-09-20 K.OHWADA
// use happy_linux
// use rssc
// change del_link_vote_comm_by_lid()

// 2006-07-23 K.OHWADA
// BUG 4154: always update time_update in admin mode

// 2006-06-10 K.OHWADA
// BUG 4030: cannot change recommend, mutual

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//=========================================================
// WebLinks Module
// 2006-05-15 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_link_edit_handler') ) 
{

//=========================================================
// class weblinks_link_edit_handler
//=========================================================
class weblinks_link_edit_handler extends happy_linux_error
{
	var $_DIRNAME;
	var $_WEBLINK_URL;

	var $_config_handler;
	var $_link_handler;
	var $_category_handler;
	var $_catlink_handler;
	var $_modify_handler;
	var $_votedata_handler;
	var $_broken_handler;
	var $_rssc_handler;
	var $_banner_handler;
	var $_link_catlink_handler;
	var $_link_view_handler;

	var $_menu;
	var $_system;
	var $_post;
	var $_form;
	var $_strings;
	var $_remote_image;

// result
	var $_newid;
	var $_save_obj  = null;
	var $_cid_array = array();
	var $_tags      = null;

	var $_banner_error_code = 0;
	var $_banner_errors     = null;

	var $_MAX_DESCRIPTION = 200;
	var $_MAX_USERCOMMENT = 200;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_edit_handler( $dirname )
{
	$this->happy_linux_error();

	$this->_DIRNAME     = $dirname;
	$this->_WEBLINK_URL = XOOPS_URL . '/modules/' . $dirname;

	$this->_link_catlink_handler =& weblinks_get_handler( 'link_catlink_basic', $dirname );
	$this->_config_handler       =& weblinks_get_handler( 'config2_basic',  $dirname );
	$this->_category_handler     =& weblinks_get_handler( 'category',       $dirname );
	$this->_link_handler         =& weblinks_get_handler( 'link',           $dirname );
	$this->_catlink_handler      =& weblinks_get_handler( 'catlink',        $dirname );
	$this->_modify_handler       =& weblinks_get_handler( 'modify',         $dirname );
	$this->_votedata_handler     =& weblinks_get_handler( 'votedata',       $dirname );
	$this->_broken_handler       =& weblinks_get_handler( 'broken',         $dirname );
	$this->_banner_handler       =& weblinks_get_handler( 'banner',         $dirname );
	$this->_link_view_handler    =& weblinks_get_handler( 'link_view',      $dirname );
	$this->_rssc_handler         =& weblinks_get_handler( 'rssc',           $dirname );

	$this->_menu         =& weblinks_menu::getInstance( $dirname );
	$this->_system       =& happy_linux_system::getInstance();
	$this->_post         =& happy_linux_post::getInstance();
	$this->_form         =& happy_linux_form::getInstance();
	$this->_strings      =& happy_linux_strings::getInstance();
	$this->_remote_image =& happy_linux_remote_image::getInstance();
}

//---------------------------------------------------------
// POST param
//---------------------------------------------------------
function get_post_lid()
{
	$lid = $this->_post->get_post_int('lid');
	return $lid;
}

function get_post_url()
{
	$url = $this->_post->get_post_text('url');
	return $url;
}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init()
{
	$this->_category_handler->load();
}

//---------------------------------------------------------
// create object
//---------------------------------------------------------
function create()
{
	$obj =& $this->_link_handler->create();
	return $obj;
}

function &create_view()
{
	$view_obj =& new weblinks_link_view( $this->_DIRNAME );
	return $view_obj;
}

function &create_edit()
{
	$edit_obj =& new weblinks_link_edit( $this->_DIRNAME );
	return $edit_obj;
}

function &create_link_save($isNew = true)
{
	$obj =& new weblinks_link_save( $this->_DIRNAME );
	if ($isNew)
	{	$obj->setNew();	}
	return $obj;
}

function &create_modify_save($isNew = true)
{
	$obj =& new weblinks_modify_save( $this->_DIRNAME );
	if ($isNew)
	{	$obj->setNew();	}
	return $obj;
}

//---------------------------------------------------------
// wrapper of link_handler
//---------------------------------------------------------
function &get($lid)
{
	$lid = intval($lid);
	$obj =& $this->_link_handler->get($lid);
	return $obj;
}

function check_exist_link($lid)
{
	$obj =& $this->get($lid);
	if ( is_object($obj) )
	{
		return true;
	}
	return false;
}

function getCount()
{
	$count = $this->_link_handler->getCount();
	return $count;
}

function insert( &$obj )
{
	$newid = $this->_link_handler->insert( $obj );
	return $newid;
}

//---------------------------------------------------------
// Does the user have authority
//---------------------------------------------------------
function has_auth_submit()
{
	$ret = $this->_menu->show_submit();
	return $ret;
}

function has_auth_submit_auto()
{
	$ret = $this->has_auth( 'auth_submit_auto_arr' );
	return $ret;
}

function has_auth_modify( $rec_uid, $flag_passwd )
{
	list($is_permit, $is_owner, $show_passwd) = 
		$this->has_auth_owner( 'auth_modify_arr', $rec_uid, $flag_passwd );

	if ($flag_passwd && $show_passwd)
	{
		$is_permit = true;
		$is_owner  = true;
	}

	return array($is_permit, $is_owner, $show_passwd);
}

function has_auth_modify_auto( $rec_uid, $flag_passwd )
{
	list($is_permit, $is_owner, $show_passwd) = 
		$this->has_auth_owner( 'auth_modify_auto_arr', $rec_uid, $flag_passwd );
	return $is_permit;
}

function get_config_by_name($name)
{
	$ret = $this->_config_handler->get_cache_by_name($name);
	return $ret;
}

function has_auth( $name )
{
	$ret = $this->_config_handler->has_auth( $name );
	return $ret;
}

function has_auth_owner( $name, $rec_uid, $flag_passwd )
{
	$ret = $this->_config_handler->has_auth_owner( $name, $rec_uid, $flag_passwd );
	return $ret;
}

//---------------------------------------------------------
// add new link
//---------------------------------------------------------
function add_link_by_post( $flag_banner=false )
{
	$newid = $this->add_link_to_link_by_post( $flag_banner );
	if ( !$newid )
	{
		return false;
	}

	$ret = $this->_catlink_handler->add_link_by_lid_cid_array( $newid, $this->_cid_array );
	if ( !$ret )
	{
		$this->_set_errors( $this->_catlink_handler->getErrors() );
		return false;
	}

	return $newid;
}

function add_link_to_link_by_post( $flag_banner=false )
{
// modify
	$this->_mid = $this->_post->get_post_int('mid');

	$save_obj =& $this->create_add_link_by_arr( $_POST, false, $flag_banner );

	$newid = $this->_link_handler->insert( $save_obj );
	if ( !$newid )
	{
		$this->_set_errors( $this->_link_handler->getErrors() );
		return false;
	}

	$this->_newid    =  $newid;
	$this->_save_obj =& $save_obj;

	return $newid;
}

// $not_gpc for bulk manage
function &create_add_link_by_arr( &$post, $not_gpc=false, $flag_banner=false )
{
	$save_obj =& $this->create_link_save();
	$save_obj->assign_add_object( $post, $not_gpc, $flag_banner );

	$this->_cid_array         =& $save_obj->get_cid_array();
	$this->_banner_error_code =  $save_obj->get_banner_error_code();
	$this->_banner_errors     =  $save_obj->get_banner_errors();

	return $save_obj;
}

//---------------------------------------------------------
// modify link
//---------------------------------------------------------
function mod_link_by_post( $lid, $flag_banner=false )
{
	$this->_clear_errors();

	$this->mod_link_to_link_by_post( $lid, $flag_banner );

	$ret = $this->_catlink_handler->delete_by_lid($lid);
	if (!$ret)
	{
		$this->_set_errors( $this->_catlink_handler->getErrors() );
	}

	$ret = $this->_catlink_handler->add_link_by_lid_cid_array( $lid, $this->_cid_array );
	if (!$ret)
	{
		$this->_set_errors( $this->_catlink_handler->getErrors() );
	}

	return $this->returnExistError();
}

function mod_link_to_link_by_post( $lid, $flag_banner=false )
{
	$obj =& $this->create_mod_link_by_post( $lid, $flag_banner );
	if ( !is_object($obj) )
	{
		$this->_set_errors_not_exist($lid);
		return false;
	}

	$ret = $this->_link_handler->update($obj);
	if (!$ret)
	{
		$this->_set_errors( $this->_link_handler->getErrors() );
		return false;
	}

	return true;
}

function &create_mod_link_by_post( $lid, $flag_banner=false )
{
	$link_obj =& $this->get($lid);
	if ( !is_object($link_obj) )
	{
		$false = false;
		return $false;
	}

	$save_obj =& $this->create_link_save();
	$save_obj->assignVars( $link_obj->gets() );
	$save_obj->assign_mod_object( $_POST, false, $flag_banner );

	$this->_cid_array         =& $save_obj->get_cid_array();
	$this->_banner_error_code =  $save_obj->get_banner_error_code();
	$this->_banner_errors     =  $save_obj->get_banner_errors();

	return $save_obj;
}

//---------------------------------------------------------
// update banner size
//---------------------------------------------------------
function update_banner_size_to_link($lid, $width, $height)
{
	$obj =& $this->_link_handler->get($lid);
	if ( !is_object($obj) )
	{	return false;	}

	$obj->setVar('width',  $width);
	$obj->setVar('height', $height);
	$ret = $this->_link_handler->update($obj);
	return $ret;
}

function update_banner_and_size_by_post()
{
	$lid = $this->get_post_lid();

	$obj =& $this->get($lid);
	if ( !is_object($obj) )
	{	return false;	}

	$obj->set_var_by_global_post('banner');
	$obj->set_var_by_global_post('width');
	$obj->set_var_by_global_post('height');

	$ret = $this->_link_handler->update($obj);
	return $ret;
}

function &get_remote_banner_size($banner)
{
	$size =& $this->_banner_handler->get_remote_banner_size( $banner );
	if (!$size)
	{
		$this->_banner_error_code = $this->_banner_handler->getErrorCode();
		$this->_banner_errors     = $this->_banner_handler->getErrors();
	}
	return $size;
}

function get_banner_error_code()
{
	return $this->_banner_error_code;
}

function get_banner_errors()
{
	return $this->_banner_errors;
}

//---------------------------------------------------------
// build_submit_preview
//---------------------------------------------------------
function build_submit_preview()
{
	$this->_clear_errors();

	$rss_flag = 0;
	$rss_url  = '';

// create link object
	$obj =& $this->create_add_link_by_arr( $_POST, false, true );

// check url, banner & check rss url
	list($rss_flag, $rss_url) = $this->_check_url_banner_rssurl( $obj );

// create edit object
	$edit_obj =& $this->create_edit();
	$edit_obj->set_object($obj);
	$edit_obj->build_preview_for_template( $this->_cid_array );

	$edit_obj->set('rss_flag', $rss_flag);
	$edit_obj->set('rss_url',  $this->_strings->sanitize_url($rss_url) );

	$show =& $edit_obj->get_vars();

	return $show;
}

function _check_url_banner_rssurl( &$obj )
{
	$this->_clear_errors();

	$url = $obj->get('url');

// check connect url
	if ( $url )
	{
		if ( !$this->_remote_image->check_url($url) )
	 	{
	 		$this->_set_errors( '<span style="color: #ff0000;">'._WEBLINKS_WARN_NOT_READ_URL."</span>" );
	 	}
	}

// banner error
	if ( $this->_banner_error_code )
	{
 		$this->_set_errors( '<span style="color: #ff0000;">'._WEBLINKS_WARN_BANNER_NOT_GET_SIZE."</span>" );
	}

	$rss_flag = 0;
	$rss_url  = '';

// create rssc object
	$rssc_obj =& $this->_rssc_handler->create_new_rssc_obj();
	if ( is_object($rssc_obj) )
	{
		$code     = $rssc_obj->get('auto_code');
		$rss_flag = $rssc_obj->get('rss_flag');
		$rss_url  = $rssc_obj->get('show_rss_url');

// discover
		switch ( $code )
		{
			case RSSC_CODE_DISCOVER_SUCCEEDED:
				 $this->_set_errors( '<b>'._RSSC_DISCOVER_SUCCEEDED."</b>" );
				break;

			case RSSC_CODE_DISCOVER_FAILED:
				 $this->_set_errors( '<span style="color: #ff0000;">'._RSSC_DISCOVER_FAILED."</span>" );
				break;
		}

// check connect rss url
		if ( $rss_url )
		{
			if ( !$this->_remote_image->check_url($rss_url) )
		 	{
		 		$this->_set_errors( '<span style="color: #ff0000;">'._RSSC_PARSE_NOT_READ_XML_URL."</span>" );
		 	}
		}
	}

	return array($rss_flag, $rss_url);
}

function check_preview_result()
{
	return $this->returnExistError();
}

function get_error_msg_preview( $format='s' )
{
	return $this->getErrors($format);
}


//---------------------------------------------------------
// build_modify_preview
//---------------------------------------------------------
function build_modify_preview( $lid )
{
	$this->_clear_errors();

	$rss_flag = 0;
	$rss_url  = '';

// create link object
	$obj =& $this->create_mod_link_by_post( $lid, true );

// check url, banner & check rss url
	list($rss_flag, $rss_url) = $this->_check_url_banner_rssurl( $obj );

// create edit object
	$edit_obj =& $this->create_edit();
	$edit_obj->set_object($obj);
	$edit_obj->build_preview_for_template( $this->_cid_array );

	$edit_obj->set('rss_flag', $rss_flag);
	$edit_obj->set('rss_url',  $this->_strings->sanitize_url($rss_url) );

	$show =& $edit_obj->get_vars();

	return $show;
}

//---------------------------------------------------------
// event tags
//---------------------------------------------------------
function &get_cid_array()
{
	return $this->_cid_array;
}

function &build_tags_newlink( $cid=0 )
{
	$tags =& $this->_build_tags_newlink_once();
	if ( !is_array($tags) )
	{
		return $tags;
	}

	if ($cid)
	{
		$tags['CATEGORY_NAME'] = $this->_category_handler->get_title( $cid );
		$tags['CATEGORY_URL']  = $this->_WEBLINK_URL . '/viewcat.php?cid=' . $cid;
	}

	return $tags;
}

function &build_tags_linksubmit( $cid=0 )
{
	$tags =& $this->_build_tags_linksubmit_once();
	if ( !is_array($tags) )
	{
		return $tags;
	}

	if ( $cid )
	{
		$tags['CATEGORY_NAME'] = $this->_category_handler->get_title( $cid );
		$tags['CATEGORY_URL']  = $this->_WEBLINK_URL . '/viewcat.php?cid=' . $cid;
	}

	return $tags;
}

function &_build_tags_newlink_once()
{
	if ( $this->_tags )
	{
		return $this->_tags;
	}

	if ( !is_object( $this->_save_obj ) )
	{
		$false = false;
		return $false;
	}

	$tags = array();
	$tags['LINK_NAME']        = $this->_save_obj->get('title');
//	$tags['LINK_DESCRIPTION'] = $this->_save_obj->description_short( $this->_MAX_DESCRIPTION );
	$tags['LINK_URL']         = $this->_WEBLINK_URL . '/singlelink.php?lid=' . $this->_newid;

	$this->_tags =& $tags;
	return $tags;
}

function &_build_tags_linksubmit_once()
{
	if ( $this->_tags )
	{
		return $this->_tags;
	}

	if ( !is_object( $this->_save_obj ) )
	{
		$false = false;
		return $false;
	}

	$tags = array();
	$tags['LINK_NAME']        = $this->_save_obj->get('title');
//	$tags['LINK_DESCRIPTION'] = $this->_save_obj->description_short( $this->_MAX_DESCRIPTION );
//	$tags['LINK_USERCOMMENT'] = $this->_save_obj->usercomment_short( $this->_MAX_USERCOMMENT );
	$tags['WAITINGLINKS_URL'] = $this->_WEBLINK_URL . '/admin/link_manage.php?op=list_new&mid=' . $this->_newid;

	$this->_tags =& $tags;
	return $tags;
}

//---------------------------------------------------------
// check POST param & set error
//---------------------------------------------------------
function build_comment($str)
{
	$text = ' <!-- weblinks : '.$str.' -->'."\n";
	return $text;
}

//=========================================================
// modify table
//=========================================================
function add_link_to_modify_by_post( $mode=0 )
{
	$save_obj =& $this->create_modify_save();

	if ($mode)
	{
		$lid = $this->_post->get_post_int('lid');

		$link_obj = $this->get($lid);
		if ( !is_object($link_obj) )
		{
			$this->_set_errors_not_exist($lid);
			return false;
		}

// not validate
		$save_obj->assignVars( $link_obj->gets() );
	}

	$save_obj->assign_add_object( $_POST, $mode );

	$newid = $this->_modify_handler->insert( $save_obj );
	if ( !$newid )
	{
		$this->_set_errors( $this->_modify_handler->getErrors() );
		return false;
	}

	$this->_newid     =  $newid;
	$this->_save_obj  =& $save_obj;
	$this->_cid_array =& $save_obj->get_cid_array();

	return $newid;
}

//=========================================================
// votedata table
// delete link, catlink, modify, votedata, broken, comments, notification
//=========================================================
function del_link_vote_comm_catlink_by_lid($lid)
{
	$this->_clear_errors();

	$ret1 = $this->del_link_vote_comm_by_lid($lid);

	$ret2 = $this->_catlink_handler->delete_by_lid($lid);
	if (!$ret2)
	{
		$this->_set_errors( $this->_catlink_handler->getErrors() );
	}

	return $this->returnExistError();
}

function del_link_vote_comm_by_lid($lid)
{
	$modid = $this->_system->get_mid();

	$ret1 = $this->_link_handler->delete_by_lid($lid);
	if (!$ret1)
	{
		$this->_set_errors( $this->_link_handler->getErrors() );
	}

	$ret2 = $this->_modify_handler->delete_by_lid($lid);
	if (!$ret2)
	{
		$this->_set_errors( $this->__modify_handler->getErrors() );
	}

	$ret3 = $this->_votedata_handler->delete_by_lid($lid);
	if (!$ret3)
	{
		$this->_set_errors( $this->_votedata_handler->getErrors() );
	}

	$ret4 = $this->_broken_handler->delete_by_lid($lid);
	if (!$ret4)
	{
		$this->_set_errors( $this->_broken_handler->getErrors() );
	}

	xoops_comment_delete( $modid, $lid);
	xoops_notification_deletebyitem ( $modid, 'link', $lid);

	return $this->returnExistError();
}

//=========================================================
// category table
//=========================================================
function update_category_link_count()
{
	$cat_objs = $this->_category_handler->get_objects_all();

	foreach ($cat_objs as $obj) 
	{
		$cid   =  $obj->getVar('cid');
		$arr   =& $this->_category_handler->get_parent_and_all_child_id($cid);
		$count =  $this->_link_catlink_handler->get_count_by_cid_array($arr);

		$obj->setVar('link_count', $count);

		$ret =  $this->_category_handler->update($obj);
		if (!$ret)
		{
			$this->_set_errors( $this->_category_handler->getErrors() );
		}
	}

	return $this->returnExistError();
}

//---------------------------------------------------------
// token ticket
//---------------------------------------------------------
function make_token( $name='' )
{
	$ret = $this->_form->build_token($name);
	return $ret;
}

function check_token( $name='' )
{
	$ret = $this->_form->check_token($name);
	return $ret;
}

//---------------------------------------------------------
// error 
//---------------------------------------------------------
function _set_errors_not_exist($lid)
{
	$msg = "link not exist lid = $lid";
	$this->_set_errors( $msg );
}

// --- class end ---
}

// === class end ===
}

?>