<?php
// $Id: rssc_build_rssc.php,v 1.4 2006/09/02 16:05:05 ohwada Exp $

// 2006-09-01 K.OHWADA
// use happy_linux_build_rss

// 2006-07-10 K.OHWADA
// use happy_linux_system

// 2006-06-04 K.OHWADA
// suppress notice : Only variable references should be returned by reference

//=========================================================
// Rss Center Module
// class builder RDF/RSS/ATOM
// for rssc module
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_build_rssc') ) 
{

//=========================================================
// class rssc_build_rssc
//=========================================================
class rssc_build_rssc extends happy_linux_build_rss
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_build_rssc()
{
	$this->happy_linux_build_rss();
	$this->set_generator(  'XOOPS rssc' );
	$this->set_category(   'RSS Center' );
	$this->set_rdf_title(  'RSS Center: RDF Feeds' );
	$this->set_rss_title(  'RSS Center: RSS Feeds' );
	$this->set_atom_title( 'RSS Center: ATOM Feeds' );
	$this->set_flag_force_build( 1 );	// always build

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_build_rssc();
	}

	return $instance;
}

//---------------------------------------------------------
// RDF
//---------------------------------------------------------
function _build_rdf_item( $item )
{
	$ret = $this->_build_common_item( $item );
	return $ret;
}

//---------------------------------------------------------
// RSS
//---------------------------------------------------------
function _build_rss_item( $item )
{
	$arr = $this->_build_common_item( $item );

// guid
	if ( empty($arr['guid']) )
	{
		$arr['guid'] = $arr['link'];
	}

// date
	$arr['pubdate'] = $arr['date_rfc822'];

	return $arr;
}

//---------------------------------------------------------
// ATOM
//---------------------------------------------------------
function _build_atom_entry( $entry )
{
	$arr = $this->_build_common_item( $entry );

// title
	$arr['title'] = $this->_build_xml_title($entry['title'], 0, 0);

// must content or summary
	if ( empty($arr['content']) && empty($arr['summary']) )
	{
		$arr['summary'] = $arr['title'];
	}

// must author_name
	if ( empty($arr['author_name']) )
	{
		$arr['author_name']  = $this->_xml( $this->_site_author_name );
		$arr['author_uri']   = '';
		$arr['author_email'] = '';
	}

// atom id
	if ( $arr['entry_id'] )
	{
		$arr['id'] = $arr['entry_id'];
	}
	else
	{
		$atom_id = "tag:".$this->_site_tag.",".$this->_site_year."://1.1.".$this->_count_line;
		$arr['id'] = $this->_xml( $atom_id );
	}

// date
	$arr['updated']   = $arr['updated_iso8601'];
	$arr['published'] = $arr['published_iso8601'];

	$this->_count_line ++;

	return $arr;
}

//---------------------------------------------------------
// common
//---------------------------------------------------------
function _build_common_item( $item )
{
// title content 
	$title_xml   = $this->_build_xml_title(   $item['title'] );
	$content_xml = $this->_build_xml_content( $item['content'] );
	$sum_xml     = $this->_build_xml_summary( $item['content'], 0, 0 );

	$category_xml    = $this->_xml( $item['category'] );
	$author_name_xml = $this->_xml( $item['author_name'] );

	$published_unix  = intval( $item['published_unix'] );
	$updated_unix    = intval( $item['updated_unix'] );
	$published_rfc822_xml  = $this->_xml( date("r", $published_unix ) );
	$updated_rfc822_xml    = $this->_xml( date("r", $updated_unix ) );
	$published_iso8601_xml = $this->_xml( $this->_iso8601_date( $published_unix ) );
	$updated_iso8601_xml   = $this->_xml( $this->_iso8601_date( $updated_unix ) );

	$ret = array(
		'link'         => $this->_xml_url( $item['link'] ),
		'guid'         => $this->_xml_url( $item['guid'] ),
		'entry_id'     => $this->_xml_url( $item['entry_id'] ),
		'author_uri'   => $this->_xml_url( $item['author_uri'] ),
		'author_email' => $this->_xml( $item['author_email'] ),
		'author_name'  => $author_name_xml,
		'title'        => $title_xml,
		'summary'      => $sum_xml,
		'description'  => $sum_xml,
		'content'      => $content_xml,
		'category'     => $category_xml,

		'published_unix'    => $published_unix,  // unixtime
		'updated_unix'      => $updated_unix,    // unixtime
		'published_rfc822'  => $published_rfc822_xml,
		'date_rfc822'       => $published_rfc822_xml,
		'updated_rfc822'    => $updated_rfc822_xml,
		'published_iso8601' => $published_iso8601_xml,
		'date_iso8601'      => $published_iso8601_xml,
		'updated_iso8601'   => $updated_iso8601_xml,

		'dc_subject'  => $category_xml,
		'dc_creator'  => $author_name_xml,
		'dc_date'     => $published_iso8601_xml,
		'content_encoded' => $content_xml,
	);

	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>