<?php
// $Id: d3forum_073.php,v 1.1 2007/06/17 03:45:16 ohwada Exp $

//=========================================================
// WebLinks Module
// for d3forum 0.73 <http://xoops.peak.ne.jp/>
// 2007-06-10 K.OHWADA
//=========================================================

function &weblinks_plugin_forums_d3forum_073( $opts )
{
	global $xoopsDB;

// option parameter
	$DIRNAME = isset( $opts['dirname'] ) ? $opts['dirname'] : 'd3forum';

	$arr = array();

	$table_forums = $xoopsDB->prefix( $DIRNAME.'_forums' );
	$sql = "SELECT * FROM " . $table_forums . " ORDER BY forum_id";
	$res = $xoopsDB->query( $sql );
//	echo $xoopsDB->error();

	while ( $row = $xoopsDB->fetchArray($res) )
	{
		$arr[ $row['forum_id'] ] = $row['forum_title'];
	}

	return $arr;
}

function &weblinks_plugin_threads_d3forum_073( $opts )
{
	global $xoopsDB;
	$myts =& MyTextSanitizer::getInstance();

// option parameter
	$DIRNAME      = isset( $opts['dirname'] )      ? $opts['dirname']                : 'd3forum';
	$forum_id     = isset( $opts['forum_id'] )     ? intval( $opts['forum_id'] )     : 0;
	$thread_limit = isset( $opts['thread_limit'] ) ? intval( $opts['thread_limit'] ) : 1;
	$thread_start = isset( $opts['thread_start'] ) ? intval( $opts['thread_start'] ) : 0;
	$post_limit   = isset( $opts['post_limit'] )   ? intval( $opts['post_limit'] )   : 1;
	$post_start   = isset( $opts['post_start'] )   ? intval( $opts['post_start'] )   : 0;
	$post_order   = isset( $opts['post_order'] )   ? $opts['post_order']             : 'DESC';

	if ($forum_id == 0)
	{
		$false = false;
		return $false;
	}

	$arr = array();
	$URL_MOD = XOOPS_URL .'/modules/'. $DIRNAME;

	$module_handler =& xoops_gethandler('module');
	$config_handler =& xoops_gethandler('config');
	$module =& $module_handler->getByDirname( $DIRNAME );
	$config =& $config_handler->getConfigsByCat(0, $module->getVar('mid'));

	$table_forums = $xoopsDB->prefix( $DIRNAME.'_forums' );
	$table_topics = $xoopsDB->prefix( $DIRNAME.'_topics' );
	$table_posts  = $xoopsDB->prefix( $DIRNAME.'_posts' );

	$pattern     = "/\[quote sitecite=([^\"'<>]*)\]/sU";
	$replacement = '[quote]';

// forum name
	$sql1  = "SELECT * FROM " . $table_forums;
	$sql1 .= " WHERE forum_id=".intval($forum_id);
	$res1  = $xoopsDB->query( $sql1 );
	$row1  = $xoopsDB->fetchArray($res1);
//	echo $xoopsDB->error();

	$arr['forum_id']    = $forum_id;
	$arr['forum_link']  = $URL_MOD.'/index.php?forum_id='.$forum_id;
	$arr['forum_title'] = $row1['forum_title'];

// latest topics
	$sql2  = "SELECT * FROM " . $table_topics;
	$sql2 .= " WHERE forum_id=".intval($forum_id);
	$sql2 .= " ORDER BY topic_last_post_time ".$post_order;
	$res2  = $xoopsDB->query( $sql2, $thread_limit, $thread_start );
//	echo $xoopsDB->error();

	while ( $row2 = $xoopsDB->fetchArray($res2) )
	{
		$thread_arr = array();
		$topic_id   = $row2['topic_id'];
		$topic_link = $URL_MOD.'/index.php?topic_id='.$topic_id;
		$thread_arr['thread_id']     = $topic_id;
		$thread_arr['thread_link']   = $topic_link;
		$thread_arr['thread_title']  = $row2['topic_title'];
		$thread_arr['thread_time']   = $row2['topic_last_post_time'];
		$thread_arr['thread_time_s'] = formatTimestamp($row2['topic_last_post_time'], "s");

// latest posts
		$sql3  = "SELECT * FROM " . $table_posts;
		$sql3 .= " WHERE topic_id=".intval($topic_id);
		$sql3 .= " ORDER BY post_time DESC";
		$res3  = $xoopsDB->query( $sql3, $post_limit, $post_start );
//		echo $xoopsDB->error();

		while ( $row3 = $xoopsDB->fetchArray($res3) )
		{
			$post_arr = array();
			$post_id  = $row3['post_id'];
			$post_arr['post_id']     = $post_id;
			$post_arr['post_link']   = $topic_link.'#post_id'.$post_id;
			$post_arr['post_title']  = $row3['subject'];
			$post_arr['post_time']   = $row3['post_time'];
			$post_arr['post_time_s'] = formatTimestamp($row3['post_time'], "s");

// text
			$html   = 0;
			$smiley = 0;
			$xcodes = 0;
			$image  = 0;
			$br     = 0;

			if ( $row3['html'] )   $html   = 1;
			if ( $row3['smiley'] ) $smiley = 1;
			if ( $row3['xcode'] )  $xcode  = 1;
			if ( $row3['br'] )     $br     = 1;
			if ( $config['allow_textimg'] )  $image  = 1;

			$desc = preg_replace($pattern, $replacement, $row3['post_text']);
			$post_arr['post_text'] = 
				$myts->makeTareaData4Show($desc, $html, $smiley, $xcode, $image, $br);

			$thread_arr['posts'][ $post_id ] = $post_arr;
		}

		$arr['threads'][$topic_id] = $thread_arr;
	}

	return $arr;
}

?>