<?php
// $Id: rss_base_object.php,v 1.1 2007/06/08 19:01:54 ohwada Exp $

// 2007-06-01 K.OHWADA
// divid from rss_object.php
// move get_unixtime_rfc822 from rss_utility.php

// 2007-05-12 K.OHWADA
// this is new file
// porting form rssc_xml_object.php

//=========================================================
// Happy Linux Framework Module
// this file contains 3 classes
//   happy_linux_rss_base
//   happy_linux_rss_base_basic
//   happy_linux_rss_base_items
// 2007-05-12 K.OHWADA
//=========================================================

//=========================================================
// class happy_linux_rss_base
//=========================================================
class happy_linux_rss_base
{
// object
	var $_control_obj     = null;
	var $_channel_obj     = null;
	var $_image_obj       = null;
	var $_textinput_obj   = null;
	var $_items_obj       = null;
	var $_single_item_obj = null;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_linux_rss_base()
{
	// dummy
}

//---------------------------------------------------------
// set & get vars
//---------------------------------------------------------
function set_vars($arr)
{
	if ( isset($arr['control']) )
	{
		$this->set_control( $arr['control'] );
	}

	if ( isset($arr['channel']) )
	{
		$this->set_channel( $arr['channel'] );
	}

	if ( isset($arr['image']) )
	{
		$this->set_image( $arr['image'] );
	}

	if ( isset($arr['textinput']) )
	{
		$this->set_textinput( $arr['textinput'] );
	}

	if ( isset($arr['items']) )
	{
		$this->set_items( $arr['items'] );
	}
}

function set_control($arr)
{
	if ( is_array($arr) &&  ( count($arr) > 0 ) )
	{
		$this->_control_obj =& $this->create_control();
		$this->_control_obj->set_vars( $arr );
	}
}

function set_channel($arr)
{
	if ( is_array($arr) &&  ( count($arr) > 0 ) )
	{
		$this->_channel_obj =& $this->create_channel();
		$this->_channel_obj->set_vars( $arr );
	}
}

function set_image($arr)
{
	if ( is_array($arr) && ( count($arr) > 0 ) )
	{
		$this->_image_obj =& $this->create_image();
		$this->_image_obj->set_vars( $arr );
	}
}

function set_textinput($arr)
{
	if ( is_array($arr) && ( count($arr) > 0 ) )
	{
		$this->_textinput_obj =& $this->create_textinput();
		$this->_textinput_obj->set_vars( $arr );
	}
}

function set_items($items)
{
	if ( is_array($items) && ( count($items) > 0 ) )
	{
		$this->_items_obj =& $this->create_items();
		$this->_items_obj->set_vars( $items );
	}
}

function set_single_item($arr)
{
	if ( is_array($arr) && ( count($arr) > 0 ) )
	{
		$this->_single_item_obj =& $this->create_single_item();
		$this->_single_item_obj->set_vars( $arr );
	}
}

function &get_vars()
{
	$arr = array(
		'control'   => $this->get_control(),
		'channel'   => $this->get_channel(),
		'image'     => $this->get_image(),
		'textinput' => $this->get_textinput(),
		'items'     => $this->get_items(),
	);
	return $arr;
}

function &get_control()
{
	$ret = false;
	if ( isset($this->_control_obj) && is_object($this->_control_obj) )
	{
		$ret =& $this->_control_obj->get_vars();
	}
	return $ret;
}

function &get_channel()
{
	$ret = false;
	if ( isset($this->_channel_obj) && is_object($this->_channel_obj) )
	{
		$ret =& $this->_channel_obj->get_vars();
	}
	return $ret;
}

function &get_image()
{
	$ret = false;
	if ( isset($this->_image_obj) && is_object($this->_image_obj) )
	{
		$ret =& $this->_image_obj->get_vars();
	}
	return $ret;
}

function &get_textinput()
{
	$ret = false;
	if ( isset($this->_textinput_obj) && is_object($this->_textinput_obj) )
	{
		$ret =& $this->_textinput_obj->get_vars();
	}
	return $ret;
}

function &get_items()
{
	$ret = false;
	if ( isset($this->_items_obj) && is_object($this->_items_obj) )
	{
		$ret =& $this->_items_obj->get_vars();
	}
	return $ret;
}

function &get_single_item()
{
	$ret = false;
	if ( isset($this->_single_item_obj) && is_object($this->_single_item_obj) )
	{
		$ret =& $this->_single_item_obj->get_vars();
	}
	return $ret;
}

function &get_channel_by_key($key)
{
	$arr = $this->get_channel();

	$ret = false;
	if ( isset($arr[$key]) )
	{
		$ret =& $arr[$key];
	}
	return $ret;
}

//---------------------------------------------------------
// create
// overload this function
//---------------------------------------------------------
function &create_control()
{
	$obj =& new happy_linux_basic();
	return $obj;
}

function &create_channel()
{
	$obj =& new happy_linux_rss_basic();
	return $obj;
}

function &create_image()
{
	$obj =& new happy_linux_rss_basic();
	return $obj;
}

function &create_textinput()
{
	$obj =& new happy_linux_rss_basic();
	return $obj;
}

function &create_items()
{
	$obj =& new happy_linux_rss_basic();
	return $obj;
}

function &create_single_item()
{
	$obj =& new happy_linux_rss_basic();
	return $obj;
}

// --- class end ---
}


//=========================================================
// class happy_linux_rss_base_basic
//=========================================================
class happy_linux_rss_base_basic extends happy_linux_basic 
{
// class
	var $_strings;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_linux_rss_base_basic()
{
	$this->happy_linux_basic();

// class
	$this->_strings     =& happy_linux_strings::getInstance();
}

//---------------------------------------------------------
// is set & array
//---------------------------------------------------------
function get($key1, $key2=false)
{
	$ret = false;
	if ( isset($this->_vars[$key1]) )
	{
		if ( $key2 )
		{
			if ( isset($this->_vars[$key1][$key2]) )
			{
				$ret = $this->_vars[$key1][$key2];
			}
		}
		else
		{
			$ret = $this->_vars[$key1];
		}
	}
	return $ret;
}

function is_set($key1, $key2=false)
{
	if ( isset($this->_vars[$key1]) )
	{
		if ( $key2 )
		{
			if ( is_array($this->_vars[$key1]) && isset($this->_vars[$key1][$key2]) )
			{
				return true;
			}
		}
		else
		{
			return true;
		}
	}
	return false;
}

//-------------------------------------------------
// non restrict feed_type
// caller build, format_from_parse, format_from_db
//-------------------------------------------------
function _build_summary_for_format()
{
	$val = '';

// ATOM summary
	if ( $this->is_set('summary') )
	{
		$val = $this->get('summary');
	}

// RSS, RDF fulltext
	elseif ( $this->_use_fulltext && $this->is_set('fulltext') )
	{
		$val = $this->get('fulltext');
	}

// RSS, RDF description
	elseif ( $this->is_set('description') )
	{
		$val = $this->get('description');
	}

	elseif ( $this->is_set('dc', 'description') )
	{
		$val = $this->get('dc', 'description');
	}

// RSS, RDF content
	elseif ( $this->is_set('content', 'encoded') )
	{
		$val = $this->get('content', 'encoded');
	}

// ATOM content
	elseif ( $this->is_set('content') && $this->get('content') )
	{
		$val = $this->get('content');
	}

	$val = $this->_strings->strip_tags_for_text( $val );

	return $val;
}

// some RSS have twe or more enclosure tag
// set first one
function _get_enclosure_list()
{
	$url    = null;
	$type   = null;
	$length = null;

	if ( $this->is_set('enclosure') )
	{
		$enc = $this->get('enclosure');

		if ( isset($enc[0]['url']) )
		{
			$url = $enc[0]['url'];
		}
		if ( isset($enc[0]['type']) )
		{
			$type = $enc[0]['type'];
		}
		if ( isset($enc[0]['length']) )
		{
			$length = intval( $enc[0]['length'] );
		}
	}

	return array($url, $type, $length);
}

//--------------------------------------------------------
// get unixtime from RFC822
//--------------------------------------------------------
function get_unixtime_rfc822( $datetime )
{
	$unixtime = strtotime($datetime);

// maybe undefined time zone
	if ($unixtime == -1)
	{

// delete time zone
		$datetime = preg_replace("/ [a-zA-Z]{3,}$/", '', $datetime);
		$unixtime = strtotime( $datetime );
	}

// give up
	$unixtime = intval($unixtime);
	if ($unixtime < 0)
	{
		$unixtime = 0;
	}

	return $unixtime;
}

// -------------------------------------------------------------------------
// http://www.arielworks.net/articles/2004/0224c/
// array parse_w3cdtf(string datetime)
// -------------------------------------------------------------------------
// http://www.w3.org/TR/NOTE-datetime
//  Year:
//      YYYY (eg 1997)
//   Year and month:
//      YYYY-MM (eg 1997-07)
//   Complete date:
//      YYYY-MM-DD (eg 1997-07-16)
//   Complete date plus hours and minutes:
//      YYYY-MM-DDThh:mmTZD (eg 1997-07-16T19:20+01:00)
//   Complete date plus hours, minutes and seconds:
//      YYYY-MM-DDThh:mm:ssTZD (eg 1997-07-16T19:20:30+01:00)
//   Complete date plus hours, minutes, seconds and a decimal fraction of a second
//      YYYY-MM-DDThh:mm:ss.sTZD (eg 1997-07-16T19:20:30.45+01:00)
// -------------------------------------------------------------------------
function get_unixtime_w3cdtf($datetime)
{
	$unixtime = 0;
	$arr  = $this->parse_w3cdtf($datetime);

	if ( isset($arr['timestamp']) )
	{
		$unixtime = intval( $arr['timestamp'] );
	}

// give up
	if ($unixtime < 0)
	{
		$unixtime = 0;
	}

	return $unixtime;
}

function parse_w3cdtf($datetime)
{

// 2004-10-24 K.OHWADA
// suppress warning
	$year     = 0;
    $month    = 0;
    $day      = 0;
    $hour     = 0;
    $minute   = 0;
    $second   = 0;
    $fraction = 0;
    $timezone = 0;
	$offset_sign   = 0;
    $offset_hour   = 0;
    $offset_minute = 0;

    // Year
    if(preg_match("/^(\d{4})$/", $datetime, $val)) {
        $year = $val[1];

    // Year and month
    } elseif(preg_match("/^([0-9]{4})-(0[1-9]|1[0-2])$/", $datetime, $val)) {
        $year = $val[1];
        $month = $val[2];

    // Complete date
    } elseif(preg_match("/^([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $datetime, $val)) {
        $year = $val[1];
        $month = $val[2];
        $day = $val[3];

    // Complete date plus hours and minutes
    } elseif(preg_match("/^([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])T([0-5][0-9]):([0-5][0-9])(Z|(\+|-)[0-5][0-9]:[0-5][0-9])$/", $datetime, $val)) {
        $year = $val[1];
        $month = $val[2];
        $day = $val[3];
        $hour = $val[4];
        $minute = $val[5];
        $timezone = $val[6];

    // Complete date plus hours, minutes and seconds
    } elseif(preg_match("/^([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])T([0-5][0-9]):([0-5][0-9]):([0-5][0-9])(Z|(\+|-)[0-5][0-9]:[0-5][0-9])$/", $datetime, $val)) {
        $year = $val[1];
        $month = $val[2];
        $day = $val[3];
        $hour = $val[4];
        $minute = $val[5];
        $second = $val[6];
        $timezone = $val[7];

    // Complete date plus hours, minutes, seconds and a decimal fraction of a second
    } elseif(preg_match("/^([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])T([0-5][0-9]):([0-5][0-9]):([0-5][0-9]).([0-9]+)(Z|(\+|-)[0-5][0-9]:[0-5][0-9])$/", $datetime, $val)) {
        $year = $val[1];
        $month = $val[2];
        $day = $val[3];
        $hour = $val[4];
        $minute = $val[5];
        $second = $val[6];
        $fraction = $val[7];
        $timezone = $val[8];

    // Not W3C-DTF
    } else {
        return false;
    }

    // Offset of Timezone for gmmktime()
    if($timezone != "Z") {
        $offset_sign = substr($timezone, 0, 1);
        $offset_hour = substr($timezone, 1, 2);
        $offset_minute = substr($timezone, 4, 2);
    }

    $timestamp = gmmktime($hour - ($offset_sign . $offset_hour), $minute - ($offset_sign . $offset_minute), $second, $month, $day, $year);

    $result = array("year" => $year, "month" => $month, "day" => $day,
                    "hour" => $hour, "minute" => $minute, "second" => $second,
                    "fraction" => $fraction, "timezone" => $timezone, "timestamp" => $timestamp);

    return $result;
}

// --- class end ---
}


//=========================================================
// class happy_linux_rss_base_items
//=========================================================
class happy_linux_rss_base_items
{
	var $_item_objs = array();

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_linux_rss_base_items()
{
	// dummy();
}

//---------------------------------------------------------
// set & get var
//---------------------------------------------------------
function set_vars($items)
{
	$this->_item_objs = array();
	foreach ($items as $v)
	{
		$item_obj =& $this->create_item_singlel();
		$item_obj->set_vars( $v );
		$this->_item_objs[] =& $item_obj;
	}
}

function &get_vars()
{
	$arr = array();
	foreach ($this->_item_objs as $item_obj)
	{
		$arr[] = $item_obj->get_vars();
	}
	return $arr;
}

//---------------------------------------------------------
// create
// overload this function
//---------------------------------------------------------
function &create_item_singlel()
{
	$obj =& new happy_linux_rss_basic();
	return $obj;
}

// --- class end ---
}

?>