<?php
// $Id: whatsnew_pda_builder.php,v 1.1 2007/05/15 05:27:24 ohwada Exp $

// 2007-05-12 K.OHWADA
// module dupulication
// change filename from whatsnew_build_pda.php

// 2005-09-28 K.OHWADA
// change func.pda.php to class

//=========================================================
// What's New Module
// class template builder for PDA 
// 2005-06-20 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('whatsnew_pda_builder') ) 
{

//=========================================================
// class whatsnew_pda_builder
//=========================================================
class whatsnew_pda_builder extends happy_linux_build_rss
{

// class
	var $_class_block;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function whatsnew_pda_builder( $dirname )
{
	$HEADER    = 'Content-Type:text/html';
	$TEMPLATE  = 'db:'.$dirname.'_pda.html';

	$this->happy_linux_build_rss();
	$this->set_dirname( $dirname );
	$this->set_header(    $HEADER );
	$this->set_template(  $TEMPLATE );
	$this->set_title(  'WhatsNew PDA' );
	$this->set_flag_force_build( 1 );	// always build
	$this->set_mode( 'other' );

// class
	$this->_class_block =& whatsnew_show_block::getInstance();
	$this->_class_block->init( $dirname );
}

function &getInstance( $dirname )
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new whatsnew_pda_builder( $dirname );
	}
	return $instance;
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function _assign_other( &$tpl )
{
	$config =& $this->_get_config();

// sanitize
	$site_name = $this->_class_block->_html_special_chars( $config['site_name'] );
	$site_desc = $this->_class_block->_html_special_chars( $config['site_desc'] );

	$tpl->assign('xoops_charset', _CHARSET);
	$tpl->assign('site_url',  $config['site_url'] );
	$tpl->assign('site_name', $site_name);
	$tpl->assign('site_desc', $site_desc);

	if ( isset($config['image_url']) && $config['image_url'] )
	{
		$tpl->assign('image_url', $config['image_url'] );
	}

	$i     = 0;
	$block = array();

	foreach ( $this->_get_article() as $article )
	{
		$line = $this->_class_block->make_block_line($i, $article);

		if ( isset($article['pda']) && $article['pda'] )
		{
			$line['link'] = $article['pda'];
		}

		$block[] = $line;
		$i ++;
	}

	$tpl->assign('whatsnew', $block);
}

//-----------------------------------------------
// use class show block
//-----------------------------------------------
function &_get_config()
{
	$ret =& $this->_class_block->get_config_data();
	return $ret;
}

function &_get_article()
{
	$ret =& $this->_class_block->collect_block_date('block');
	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>