<?php
// $Id: submit.php,v 1.16 2007/06/18 07:28:03 ohwada Exp $

// 2007-06-18 K.OHWADA
// header_oh.php
// add WEBLINKS_URL in redirect_header

// 2007-05-18 K.OHWADA
// get_error_msg_addlink() -> get_errors_addlink()

// 2007-03-25 K.OHWADA
// small change

// 2007-03-01 K.OHWADA
// weblinks_link_handler.php
// update_category_link_count()

// 2006-12-10 K.OHWADA
// use weblinks_modify

// 2006-10-01 K.OHWADA
// use happy_linux
// use rssc WEBLINKS_RSSC_USE

// 2006-07-29 K.OHWADA
// REQ: countup xoops post count

// 2006-05-15 K.OHWADA
// add class weblinks_submit()
// use new handler
// use token ticket
// dont use global

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//================================================================
// WebLinks Module
// 2004/01/23 K.OHWADA
//================================================================

//---------------------------------------------------------
// TODO
// anonymous can choice recieve or not email
//---------------------------------------------------------

include 'header_oh.php';
include_once XOOPS_ROOT_PATH.'/include/xoopscodes.php';
include_once XOOPS_ROOT_PATH.'/class/xoopsformloader.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/include/gtickets.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/html.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/form.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_mailer.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_linkitem_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_linkitem_define_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_linkitem_store_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_form_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_form_check_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_sendmail.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_edit.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_edit_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_modify.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_modify_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_rssc_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_rssc_edit_handler.php';

//=========================================================
// class weblinks_submit
//=========================================================
class weblinks_submit extends happy_linux_error
{
	var $_dirname;

	var $_config_handler;
	var $_link_view_handler;
	var $_link_edit_handler;
	var $_link_form_handler;
	var $_link_check_handler;

	var $_rssc_edit_handler;
	var $_rssc_handler;

	var $_template;
	var $_myts;
	var $_post;

// config
	var $_conf;
	var $_has_auth_submit;
	var $_has_auth_submit_auto;
	var $_has_auth_html;

// system
	var $system_is_module_admin;
	var $system_is_user;
	var $system_module_name;
	var $system_uid;
	var $system_uname;
	var $system_email;

// post
	var $_post_notify;
	var $_post_op;
	var $_post_rss_flag;

	var $_newid;
	var $_banner_error_code = 0;
	var $_rssc_error_code   = 0;

	var $_flag_error = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_submit($dirname)
{
	$this->happy_linux_error();
	$this->set_debug_print_error( WEBLINKS_DEBUG_ERROR );

	$this->_dirname = $dirname;

	$this->_config_handler     =& weblinks_get_handler( 'config2_basic',   WEBLINKS_DIRNAME );
	$this->_link_view_handler  =& weblinks_get_handler( 'link_view',       WEBLINKS_DIRNAME );
	$this->_link_edit_handler  =& weblinks_get_handler( 'link_edit',       WEBLINKS_DIRNAME );
	$this->_link_form_handler  =& weblinks_get_handler( 'link_form',       WEBLINKS_DIRNAME );
	$this->_link_check_handler =& weblinks_get_handler( 'link_form_check', WEBLINKS_DIRNAME );

	$this->_rssc_edit_handler  =& weblinks_get_handler( 'rssc_edit',       WEBLINKS_DIRNAME );
	$this->_rssc_handler       =& weblinks_get_handler( 'rssc',            WEBLINKS_DIRNAME );

	$this->_template   =& weblinks_template::getInstance( $dirname );
	$this->_myts       =& MyTextSanitizer::getInstance();
	$this->_post       =& happy_linux_post::getInstance();

	$this->_conf =& $this->_config_handler->get_conf();

	$system =& happy_linux_system::getInstance();
	$this->system_is_module_admin = $system->is_module_admin();
	$this->system_is_user         = $system->is_user();
	$this->system_module_name     = $system->get_module_name();
	$this->system_uid             = $system->get_uid();

}

//---------------------------------------------------------
// POST param
//---------------------------------------------------------
function get_post_op()
{
	$op = '';
	if     (isset($_POST['submit']))   $op = 'submit';
	elseif (isset($_POST['preview']))  $op = 'preview';
	$this->_post_op = $op;
	return $op;
}

function get_post_notify()
{
	$this->_post_notify = $this->_post->get_post_int('notify');
	return $this->_post_notify;
}

function get_post_rss_flag()
{
	$this->_post_rss_flag = $this->_post->get_post_get_int('rss_flag');
	return $this->_post_rss_flag;
}

//---------------------------------------------------------
// check_access
//---------------------------------------------------------
function check_access()
{
	$this->_has_auth_submit      = $this->_link_edit_handler->has_auth_submit();
	$this->_has_auth_submit_auto = $this->_link_edit_handler->has_auth_submit_auto();

// admin
	if ( $this->system_is_module_admin )
	{
		return 1;	// admin
	}

// not permit
	if ( !$this->_has_auth_submit ) 
	{
		if ( $this->system_uid ) 
		{
			return -1;	// not permit
		}
		else
		{
			return -2;	// anonymous
		}
	}

	$this->_link_edit_handler->init();

	return 0;	// OK
}

function get_permit_param()
{
	$ret = array($this->_has_auth_submit_auto, $this->system_is_user);
	return $ret;
}

//---------------------------------------------------------
// submit_form
//---------------------------------------------------------
function print_submit_form()
{
	$this->print_submit_header();
	$this->print_submit_comment();

	$this->show_user_form('submit');
}

function show_user_form($form_mode)
{
	$notify_show = 0;

	if ( !$this->_has_auth_submit_auto && $this->system_is_user )
	{
		$notify_show = 1;
	}

	$this->_link_form_handler->set_notify_show( $notify_show );
	$this->_link_form_handler->show_user_form($form_mode);
}

//---------------------------------------------------------
// preview
//---------------------------------------------------------
function print_preview()
{
	$this->print_submit_header();
	echo "<hr />\n";
	echo "<h4>"._PREVIEW."</h4>\n";

// check form
	if ( !$this->_link_check_handler->check_form_addlink_by_post() ) 
	{
		echo '<div class="weblinks_submit_error">';
		echo $this->_link_check_handler->get_errors_addlink('s');
		echo $this->_link_check_handler->get_formated_error_addlink();
		echo "</div>\n";
		echo "<br />\n";
	}

	$arr_preview = $this->_link_edit_handler->build_submit_preview();

// check preview error
	if ( !$this->_link_edit_handler->check_preview_result() )
	{
		echo $this->_link_edit_handler->get_error_msg_preview();
		echo "<br />\n";
	}

	echo $this->_template->fetch_link_single( $arr_preview );

	echo "<hr />\n";
	$this->print_submit_comment();

	$this->show_user_form('submit_preview');
}

//---------------------------------------------------------
// submit
//---------------------------------------------------------
function check_form()
{
	$this->_flag_error = 0;
	if( !$this->_link_edit_handler->check_token() ) 
	{
		$this->_flag_error = 1;
		return false;
	}
	if ( !$this->_link_check_handler->check_form_addlink_by_post() )
	{
		$this->_flag_error = 2;
		return false;
	}
	return true;
}

function print_form_with_error()
{
	$this->print_submit_header();

	if ( $this->_flag_error == 1 )
	{
		echo "<br />\n";
		xoops_error( "Token Error" );
		echo "<br />\n";
	}

	if ( $this->_flag_error == 2 )
	{
		echo '<div class="weblinks_submit_error">';
		echo $this->_link_check_handler->get_errors_addlink('s');
		echo $this->_link_check_handler->get_formated_error_addlink();
		echo "</div>\n";
		echo "<br />\n";
	}

	$this->print_submit_comment();
	$this->show_user_form('submit_preview');
}

function post_auto_approve()
{
	$newid = $this->_link_edit_handler->add_link_by_post( true );
	if (!$newid)
	{
		$this->_set_errors( $this->_link_edit_handler->getErrors() );
		return false;
	}

	$this->_banner_error_code = $this->_link_edit_handler->get_banner_error_code();

	if ( $this->_conf['cat_count'] )
	{
// not check error
		$this->_link_edit_handler->update_category_link_count();
	}

// REQ: countup xoops post count
	global $xoopsUser;
	if ( $this->_conf['system_post_link'] && is_object($xoopsUser) ) 
	{
		$xoopsUser->incrementPost();
	}

	$this->_newid = $newid;
	return $newid;
}

function post_approve()
{
	$newid = $this->_link_edit_handler->add_link_to_modify_by_post();
	if (!$newid)
	{
		$this->_set_errors( $this->_link_edit_handler->getErrors() );
		return false;
	}

	return $newid;
}

//---------------------------------------------------------
// print
//---------------------------------------------------------
function print_submit_header()
{
	echo '<link rel="stylesheet" type="text/css" media="all" href="'.WEBLINKS_URL.'/weblinks.css" />'."\n";
	echo '&nbsp;';
	echo '<a href="'.XOOPS_URL.'/">'._HOME.'</a> &gt;&gt;';
	echo '<a href="'.WEBLINKS_URL.'/">'.$this->system_module_name.'</a> &gt;&gt;';
	echo '<span class="weblinks_bold">'._WLS_SUBMIT_NEW_LINK.'</span><br /><br />'."\n";
}

function print_submit_comment()
{
	echo '<div style="width: 100%; margin: 5px; padding: 5px;">'."\n";

	echo $this->_conf['submit_main'];

	if ( !$this->_has_auth_submit_auto )
	{
		echo $this->_conf['submit_pending'];
	}

// check_double
	if ( $this->_conf['check_double'] )
	{
		echo $this->_conf['submit_double'];
	}

	echo "</div><br />\n";
}

//---------------------------------------------------------
// event tags
//---------------------------------------------------------
function build_tags_addlink($newid)
{
	list($tags, $cid) = $this->_link_edit_handler->build_tags_addlink($newid);
	return array($tags, $cid);
}

//---------------------------------------------------------
// rssc edit handler
//---------------------------------------------------------
function add_rssc()
{
	$ret = $this->_rssc_edit_handler->add_rssc( $this->_newid );
	if ( $ret != 0 )
	{
		$this->_set_errors( $this->_rssc_edit_handler->getErrors() );
	}

	$this->_rssc_error_code = $ret;
	return $ret;
}

//---------------------------------------------------------
// get_add_link_msg
//---------------------------------------------------------
function get_add_link_msg()
{
	$msg = '';

	if ( $this->_banner_error_code )
	{
		$msg .= _WEBLINKS_WARN_BANNER_NOT_GET_SIZE."<br />\n";
	}

	switch ( $this->_rssc_error_code )
	{
		case RSSC_CODE_DISCOVER_FAILED:
			$msg .= _RSSC_DISCOVER_FAILED."<br />\n";
			break;

		case RSSC_CODE_PARSE_FAILED:
			$msg .= _RSSC_PARSE_FAILED."<br />\n";
			break;

		case RSSC_CODE_PARSE_NOT_READ_XML_URL:
			$msg .= _RSSC_PARSE_NOT_READ_XML_URL."<br />\n";
			break;
	}

	return $msg;
}

//---------------------------------------------------------
// utility
//---------------------------------------------------------
function build_comment($str)
{
	$ret = $this->_link_edit_handler->build_comment($str);
	return $ret;
}

// --- class end ---
}


//=========================================================
// main
//=========================================================
//$conf_cat_path = 1;

$weblinks_submit   =& new weblinks_submit( WEBLINKS_DIRNAME );
$weblinks_sendmail =& weblinks_sendmail::getInstance( WEBLINKS_DIRNAME );
$weblinks_time     =& happy_linux_time::getInstance();

$FLAG_EVENT_ANONYMOUS = 1;	// send email for anonymous

// check permit
$check = $weblinks_submit->check_access();

if ( $check == -1 ) 
{
	$msg  = _NOPERM;
	$msg .= $weblinks_submit->build_comment("not permit");	// for test form
	redirect_header( WEBLINKS_URL.'/index.php', 2, $msg);
	exit();
}

if ( $check == -2 ) 
{
	$msg  = _WLS_MUSTREGFIRST;
	$msg .= $weblinks_submit->build_comment("not user");	// for test form
	redirect_header( XOOPS_URL.'/user.php', 2, $msg);
	exit();
}

if ( $check == 1 )
{
// add WEBLINKS_URL
	$url = WEBLINKS_URL. '/admin/link_manage.php?op=addLink';

// REQ 3110: Add in this category
	if ( isset($_GET['cid']) )
	{
		$url .= '&amp;cid='.$_GET['cid'];
	}

	redirect_header($url, 2, _WLS_GOTOADMIN);	
}

$op       = $weblinks_submit->get_post_op();
$notify   = $weblinks_submit->get_post_notify();
$rss_flag = $weblinks_submit->get_post_rss_flag();

// start
list($has_auto_approve, $is_user) = $weblinks_submit->get_permit_param();

// Notify of new link (anywhere) and new link in category.
$notification_handler =& xoops_gethandler('notification');

// save to DB
if ( $op == 'submit' )
{

	if ( !$weblinks_submit->check_form() )
	{
		include XOOPS_ROOT_PATH.'/header.php';
		$weblinks_submit->print_form_with_error();
		include XOOPS_ROOT_PATH.'/footer.php';
		exit();
	}

// auto approve
	if ( $has_auto_approve )
	{
// insert link
		$newid = $weblinks_submit->post_auto_approve();
		if (!$newid)
		{
			redirect_header( WEBLINKS_URL.'/index.php', 3, "DB Error");
			exit();
		}

		$url_singlelink = WEBLINKS_URL. '/singlelink.php?lid='. $newid;

// notification
		list($tags, $cid) = $weblinks_submit->build_tags_addlink($newid);
		$notification_handler->triggerEvent('global', 0, 'new_link', $tags);
		$notification_handler->triggerEvent('category', $cid, 'new_link', $tags);

		if ( WEBLINKS_RSSC_USE && $rss_flag )
		{
// add rssc
			$ret = $weblinks_submit->add_rssc();
			if ($ret == WEBLINKS_CODE_DB_ERROR)
			{
				redirect_header($url_singlelink, 3, "DB Error");
				exit();
			}
		}

// redirect to single link
		$msg  = _WLS_RECEIVED."<br />\n";
		$msg .= _WLS_ISAPPROVED."<br />\n";
		$msg2 = $weblinks_submit->get_add_link_msg();
		$time = $weblinks_time->get_elapse_time();
		if ( $msg2 )
		{
			$msg .= "<br />\n";
			$msg .= "$msg2 <br />\n";
			$msg .= "$time sec";
			redirect_header($url_singlelink, 5, $msg);
		}

		$msg .= "$time sec <br />\n";
		$msg .= $weblinks_submit->build_comment("submit approve link");	// for test form
		redirect_header($url_singlelink, 2, $msg);
	}

// approve
	else
	{
// insert link	
// bug fix: approve notify mail dont send

		$modify_newid = $weblinks_submit->post_approve();
		if (!$modify_newid)
		{
			redirect_header( WEBLINKS_URL.'/index.php', 3, "DB Error");
			exit();
		}

// send email to admin, new link notification for user
		list($tags, $cid) = $weblinks_submit->build_tags_addlink($modify_newid);
		$tags['WAITINGLINKS_URL'] = WEBLINKS_URL.'/admin/link_manage.php?op=listNewLinks';
		$notification_handler->triggerEvent('global', 0, 'link_edit', $tags);
		$notification_handler->triggerEvent('category', $cid, 'link_edit', $tags);

// register to waiting notification for user
		if ($notify) 
		{
			include_once XOOPS_ROOT_PATH . '/include/notification_constants.php';

// bug fix: approve notify mail dont send
			$notification_handler->subscribe('link', $modify_newid, 'approve', XOOPS_NOTIFICATION_MODE_SENDONCETHENDELETE);
		}

// send email to admin, new link notification for anonymous
// REQ 3028: send new link email to admin
// TODO: anonymous can choice recieve or not email

		if ( $FLAG_EVENT_ANONYMOUS && !$is_user && !empty($_POST['mail']) )
		{
			$ret = $weblinks_sendmail->send_newlink_to_admin();
			if (!$ret)
			{
				$msg = _WLS_RECEIVED."<br />Mail Error";
				redirect_header( WEBLINKS_URL.'/index.php', 3, $msg);
			}
		}

		$msg  = _WLS_RECEIVED;
		$msg .= $weblinks_submit->build_comment("submit request link");	// for test form
		redirect_header( WEBLINKS_URL.'/index.php', 2, $msg);
	}
}

// preview mode
elseif ($op == 'preview')
{
	include XOOPS_ROOT_PATH.'/header.php';
	$weblinks_submit->print_preview();
	include XOOPS_ROOT_PATH.'/footer.php';
}

// submit form
else 
{
	include XOOPS_ROOT_PATH.'/header.php';
	$weblinks_submit->print_submit_form();
	include XOOPS_ROOT_PATH.'/footer.php';
}

exit();
// --- end of main ---

?>