<?php
// $Id: gm_get_location.php,v 1.13 2007/07/08 02:48:17 ohwada Exp $

// 2007-07-01 K.OHWADA
// is_japanese()

// 2007-03-17 wye
// BUG 4509: JavaScript error

// 2006-12-10 wye & K.OHWADA
// google map: googleGeocode

// 2006-11-22 wye & K.OHWADA
// google map: JP Geocode

// 2006-11-04 wye & K.OHWADA
// google map: JP inverse Geocoder
// google map: inline mode

// 2006-10-15 wye & K.OHWADA
// BUG 4313: in some enviroment, character code is judged by mistake.

//================================================================
// WebLinks Module
// 2006-10-01 wye <http://never-ever.info/>
//================================================================

//---------------------------------------------------------
// myself:     gm_get_location.php
// new window: gm_get_location.php?mode=opener
// inline:     gm_get_location.php?mode=parent
//---------------------------------------------------------

include "header.php";

$config_handler =& weblinks_get_handler( 'config2_basic', WEBLINKS_DIRNAME );
$system         =& happy_linux_system::getInstance();
$post           =& happy_linux_post::getInstance();

$mode = $post->get_get_text('mode');
$conf = $config_handler->get_conf();

// google map: googleGeocode
$flag_google_geocode = true;

$str_is_japanese = "false";
$flag_jp_geocode =  false;
$flag_jp_inv_geo =  false;
if ( $system->is_japanese() )
{
	$str_is_japanese = "true";
	$flag_jp_geocode =  true;
	$flag_jp_inv_geo =  true;
}

// constant
$ICON_SIZE_WIDTH  = 15;
$ICON_SIZE_HEIGHT = 15;
$ICON_ANCHOR_X    = 8;
$ICON_ANCHOR_Y    = 8;
$ACCURACY_TO_ZOOM = 12;
$ZOOM_MAX         = 17;
$ZOOM_DEFAULT     = 13;
$ICON_IMAGE       = WEBLINKS_ROOT_PATH.'/images/cicon.png';

//---------------------------------------------------------
// Google Map Configurations
//---------------------------------------------------------
$gm_lang              = _LANGCODE;
$gm_apikey            = $conf['gm_apikey'];
$gm_server            = $conf['gm_server'];
$gm_default_latitude  = $conf['gm_latitude'];
$gm_default_longitude = $conf['gm_longitude'];
$gm_default_zoom      = $conf['gm_zoom'];

$gm_default_location  = happy_linux_convert_to_utf8( $conf['gm_location'] );
$gm_default_location  = htmlspecialchars($gm_default_location, ENT_QUOTES);

$gm_version = '2';
//---------------------------------------------------------

$gm_url = $gm_server.'maps?file=api&amp;hl='.$gm_lang.'&amp;v='.$gm_version.'&amp;key='.$gm_apikey;
$gm_lang_location = _WEBLINKS_GM_LATITUDE.': #lat# / '._WEBLINKS_GM_LONGITUDE.': #lng# / '._WEBLINKS_GM_ZOOM.': #zoom#';
$gm_lang_default_location = _WEBLINKS_GM_LATITUDE.': '.$gm_default_latitude.' / '._WEBLINKS_GM_LONGITUDE.': '.$gm_default_longitude.' / '._WEBLINKS_GM_ZOOM.': '.$gm_default_zoom;

$gm_lang_location         = happy_linux_convert_to_utf8( $gm_lang_location );
$gm_lang_default_location = happy_linux_convert_to_utf8( $gm_lang_default_location );

$lang_title            = happy_linux_convert_to_utf8( _WEBLINKS_GM_GET_LOCATION );
$lang_get_latitude     = happy_linux_convert_to_utf8( _WEBLINKS_GM_GET_LATITUDE );
$lang_get_addr         = happy_linux_convert_to_utf8( _WEBLINKS_GM_GET_ADDR );
$lang_default_location = happy_linux_convert_to_utf8( _WEBLINKS_GM_DEFAULT_LOCATION );
$lang_current_location = happy_linux_convert_to_utf8( _WEBLINKS_GM_CURRENT_LOCATION );
$lang_not_compatible   = happy_linux_convert_to_utf8( _WEBLINKS_GM_NOT_COMPATIBLE );
$lang_off              = happy_linux_convert_to_utf8( _WEBLINKS_GM_DISP_OFF );
$lang_js_invalid       = happy_linux_convert_to_utf8( _WEBLINKS_JAVASCRIPT_INVALID );
$lang_close            = happy_linux_convert_to_utf8( _CLOSE );

// geocode
$lang_search_map_from_addr    = happy_linux_convert_to_utf8( _WEBLINKS_GM_SEARCH_MAP_FROM_ADDRESS );
$lang_no_match_place          = happy_linux_convert_to_utf8( _WEBLINKS_GM_NO_MATCH_PLACE );
$lang_jp_search_map_from_addr = happy_linux_convert_to_utf8( _WEBLINKS_GM_JP_SEARCH_MAP_FROM_ADDRESS );
$lang_jp_tokyo_geocode        = happy_linux_convert_to_utf8( _WEBLINKS_GM_JP_TOKYO_AC_GEOCODE );
$lang_jp_mlit_isj             = happy_linux_convert_to_utf8( _WEBLINKS_GM_JP_MLIT_ISJ );

$google_geocode = '';
if ($flag_google_geocode)
{
$google_geocode = <<<END_OF_TEXT
<form action="#" onsubmit="googleGeocoder(this.address_search.value); return false">
<input type="text" id="address_search" name="address_search" size="60" />
<input type="submit" value="$lang_search_map_from_addr" />
</form>
END_OF_TEXT;
}

$jp_geocode = '';
if ($flag_jp_geocode)
{
$jp_geocode = <<<END_OF_TEXT
<br />
<input type="button" value="$lang_jp_search_map_from_addr" onClick="geocoderFromSearchJp()">
<br />
<span style="font-size:80%;">
<a href="http://pc035.tkl.iis.u-tokyo.ac.jp/~sagara/geocode/" target="_blank">
$lang_jp_tokyo_geocode
</a> (<a href="http://nlftp.mlit.go.jp/isj/" target="_blank">
$lang_jp_mlit_isj
</a>) </span>
<div id="address_select_jp"></div>
<br />
END_OF_TEXT;
}

// BUG 4313: in some enviroment, character code is judged by mistake.
happy_linux_http_output('pass');
header ('Content-Type:text/html; charset=UTF-8');

echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">'."\n";

if ($gm_apikey)
{
// --- raw HTML begin ---
?>
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml">
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Cache-Control" content="no-cache">
<meta http-equiv="Expires" content="Thu, 01 Dec 1994 16:00:00 GMT">
<title>weblinks - <?php echo $lang_title; ?></title>
<script src="<?php echo $gm_url; ?>" type="text/javascript" charset="UTF-8"></script>

<script type="text/javascript">
//<![CDATA[
var opener_mode = "<?php echo $mode; ?>";
var gm_default_location = "<?php echo $gm_default_location; ?>";
var gm_default_latitude = <?php echo $gm_default_latitude; ?>;
var gm_default_longitude = <?php echo $gm_default_longitude; ?>;
var gm_default_zoom = <?php echo $gm_default_zoom; ?>;
var gm_lang_location = "<?php echo $gm_lang_location; ?>";
var centermarker, Dmarker;
var geocoder;

// google Geocoder
var is_japanese = <?php echo $str_is_japanese; ?>;
var flag_google_geocode = "<?php echo $flag_google_geocode; ?>";

// JP Geocoder
var flag_jp_geocode = "<?php echo $flag_jp_geocode; ?>";
var map;
var candidates;
var iconf;

// JP inverse Geocoder
var flag_jp_inv_geo = "<?php echo $flag_jp_inv_geo; ?>";
var jp_inv_address = '';
var jp_inv_pref    = '';
var jp_inv_city    = '';
var jp_inv_town    = '';
var jp_inv_number  = '';

function load() 
{
	if ( GBrowserIsCompatible() )
	{
		showGmap();
	}
	else
	{
		document.getElementById("not_compatible").innerHTML = "<?php echo $lang_not_compatible; ?>";
	}
}
function showGmap() 
{
	map = new GMap2( document.getElementById("map") );
	map.addControl(new GLargeMapControl());
	map.addControl(new GMapTypeControl());
	geocoder = new GClientGeocoder();

	//center marker
	var center_icon = new GIcon();
	center_icon.image = "<?php echo $ICON_IMAGE; ?>";
	center_icon.iconSize = new GSize( <?php echo $ICON_SIZE_WIDTH; ?> , <?php echo $ICON_SIZE_HEIGHT; ?> );
	center_icon.iconAnchor = new GPoint( <?php echo $ICON_ANCHOR_X; ?> , <?php echo $ICON_ANCHOR_Y; ?> );

	GEvent.addListener(map, "moveend", function() {
		var center = map.getCenter();
		var zl = map.getZoom();

		msg_jp_address = '';

		if ( flag_jp_inv_geo )
		{
			inverseGeocoderJp( center.y , center.x );
			msg_jp_address = '<input type="button" value="<?php echo $lang_get_addr; ?>" onclick="setParentAddressFromInvJp()"> ';
		}

		var current_latitude = sprintf( gm_lang_location , { lat:center.y, lng:center.x, zoom:zl} ) + '<br /><br />';
		var message = '<input type="button" value="<?php echo $lang_get_latitude; ?>" onclick="setParentLatitude('+center.y+','+center.x+','+zl+')"> ';
		message += msg_jp_address;

		if (( opener_mode == '' )||( opener_mode == 'opener' ))
		{
			message += '<input type="button" value="<?php echo $lang_close; ?>" onclick="window.close()"> ';
		}
		else if ( opener_mode == 'parent' )
		{
			message += '<input type="button" value="<?php echo $lang_off; ?>" onClick="dispOff()"> ';
		}

		document.getElementById("current_latitude").innerHTML = current_latitude; 
		document.getElementById("message").innerHTML = message; 

	//Center marker
		map.removeOverlay( centermarker );
		centermarker = new GMarker( map.getCenter(), center_icon );
		map.addOverlay( centermarker );

	//Draggable marker
		map.removeOverlay( Dmarker );
		Dmarker = new GMarker( map.getCenter(), { draggable:true , bouncy:true , bounceGravity:0.5 } );
		map.addOverlay( Dmarker );

		GEvent.addListener( Dmarker, "dragend", function() {
			window.setTimeout( function() {
				map.panTo( Dmarker.getPoint() );
			}, 1000 );
		});

	});

	parent_param = getParentLatitude();
	parent_flag  = parent_param[0];

// if parent param is set
	if( parent_flag )
	{
		now_lat  = parent_param[1];
		now_lng  = parent_param[2];
		now_zoom = parent_param[3];
	}
// if NOT set
	else
	{
		now_lat  = gm_default_latitude;
		now_lng  = gm_default_longitude;
		now_zoom = gm_default_zoom;
	}

	map.setCenter( new GLatLng( now_lat, now_lng ), Math.floor( now_zoom ) );

	addr = getParentAddress();

	if ( flag_google_geocode && addr )
	{
		document.getElementById("address_search").value = addr.htmlspecialchars();

// if parent param is NOT set
		if( parent_flag == false )
		{
			googleGeocoder(addr);
		}
	}

	if ( flag_jp_geocode && addr )
	{
		geocoderJp(addr);
	}

}
function getParentLatitude() 
{
	lat  = 0;
	lng  = 0;
	zoom = 0;
	flag = false;

	if ( opener_mode == 'opener' )
	{
// when parent exist
		if ( opener != null )
		{
// when element exist
			if ( opener.document.getElementById("gm_latitude") != null )
			{
				lat  = opener.document.getElementById("gm_latitude").value;
			}
			if ( opener.document.getElementById("gm_longitude") != null )
			{
				lng  = opener.document.getElementById("gm_longitude").value;
			}
			if ( opener.document.getElementById("gm_zoom") != null )
			{
				zoom = opener.document.getElementById("gm_zoom").value;
			}
		}
	}
	else if ( opener_mode == 'parent' )
	{
// when parent exist
		if ( parent != null )
		{
// when element exist
			if ( parent.document.getElementById("gm_latitude") != null )
			{
				lat  = parent.document.getElementById("gm_latitude").value;
			}
			if ( parent.document.getElementById("gm_longitude") != null )
			{
				lng  = parent.document.getElementById("gm_longitude").value;
			}
			if ( parent.document.getElementById("gm_zoom") != null )
			{
				zoom = parent.document.getElementById("gm_zoom").value;
			}
		}
	}

// if parent param is set
	if( (lat != 0) || (lng != 0) || (zoom != 0) )
	{
		flag = true;
	}

	arr = new Array(flag, lat, lng, zoom);
	return arr;
}
function setParentLatitude( yyy , xxx , zzz )
{
	//xxx=Math.floor(xxx * 100000000)/100000000;
	//yyy=Math.floor(yyy * 100000000)/100000000;
	if ( opener_mode == 'opener' )
	{
// when parent exist
		if ( opener != null) 
		{
// when element exist
			if ( opener.document.getElementById("gm_latitude") != null) 
			{
				opener.document.getElementById( "gm_latitude" ).value = yyy;
			}
			if ( opener.document.getElementById("gm_longitude") != null)
			{
				opener.document.getElementById( "gm_longitude" ).value = xxx;
			}
			if ( opener.document.getElementById("gm_zoom") != null)
			{
				opener.document.getElementById( "gm_zoom" ).value = Math.floor( zzz );
			}
		}
	}
	else if ( opener_mode == 'parent' )
	{
// when parent exist
		if ( parent != null) 
		{
// when element exist
			if ( parent.document.getElementById("gm_latitude") != null) 
			{
				parent.document.getElementById( "gm_latitude" ).value = yyy;
			}
			if ( parent.document.getElementById("gm_longitude") != null)
			{
				parent.document.getElementById( "gm_longitude" ).value = xxx;
			}
			if ( parent.document.getElementById("gm_zoom") != null)
			{
				parent.document.getElementById( "gm_zoom" ).value = Math.floor( zzz );
			}
		}
	}
}
function getParentAddress()
{
	state = '';
	city  = '';
	addr  = '';

	if ( opener_mode == 'opener' )
	{
// when parent exist
		if ( opener != null )
		{
// when element exist
			if ( opener.document.getElementById("state") != null )
			{
				state = opener.document.getElementById("state").value;
			}
			if ( opener.document.getElementById("city") != null )
			{
				city = opener.document.getElementById("city").value;
			}
			if ( opener.document.getElementById("addr") != null )
			{
				addr = opener.document.getElementById("addr").value;
			}
		}
	}
	else if ( opener_mode == 'parent' )
	{
// when parent exist
		if ( parent != null )
		{
// when element exist
			if ( parent.document.getElementById("state") != null )
			{
				state  = parent.document.getElementById("state").value;
			}
			if ( parent.document.getElementById("city") != null )
			{
				city  = parent.document.getElementById("city").value;
			}
			if ( parent.document.getElementById("addr") != null )
			{
				addr = parent.document.getElementById("addr").value;
			}
		}
	}

	if ( is_japanese )
	{
		addr_cat = state + city + addr;
	}
	else
	{
		addr_cat = addr + ' ' + city + ' ' + state;
	}

	return addr_cat;
}
function setParentAddressFromInvJp()
{
	var location = jp_inv_address;
	var state    = jp_inv_pref;
	var city     = jp_inv_city;
	var addr     = jp_inv_town + jp_inv_number;
	setParentAddress(location, state, city, addr);
}
function setParentAddress(location, state, city, addr)
{
	if ( opener_mode == 'opener' )
	{
// when parent exist
		if ( opener != null) 
		{
// when element exist
			if (( opener.document.getElementById("gm_location") != null)&&(location != ''))
			{
				opener.document.getElementById( "gm_location" ).value = location.htmlspecialchars();
			}
			if (( opener.document.getElementById("state") != null)&&(state != ''))
			{
				opener.document.getElementById( "state" ).value = state.htmlspecialchars();
			}
			if (( opener.document.getElementById("city") != null)&&(city != ''))
			{
				opener.document.getElementById( "city" ).value = city.htmlspecialchars();
			}
			if (( opener.document.getElementById("addr") != null)&&(addr != ''))
			{
				opener.document.getElementById( "addr" ).value = addr.htmlspecialchars();
			}
		}
	}
	else if ( opener_mode == 'parent' )
	{
// when parent exist
		if ( parent != null) 
		{
// when element exist
			if (( parent.document.getElementById("gm_location") != null)&&(location != ''))
			{
				parent.document.getElementById( "gm_location" ).value = location.htmlspecialchars();
			}
			if (( parent.document.getElementById("state") != null)&&(state != ''))
			{
				parent.document.getElementById( "state" ).value = state.htmlspecialchars();
			}
			if (( parent.document.getElementById("city") != null)&&(city != ''))
			{
				parent.document.getElementById( "city" ).value = city.htmlspecialchars();
			}
			if (( parent.document.getElementById("addr") != null)&&(addr != ''))
			{
				parent.document.getElementById( "addr" ).value = addr.htmlspecialchars();
			}
		}
	}
}
function dispOff()
{
	if ( opener_mode == 'parent' )
	{
// when parent exist
		if ( parent != null) 
		{
			if ( parent.document.getElementById("weblinks_gm_iframe") != null)
			{
				parent.document.getElementById("weblinks_gm_iframe").innerHTML = '';
			}
		}
	}
}
function googleGeocoder(addr) 
{
	if (geocoder && addr) 
	{
		geocoder.getLatLng(addr, function(point) {
			if (!point) 
			{
				alert( "<?php echo $lang_no_match_place; ?>" + "\n" + addr );
			}
			else 
			{
				map.setCenter( point, <?php echo $ZOOM_DEFAULT; ?> );
			}
		});
 	}
}
function googleGeocoder2( addr )
{
	var address_select = document.getElementById("address_select");
	if (geocoder && addr) 
	{
		geocoder.getLocations( addr , function( response ) {
			if ( !response || response.Status.code != 200 ) 
			{
				alert( "<?php echo $lang_no_match_place; ?>" + "\n" + addr );
				alert( query + " not found" );
			}
			else 
			{
				place = response.Placemark[0];
				var point = new GLatLng( place.Point.coordinates[1] , place.Point.coordinates[0] );
				// alert( place.AddressDetails.Accuracy );
				var zoom = place.AddressDetails.Accuracy + <?php echo $ACCURACY_TO_ZOOM; ?>;
				zoom = maxZoom( zoom );
				map.setCenter( point , zoom );
			}
		});
	}
}
function maxZoom( z )
{
	if ( z > <?php echo $ZOOM_MAX; ?> )
	{
		z = <?php echo $ZOOM_MAX; ?>;
	}
	return z;
}
function geocoderFromSearchJp()
{
	addr = document.getElementById("address_search").value;
	if ( addr )
	{
		geocoderJp( addr );
	}
}
function geocoderJp( addr )
{
	if( addr != '' )
	{
		var url = 'gm_jp_geocode.php?query=' + encodeURI( addr );
		GDownloadUrl( url , function( data , responseCode ) {
			if( responseCode == 200 )
			{
				// alert(data);
				xml = GXml.parse( data );
				candidates = xml.documentElement.getElementsByTagName("candidate");
				iconf = xml.documentElement.getElementsByTagName("iConf")[0].firstChild.nodeValue;
				select  = '';

				if( candidates.length == 1 )
				{
					geoMapSetCenterJp( 0 );
				}
				else if( candidates.length == 0 )
				{
					alert( "<?php echo $lang_no_match_place; ?>" + "\n" + addr );
				}
				else
				{
					select  = '<form><select id="georst" onchange="geoMapSetCenterJp(this.value)">';
					select += '<option value="">--</option>';
					for( i = 0; i < candidates.length ; i++ )
					{
						address = candidates[i].getElementsByTagName("address")[0];
						select += '<option value="'+ i +'">';
						select += address.firstChild.nodeValue.htmlspecialchars() +'</option>';
					}
					select += '</select></form>';
				}

				address_select_jp = document.getElementById("address_select_jp");
				address_select_jp.innerHTML = select;
			}
		});
	}
}
function geoMapSetCenterJp( val )
{
	var lng = candidates[val].getElementsByTagName('longitude')[0].firstChild.nodeValue;
	var lat = candidates[val].getElementsByTagName('latitude')[0].firstChild.nodeValue;
	var zm = Math.floor( iconf );
	zm = ( zm >= 2 && zm <= 5 ) ? 12 + zm : 13;
	zm = maxZoom( zm );
	map.setCenter( new GLatLng( parseFloat( lat ) , parseFloat( lng ) ) , Math.floor( zm ) );
}
function inverseGeocoderJp( lat , lng )
{
	var url = 'gm_jp_invgeo.php?lon='+ lng +'&lat='+ lat;
	GDownloadUrl( url , function( data , responseCode ) {
		if( responseCode == 200 )
		{
			var xml = GXml.parse( data );
			if ( xml.documentElement.getElementsByTagName("address")[0] != null) 
			{
				jp_inv_address  = xml.documentElement.getElementsByTagName("address")[0].firstChild.nodeValue;
			}
			if ( xml.documentElement.getElementsByTagName("pref")[0] != null) 
			{
				jp_inv_pref  = xml.documentElement.getElementsByTagName("pref")[0].firstChild.nodeValue;
			}
			if ( xml.documentElement.getElementsByTagName("city")[0] != null) 
			{
				jp_inv_city  = xml.documentElement.getElementsByTagName("city")[0].firstChild.nodeValue;
			}
			if ( xml.documentElement.getElementsByTagName("town")[0] != null) 
			{
				jp_inv_town  = xml.documentElement.getElementsByTagName("town")[0].firstChild.nodeValue;;
			}
			if ( xml.documentElement.getElementsByTagName("number")[0] != null) 
			{
				jp_inv_number  = xml.documentElement.getElementsByTagName("number")[0].firstChild.nodeValue;
			}
		}
		document.getElementById("current_address").innerHTML = jp_inv_address.htmlspecialchars();
	});
}
//#xxx# of the character string is replaced by data
//by gijyutsuhyouron [Ajax] chap.5
function sprintf( template, obj )
{
	var rslt = template;
	for( var Name in obj )
	{
		value = obj[Name];
		reg = new RegExp( "#" + Name + "#", "g" );
		rslt = rslt.replace( reg, value );
	}
	return rslt;
}
// reference: mygmap module's mygmap.js
String.prototype.htmlspecialchars = function() {
	var tmp = this.toString();
	tmp = tmp.replace(/\//g, "");
	tmp = tmp.replace(/&/g, "&amp;");
	tmp = tmp.replace(/"/g, "&quot;");
	tmp = tmp.replace(/'/g, "&#39;");
	tmp = tmp.replace(/</g, "&lt;");
	tmp = tmp.replace(/>/g, "&gt;");
	return tmp;
}
window.onload = load;
window.onunload = GUnload;
//]]>
</script>

</head>
<body>
<h3><?php echo $lang_title; ?></h3>

<noscript>
  <h4 style="color: #ff0000;"><?php echo $lang_js_invalid; ?></h4>
</noscript>

<h4 id="not_compatible" style="color: #ff0000;"></h4>

<?php echo $google_geocode; ?>
<?php echo $jp_geocode; ?>
<b><?php echo $lang_current_location; ?></b><br />
<div id="current_address"></div>
<div id="current_latitude"></div>
<b><?php echo $lang_default_location; ?></b><br />
<?php echo $gm_default_location; ?><br />
<?php echo $gm_lang_default_location; ?><br /><br />
<div id="message"></div>
<br />

<div id="map" style="width:98%; height: 480px; border:1px solid #999999;"></div>
<br />

</body>
</html>
<?php
// --- raw HTML end ---

}
else
{

// --- raw HTML begin ---
?>
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml">
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
<title>weblinks - <?php echo $lang_title; ?></title>
</head>
<body>
<h3><?php echo $lang_title; ?></h3>
<h4 style="color: #ff0000;">not set google map api key</h4>
</body>
</html>
<?php
// --- raw HTML end ---

}
exit();
?>