<?php
// $Id: weblinks_config_check_handler.php,v 1.10 2007/06/17 03:44:26 ohwada Exp $

// 2007-06-10 K.OHWADA
// d3forum

// 2007-04-08 K.OHWADA
// add_column_table_142()

// 2007-03-25 K.OHWADA
// add_column_table_141()

// 2007-02-20 K.OHWADA
// renew config table, linkitem table

// 2006-12-10 K.OHWADA
// use add_column_table_130()

// 2006-10-01 K.OHWADA
// use happy_linux
// add _check_version_config() _check_version_linkitem()
// google map

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//================================================================
// WebLinks Module
// this file contain 2 class
//   weblinks_config_check_handler
//   weblinks_config_check_form
// 2006-05-15 K.OHWADA
//================================================================

// === class begin ===
if( !class_exists('weblinks_config_check_handler') ) 
{

//================================================================
// class weblinks_config_check
//================================================================
class weblinks_config_check_handler extends happy_linux_error
{
	var $_DIRNAME;
	var $_STYLE_SHEET = 'weblinks.css';

// handler
	var $_category_handler;
	var $_link_handler;
	var $_modify_handler;
	var $_config_store_handler;
	var $_linkitem_store_handler;
	var $_config_form;

	var $_system_is_admin;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_config_check_handler( $dirname )
{
	$this->happy_linux_error();
	$this->_DIRNAME = $dirname;

// config_store_handler
	$define =& weblinks_config2_define::getInstance( $dirname );
	$this->_config_store_handler =& happy_linux_config_store_handler::getInstance();
	$this->_config_store_handler->set_handler('config2', $dirname, 'weblinks');
	$this->_config_store_handler->set_define( $define );

// handler
	$this->_category_handler       =& weblinks_get_handler('category',       $dirname );
	$this->_link_handler           =& weblinks_get_handler('link',           $dirname );
	$this->_modify_handler         =& weblinks_get_handler('modify',         $dirname );
	$this->_linkitem_store_handler =& weblinks_get_handler('linkitem_store', $dirname );

	$this->_config_form = weblinks_config_check_form::getInstance();

	$system =& happy_linux_system::getInstance();
	$this->_system_is_admin = $system->is_module_admin();

}

//---------------------------------------------------------
// init config
//---------------------------------------------------------
function is_admin()
{
	return $this->_system_is_admin;
}

function print_style_sheet()
{
	$url = XOOPS_URL.'/modules/'.$this->_DIRNAME.'/'.$this->_STYLE_SHEET;
	echo '<link rel="stylesheet" type="text/css" href="'.$url.'" />';
}

//---------------------------------------------------------
// init config
//---------------------------------------------------------
function check_init()
{
	if ( !$this->_exists_config_table() )
	{	return false;	}

	if ( !$this->_check_init_config() )
	{	return false;	}

	if ( !$this->_exists_linkitem_table() )
	{	return false;	}

	if ( !$this->_check_init_linkitem() )
	{	return false;	}

	return true;
}

function init()
{
	$this->_clear_errors();

	if ( !$this->_exists_config_table() )
	{
		$ret = $this->_config_store_handler->create_table();
		if ( !$ret )
		{
			$this->_set_errors( $this->_config_store_handler->getErrors() );
		}
	}

	if ( !$this->_check_init_config() )
	{
		$ret = $this->_config_store_handler->init();
		if ( !$ret )
		{
			$this->_set_errors( $this->_config_store_handler->getErrors() );
		}
	}

	if ( !$this->_exists_linkitem_table() )
	{
		$ret = $this->_linkitem_store_handler->create_table();
		if ( !$ret )
		{
			$this->_set_errors( $this->_linkitem_store_handler->getErrors() );
		}
	}

	if ( !$this->_check_init_linkitem() )
	{
		$ret = $this->_linkitem_store_handler->init();
		if ( !$ret )
		{
			$this->_set_errors( $this->_linkitem_store_handler->getErrors() );
		}
	}

	return $this->returnExistError();
}

//---------------------------------------------------------
// upgrade config
//---------------------------------------------------------
function check_version()
{
	if ( !$this->_check_version_config() )
	{	return false;	}

	if ( !$this->_check_version_linkitem() )
	{	return false;	}

	if ( !$this->_check_version_link_110() )
	{	return false;	}

	if ( !$this->_check_version_modify_110() )
	{	return false;	}

	if ( !$this->_check_version_link_120() )
	{	return false;	}

	if ( !$this->_check_version_modify_120() )
	{	return false;	}

	if ( !$this->_check_version_link_130() )
	{	return false;	}

	if ( !$this->_check_version_modify_130() )
	{	return false;	}

	if ( !$this->_check_version_category_140() )
	{	return false;	}

	if ( !$this->_check_version_link_140() )
	{	return false;	}

	if ( !$this->_check_version_modify_140() )
	{	return false;	}

	if ( !$this->_check_version_category_141() )
	{	return false;	}

	if ( !$this->_check_version_link_141() )
	{	return false;	}

	if ( !$this->_check_version_modify_141() )
	{	return false;	}

	if ( !$this->_check_version_category_142() )
	{	return false;	}

	if ( !$this->_check_version_link_142() )
	{	return false;	}

	if ( !$this->_check_version_modify_142() )
	{	return false;	}

	return true;
}

function upgrade()
{
	$this->_clear_errors();

	if ( !$this->_check_renew_config() )
	{
// destroy value, becuase renewal order
		$ret = $this->_config_store_handler->clean_table();
		if ( !$ret )
		{
			$this->_set_errors( $this->_config_store_handler->getErrors() );
		}

		$ret = $this->_config_store_handler->init();
		if ( !$ret )
		{
			$this->_set_errors( $this->_config_store_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_linkitem_140_1() )
	{
		$ret = $this->_linkitem_store_handler->add_column_table_140();
		if ( !$ret )
		{
			$this->_set_errors( $this->_linkitem_store_handler->getErrors() );
		}
	}

	if ( !$this->_check_renew_linkitem() )
	{
// destroy value, becuase renewal order
		$ret = $this->_linkitem_store_handler->clean_table();
		if ( !$ret )
		{
			$this->_set_errors( $this->_linkitem_store_handler->getErrors() );
		}

		$ret = $this->_linkitem_store_handler->init();
		if ( !$ret )
		{
			$this->_set_errors( $this->_linkitem_store_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_config() )
	{
		$ret = $this->_config_store_handler->upgrade();
		if ( !$ret )
		{
			$this->_set_errors( $this->_config_store_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_linkitem() )
	{
		$ret = $this->_linkitem_store_handler->upgrade();
		if ( !$ret )
		{
			$this->_set_errors( $this->_config_linkitem_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_link_110() )
	{
		$ret = $this->_link_handler->add_column_table_110();
		if ( !$ret )
		{
			$this->_set_errors( $this->_link_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_modify_110() )
	{
		$ret = $this->_modify_handler->add_column_table_110();
		if ( !$ret )
		{
			$this->_set_errors( $this->_modify_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_link_120() )
	{
		$ret = $this->_link_handler->add_column_table_120();
		if ( !$ret )
		{
			$this->_set_errors( $this->_link_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_modify_120() )
	{
		$ret = $this->_modify_handler->add_column_table_120();
		if ( !$ret )
		{
			$this->_set_errors( $this->_modify_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_link_130() )
	{
		$ret = $this->_link_handler->add_column_table_130();
		if ( !$ret )
		{
			$this->_set_errors( $this->_link_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_modify_130() )
	{
		$ret = $this->_modify_handler->add_column_table_130();
		if ( !$ret )
		{
			$this->_set_errors( $this->_modify_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_category_140() )
	{
		$ret = $this->_category_handler->add_column_table_140();
		if ( !$ret )
		{
			$this->_set_errors( $this->_category_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_link_140() )
	{
		$ret = $this->_link_handler->add_column_table_140();
		if ( !$ret )
		{
			$this->_set_errors( $this->_link_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_modify_140() )
	{
		$ret = $this->_modify_handler->add_column_table_140();
		if ( !$ret )
		{
			$this->_set_errors( $this->_modify_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_category_141() )
	{
		$ret = $this->_category_handler->add_column_table_141();
		if ( !$ret )
		{
			$this->_set_errors( $this->_category_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_link_141() )
	{
		$ret = $this->_link_handler->add_column_table_141();
		if ( !$ret )
		{
			$this->_set_errors( $this->_link_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_modify_141() )
	{
		$ret = $this->_modify_handler->add_column_table_141();
		if ( !$ret )
		{
			$this->_set_errors( $this->_modify_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_category_142() )
	{
		$ret = $this->_category_handler->add_column_table_142();
		if ( !$ret )
		{
			$this->_set_errors( $this->_category_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_link_142() )
	{
		$ret = $this->_link_handler->add_column_table_142();
		if ( !$ret )
		{
			$this->_set_errors( $this->_link_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_modify_142() )
	{
		$ret = $this->_modify_handler->add_column_table_142();
		if ( !$ret )
		{
			$this->_set_errors( $this->_modify_handler->getErrors() );
		}
	}

	return $this->returnExistError();
}

//---------------------------------------------------------
// print form
//---------------------------------------------------------
function print_form_init( $action='' )
{
	$this->_config_form->print_form_init( $action );
}

function print_form_upgrade( $action='' )
{
	$this->_config_form->print_form_upgrade( $action );
}


//---------------------------------------------------------
// check config
//---------------------------------------------------------
function _exists_config_table()
{
	$ret = $this->_config_store_handler->existsTable();
	return $ret;
}

function _exists_linkitem_table()
{
	$ret = $this->_linkitem_store_handler->existsTable();
	return $ret;
}

function _check_init_config()
{
	$num = $this->_config_store_handler->getCount();
	if ( $num == 0 )
	{	return false;	}

	return true;
}

function _check_init_linkitem()
{
	$num = $this->_linkitem_store_handler->getCount();
	if ( $num == 0 )
	{	return false;	}

	return true;
}

//---------------------------------------------------------
// config version
//---------------------------------------------------------
function _check_renew_config()
{
	$this->_config_store_handler->load();

	if ( !$this->_check_version_config_140() )
	{	return false;	}

	return true;
}

function _check_version_config()
{
	$this->_config_store_handler->load();

	if ( !$this->_check_version_config_120() )
	{	return false;	}

	if ( !$this->_check_version_config_140() )
	{	return false;	}

	if ( !$this->_check_version_config_141() )
	{	return false;	}

	if ( !$this->_check_version_config_142() )
	{	return false;	}

	if ( !$this->_check_version_config_150() )
	{	return false;	}

	return true;
}

function _check_version_config_120()
{
// google map
	$ret = $this->_config_store_handler->check_exist_by_name( 'map_use' );
	return $ret;
}

function _check_version_config_140()
{
// performance
	$ret = $this->_config_store_handler->check_exist_by_name( 'cat_path' );
	return $ret;
}

function _check_version_config_141()
{
// performance
	$ret = $this->_config_store_handler->check_exist_by_name( 'index_description' );
	return $ret;
}

function _check_version_config_142()
{
// performance
	$ret = $this->_config_store_handler->check_exist_by_name( 'cat_desc_mode' );
	return $ret;
}

function _check_version_config_150()
{
// performance
	$ret = $this->_config_store_handler->check_exist_by_name( 'd3forum_plugin' );
	return $ret;
}

//---------------------------------------------------------
// linkitem version
//---------------------------------------------------------
function _check_renew_linkitem()
{
	$this->_linkitem_store_handler->load();

	if ( !$this->_check_version_linkitem_120() )
	{	return false;	}

	if ( !$this->_check_version_linkitem_140_2() )
	{	return false;	}

	return true;
}

function _check_version_linkitem()
{
	$this->_linkitem_store_handler->load();

	if ( !$this->_check_version_linkitem_120() )
	{	return false;	}

	if ( !$this->_check_version_linkitem_130() )
	{	return false;	}

	if ( !$this->_check_version_linkitem_140_1() )
	{	return false;	}

	if ( !$this->_check_version_linkitem_140_2() )
	{	return false;	}

	if ( !$this->_check_version_linkitem_141() )
	{	return false;	}

	if ( !$this->_check_version_linkitem_142() )
	{	return false;	}

	return true;
}

function _check_version_linkitem_120()
{
// google map
	$ret = $this->_linkitem_store_handler->check_exist_by_name( 'map_use' );
	return $ret;
}

function _check_version_linkitem_130()
{
	$ret = $this->_linkitem_store_handler->check_exist_by_name( 'time_publish' );
	return $ret;
}

function _check_version_linkitem_140_1()
{
	$ret = $this->_linkitem_store_handler->check_version_140();
	return $ret;
}

function _check_version_linkitem_140_2()
{
	$ret = $this->_linkitem_store_handler->check_exist_by_name( 'forum_id' );
	return $ret;
}

function _check_version_linkitem_141()
{
	$ret = $this->_linkitem_store_handler->check_exist_by_name( 'album_id' );
	return $ret;
}

function _check_version_linkitem_142()
{
	$ret = $this->_linkitem_store_handler->check_exist_by_name( 'gm_type' );
	return $ret;
}

//---------------------------------------------------------
// category
//---------------------------------------------------------
function _check_version_category_140()
{
	$ret = $this->_category_handler->check_version_140();
	return $ret;
}

function _check_version_category_141()
{
	$ret = $this->_category_handler->check_version_141();
	return $ret;
}

function _check_version_category_142()
{
	$ret = $this->_category_handler->check_version_142();
	return $ret;
}

//---------------------------------------------------------
// link modify version
//---------------------------------------------------------
function _check_version_link_110()
{
	$ret = $this->_link_handler->check_version_110();
	return $ret;
}

function _check_version_modify_110()
{
	$ret = $this->_modify_handler->check_version_110();
	return $ret;
}

function _check_version_link_120()
{
	$ret = $this->_link_handler->check_version_120();
	return $ret;
}

function _check_version_modify_120()
{
	$ret = $this->_modify_handler->check_version_120();
	return $ret;
}

function _check_version_link_130()
{
	$ret = $this->_link_handler->check_version_130();
	return $ret;
}

function _check_version_modify_130()
{
	$ret = $this->_modify_handler->check_version_130();
	return $ret;
}

function _check_version_link_140()
{
	$ret = $this->_link_handler->check_version_140();
	return $ret;
}

function _check_version_modify_140()
{
	$ret = $this->_modify_handler->check_version_140();
	return $ret;
}

function _check_version_link_141()
{
	$ret = $this->_link_handler->check_version_141();
	return $ret;
}

function _check_version_modify_141()
{
	$ret = $this->_modify_handler->check_version_141();
	return $ret;
}

function _check_version_link_142()
{
	$ret = $this->_link_handler->check_version_142();
	return $ret;
}

function _check_version_modify_142()
{
	$ret = $this->_modify_handler->check_version_142();
	return $ret;
}

// --- class end ---
}

//================================================================
// class weblinks_config_check_form
//================================================================
class weblinks_config_check_form extends happy_linux_config_form
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_config_check_form()
{
	$this->happy_linux_config_form();

	$this->set_lib_box_div_class(        'weblinks_confirm' );
	$this->set_lib_box_span_title_class( 'weblinks_confirm_title' );
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_config_check_form();
	}

	return $instance;
}

//---------------------------------------------------------
// public
//---------------------------------------------------------
function print_form_init( $action='' )
{
	xoops_error( _WEBLINKS_INIT_NOT );
	echo "<br />\n";
	echo $this->build_lib_box_button_class(_WEBLINKS_INIT_EXEC, '', 'init', _SAVE, $action );
	echo "<br />\n";

}

function print_form_upgrade( $action='' )
{
	$title = sprintf( _WEBLINKS_VERSION_NOT, WEBLINKS_VERSION );
	xoops_error( $title );
	echo "<br />\n";
	echo $this->build_lib_box_button_class( _WEBLINKS_UPGRADE_EXEC, '', 'upgrade', _SAVE, $action );
	echo "<br />\n";

}

// --- class end ---
}

// === class end ===
}

?>