<?php
// $Id: header.php,v 1.2 2007/02/18 07:14:08 ohwada Exp $ 

// 2007-02-18 K.OHWADA
// happy_search_xoops_module_handler.php

//=========================================================
// Happy Search
// 2006-11-11 K.OHWADA
//=========================================================

//---------------------------------------------------------
// system files
//---------------------------------------------------------
require '../../mainfile.php'; 

$XOOPS_LANGUAGE = $xoopsConfig['language'];
include_once XOOPS_ROOT_PATH.'/class/xoopsformloader.php';

// search.php
if ( file_exists(XOOPS_ROOT_PATH.'/language/'.$XOOPS_LANGUAGE.'/search.php') ) 
{
	include_once XOOPS_ROOT_PATH.'/language/'.$XOOPS_LANGUAGE.'/search.php';
}
else
{
	include_once XOOPS_ROOT_PATH.'/language/english/search.php';
}

//---------------------------------------------------------
// happy_linux
//---------------------------------------------------------
if ( !file_exists(XOOPS_ROOT_PATH.'/modules/happy_linux/include/version.php') ) 
{
	include XOOPS_ROOT_PATH.'/header.php';
	xoops_error( 'require happy_linux module' );
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

include_once XOOPS_ROOT_PATH.'/modules/happy_linux/include/version.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/include/functions.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/include/multibyte.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/api/language.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/strings.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/error.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/post.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/system.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/convert_encoding.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/search.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/highlight.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/object.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/object_handler.php';

//---------------------------------------------------------
// happy_search
//---------------------------------------------------------
if( !defined('HAPPY_SEARCH_DIRNAME') )
{
	define('HAPPY_SEARCH_DIRNAME', $xoopsModule->dirname() );
}

if( !defined('HAPPY_SEARCH_ROOT_PATH') )
{
	define('HAPPY_SEARCH_ROOT_PATH', XOOPS_ROOT_PATH.'/modules/'.HAPPY_SEARCH_DIRNAME );
}

if( !defined('HAPPY_SEARCH_URL') )
{
	define('HAPPY_SEARCH_URL', XOOPS_URL.'/modules/'.HAPPY_SEARCH_DIRNAME );
}

// include files
include_once HAPPY_SEARCH_ROOT_PATH.'/include/happy_search_version.php';
include_once HAPPY_SEARCH_ROOT_PATH.'/include/happy_search_constant.php';
include_once HAPPY_SEARCH_ROOT_PATH.'/include/search_function.php';
include_once HAPPY_SEARCH_ROOT_PATH.'/class/happy_search_xoops_module_handler.php';
include_once HAPPY_SEARCH_ROOT_PATH.'/class/happy_search_modules.php';
include_once HAPPY_SEARCH_ROOT_PATH.'/class/happy_search_google.php';
include_once HAPPY_SEARCH_ROOT_PATH.'/class/happy_search.php';

// check happy_linux version
if ( HAPPY_LINUX_VERSION < HAPPY_SEARCH_HAPPY_LINUX_VERSION ) 
{
	$msg = 'require happy_linux module v'.HAPPY_SEARCH_HAPPY_LINUX_VERSION.' or later';
	include XOOPS_ROOT_PATH.'/header.php';
	xoops_error( $msg );
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

//---------------------------------------------------------
// search module
//---------------------------------------------------------
$system =& happy_linux_system::getInstance();

$SEARCH_DIRNAME = 'search';
$search_name = $system->get_module_name_by_dirname( $SEARCH_DIRNAME );

if( !function_exists( 'search_make_context' ) ) 
{
	if ( file_exists(XOOPS_ROOT_PATH.'/modules/'.$SEARCH_DIRNAME.'/include/function.php') )
	{
		include_once XOOPS_ROOT_PATH.'/modules/'.$SEARCH_DIRNAME.'/include/function.php';
	}
	else
	{
		include_once HAPPY_SEARCH_ROOT_PATH.'/include/search_function.php';
	}
}

//---------------------------------------------------------
// xoogle module
//---------------------------------------------------------
$xoogle_name = $system->get_module_name_by_dirname( 'xoogle' );

if( !class_exists( 'nusoap_base' ) ) 
{
	if ( file_exists(XOOPS_ROOT_PATH.'/modules/xoogle/class/nusoap.php') ) 
	{
		include_once XOOPS_ROOT_PATH.'/modules/xoogle/class/nusoap.php';
	}
	else
	{
		include_once HAPPY_SEARCH_ROOT_PATH.'/class/nusoap.php';
	}
}

?>