<?php
// $Id: happy_search_xoops_module_handler.php,v 1.2 2007/05/20 17:16:29 ohwada Exp $

// 2007-05-20 K.OHWADA
// XC 2.1; legacy module

//=========================================================
// Happy Search
// 2007-02-18 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('happy_search_xoops_module_handler') ) 
{

//=========================================================
// class happy_search_xoops_module_handler
//=========================================================
class happy_search_xoops_module_handler
{
	var $_module_handler;
	var $_db;
	var $_table;

	var $_dirname_comment = 'system';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_search_xoops_module_handler()
{
	$this->_module_handler =& xoops_gethandler('module');
	$this->_db    =& $this->_module_handler->db;
	$this->_table =  $this->_db->prefix( 'modules' );

	$system =& happy_linux_system::getInstance();

	if ( $system->is_active_legacy_module() ) {
		$this->_dirname_comment = 'legacy';
	} else {
		$this->_dirname_comment = 'system';
	}
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new happy_search_xoops_module_handler();
	}

	return $instance;
}

//---------------------------------------------------------
// basic function
//---------------------------------------------------------
function &get($id)
{
	$obj =& $this->_module_handler->get($id);
	if ( $obj->getVar('dirname') == $this->_dirname_comment ) {
		$obj->setVar( 'name', _HAPPY_SEARCH_SYSTEM_COMMENT );
	}
	return $obj;
}

function &get_objects_in_group( &$group, &$except )
{
	if ( !is_array($group) || (count($group) == 0) )
	{
		$null = null;
		return $null;
	}

	$where = "mid IN ( ". implode(',', $group) ." )";
	if ( is_array($except) && count($except) ) 
	{
		foreach ($except as $mid) 
		{
			$where .= " AND mid <> ".$mid;
		}
	}

	$objs =& $this->get_objects_isactive( $where );
	return $objs;
}

function &get_objects_isactive( $in_where=null )
{
	$where = "isactive = 1";
	$where .= " AND ( hassearch = 1 OR dirname = '".$this->_dirname_comment."' )";

	if ( $in_where ) 
	{
		$where .= " AND ".$in_where;
	}
	$objs =& $this->get_objects_where( $where );
	return $objs;
}

function &get_objects_where( $where=null )
{
	$sql  = "SELECT * FROM ". $this->_table;
	if ( $where ) 
	{
		$sql .= " WHERE ".$where;
	}
	$sql .= " ORDER BY weight ASC, mid ASC";
	$objs =& $this->get_objects_by_sql($sql);
	return $objs;
}

function &get_objects_by_sql( $sql, $limit=0, $start=0, $id_as_key=true )
{
	$result = $this->_db->query($sql, $limit, $start);
	if (!$result) {
		return $ret;
	}

	while ($myrow = $this->_db->fetchArray($result)) {
		$module =& new XoopsModule();
		$module->assignVars($myrow);
		if ( $module->getVar('dirname') == $this->_dirname_comment ) {
			$module->setVar('name', _HAPPY_SEARCH_SYSTEM_COMMENT );
		}
		if (!$id_as_key) {
			$ret[] =& $module;
		} else {
			$ret[$myrow['mid']] =& $module;
		}
		unset($module);
	}

	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>