<?php
// $Id: rssc_feed_basic_handler.php,v 1.7 2006/09/27 03:02:48 ohwada Exp $

// 2006-09-20 K.OHWADA
// add _DEBUG_INSERT_EXEC
// add get_clear_num()

// 2006-07-10 K.OHWADA
// use happy_linux_basic happy_linux_basic_handler
// corresponding to podcast
// add enclosure

// 2006-06-04 K.OHWADA
// this is new file
// move from feed_handler

//=========================================================
// Rss Center Module
// 2006-06-04 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_feed_basic_handler') ) 
{

//=========================================================
// class rssc_feed_basic
//=========================================================
class rssc_feed_basic extends happy_linux_basic
{
// constant
	var $_FLAG_SUBSUTUTE_DATE = true;

	var $_clear_num = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_feed_basic()
{
	$this->happy_linux_basic();

	$this->init();
}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init()
{
	$this->_vars = array(
		'lid' => 0,
		'uid' => 0,
		'mid' => 0,
		'p1'  => 0,
		'p2'  => 0,
		'p3'  => 0,
		'site_title' => '',
		'site_link'  => '',
		'title'    => '',
		'link'     => '',
		'entry_id' => '',
		'guid'     => '',
		'updated_unix'   => 0,
		'published_unix' => 0,
		'category'     => '',
		'author_name'  => '',
		'author_uri'   => '',
		'author_email' => '',
		'type_cont'    => '',
		'raws'    => '',
		'content' => '',
		'search'  => '',
		'aux_int_1' => 0,
		'aux_int_2' => 0,
		'aux_text_1' => '',
		'aux_text_2' => '',

// enclosure
		'enclosure_url'    => '',
		'enclosure_type'   => '',
		'enclosure_length' => 0,

	);

}

//---------------------------------------------------------
// element
//---------------------------------------------------------
function set_search()
{
	$search = $this->get('title').' '.$this->get('content');
	$search = $this->strip_control($search);
	$search = $this->strip_style_tag($search);
	$search = $this->add_space_after_tag($search);
	$search = strip_tags($search);

	$this->set('search', $search);
}

function set_raws($item)
{
// atom
	if ( isset($item['atom_content']) )
	{
		$item['atom_content'] = '';
	}

	if ( isset($item['content']) )
	{
		$item['content'] = '';
	}

	$raws = serialize($item);
	$this->set('raws', $raws);
}

function get_raws()
{
	$ret  = false;
	$raws = $this->get('raws');
	if ($raws)
	{
		$ret = unserialize($raws);
	}
	return $ret;
}

//---------------------------------------------------------
// subsutute date
// some feed have no date
// subsutute by present time
//---------------------------------------------------------
function subsutute_date()
{
// no action, if not flag
	if ( !$this->_FLAG_SUBSUTUTE_DATE )
	{
		return;
	}

	$time = time();

	if ( $this->get('updated_unix') == 0 )
	{
		$this->set('updated_unix', $time);
	}

	if ( $this->get('published_unix') == 0 )
	{
		$this->set('published_unix', $time);
	}
}

// --- class end ---
}


//=========================================================
// class rssc_feed_basic_handler
// this class is used by command line
// this class handle MySQL table directly
// this class does not use another class
//=========================================================
class rssc_feed_basic_handler extends happy_linux_basic_handler
{
	var $_DEBUG_INSERT_EXEC = true;

// param
	var $_count_refresh_feed   = 0;
	var $_flag_force_overwrite = false;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_feed_basic_handler( $dirname )
{
	$this->happy_linux_basic_handler( $dirname );

	$this->set_table_name('feed');
	$this->set_id_name('fid');
	$this->set_class_name('rssc_feed_basic');

	$this->set_debug_db_sql(   RSSC_DEBUG_FEED_BASIC_SQL );
	$this->set_debug_db_error( RSSC_DEBUG_ERROR );

}

//---------------------------------------------------------
// insert
//---------------------------------------------------------
function insert( &$obj )
{
	if ( !$this->_check_class($obj) )
	{
		$this->_set_errors('feed table: not match class');
		return false;
	}

	foreach ( $obj->get_vars() as $k => $v )
	{	${$k} = $v;	}

	$sql  = 'INSERT INTO '.$this->_table.' (';
	$sql .= 'lid, ';
	$sql .= 'uid, ';
	$sql .= 'mid, ';
	$sql .= 'p1, ';
	$sql .= 'p2, ';
	$sql .= 'p3, ';
	$sql .= 'site_title, ';
	$sql .= 'site_link, ';
	$sql .= 'title, ';
	$sql .= 'link, ';
	$sql .= 'entry_id, ';
	$sql .= 'guid, ';
	$sql .= 'updated_unix, ';
	$sql .= 'published_unix, ';
	$sql .= 'category, ';
	$sql .= 'author_name, ';
	$sql .= 'author_uri, ';
	$sql .= 'author_email, ';
	$sql .= 'type_cont, ';
	$sql .= 'raws, ';
	$sql .= 'content, ';
	$sql .= 'search, ';
	$sql .= 'aux_int_1, ';
	$sql .= 'aux_int_2, ';
	$sql .= 'aux_text_1, ';
	$sql .= 'aux_text_2, ';

// enclosure
	$sql .= 'enclosure_url, ';
	$sql .= 'enclosure_type, ';
	$sql .= 'enclosure_length ';

	$sql .= ') VALUES (';
	$sql .= intval($lid).', ';
	$sql .= intval($uid).', ';
	$sql .= intval($mid).', ';
	$sql .= intval($p1).', ';
	$sql .= intval($p2).', ';
	$sql .= intval($p3).', ';
	$sql .= $this->quote($site_title).', ';
	$sql .= $this->quote($site_link).', ';
	$sql .= $this->quote($title).', ';
	$sql .= $this->quote($link).', ';
	$sql .= $this->quote($entry_id).', ';
	$sql .= $this->quote($guid).', ';
	$sql .= intval($updated_unix).', ';
	$sql .= intval($published_unix).', ';
	$sql .= $this->quote($category).', ';
	$sql .= $this->quote($author_name).', ';
	$sql .= $this->quote($author_uri).', ';
	$sql .= $this->quote($author_email).', ';
	$sql .= $this->quote($type_cont).', ';
	$sql .= $this->quote($raws).', ';
	$sql .= $this->quote($content).', ';
	$sql .= $this->quote($search).', ';
	$sql .= intval($aux_int_1).', ';
	$sql .= intval($aux_int_2).', ';
	$sql .= $this->quote($aux_text_1).', ';
	$sql .= $this->quote($aux_text_2).', ';

// enclosure
	$sql .= $this->quote($enclosure_url).', ';
	$sql .= $this->quote($enclosure_type).', ';
	$sql .= intval($enclosure_length).' ';

	$sql .= ')';

	if ( !$this->query($sql) ) 
	{	return false;	}

	$newid = $this->_db->getInsertId();
	return $newid;
}

//---------------------------------------------------------
// delete
//---------------------------------------------------------
function delete_by_link($link)
{ 
	$sql = 'DELETE FROM '.$this->_table.' WHERE link='.$this->quote($link);
	$ret = $this->query($sql);
	return $ret;
}

//---------------------------------------------------------
// get_count
//---------------------------------------------------------
function get_count_by_link_time($link, $time)
{
	$sql  = 'SELECT count(*) FROM '.$this->_table.' WHERE ';
	$sql .= 'link='.$this->quote($link).' AND ';
	$sql .= 'updated_unix >= '.intval($time);

	$count = $this->get_count_by_sql($sql);
	return $count;
}

function get_count_by_link($link)
{
	$sql  = 'SELECT count(*) FROM '.$this->_table.' WHERE ';
	$sql .= 'link='.$this->quote($link);

	$count = $this->get_count_by_sql($sql);
	return $count;
}

//---------------------------------------------------------
// get_fid array
//---------------------------------------------------------
function &get_fid_array_older($limit=0, $offset=0)
{
	$sql = 'SELECT fid FROM '.$this->_table.' ORDER BY updated_unix ASC';
	$arr =& $this->get_first_row_by_sql($sql, $limit, $offset);
	return $arr;
}

//---------------------------------------------------------
// clear feed
//---------------------------------------------------------
function clear_over_num($num)
{
	$this->_clear_errors();
	$this->_clear_num = 0;

	if ($num <= 0)
	{
		return true;	// no action
	}

	$total = $this->get_count_all();
	if ($total < $num)
	{
		return true;	// no action
	}

	$limit   = $total - $num;
	$fid_arr = $this->get_fid_array_older($limit);

// exec
	foreach( $fid_arr as $fid )
	{
		$this->delete_by_id($fid);
	}

	$this->_clear_num = $limit;
	return $this->returnExistError();
}

function get_clear_num()
{
	return $this->_clear_num;
}

//---------------------------------------------------------
// refresh feed
//---------------------------------------------------------
function refresh($lid, $uid, $mid, $p1, $p2, $p3, $item)
{
	$this->_clear_errors();

// return , if already exit, when not force
	if ( !$this->_flag_force_overwrite )
	{
		$link  = $this->_get_item($item, 'link');
		$time  = $this->_get_item($item, 'updated_unix');
		$count_time = $this->get_count_by_link_time($link, $time);
		if ($count_time)
		{
			return true;
		}
	}

// delete old, if exist
	$count_link = $this->get_count_by_link($link);
	if ($count_link) 
	{
		$this->delete_by_link($link);
	}

// add new
	$obj = $this->create();
	$obj->merge_vars($item);
	$obj->set_raws($item);

	$obj->set('lid', $lid);
	$obj->set('uid', $uid);
	$obj->set('mid', $mid);
	$obj->set('p1',  $p1);
	$obj->set('p2',  $p2);
	$obj->set('p3',  $p3);
	$obj->subsutute_date();
	$obj->set_search();

// enclosure
	$obj->set( 'enclosure_url',     $this->_get_item($item, 'enclosure_url') ); 
	$obj->set( 'enclosure_type',    $this->_get_item($item, 'enclosure_type') );
	$obj->set( 'enclosure_length',  $this->_get_item($item, 'enclosure_length') );

	if ( $this->_DEBUG_INSERT_EXEC )
	{
		$this->insert($obj);
	}

	$this->_count_refresh_feed ++;

    return $this->returnExistError();
}

function _get_item($item, $key)
{
	if ( isset($item[$key]) )
	{
		$ret = $item[$key];
		return $ret;
	}

	return null;
}

//---------------------------------------------------------
// counter
//---------------------------------------------------------
function clear_count()
{
	$this->_count_refresh_feed = 0;
}

function get_count_refresh_feed()
{
	return $this->_count_refresh_feed;
}

//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function set_force_overwrite($value)
{
	$this->_flag_force_overwrite = intval($value);
}

// --- class end ---
}

// === class end ===
}

?>