<?php
// $Id: modlink.php,v 1.13 2007/05/18 14:36:38 ohwada Exp $

// 2007-05-18 K.OHWADA
// get_error_msg_modlink() -> get_errors_modlink()

// 2007-03-01 K.OHWADA
// weblinks_link_handler.php
// update_category_link_count()

// 2006-12-10 K.OHWADA
// use weblinks_modify

// 2006-09-20 K.OHWADA
// use happy_linux
// use rssc WEBLINKS_RSSC_USE

// 2006-05-15 K.OHWADA
// add class weblinks_modlink()
// new handler
// use token ticket
// dont use global

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//================================================================
// WebLinks Module
// 2004/01/23 K.OHWADA
//================================================================

include 'header.php';
include_once XOOPS_ROOT_PATH.'/include/xoopscodes.php';
include_once XOOPS_ROOT_PATH.'/class/xoopsformloader.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/include/gtickets.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/html.php';
include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/form.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_linkitem_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_linkitem_define_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_linkitem_store_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_form_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_form_check_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_rssc_edit_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_edit.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_edit_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_modify.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_modify_handler.php';


//=========================================================
// class weblinks_modlink
//=========================================================
class weblinks_modlink extends happy_linux_error
{
	var $_config_handler;
	var $_link_edit_handler;
	var $_link_view_handler;
	var $_link_form_handler;
	var $_link_check_handler;

	var $_rssc_edit_handler;
	var $_rssc_handler;

	var $_template;
	var $_system;
	var $_post;

// config
	var $_conf;

// system
	var $_system_is_module_admin;
	var $_system_uid;
	var $_system_module_name;

	var $_is_permit = false;
	var $_is_auto   = false;
	var $_is_owner  = false;
	var $_flag_usercomment_show = 0;
	var $_flag_passwd_match     = false;
	var $_flag_passwd_incorrect = false;

// post
	var $_post_op;
	var $_post_rss_flag;

// link record
	var $_lid;
	var $_link_title_s;

	var $_banner_error_code = 0;
	var $_rssc_error_code   = 0;
	var $_flag_error = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_modlink()
{
	$this->happy_linux_error();
	$this->set_debug_print_error( WEBLINKS_DEBUG_ERROR );

	$this->_config_handler     =& weblinks_get_handler( 'config2_basic',   WEBLINKS_DIRNAME );
	$this->_link_edit_handler  =& weblinks_get_handler( 'link_edit',       WEBLINKS_DIRNAME );
	$this->_link_view_handler  =& weblinks_get_handler( 'link_view',       WEBLINKS_DIRNAME );
	$this->_link_form_handler  =& weblinks_get_handler( 'link_form',       WEBLINKS_DIRNAME );
	$this->_link_check_handler =& weblinks_get_handler( 'link_form_check', WEBLINKS_DIRNAME );

	$this->_rssc_edit_handler  =& weblinks_get_handler( 'rssc_edit',       WEBLINKS_DIRNAME );
	$this->_rssc_handler       =& weblinks_get_handler( 'rssc',            WEBLINKS_DIRNAME );

	$this->_template =& weblinks_template::getInstance( WEBLINKS_DIRNAME );
	$this->_system   =& happy_linux_system::getInstance();
	$this->_post     =& happy_linux_post::getInstance();

	$this->_conf = $this->_config_handler->get_conf();

	$this->_system_is_module_admin = $this->_system->is_module_admin();
	$this->_system_uid             = $this->_system->get_uid();
	$this->_system_module_name     = $this->_system->get_module_name();

}

//---------------------------------------------------------
// init & get obj
//---------------------------------------------------------
function get_post_op()
{
	$op = '';
	if     (isset($_POST['submit']))   $op = 'submit';
	elseif (isset($_POST['preview']))  $op = 'preview';
	$this->_post_op = $op;
	return $op;
}

function get_post_get_lid()
{
	$this->_lid = $this->_post->get_post_get_int('lid');
	return $this->_lid;
}

function get_post_rss_flag()
{
	$this->_post_rss_flag = $this->_post->get_post_get_int('rss_flag');
	return $this->_post_rss_flag;
}

//---------------------------------------------------------
// check_access
//---------------------------------------------------------
function check_access()
{

// admin
	if ( $this->_system_is_module_admin )
	{
		return 1;	// admin
	}

	$obj =& $this->_link_edit_handler->get($this->_lid);

	if ( !is_object($obj) )
	{
		return -3;	// no record
	}

	$this->_link_title_s = $obj->getVar('title', 's');
	$rec_uid             = $obj->get('uid');
	$rec_passwd          = $obj->get('passwd');

	$passwd_match = $this->check_passwd_match( $rec_passwd );

	list($is_permit, $is_owner, $show_passwd) = 
		$this->_link_edit_handler->has_auth_modify( $rec_uid, $passwd_match );

	$is_auto = $this->_link_edit_handler->has_auth_modify_auto( $rec_uid, $passwd_match );

// not permit
	if ( !$is_permit ) 
	{
		if ( $this->_system_uid > 0 ) 
		{
			return -1;	// not permit
		}
		elseif ( !$show_passwd )
		{
			return -2;	// anonymous
		}
	}

	$this->_is_permit = $is_permit;
	$this->_is_auto   = $is_auto;
	$this->_is_owner  = $is_owner;

	if ( $show_passwd && ( $this->_flag_passwd_incorrect || !$this->_flag_passwd_match ))
	{
		return 2;	// password form
	}

	$this->_link_edit_handler->init();

	$this->_flag_usercomment_show = 0;
	if ( $is_owner )
	{
		$this->_flag_usercomment_show = 1;
	}

	return 0;	// OK
}

function check_passwd_match( $rec_passwd )
{
	$this->_flag_passwd_match     = false;
	$this->_flag_passwd_incorrect = false;

	$request = $this->_post->get_post_int('request');

	list($passwd, $flag_passwd, $flag_code)
		= $this->_post->get_post_get_passwd_old();

	if ( $flag_passwd || $flag_code )
	{
		if( $rec_passwd == md5( $passwd ))
		{
			if( $flag_code || $request )
			{
				$this->_flag_passwd_match = true;
			}
			return true;
		}

		$this->_flag_passwd_incorrect = true;
	}

	return false;
}

function get_title()
{
	return $this->_link_title_s;
}

//---------------------------------------------------------
// modify_form
//---------------------------------------------------------
function print_modify_form($lid)
{
	$this->print_modify_header();
	$this->print_modify_comment();

	$this->show_user_form('modify', $lid);
}

function show_user_form($form_mode, $lid)
{
	$this->_link_form_handler->set_flag_owner( $this->_is_owner );
	$this->_link_form_handler->show_user_form($form_mode, $lid);
}

//---------------------------------------------------------
// preview
//---------------------------------------------------------
function print_preview()
{
	$this->print_modify_header();
	echo "<hr />\n";
	echo "<h4>"._PREVIEW."</h4>\n";

// check form
	if ( !$this->_link_check_handler->check_form_modlink_by_post( $this->_is_owner ) ) 
	{
		echo '<div class="weblinks_submit_error">';
		echo $this->_link_check_handler->get_errors_modlink('s');
		echo "</div>\n";
		echo "<br />\n";
    }

	$arr_preview = $this->_link_edit_handler->build_modify_preview( $this->_lid );

// check preview error
	if ( !$this->_link_edit_handler->check_preview_result() )
	{
		echo $this->_link_edit_handler->get_error_msg_preview();
		echo "<br />\n";
	}

	echo $this->_template->fetch_link_single( $arr_preview );

	echo "<hr />\n";
	$this->print_modify_comment();

	$this->show_user_form('modify_preview', $this->_lid);

}

//---------------------------------------------------------
// post
//---------------------------------------------------------
function check_form()
{
	$this->_flag_error = 0;
	if( !$this->_link_edit_handler->check_token() ) 
	{
		$this->_flag_error = 1;
		return false;
	}
	if ( !$this->_link_check_handler->check_form_modlink_by_post( $this->_is_owner ) )
	{
		$this->_flag_error = 2;
		return false;
	}
	return true;
}

function print_form_with_error()
{
	$this->print_modify_header();

	if ( $this->_flag_error == 1 )
	{
		echo "<br />\n";
		xoops_error( "Token Error" );
		echo "<br />\n";
	}

	if ( $this->_flag_error == 2 )
	{
		echo '<div class="weblinks_submit_error">';
		echo $this->_link_check_handler->get_errors_modlink('s');
		echo "</div>\n";
		echo "<br />\n";
	}

	$this->print_modify_comment();

	$this->show_user_form('modify_preview', $this->_lid);
}

function post_auto_approve()
{
	$ret = $this->_link_edit_handler->mod_link_by_post( $this->_lid, true );
	if ( !$ret )
	{
		$this->_set_errors( $this->_link_edit_handler->getErrors() );
		return false;
	}

	$this->_banner_error_code = $this->_link_edit_handler->get_banner_error_code();

	if ( $this->_conf['cat_count'] )
	{
// not check error
		$this->_link_edit_handler->update_category_link_count();
	}

	return true;
}

function post_approve()
{
	$mode  = 1;	// request
	$newid = $this->_link_edit_handler->add_link_to_modify_by_post( $mode );
	if ( !$newid )
	{
		$this->_set_errors( $this->_link_edit_handler->getErrors() );
		return false;
	}

	return $newid;
}

//---------------------------------------------------------
// print
//---------------------------------------------------------
function print_modify_header()
{
	echo '<link rel="stylesheet" type="text/css" media="all" href="'.WEBLINKS_URL.'/weblinks.css" />'."\n";
	echo '&nbsp;';
	echo '<a href="'.XOOPS_URL.'/">'._HOME.'</a> &gt;&gt;';
	echo '<a href="'.WEBLINKS_URL.'/">'.$this->_system_module_name.'</a> &gt;&gt;';
	echo '<a href="'.WEBLINKS_URL.'/singlelink.php?lid='.$this->_lid.'">'.$this->_link_title_s.'</a> &gt;&gt;';
	echo '<span class="weblinks_bold">'._WLS_MODIFY.'</span><br /><br />'."\n";
}

function print_modify_comment()
{
	echo '<div style="width: 100%; margin: 5px; padding: 5px;">'."\n";

	echo $this->_conf['modlink_main'];
	if ( !$this->_is_auto )
	{
		echo $this->_conf['modlink_pending'];
		if ( !$this->_is_owner )
		{
			echo $this->_conf['modlink_not_owner'];
		}
	}

	echo "</div><br />\n";
}

//---------------------------------------------------------
// get parameter
//---------------------------------------------------------
function get_permit_param()
{
	return array($this->_is_permit, $this->_is_auto, $this->_is_owner);
}

function get_passwd_incorrect()
{
	return $this->_flag_passwd_incorrect;
}


//---------------------------------------------------------
// rssc edit handler
//---------------------------------------------------------
function mod_rssc()
{
	$ret = $this->_rssc_edit_handler->mod_rssc( $this->_lid );
	if ( $ret != 0 )
	{
		$this->_set_errors( $this->_rssc_edit_handler->getErrors() );
	}
	$this->_rssc_error_code = $ret;
	return $ret;
}

//---------------------------------------------------------
// get_mod_link_msg
//---------------------------------------------------------
function get_mod_link_msg()
{
	$msg = '';

	if ( $this->_banner_error_code )
	{
		$msg .= _WEBLINKS_WARN_BANNER_NOT_GET_SIZE."<br />\n";
	}

	switch ( $this->_rssc_error_code )
	{
		case RSSC_CODE_DISCOVER_FAILED:
			$msg .= _RSSC_DISCOVER_FAILED."<br />\n";
			break;

		case RSSC_CODE_PARSE_FAILED:
			$msg .= _RSSC_PARSE_FAILED."<br />\n";
			break;

		case RSSC_CODE_PARSE_NOT_READ_XML_URL:
			$msg .= _RSSC_PARSE_NOT_READ_XML_URL."<br />\n";
			break;
	}

	return $msg;
}

//---------------------------------------------------------
// utility
//---------------------------------------------------------
function build_comment($str)
{
	$ret = $this->_link_edit_handler->build_comment($str);
	return $ret;
}

//---------------------------------------------------------
// token ticket
//---------------------------------------------------------
function make_token()
{
	$ret = $this->_link_edit_handler->make_token();
	return $ret;
}

// --- class end ---
}


//=========================================================
// main
//=========================================================
$weblinks_modlink =& new weblinks_modlink();

// start
$op       = $weblinks_modlink->get_post_op();
$lid      = $weblinks_modlink->get_post_get_lid();
$rss_flag = $weblinks_modlink->get_post_rss_flag();

// check permit
$check = $weblinks_modlink->check_access();

if ( $check == -1 ) 
{
	$msg  = _NOPERM;
	$msg .= $weblinks_modlink->build_comment("not permit");	// for test form
	redirect_header("index.php", 2, $msg);
	exit();
}

if ( $check == -2 ) 
{
	$msg  = _WLS_MUSTREGFIRST;
	$msg .= $weblinks_modlink->build_comment("not user");	// for test form
	redirect_header( XOOPS_URL.'/user.php', 2, $msg);
	exit();
}

if ( $check == -3 ) 
{
	redirect_header("index.php", 2, _WLS_ERRORNOLINK);
	exit();
}

if ( $check == 1 )
{
	$url = "./admin/link_manage.php?op=modLink&lid=".$lid;
	redirect_header($url, 1, _WLS_GOTOADMIN);	
	exit();
}

list($is_permit, $is_auto_approve, $is_owner) = $weblinks_modlink->get_permit_param();

if ( $check == 2 )
{
	$xoopsOption['template_main'] = WEBLINKS_DIRNAME."_passwd.html";

	include XOOPS_ROOT_PATH."/header.php";
	$link_title       = $weblinks_modlink->get_title();
	$passwd_incorrect = $weblinks_modlink->get_passwd_incorrect();
	list($token_name, $token_value) = $weblinks_modlink->make_token();
	weblinks_print_form_password($lid, $link_title, $token_name, $token_value, $passwd_incorrect, $is_permit);
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

$url_singlelink = "singlelink.php?lid=".$lid;

// save to DB
if ($op == 'submit') 
{
	if ( !$weblinks_modlink->check_form() ) 
	{
		include XOOPS_ROOT_PATH."/header.php";
		$weblinks_modlink->print_form_with_error();
		include XOOPS_ROOT_PATH.'/footer.php';
		exit();
    }

// auto modify approve
	if ( $is_auto_approve )
	{
		$ret = $weblinks_modlink->post_auto_approve();
		if (!$ret)
		{
			redirect_header($url_singlelink, 3, "DB Error");
			exit();
		}

		if ( WEBLINKS_RSSC_USE )
		{
// mod rssc
			$ret = $weblinks_modlink->mod_rssc();
			if ($ret == WEBLINKS_CODE_DB_ERROR)
			{
				redirect_header($url_singlelink, 3, "DB Error");
				exit();
			}
		}

// redirect to single link
		$msg  = _WLS_MODIFYAPPROVED . "<br />\n";
		$msg2 = $weblinks_modlink->get_mod_link_msg();
		$time = $happy_linux_time->get_elapse_time();
		if ( $msg2 )
		{
			$msg .= "<br />\n";
			$msg .= "$msg2 <br />\n";
			$msg .= "$time sec";
			redirect_header($url_singlelink, 3, $msg);
		}

		$msg .= "$time sec <br />\n";
		$msg .= $weblinks_modlink->build_comment("modify approve link");	// for test form
		redirect_header($url_singlelink, 2, $msg);
	}

// modify approve
	else
	{
		$ret = $weblinks_modlink->post_approve();
		if (!$ret)
		{
			redirect_header($url_singlelink, 3, "DB Error");
			exit();
		}

		$tags = array();
		$tags['MODIFYREPORTS_URL'] = WEBLINKS_URL."/admin/index.php?op=listModReq";

		$notification_handler =& xoops_gethandler('notification');
		$notification_handler->triggerEvent('global', 0, 'link_modify', $tags);

		$msg  = _WLS_THANKSFORINFO;
		$msg .= $weblinks_modlink->build_comment("modify request link");	// for test form
		redirect_header($url_singlelink, 2, $msg);
	}
}

// preview mode
elseif ($op == 'preview')
{
	include XOOPS_ROOT_PATH."/header.php";
	$weblinks_modlink->print_preview();
	include XOOPS_ROOT_PATH.'/footer.php';
}

// modify form
else 
{
	include XOOPS_ROOT_PATH."/header.php";
	$weblinks_modlink->print_modify_form($lid);
	include XOOPS_ROOT_PATH.'/footer.php';
}

exit();
// --- end of main ---


function weblinks_print_form_password($lid, $link_title, $token_name, $token_value, $incorrect, $request)
{
	global $xoopsTpl, $xoopsConfig;

	$template =& weblinks_template::getInstance( WEBLINKS_DIRNAME );
	$template->assignIndex();

	$xoopsTpl->assign('lang_requestmod',      _WLS_REQUESTMOD);
	$xoopsTpl->assign('lang_password',        _US_PASSWORD);
	$xoopsTpl->assign('lang_submitter',       _WLS_LINKSUBMITTER);
	$xoopsTpl->assign('lang_pleasepassword',  _WLS_PLEASEPASSWORD);
	$xoopsTpl->assign('lang_registered_dsc',  _WLS_REGSTERED_DSC);
	$xoopsTpl->assign('lang_lostpassword',    _US_LOSTPASSWORD);
	$xoopsTpl->assign('lang_noproblem',       _US_NOPROBLEM);
	$xoopsTpl->assign('lang_youremail',       _US_YOUREMAIL);
	$xoopsTpl->assign('lang_sendpassword',    _US_SENDPASSWORD);
	$xoopsTpl->assign('lang_modify',          _WLS_MODIFY);
	$xoopsTpl->assign('lang_cancel',          _CANCEL);
	$xoopsTpl->assign('lang_password_incorrect',  _WEBLINKS_PASSWORD_INCORRECT);
	$xoopsTpl->assign('lang_anonymous',       $xoopsConfig['anonymous'] );
	$xoopsTpl->assign('lid',         $lid);
	$xoopsTpl->assign('link_title',  $link_title);
	$xoopsTpl->assign('token_name',  $token_name);
	$xoopsTpl->assign('token_value', $token_value);
	$xoopsTpl->assign('incorrect_show', $incorrect);
	$xoopsTpl->assign('request_show',   $request);
}

?>