<?php
// $Id: weblinks_template.php,v 1.15 2007/03/25 15:03:49 ohwada Exp $

// 2007-03-25 K.OHWADA
// fetch_photo_list()
// change assignHeader()

// 2007-03-18 K.OHWADA
// fetch_gm_list() fetch_gm_single()

// 2007-03-01 K.OHWADA
// linkitem_basic_handler
// link_basic_handler
// fetch_category_navi()
// fetch_forum_list()

// 2006-12-10 K.OHWADA
// add _assign_linkitem_name()

// 2006-10-14 K.OHWADA
// add assignSearch()

// 2006-10-05 K.OHWADA
// use happy_linux
// use rssc WEBLINKS_RSSC_USE
// google map
// add fetch_link_map()
// use weblinks_locate_factory

// 2006-07-30 K.OHWADA
// BUG 4169: not show total in index

// 2006-05-15 K.OHWADA
// use new handler

// 2006-03-26 K.OHWADA
// REQ 3807: Description in main page

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication
// move from include/functions

//================================================================
// WebLinks Module
// 2004/01/23 K.OHWADA
//================================================================

//---------------------------------------------------------
// TODO
// global $xoopsTpl
// class language_convert get_country()
//---------------------------------------------------------

// === class begin ===
if( !class_exists('weblinks_template') ) 
{

//=========================================================
// class weblinks_template
//=========================================================
class weblinks_template
{
// handler
	var $_config_handler;
	var $_linkitem_handler;
	var $_category_handler;
	var $_link_handler;
	var $_rssc_handler;
	var $_menu;
	var $_system;
	var $_post;

// dirname
	var $_DIRNAME;

// template
	var $_template_header        = null;
	var $_template_search_form   = null;
	var $_template_guidance      = null;
	var $_template_link_single   = null;
	var $_template_links_list    = null;
	var $_template_link_map      = null;
	var $_template_category_navi = null;
	var $_template_forum_list    = null;
	var $_template_photo_list    = null;
	var $_template_gm_list       = null;
	var $_template_gm_single     = null;

// system variable
	var $_module_name;
	var $_xoops_language;
	var $_happy_linux_url;

// local variable
	var $_time_start = 0;
	var $_time_prev  = 0;

// config
	var $_conf;

	var $_total_site_recommend;
	var $_total_site_mutual;
	var $_total_site_rss;
	var $_total_feed;

// keyword
	var $_keywords_urlencode = null;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_template( $dirname )
{
	$this->_DIRNAME = $dirname ;

// handler
	$this->_config_handler    =& weblinks_get_handler( 'config2_basic',  $dirname );
	$this->_linkitem_handler  =& weblinks_get_handler( 'linkitem_basic', $dirname );
	$this->_category_handler  =& weblinks_get_handler( 'category_basic', $dirname );
	$this->_link_handler      =& weblinks_get_handler( 'link_basic',     $dirname );
	$this->_rssc_handler      =& weblinks_get_handler( 'rssc',           $dirname );

	$locate        =& weblinks_locate_factory::getInstance( $dirname );
	$this->_system =& happy_linux_system::getInstance();
	$this->_menu   =& weblinks_menu::getInstance( $dirname );
	$this->_post   =& happy_linux_post::getInstance();

	$this->_conf = $this->_config_handler->get_conf();
	$conf_map_template = $this->_conf['map_template'];

// system
	$this->_module_name    = $this->_system->get_module_name();
	$this->_xoops_language = $this->_system->get_language();

// locate
	$locate->weblinks_init();
	$this->_happy_linux_url = $locate->get_var('happy_linux_url');

// template
	$this->_template_header      = XOOPS_ROOT_PATH.'/modules/'.$dirname.'/templates/parts/weblinks_header.html';
	$this->_template_search_form = XOOPS_ROOT_PATH.'/modules/'.$dirname.'/templates/parts/weblinks_search_form.html';
	$this->_template_guidance    = XOOPS_ROOT_PATH.'/modules/'.$dirname.'/templates/parts/weblinks_guidance.html';
	$this->_template_link_single = XOOPS_ROOT_PATH.'/modules/'.$dirname.'/templates/parts/weblinks_link_single.html';
	$this->_template_links_list  = XOOPS_ROOT_PATH.'/modules/'.$dirname.'/templates/parts/weblinks_links_list.html';
	$this->_template_category_navi = XOOPS_ROOT_PATH.'/modules/'.$dirname.'/templates/parts/weblinks_category_navi.html';
	$this->_template_forum_list  = XOOPS_ROOT_PATH.'/modules/'.$dirname.'/templates/parts/weblinks_forum_list.html';
	$this->_template_photo_list  = XOOPS_ROOT_PATH.'/modules/'.$dirname.'/templates/parts/weblinks_photo_list.html';
	$this->_template_gm_list     = XOOPS_ROOT_PATH.'/modules/'.$dirname.'/templates/parts/weblinks_gm_list.html';
	$this->_template_gm_single   = XOOPS_ROOT_PATH.'/modules/'.$dirname.'/templates/parts/weblinks_gm_single.html';

	if ($conf_map_template)
	{
		$this->_template_link_map = XOOPS_ROOT_PATH.'/modules/'.$dirname.'/templates/map/'.$conf_map_template;
	}

}

function &getInstance( $dirname )
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_template( $dirname );
	}

	return $instance;
}

//-------------------------------------------------------------------
// assign template
//-------------------------------------------------------------------
function assignPageTitle( $title, $format=true )
{
	global $xoopsTpl;

	$module_name = htmlspecialchars($this->_module_name, ENT_QUOTES);

	if ($format)
	{
		$title = htmlspecialchars($title, ENT_QUOTES);
	}

	$pagetitle = $module_name.' - '.$title;
	$xoopsTpl->assign('xoops_pagetitle', $pagetitle);
}

function assignIndex()
{
	global $xoopsTpl;
	$this->_assign_header_common( $xoopsTpl );
}

function assignHeader( $description=null )
{
	global $xoopsTpl;
	$this->load_total();

	$header   = $this->fetch_header( $description );
	$guidance = $this->fetch_guidance();

	$xoopsTpl->assign('weblinks_header',      $header);
	$xoopsTpl->assign('weblinks_guidance',    $guidance);

// BUG: not show total in index
	$this->_assign_header_total( $xoopsTpl );
}

function assignSearch( $show_mark=0, $show_cat=0, $show_br1=0, $show_br2=0, $subcat=0  )
{
	global $xoopsTpl;

	$this->_assign_search_common( $xoopsTpl );

	$text = $this->fetch_search_form( $show_mark, $show_cat, $show_br1, $show_br2, $subcat );
	$xoopsTpl->assign('weblinks_search_form', $text);

}

function assignDisplayLink()
{
	global $xoopsTpl;
	$this->_assign_link_common( $xoopsTpl );
}

function fetch_gm_list( &$links, $gm_latitude, $gm_longitude, $gm_zoom, $css_map='weblinks_gm_map_index' )
{
	$tpl = new XoopsTpl();
	$this->_assign_gm_common( $tpl, $gm_latitude, $gm_longitude, $gm_zoom );
	$tpl->assign('css_map',  $css_map);

	if ( is_array($links) && count($links) )
	{
		foreach ($links as $link) 
		{
			$tpl->append('links', $link);
		}
	}

	$text = $tpl->fetch( $this->_template_gm_list );
	return $text;
}

function fetch_gm_single( &$link )
{
	$tpl = new XoopsTpl();
	$this->_assign_gm_common( $tpl );
	$this->_assign_linkitem_name( $tpl );
	$tpl->assign('link', $link);

	$text = $tpl->fetch( $this->_template_gm_single );
	return $text;
}

function _assign_gm_common( &$tpl, $gm_latitude=0, $gm_longitude=0, $gm_zoom=0 )
{
// system parameter
	$tpl->assign('xoops_url',      XOOPS_URL );
	$tpl->assign('xoops_langcode', _LANGCODE );
	$tpl->assign('dirname',        $this->_DIRNAME );

	$tpl->assign('gm_server',    $this->_conf['gm_server'] );
	$tpl->assign('gm_apikey',    $this->_conf['gm_apikey'] );
	$tpl->assign('gm_latitude',  $gm_latitude );
	$tpl->assign('gm_longitude', $gm_longitude );
	$tpl->assign('gm_zoom',      $gm_zoom );
	$tpl->assign('lang_js_invalid',     _WEBLINKS_JAVASCRIPT_INVALID );
	$tpl->assign('lang_not_compatible', _WEBLINKS_GM_NOT_COMPATIBLE );
	$tpl->assign('lang_more',           _WLS_MORE );
}

function fetch_header( $description=null )
{
	$tpl = new XoopsTpl();
	$this->_assign_header_common( $tpl );
	$this->_assign_header_total(  $tpl );

	$tpl->assign( 'keywords',   $this->_keywords_urlencode );
	$tpl->assign( 'index_desc', $description );

	$text = $tpl->fetch( $this->_template_header );
	return $text;
}

function fetch_guidance()
{
	$tpl = new XoopsTpl();
	$this->_assign_header_common( $tpl );
	$this->_assign_header_total(  $tpl );

	$tpl->assign( 'keywords', $this->_keywords_urlencode );

	$text = $tpl->fetch( $this->_template_guidance );
	return $text;
}

function fetch_search_form( $show_mark=0, $show_cat=0, $show_br1=0, $show_br2=0, $subcat=0 )
{
	$tpl  = new XoopsTpl();

	$selbox = '';
	$cid    = $this->_post->get_get_int('cid');
	$mark   = $this->_post->get_get_text('mark');
	$query  = trim( $this->_post->get_get_text('query') );

	if ( $subcat == 0 )
	{
		$subcat = $this->_post->get_get_int('subcat');
	}

	$andor = $this->_post->get_get_text('andor');
	if ( ( $andor != 'OR' ) && ( $andor != 'exact' ) )
	{
		$andor = 'AND';
	}

	if ( $show_cat )
	{
		$selbox = $this->_build_cat_selbox( $cid );
	}

	$this->_assign_header_common( $tpl );
	$this->_assign_search_common( $tpl );

	$tpl->assign('show_mark', $show_mark );
	$tpl->assign('show_cat',  $show_cat );
	$tpl->assign('show_br1',  $show_br1 );
	$tpl->assign('show_br2',  $show_br2 );

	$tpl->assign('search_query',      htmlspecialchars($query, ENT_QUOTES) );
	$tpl->assign('search_selected',   $this->_get_search_selected( $andor, $mark ) );
	$tpl->assign('search_checked',    $this->_get_search_checked( $subcat ) );
	$tpl->assign('search_cat_selbox', $selbox);

	$text = $tpl->fetch( $this->_template_search_form );
	return $text;
}

function fetch_link_single( &$link )
{
	$tpl = new XoopsTpl();

	$link['map'] = $this->fetch_link_map( $link );
	$this->_assign_link_common( $tpl );
	$tpl->assign('link',     $link);
	$tpl->assign('keywords', $this->_keywords_urlencode );
	$text = $tpl->fetch( $this->_template_link_single );
	return $text;
}

function fetch_link_map( &$link )
{
	$text = '';
	if ( $this->_template_link_map )
	{
		$tpl = new XoopsTpl();
		$this->_assign_link_common( $tpl );
		$tpl->assign('link', $link);
		$text = $tpl->fetch( $this->_template_link_map );
	}
	return $text;
}

function fetch_links_full( &$links )
{
	$text = '';
	foreach ($links as $link) 
	{
		$text .= $this->fetch_link_single( $link );
	}
	return $text;
}

function fetch_links_list( &$links )
{
	$tpl = new XoopsTpl();
	$this->_assign_link_common( $tpl );
	$tpl->assign('keywords', $this->_keywords_urlencode );

	if ( is_array($links) )
	{
		foreach ($links as $link) 
		{
			$tpl->append('links', $link);
		}
	}

	$text = $tpl->fetch( $this->_template_links_list );
	return $text;
}

function fetch_category_navi( &$categories, $image_mode, $cols, $keywords )
{
	$width = intval(100/$cols);
	$count = count($categories);
	$cols_remainder =& $this->build_remainder_array( $this->calc_remainder( $count, $cols ) );

	$tpl = new XoopsTpl();
	$tpl->assign( 'xoops_url', XOOPS_URL );
	$tpl->assign( 'dirname',   $this->_DIRNAME );
	$tpl->assign('keywords',   $keywords);
	$tpl->assign( 'category_cols',       $cols );
	$tpl->assign( 'category_width',      $width );
	$tpl->assign( 'category_image_mode', $image_mode );
	$tpl->assign( 'main_categories',     $categories );
	$tpl->assign( 'cols_remainder',      $cols_remainder );
	$text = $tpl->fetch( $this->_template_category_navi );
	return $text;
}

function fetch_forum_list( &$threads )
{
	$tpl = new XoopsTpl();
	$tpl->assign('lang_forum',  _WEBLINKS_FORUM);
	$tpl->assign('lang_thread', _WEBLINKS_THREAD);
	$tpl->assign('forum_threads', $threads);
	$text = $tpl->fetch( $this->_template_forum_list );
	return $text;
}

function fetch_photo_list( &$photos )
{
	$tpl = new XoopsTpl();
	$tpl->assign('album_photos', $photos);
	$text = $tpl->fetch( $this->_template_photo_list );
	return $text;
}

function calc_remainder( $num, $max )
{
// exsample $max=3
// 0 -> 0
// 1 -> 2
// 2 -> 1
// 3 -> 0
// 4 -> 2
// 5 -> 1
// 6 -> 0

	$remainder = $max - ($num % $max);
	if ( $remainder >= $max )
	{
		$remainder = 0;
	}
	return $remainder;
}

function &build_remainder_array( $num )
{
	$arr = array();
	if ( $num > 0 )
	{
		for ($i=0; $i<$num; $i++)
		{
			$arr[] = '';
		}
	}
	return $arr;
}

//=========================================================
// private
//=========================================================
function _assign_header_common( &$tpl )
{
	$show_site_rss = 0;
	$show_atomfeed = 0;

	if ( WEBLINKS_RSSC_USE )
	{
		$show_site_rss = 1;
		$show_atomfeed = 1;
	}

// system parameter
	$tpl->assign('xoops_url',      XOOPS_URL );
	$tpl->assign('xoops_language', $this->_xoops_language );
	$tpl->assign('module_name',    $this->_module_name );
	$tpl->assign('dirname',        $this->_DIRNAME );

// menu show
	$tpl->assign('show_submit',        $this->_menu->show_submit() );
	$tpl->assign('show_site_popular',  $this->_menu->show_hits() );
	$tpl->assign('show_site_higtrate', $this->_menu->show_rating() );

// config
	$tpl->assign('logoshow',            $this->_conf['logoshow'] );
	$tpl->assign('titleshow',           $this->_conf['titleshow'] );
	$tpl->assign('show_site_recommend', $this->_conf['recommend_pri'] );
	$tpl->assign('show_site_mutual',    $this->_conf['mutual_pri'] );
	$tpl->assign('show_site_rss',  $show_site_rss );
	$tpl->assign('show_atomfeed',  $show_atomfeed );

	$tpl->assign('happy_linux_url',  $this->_happy_linux_url );

// REQ 3110: Add in this category
	if ( isset($_GET['cid']) )
	{
		$tpl->assign('cid', intval($_GET['cid']) );
	}

// --- lang ---
	$tpl->assign('lang_home',     _HOME);
	$tpl->assign('lang_nomatch',  _WLS_NOMATCH);

// guidance bar
	$tpl->assign('lang_main',           _WLS_MAIN);
	$tpl->assign('lang_submitlink',     _WLS_SUBMIT_NEW_LINK);
	$tpl->assign('lang_site_popular',   _WLS_SITE_POPULAR);	
	$tpl->assign('lang_site_highrate',  _WLS_SITE_HIGHRATE);
	$tpl->assign('lang_site_recommend', _WLS_SITE_RECOMMEND);
	$tpl->assign('lang_site_mutual',    _WLS_SITE_MUTUAL);

// second guidance bar
	$tpl->assign('lang_catlist',        _WLS_CATLIST);
	$tpl->assign('lang_site_rss',       _WLS_SITE_RSS);
	$tpl->assign('lang_atomfeed',       _WLS_ATOMFEED);
	$tpl->assign('lang_site_random',    _WLS_SITE_RANDOM);

// index.php
	$tpl->assign('lang_new_sitelist',   _WLS_NEW_SITELIST);
	$tpl->assign('lang_new_atomfeed',   _WLS_NEW_ATOMFEED);

// java script
	$tpl->assign('lang_js_invalid',     _WEBLINKS_JAVASCRIPT_INVALID );

}

function _assign_header_total( &$tpl )
{
	$total_site_topten    = "top".intval( $this->_conf['topten_links'] );

	$tpl->assign('total_site_recommend', $this->_total_site_recommend);
	$tpl->assign('total_site_mutual',    $this->_total_site_mutual);
	$tpl->assign('total_site_rss',       $this->_total_site_rss);
	$tpl->assign('total_atomfeed',       $this->_total_feed);

// BUG 3111: timeout occurs in popular site if many top categories
	$tpl->assign('total_site_topten', $total_site_topten);
}

function _assign_search_common( &$tpl )
{
	$tpl->assign('search_google_server', $this->_conf['google_server'] );

// --- lang ---
	$tpl->assign('lang_search_search',  _SR_SEARCH);
	$tpl->assign('lang_search_all',     _SR_ALL);
	$tpl->assign('lang_search_any',     _SR_ANY);
	$tpl->assign('lang_search_exact',   _SR_EXACT);
	$tpl->assign('lang_search_result',  _SR_SEARCHRESULTS);
	$tpl->assign('lang_search_showall', _SR_SHOWALLR);
	$tpl->assign('lang_search_prev',    _SR_PREVIOUS);
	$tpl->assign('lang_search_next',    _SR_NEXT);
	$tpl->assign('lang_search_keyword', _SR_KEYWORDS.':');
	$tpl->assign('lang_search_ignore',  sprintf(_SR_IGNOREDWORDS, $this->_conf['search_min']) );

	$tpl->assign('lang_search_google',      _HAPPY_LINUX_SEARCH_GOOGLE );
	$tpl->assign('lang_search_with_subcat', _HAPPY_LINUX_SEARCH_WITH_SUBCAT );
	$tpl->assign('lang_search_not_select',  _HAPPY_LINUX_SEARCH_NOT_SELECT);
	$tpl->assign('lang_search_candidate',   _HAPPY_LINUX_SEARCH_CANDICATE );
}

function _get_search_selected( $andor, $mark )
{
	$selected = array();

	if ($andor == 'exact') 
	{
		$selected['exact'] = 'selected';
	}
	elseif ($andor == 'OR')
	{
		$selected['or'] = 'selected';
	}
	else
	{
		$selected['and'] = 'selected';
	}

	if ($mark == 'recommend') 
	{
		$selected['recommend'] = 'selected';
	}
	elseif ($mark == 'mutual')
	{
		$selected['mutual'] = 'selected';
	}

	return $selected;
}

function _get_search_checked( $subcat )
{
	$checked = array();

	if ($subcat == 1) 
	{
		$checked['subcat'] = 'checked';
	}

	return $checked;
}

function _assign_link_common( &$tpl )
{
	$this->_assign_linkitem_name( $tpl );

	$show_atomfeed = 0;
	if ( WEBLINKS_RSSC_USE )
	{
		$show_atomfeed = 1;
	}

// system parameter
	$tpl->assign('xoops_url',       XOOPS_URL );
	$tpl->assign('xoops_language',  $this->_xoops_language );
	$tpl->assign('is_module_admin', $this->_system->is_module_admin() );
	$tpl->assign('module_name',     $this->_module_name );
	$tpl->assign('country_code',    $this->_conf['country_code'] );
	$tpl->assign('flag_map_use',    $this->_conf['map_use'] );
	$tpl->assign('dirname',         $this->_DIRNAME );

// show ratelink
	$show_ratelink = false;
	$show_rating   = false;
	if ( $this->_menu->show_rating() )
	{
		$show_rating = true;

		$has_auth_ratelink = $this->_config_handler->has_auth_ratelink();
		if ( $has_auth_ratelink )
		{
			$show_ratelink = true;
		}
	}

// menu show
	$tpl->assign('show_hits',       $this->_menu->show_hits() );
	$tpl->assign('show_rating',     $show_rating );
	$tpl->assign('show_ratelink',   $show_ratelink );
	$tpl->assign('show_atomfeed',   $show_atomfeed );
	$tpl->assign('show_brokenlink', $this->_conf['use_brokenlink'] );

// index
	$tpl->assign('lang_more',            _WLS_MORE);
	$tpl->assign('lang_site_new',        _WLS_SITE_NEW);
	$tpl->assign('lang_site_update',     _WLS_SITE_UPDATE);
	$tpl->assign('lang_site_popular',    _WLS_SITE_POPULAR);
	$tpl->assign('lang_site_recommend',  _WLS_SITE_RECOMMEND);
	$tpl->assign('lang_site_mutual',     _WLS_SITE_MUTUAL);
	$tpl->assign('lang_image_new',       _WLS_SITE_NEW);
	$tpl->assign('lang_image_update',    _WLS_SITE_UPDATE);
	$tpl->assign('lang_image_popular',   _WLS_SITE_POPULAR);
	$tpl->assign('lang_image_recommend', _WLS_SITE_RECOMMEND);
	$tpl->assign('lang_image_mutual',    _WLS_SITE_MUTUAL);
	$tpl->assign('lang_image_google_maps', _WEBLINKS_GOOGLE_MAPS);

// singlelink
	$tpl->assign('lang_visit' ,          _WLS_VISIT);
	$tpl->assign('lang_promoter',        _WLS_PROMOTER);
	$tpl->assign('lang_modify',          _WLS_MODIFY);
	$tpl->assign('lang_editthislink' ,   _WLS_EDITTHISLINK);
	$tpl->assign('lang_ratethissite',    _WLS_RATETHISSITE);
	$tpl->assign('lang_reportbroken',    _WLS_REPORTBROKEN);
	$tpl->assign('lang_tellafriend',     _WLS_TELLAFRIEND);

	$tpl->assign('lang_comments',      _COMMENTS );
	$tpl->assign('lang_print',         _PRINT);
	$tpl->assign('lang_pssword',       _US_PASSWORD );

	$tpl->assign('lang_site_title',     _WLS_SITETITLE );
	$tpl->assign('lang_site_url',       _WLS_SITEURL );
	$tpl->assign('lang_lastupdate',     _WLS_LASTUPDATE );
	$tpl->assign('lang_category',       _WLS_CATEGORY );
	$tpl->assign('lang_linkid',         _WLS_LINKID );
	$tpl->assign('lang_banner_url',     _WLS_BANNERURL );
	$tpl->assign('lang_rss_url',        _WLS_RSS_URL );
	$tpl->assign('lang_name',           _WLS_NAME );
	$tpl->assign('lang_email',          _WLS_EMAIL );
	$tpl->assign('lang_company',        _WLS_COMPANY );
	$tpl->assign('lang_zip',            _WLS_ZIP );
	$tpl->assign('lang_state',          _WLS_STATE );
	$tpl->assign('lang_city',           _WLS_CITY );
	$tpl->assign('lang_addr',           _WLS_ADDR );
	$tpl->assign('lang_addr2',          _WLS_ADDR2 );
	$tpl->assign('lang_tel',            _WLS_TEL );
	$tpl->assign('lang_fax',            _WLS_FAX );
	$tpl->assign('lang_hits',           _WLS_HITS );
	$tpl->assign('lang_rating',         _WLS_RATING );
	$tpl->assign('lang_votes',          _WLS_VOTE );
	$tpl->assign('lang_options',        _WLS_OPTIONS );
	$tpl->assign('lang_description',    _WLS_DESCRIPTION );
	$tpl->assign('lang_user_comment',   _WLS_USER_COMMENT );
	$tpl->assign('lang_admin_commnet',  _WLS_ADMINCOMMENT );
	$tpl->assign('lang_broken_counter', _WLS_BROKEN_COUNTER );

	$tpl->assign('lang_mid',           _WEBLINKS_MID );
	$tpl->assign('lang_userid',        _WEBLINKS_USERID );
	$tpl->assign('lang_rssc_lid',      _WEBLINKS_RSSC_LID );
	$tpl->assign('lang_create',        _WEBLINKS_CREATE );
	$tpl->assign('lang_time_publish',  _WEBLINKS_TIME_PUBLISH );
	$tpl->assign('lang_time_expire',   _WEBLINKS_TIME_EXPIRE );
	$tpl->assign('lang_map_use',       _WEBLINKS_MAP_USE );
	$tpl->assign('lang_etc',           _WEBLINKS_ETC );
	$tpl->assign('lang_textarea',      _WEBLINKS_TEXTAREA );
	$tpl->assign('lang_gm_latitude',   _WEBLINKS_GM_LATITUDE );
	$tpl->assign('lang_gm_longitude',  _WEBLINKS_GM_LONGITUDE );
	$tpl->assign('lang_gm_zoom',       _WEBLINKS_GM_ZOOM );

// banner
	$tpl->assign('link_image_use', $this->_conf['link_image_use'] );
	$tpl->assign('list_image_use', $this->_conf['list_image_use'] );

}

//---------------------------------------------------------
// linkitem_handler
//---------------------------------------------------------
function _assign_linkitem_name( &$tpl )
{
	$this->_linkitem_handler->load_once();
	$conf =& $this->_linkitem_handler->get_conf();
	foreach ($conf as $k => $v)
	{
		$name  = htmlspecialchars('lang_link_'.$k, ENT_QUOTES);
		$value = htmlspecialchars($v,              ENT_QUOTES);
		$tpl->assign($name, $value);
	}
}

//---------------------------------------------------------
// category_handler
//---------------------------------------------------------
function _build_cat_selbox( $cid )
{
	$this->_category_handler->load_once();
	$selbox = $this->_category_handler->build_selbox( $cid, 1, "cid", '', _HAPPY_LINUX_SEARCH_NOT_SELECT, 0 );
	return $selbox;
}

//-------------------------------------------------------------------
// link_handler rssc_handler
//-------------------------------------------------------------------
function load_total()
{
	$this->_total_site_recommend = $this->_link_handler->get_count_by_mark('recommend');
	$this->_total_site_mutual    = $this->_link_handler->get_count_by_mark('mutual');
	$this->_total_site_rss       = $this->_link_handler->get_count_rss_flag();
	$this->_total_feed           = $this->_rssc_handler->get_feed_count();
}

//---------------------------------------------------------
// set keyword property
//---------------------------------------------------------
function set_keywords_urlencode($val)
{
	$this->_keywords_urlencode = $val;
}

// --- class end ---
}

// === class end ===
}

?>