<?php
// $Id: weblinks_link.php,v 1.8 2007/03/25 15:03:49 ohwada Exp $

// 2007-03-25 K.OHWADA
// album_id

// 2007-03-01 K.OHWADA
// add forum_id comment_use field
// BUG: admin approve wrong password when guest submit
// BUG: cannot use bbcode in admincomment

// 2006-12-10 K.OHWADA
// add link_save class
// use happy_linux_object_validater
// add time_publish textarea1

// 2006-10-12 K.OHWADA
// BUG 4318: cannot register bulk links.
// add set_not_gpc()

// 2006-10-01 K.OHWADA
// divided from weblinks_link_handler
// google map
// change addr_urlencode()

//=========================================================
// WebLinks Module
// this file contain 4 class
//   weblinks_link_base
//   weblinks_link 
//   weblinks_link_save 
//   weblinks_link_validate
// 2006-09-20 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_link') ) 
{

//=========================================================
// class weblinks_link_base
//=========================================================
class weblinks_link_base extends happy_linux_object_validater
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_base()
{
	$this->happy_linux_object_validater();
}

//---------------------------------------------------------
// show
//---------------------------------------------------------
function name_disp( $format='s' )
{
	$name = $this->getVar('name', $format);
	$flag = $this->getVar('nameflag');
	$text = $this->name_mail_disp_common( $name, $flag );
	return $text;
}

function mail_disp( $format='s' )
{
	$mail = $this->getVar('mail', $format);
	$flag = $this->getVar('mailflag');
	$text = $this->name_mail_disp_common( $mail, $flag );
	return $text;
}

function name_mail_disp_common( $value, $flag )
{
	$text = null;
	if ($flag)
	{
		$text = $value;
	}
	return $text;
}

function description_disp()
{
	$myts =& MyTextSanitizer::getInstance();

	$context  = $this->get('description');
	$dohtml   = $this->get('dohtml');
	$dosmiley = $this->get('dosmiley');
	$doxcode  = $this->get('doxcode');
	$doimage  = $this->get('doimage');
	$dobr     = $this->get('dobr');

	$text = $myts->displayTarea($context, $dohtml, $dosmiley, $doxcode, $doimage, $dobr);
	return $text;
}

function textarea1_disp()
{
	$myts =& MyTextSanitizer::getInstance();

	$context  = $this->get('textarea1');
	$dohtml   = $this->get('dohtml1');
	$dosmiley = $this->get('dosmiley1');
	$doxcode  = $this->get('doxcode1');
	$doimage  = $this->get('doimage1');
	$dobr     = $this->get('dobr1');

	$text = $myts->displayTarea($context, $dohtml, $dosmiley, $doxcode, $doimage, $dobr);
	return $text;
}

function textarea2_disp()
{
	$myts =& MyTextSanitizer::getInstance();

	$context  = $this->get('textarea2');
	$dohtml   = 0;
	$dosmiley = 1;
	$doxcode  = 1;
	$doimage  = 1;
	$dobr     = 1;

	$text = $myts->displayTarea($context, $dohtml, $dosmiley, $doxcode, $doimage, $dobr);
	return $text;
}

// BUG: cannot use bbcode in admincomment
function admincomment_disp()
{
	$myts =& MyTextSanitizer::getInstance();

	$context  = $this->get('admincomment');
	$dohtml   = 0;
	$dosmiley = 1;
	$doxcode  = 1;
	$doimage  = 1;
	$dobr     = 1;

	$text = $myts->displayTarea($context, $dohtml, $dosmiley, $doxcode, $doimage, $dobr);
	return $text;
}

//---------------------------------------------------------
// cid array field
//---------------------------------------------------------
function &get_cid_array_form_post( &$post )
{
	$arr =& $this->_post->get_int_unique_array_without_from_post( $post, 'cid', 0 );
	return $arr;
}

// --- class end ---
}

//=========================================================
// class weblinks_link
//=========================================================
class weblinks_link extends weblinks_link_base
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link()
{
	$this->weblinks_link_base();

	$this->initVar('lid',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('uid',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('cids',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('title',  XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('url',    XOBJ_DTYPE_URL,    null, false, 255);
	$this->initVar('banner', XOBJ_DTYPE_URL,    null, false, 255);
	$this->initVar('description',  XOBJ_DTYPE_TXTAREA);
	$this->initVar('name',     XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('nameflag', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('mail',     XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('mailflag', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('company',  XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('addr',     XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('tel',      XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('search',     XOBJ_DTYPE_TXTAREA);
	$this->initVar('passwd',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('admincomment',   XOBJ_DTYPE_TXTAREA);
	$this->initVar('mark',         XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('time_create',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('time_update',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('hits',     XOBJ_DTYPE_INT, 0, false);
	$this->initVar('rating',   XOBJ_DTYPE_FLOAT, 0.0, false);
	$this->initVar('votes',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('comments', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('width',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('height',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('recommend',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('mutual',     XOBJ_DTYPE_INT, 0, false);
	$this->initVar('broken',     XOBJ_DTYPE_INT, 0, false);
	$this->initVar('rss_url',    XOBJ_DTYPE_URL, null, false, 255);
	$this->initVar('rss_flag',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('rss_xml',    XOBJ_DTYPE_TXTAREA);
	$this->initVar('rss_update', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('usercomment',  XOBJ_DTYPE_TXTAREA);
	$this->initVar('zip',    XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('state',  XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('city',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('addr2',  XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('fax',    XOBJ_DTYPE_TXTBOX, null, false, 255);

// html
	$this->initVar('dohtml',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('dosmiley', XOBJ_DTYPE_INT, 1, false);
	$this->initVar('doxcode',  XOBJ_DTYPE_INT, 1, false);
	$this->initVar('doimage',  XOBJ_DTYPE_INT, 1, false);
	$this->initVar('dobr',     XOBJ_DTYPE_INT, 1, false);
	$this->initVar('etc1',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('etc2',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('etc3',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('etc4',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('etc5',   XOBJ_DTYPE_TXTBOX, null, false, 255);

// rssc
	$this->initVar('rssc_lid',  XOBJ_DTYPE_INT,   0);
	$this->initVar('map_use',   XOBJ_DTYPE_INT,   1);

// google map: hacked by wye
	$this->initVar('gm_latitude',  XOBJ_DTYPE_FLOAT, 0, false );
	$this->initVar('gm_longitude', XOBJ_DTYPE_FLOAT, 0, false );
	$this->initVar('gm_zoom',      XOBJ_DTYPE_INT,   0, false );

// aux
	$this->initVar('aux_int_1',  XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_int_2',  XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_text_1', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('aux_text_2', XOBJ_DTYPE_TXTBOX, null, false, 255);

// publish
	$this->initVar('time_publish', XOBJ_DTYPE_INT, 0);
	$this->initVar('time_expire',  XOBJ_DTYPE_INT, 0);
	$this->initVar('textarea1',    XOBJ_DTYPE_TXTAREA);
	$this->initVar('textarea2',    XOBJ_DTYPE_TXTAREA);
	$this->initVar('dohtml1',      XOBJ_DTYPE_INT, 0);
	$this->initVar('dosmiley1',    XOBJ_DTYPE_INT, 1);
	$this->initVar('doxcode1',     XOBJ_DTYPE_INT, 1);
	$this->initVar('doimage1',     XOBJ_DTYPE_INT, 1);
	$this->initVar('dobr1',        XOBJ_DTYPE_INT, 1);

// forum
	$this->initVar('forum_id',     XOBJ_DTYPE_INT, 0);
	$this->initVar('comment_use',  XOBJ_DTYPE_INT, 1);

	$this->initVar('album_id',     XOBJ_DTYPE_INT,   0);
}

//---------------------------------------------------------
// for admin user list
//---------------------------------------------------------
function user_name( $format )
{
	$uid   = $this->get('uid');
	$title = $this->get('title');
	$name  = $this->get('name');

	$system_name = $this->_system->get_uname_by_uid( $uid );

	$user_name = '';
	if ($name)
	{
		$user_name = $name;
	}
	elseif ($uid && $system_name)
	{
		$user_name = $system_name;
	}
	else
	{
		$user_name = $title;
	}

	$user_name = $this->sanitize_format_text($user_name, $format);
	return $user_name;
}

function user_mail( $format )
{
	$uid   = $this->get('uid');
	$title = $this->get('title');
	$mail  = $this->get('mail');

	$system_mail = $this->_system->get_email_by_uid( $uid );

	$user_mail = '';
	if ($mail)
	{
		$user_mail = $mail;
	}
	elseif ($uid && $system_mail)
	{
		$user_mail = $system_mail;
	}
	else
	{
		$user_mail = $title;
	}

	$user_mail = $this->sanitize_format_text($user_mail, $format);
	return $user_mail;
}

// --- class end ---
}


//=========================================================
// class weblinks_link_save
//=========================================================
class weblinks_link_save extends weblinks_link
{
	var $_banner_handler;
	var $_link_validate;

// result
	var $_cid_arr           = null;
	var $_banner_error_code = 0;
	var $_banner_errors     = null;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_save( $dirname )
{
	$this->weblinks_link();

	$this->_banner_handler =& weblinks_get_handler( 'banner', $dirname );
	$this->_link_validate  =& weblinks_link_validate::getInstance( $dirname );
}

//---------------------------------------------------------
// assign add object
// $_POST or bulk
//---------------------------------------------------------
function assign_add_object( &$post, $not_gpc=false, $flag_banner=false )
{
	$this->_set_vars_common( $post, $not_gpc );

// set object
	$this->set_object_with_validater();

// time
	$time = time();
	$this->setVar('time_create', $time);
	$this->setVar('time_update', $time);

// passwd
	$this->setVar('passwd', $this->_link_validate->get_passwd_md5_new($post) );

// banner
	if ( $flag_banner )
	{
		$this->_set_obj_banner_size();
	}

// search
	$this->_set_obj_search( $post);
}

//---------------------------------------------------------
// assign mod object
// $_POST or bulk
//---------------------------------------------------------
function assign_mod_object( &$post, $not_gpc=false, $flag_banner=false )
{
	$this->_set_vars_common( $post, $not_gpc );

// time_update
	$this->set_validater_value_allow_by_array( $this->get_value_allow_type_time_update_form_post( $post, 'time_update') );

// passwd
	$this->set_validater_value_allow_by_array( $this->_link_validate->get_passwd_md5_mod_array($post) );

// rssc_lid
	$this->set_validater_value_allow_by_array( $this->get_value_allow_type_int_with_flag_update_from_post($post, 'rssc_lid') );

// set object
	$this->set_object_with_validater();

// banner
	if ( $flag_banner )
	{
		$this->_set_obj_banner_size();
	}

// search
	$this->_set_obj_search( $post );

}

//---------------------------------------------------------
// get parameter
//---------------------------------------------------------
function &get_cid_array()
{
	return $this->_cid_arr;
}

function get_banner_error_code()
{
	return $this->_banner_error_code;
}

function get_banner_errors()
{
	return $this->_banner_errors;
}

//---------------------------------------------------------
// assign vars
//---------------------------------------------------------
function _set_vars_common( &$post, $not_gpc=false )
{
	$this->set_validater_name_prefix( 'weblinks' );

	$this->_link_validate->init();
	$this->set_validater_conf_array( $this->_link_validate->get_conf_array() );
	$this->merge_validater_allow_list( $this->_link_validate->get_allow_list() );

// post value
	$this->merge_validater_value_list( $this->validate_values_from_post( $post, $not_gpc ) );

// uid
	$this->set_validater_value_allow_by_array( $this->_link_validate->get_uid_array( $post ) );
}

//---------------------------------------------------------
// banner size field
// presuppose to execute set_object_with_validater()
//---------------------------------------------------------
function _set_obj_banner_size()
{
	$banner = $this->get('banner');

// return size zero, if not banner
	$size =& $this->_banner_handler->get_remote_banner_size( $banner );

	if ( is_array($size) && isset($size[0]) && isset($size[1]) )
	{
		$this->setVar('width',  $size[0]);
		$this->setVar('height', $size[1]);
	}
	elseif ( !$size )
	{
		$this->_banner_error_code = $this->_banner_handler->getErrorCode();
		$this->_banner_errors     = $this->_banner_handler->getErrors();
	}
}

//---------------------------------------------------------
// search field
// presuppose to execute set_object_with_validater()
//---------------------------------------------------------
function _set_obj_search( &$post)
{
	$this->_cid_arr =& $this->get_cid_array_form_post( $post );
	$search = $this->_build_search( $this->_cid_arr );
	$this->setVar('search', $search);
}

function _build_search( &$cid_arr )
{
	$search_list =& $this->_link_validate->get_search_list();

	$search = '';

	foreach( $this->gets() as $k => $v)
	{
		if ( isset($search_list[$k]) && $search_list[$k] )
		{
			$search .= $v.' ';
		}
	}

	$search .= $this->name_disp('n').' ';
	$search .= $this->mail_disp('n').' ';

	$search .= strip_tags( $this->description_disp() ).' ';
	$search .= strip_tags( $this->textarea1_disp() ).' ';
	$search .= strip_tags( $this->textarea2_disp() ).' ';

	$search .= $this->_link_validate->build_search_category( $cid_arr ).' ';

	$search = preg_replace("/\n|\r/",' ',$search);

	return $search;
}

// --- class end ---
}

//=========================================================
// class weblinks_link_validate
//=========================================================
class weblinks_link_validate
{
	var $_config_handler;
	var $_category_handler;
	var $_linkitem_define_handler;
	var $_system;
	var $_post;

// local
	var $_conf;
	var $_xoops_uid;
	var $_is_xoops_module_admin;
	var $_is_xoops_guest;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_validate( $dirname )
{
	$this->_config_handler          =& weblinks_get_handler( 'config2_basic',   $dirname );
	$this->_category_handler        =& weblinks_get_handler( 'category',        $dirname );
	$this->_linkitem_define_handler =& weblinks_get_handler( 'linkitem_define', $dirname );

	$this->_system  =& happy_linux_system::getInstance();
	$this->_post    =& happy_linux_post::getInstance();

	$this->_conf =& $this->_config_handler->get_conf();

	$this->_xoops_uid             = $this->_system->get_uid();
	$this->_is_xoops_module_admin = $this->_system->is_module_admin();
	$this->_is_xoops_guest        = $this->_system->is_guest();
}

function &getInstance( $dirname )
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_link_validate( $dirname );
	}

	return $instance;
}

//---------------------------------------------------------
// config
//---------------------------------------------------------
function init()
{
	$this->_linkitem_define_handler->load();
}

function &get_conf_array()
{
	$arr =& $this->_linkitem_define_handler->get_cached_by_name();
	return $arr;
}

function &get_allow_list()
{
	$arr1 =& $this->_linkitem_define_handler->get_save_mode_list();
	$arr2 =& $this->_config_handler->has_auth_desc_option();
	$arr3 =  array_merge($arr1, $arr2);
	return $arr3;
}

function &get_search_list()
{
	$arr =& $this->_linkitem_define_handler->get_search_list();
	return $arr;
}

//---------------------------------------------------------
// xoops param
//---------------------------------------------------------
function get_xoops_uid()
{
	return $this->_xoops_uid;
}

function is_xoops_module_admin()
{
	return $this->_is_xoops_module_admin;
}

function is_xoops_guest()
{
	return $this->_is_xoops_guest;
}

//---------------------------------------------------------
// uid field
//---------------------------------------------------------
function get_uid_array( &$post )
{
	$uid = $this->get_uid( $post );
	return array('uid', $uid, true);
}

function get_uid( &$post )
{
// default: submitter
	$uid = $this->get_xoops_uid();

// if admin
	if ( $this->is_xoops_module_admin() && isset($post['uid']) )
	{
		$uid = intval($post['uid']);
	}

	return $uid;
}

//---------------------------------------------------------
// passwd field
//---------------------------------------------------------
function get_passwd_md5_new_array( &$post )
{
	$passwd = $this->get_passwd_md5_new( $post );
	return array('passwd', $passwd, 'true');
}

function get_passwd_md5_new( &$post )
{
// admin or guest specify
	if ( $this->_has_passwd() && isset($post['passwd_new']) && $post['passwd_new'] )
	{
		$passwd = $this->_post->get_text_from_post( $post, 'passwd_new');
		$passwd = md5( $passwd );
	}

// admin approve new link
	elseif ( $this->_is_approve_passwd($post, 'approve') )
	{
		$passwd = $this->_post->get_text_from_post( $post, 'passwd_md5');
	}

// default
	if ( empty($passwd) )
	{
		$passwd = md5( xoops_makepass() );
	}

	return $passwd;
}

function get_passwd_md5_mod_array( &$post )
{
// default
	$passwd = '';
	$allow  = false;

// admin or guest specify
	if ( $this->_has_passwd() && isset($post['passwd_new']) && $post['passwd_new'] )
	{
		$passwd = $this->_post->get_text_from_post( $post, 'passwd_new');
		$passwd = md5( $passwd );
		$allow  = true;
	}

// admin approve mod link
	elseif ( $this->_is_approve_passwd($post, 'approveModReq') )
	{
		$passwd = $this->_post->get_text_from_post( $post, 'passwd_md5');
		$allow  = true;
	}

	return array('passwd', $passwd, $allow);
}

function _is_approve_passwd( &$post, $op )
{
// BUG: admin approve wrong password when guest submit
	if ( $this->is_xoops_module_admin() && 
	     isset($post['op']) && ($post['op'] == $op) &&
	     isset($post['passwd_md5']) && $post['passwd_md5'] )
	{
		return true;
	}
	return false;
}

function _has_passwd()
{
// admin
	if ( $this->is_xoops_module_admin() )
	{
		return true;
	}
// use passwd & guest
	if ( $this->_conf['use_passwd'] && $this->is_xoops_guest() )
	{
		return true;
	}
	return false;
}

//---------------------------------------------------------
// search field
//---------------------------------------------------------
function build_search_category( &$cid_arr )
{
	$search = '';

	if ( is_array($cid_arr) )
	{
		foreach ($cid_arr as $cid)
		{
			$path_array = $this->_category_handler->get_parent_path($cid);

			foreach ($path_array as $path)
			{
				$search .= $path['title'].' ';
			}
		}
	}

	return $search;
}

// --- class end ---
}

// === class end ===
}

?>