<?php
// $Id: weblinks_top.php,v 1.12 2007/03/25 15:03:49 ohwada Exp $

// 2007-03-25 wye & K.OHWADA
// google map

// 2007-03-17 K.OHWADA
// BUG 4508: Fatal error: Call to undefined function: weblinks_get_handler() in blocks/weblinks_top.php

// 2006-11-03 hiro <http://ishinomaki.cc/>
// add b_weblinks_generic_show()

// 2006-05-15 K.OHWADA
// change $moduel_url to $dirname

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// 2004/01/14 K.OHWADA
//=========================================================

// --- block function begin ---
if( !function_exists( 'b_weblinks_top_show' ) ) 
{

//---------------------------------------------------------
// $options
// [0] module directory name (weblinks)
// [1] order (time_update/hits/rating)
// [2] number of display links (10)
// [3] max length of title (30)
//       when 0, unlimited
// [4] days to show new icon (7)
//       when 0, not show
// [5] hits to show popular icon (0)
//       when 0, not show
// [6] max width of banner image (50)
//       when 0, not show
// [7] default width of banner image (50)
//       when 0, use original size
// [8] google map mode (0)
//       when 0, not show
//       when 1, use config latitude/longitude/zoom
//       when 2, use following value
// [9]  google map latitude  (0)
// [10] google map longitude (0)
// [11] google map zoom      (0)
// [12] google map heigh   (300) px
// [13] google map timeout (1000) msec
//       when -1, use window.onload
//---------------------------------------------------------

function b_weblinks_top_show($options) 
{
	global $xoopsDB;

	$CONF_BROKEN = 5;
	$SHOW_GM     = true;
	$GM_TIMEOUT  = 1000;	// m sec

	$DIRNAME = empty( $options[0] ) ? basename( dirname( dirname( __FILE__ ) ) ) : $options[0];
	$order         = $options[1];
	$limit         = intval($options[2]);
	$max_title     = intval($options[3]);
	$newdays       = intval($options[4]);
	$popular       = intval($options[5]);
	$max_width     = intval($options[6]);
	$width_default = intval($options[7]);

	$gm_mode      = isset($options[8])  ? intval($options[8])    : 0;
	$gm_latitude  = isset($options[9])  ? floatval($options[9])  : 0;
	$gm_longitude = isset($options[10]) ? floatval($options[10]) : 0;
	$gm_zoom      = isset($options[11]) ? intval($options[11])   : 0;
	$gm_height    = isset($options[12]) ? intval($options[12])   : 0;
	$gm_timeout   = isset($options[13]) ? intval($options[13])   : 0;

	$max_desc = 0;

	if (($order != 'hits')&&($order != 'rating'))
	{
		$order = 'time_update';
	}

	$param = array(
		'order'         => $order,
		'max_title'     => $max_title,
		'max_desc'      => $max_desc,
		'newdays'       => $newdays,
		'popular'       => $popular,
		'max_width'     => $max_width,
		'width_default' => $width_default,
	);

	$block = array();
	$block['dirname']       = $DIRNAME;
	$block['lang_hits']     = _MB_WEBLINKS_HITS;
	$block['lang_rating']   = _MB_WEBLINKS_RATING;
	$block['lang_votes']    = _MB_WEBLINKS_VOTES;
	$block['lang_comments'] = _MB_WEBLINKS_COMMENTS;
	$block['lang_more']     = _MB_WEBLINKS_MORE;

	$table_config = $xoopsDB->prefix( $DIRNAME."_config2" );
	$table_link   = $xoopsDB->prefix( $DIRNAME."_link" );

// config
	$sql1 = 'SELECT * FROM '. $table_config .' ORDER BY conf_id ASC';
	$res1 = $xoopsDB->query($sql1, 0, 0);
	if ( !$res1 )
	{
		return $block;
	}

	while ($row1 = $xoopsDB->fetchArray($res1)) 
	{
		$conf[ $row1['conf_name'] ] = $row1['conf_value'];
	}

// link
	$sql2  = "SELECT * FROM ".$table_link;
	$sql2 .= " WHERE broken < ".$CONF_BROKEN;
	$sql2 .= " ORDER BY ".$order." DESC";

	$res2 = $xoopsDB->query($sql2, $limit, 0);
	if ( !$res2 ) 
	{
		return $block;
	}

	while( $row2 = $xoopsDB->fetchArray($res2) )
	{
		$block['links'][] = b_weblinks_build_link($row2, $param);
	}

// use config value
	if ( $gm_mode == 1 )
	{
		$gm_latitude  = $conf['gm_latitude'];
		$gm_longitude = $conf['gm_longitude'];
		$gm_zoom      = $conf['gm_zoom'];
	}

	$show_gm = false;
	if ( $gm_mode != 0 )
	{
		$show_gm = $conf['gm_use'];
	}

	$block['show_gm']      = $show_gm;
	$block['gm_server']    = $conf['gm_server'];
	$block['gm_apikey']    = $conf['gm_apikey'];
	$block['gm_latitude']  = $gm_latitude;
	$block['gm_longitude'] = $gm_longitude;
	$block['gm_zoom']      = $gm_zoom;
	$block['gm_height']    = $gm_height;
	$block['gm_timeout']   = $gm_timeout;

	return $block;
}

function b_weblinks_top_edit($options) 
{
	$DIRNAME = empty( $options[0] ) ? basename( dirname( dirname( __FILE__ ) ) ) : $options[0];

	$form  = "<table><tr><td>";
	$form .= "Module Directory: ";
	$form .= "</td><td>";
	$form .= $DIRNAME." ";
	$form .= '<input type="hidden" name="options[0]" value="'. $DIRNAME .'" />'."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_ORDER;
	$form .= "</td><td>";
	$form .= $options[1]." ";
	$form .= '<input type="hidden" name="options[1]" value="'. $options[1] .'" />'."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_DISP;
	$form .= "</td><td>";
	$form .= '<input type="text" name="options[2]" value="'. intval($options[2]) .'" />'."\n";
	$form .= "&nbsp;". _MB_WEBLINKS_LINKS ."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_CHARS;
	$form .= "</td><td>";
	$form .= '<input type="text" name="options[3]" value="'. intval($options[3]) .'" />'."\n";
	$form .= "&nbsp;". _MB_WEBLINKS_LENGTH  ."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_NEWDAYS;
	$form .= "</td><td>";
	$form .= '<input type="text" name="options[4]" value="'. intval($options[4]) .'" />'."\n";
	$form .= "&nbsp;". _MB_WEBLINKS_DAYS ."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_POPULAR;
	$form .= "</td><td>";
	$form .= '<input type="text" name="options[5]" value="'. intval($options[5]) .'" />'."\n";
	$form .= "&nbsp;". _MB_WEBLINKS_HITS ."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_MAX_WIDTH;
	$form .= "</td><td>";
	$form .= '<input type="text" name="options[6]" value="'. intval($options[6]) .'" />'."\n";
	$form .= "&nbsp;". _MB_WEBLINKS_PIXEL ."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_WIDTH_DEFAULT;
	$form .= "</td><td>";
	$form .= '<input type="text" name="options[7]" value="'. intval($options[7]) .'" />'."\n";
	$form .= "&nbsp;". _MB_WEBLINKS_PIXEL ."\n";
	$form .= "</td></tr>\n<tr><td>";

	$form .= _MB_WEBLINKS_GM_MODE;
	$form .= "</td><td>";
	$form .= '<input type="text" name="options[8]" value="'. intval($options[8]) .'" />'."\n";
	$form .= _MB_WEBLINKS_GM_MODE_DSC;
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_GM_LATITUDE;
	$form .= "</td><td>";
	$form .= '<input type="text" name="options[9]" value="'. floatval($options[9]) .'" />'."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_GM_LONGITUDE;
	$form .= "</td><td>";
	$form .= '<input type="text" name="options[10]" value="'. floatval($options[10]) .'" />'."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_GM_ZOOM;
	$form .= "</td><td>";
	$form .= '<input type="text" name="options[11]" value="'. intval($options[11]) .'" />'."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_GM_HEIGHT;
	$form .= "</td><td>";
	$form .= '<input type="text" name="options[12]" value="'. intval($options[12]) .'" />'."\n";
	$form .= _MB_WEBLINKS_PIXEL;
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_GM_TIMEOUT;
	$form .= "</td><td>";
	$form .= '<input type="text" name="options[13]" value="'. intval($options[13]) .'" />'."\n";
	$form .= _MB_WEBLINKS_GM_TIMEOUT_DSC;
	$form .= "</td></tr></table>\n";
	return $form;

}

//---------------------------------------------------------
// $options
// [0] module directory name (weblinks)
// [1] number of display links (5)
// [2] max length of title (30)
//       -1: unlimited, 0: not show
// [3] max length of description (0)
//       0: not show
// [4] days to show new icon (0)
//       when 0, not show
// [5] hits to show popular icon (0)
//       when 0, not show
// [6] max width of banner image (50)
//       when 0, not show
// [7] default width of banner image (50)
//       when 0, use original size
// [8] flag of showing date (0)
// [9] mode of showing url (1)
//      0: singlelink.php, 1: visit.php, 2: url of link
// [10] flag of exclude empty url (1)
//      0: include empty url, 1: exclude empty url 
// [11] category id (0)
// [12] flag of sub categories (1)
//       0: without sub, 1: with sub
// [13] mode (-/recommend/mutual)
// [14] flag of random link (1)
//       0: normal, 1: random
//
// following parameter is valid, when flag of random link is normal
// [15] order (lid/time_update/time_create/hits/rating/title)
// [16] sort  (ASC/DESC)
//
// latest: dirname|10|30|0|7|0|50|50|1|0|0|0|1|-|0|time_update|DESC
// random: dirname|5 |30|0|0|0|50|50|0|1|1|0|1|-|1|lid        |ASC
//
// 2006-11-03 hiro <http://ishinomaki.cc/>
//---------------------------------------------------------

function b_weblinks_generic_show($options) 
{
	include_once XOOPS_ROOT_PATH.'/class/xoopstree.php';

	global $xoopsDB;
	$myts =& MyTextSanitizer::getInstance();

	$CONF_BROKEN = 5;

	$DIRNAME = empty( $options[0] ) ? basename( dirname( dirname( __FILE__ ) ) ) : $options[0];
	$limit          = intval($options[1]);
	$max_title      = intval($options[2]);
	$max_desc       = intval($options[3]);
	$newdays        = intval($options[4]);
	$popular        = intval($options[5]);
	$max_width      = intval($options[6]);
	$width_default  = intval($options[7]);
	$show_date      = intval($options[8]);
	$show_mode_url  = intval($options[9]);
	$flag_url_empty = intval($options[10]);
	$cid            = intval($options[11]);
	$flag_subcat    = intval($options[12]);
	$mode_link      = $options[13];
	$flag_random    = intval($options[14]);
	$order          = $options[15];
	$sort           = $options[16];

	if (($order != 'time_update')&&($order != 'time_create')&&($order != 'hits')&&($order != 'rating')&&($order != 'title'))
	{
		$order = 'lid';
	}

	if ($sort != 'DESC')
	{
		$sort = 'ASC';
	}

	if (($mode_link != 'recommend')&&($mode_link != 'mutual'))
	{
		$mode_link = '';
	}

	$show_title = 1;
	if ($max_title == 0)
	{
		$show_title = 0;
	}

	$table_link     = $xoopsDB->prefix( $DIRNAME."_link" );
	$table_category = $xoopsDB->prefix( $DIRNAME."_category" );
	$table_catlink  = $xoopsDB->prefix( $DIRNAME."_catlink" );

	$block = array();
	$block['dirname']       = $DIRNAME;
	$block['lang_hits']     = _MB_WEBLINKS_HITS;
	$block['lang_rating']   = _MB_WEBLINKS_RATING;
	$block['lang_votes']    = _MB_WEBLINKS_VOTES;
	$block['lang_comments'] = _MB_WEBLINKS_COMMENTS;
	$block['lang_random']   = _MB_WEBLINKS_RANDOM;
	$block['show_title']    = $show_title;
	$block['show_date']     = $show_date;
	$block['show_mode_url'] = $show_mode_url;

	$param = array(
		'order'         => $order,
		'max_title'     => $max_title,
		'max_desc'      => $max_desc,
		'newdays'       => $newdays,
		'popular'       => $popular,
		'max_width'     => $max_width,
		'width_default' => $width_default,
	);

	$sql_link      = "SELECT l.* FROM ".$table_link." l ";
	$sql_catlink   = '';

	$where_link    = "l.broken < ". $CONF_BROKEN ." ";
	$where_catlink = '';
	$where_mode    = '';

// url empty
	if ($flag_url_empty == 1)
	{
		$where_link .= "AND l.url != '' ";
	}

// all categories ( not specify )
	if (($cid == 0)&&($flag_subcat == 1))
	{
		$sql_catlink   = '';
		$where_catlink = '';
	}

// specify category
	else
	{
		$sql_catlink  = $table_catlink." cl ON l.lid=cl.lid ";

// parent category only
		if ($flag_subcat == 0)
		{
			$where_catlink = "cl.cid=".$cid." ";
		}

// parent and all children categories
		else
		{
			$cattree = new XoopsTree($table_category, 'cid', 'pid');
			$cid_array = array();
			$cid_array = $cattree->getAllChildId($cid);

			if (count($cid_array) == 0)
			{
				$cids = $cid;
			}
			else
			{
				array_push($cid_array, $cid);	// with parent
				$cids = implode(',', $cid_array);
			}

			$where_catlink = "cl.cid IN(".$cids.") ";
		}
	}

	if ($mode_link)
	{
		$where_mode = $mode_link."=1 ";
	}

// random mode
	if ( $flag_random )
	{
		$sql_orderby = "rand()";
	}
// normal mode
	elseif ($order != '' && $sort != '')
	{
		$sql_orderby = "l.".$order." ".$sort;
	}

// build sql
	$sql = $sql_link;

	if ( $sql_catlink )
	{
		$sql .= " INNER JOIN ".$sql_catlink;
	}

	$sql .= "WHERE ".$where_link;

	if ( $where_catlink )
	{
		$sql .= " AND ".$where_catlink;
	}

	if ( $where_mode )
	{
		$sql .= " AND ".$where_mode;
	}

	if ( $sql_orderby )
	{
		$sql .= " ORDER BY ".$sql_orderby;
	}

	$result = $xoopsDB->query($sql, $limit);
	if ( !$result ) 
	{
//		echo $xoopsDB->error();
		return $block;
	}

	while ($row = $xoopsDB->fetchArray($result))
	{
		$block['links'][] = b_weblinks_build_link($row, $param);
	}

	return $block;
}

function b_weblinks_generic_edit($options)
{
// BUG 4508: Fatal error: Call to undefined function: weblinks_get_handler()

	global $xoopsDB;

	$DIRNAME = empty( $options[0] ) ? basename( dirname( dirname( __FILE__ ) ) ) : $options[0];
	$WEBLINKS_ROOT_PATH = XOOPS_ROOT_PATH.'/modules/'.$DIRNAME;

	include_once XOOPS_ROOT_PATH.'/class/xoopstree.php';
	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/include/functions.php';
	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/error.php';
	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/strings.php';
	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/system.php';
	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/basic_handler.php';
	include_once $WEBLINKS_ROOT_PATH.'/include/weblinks_constant.php';
	include_once $WEBLINKS_ROOT_PATH.'/include/functions.php';
	include_once $WEBLINKS_ROOT_PATH.'/class/weblinks_config2_basic_handler.php';
	include_once $WEBLINKS_ROOT_PATH.'/class/weblinks_category_basic_handler.php';

// config init before get_handler(category)
	$config_handler =& weblinks_get_handler( 'config2_basic',  $DIRNAME );
	$config_handler->init();

	$category_handler =& weblinks_get_handler( 'category_basic', $DIRNAME );
	$category_handler->load_once();

// show date
	$date_checked_0 = '';
	$date_checked_1 = '';
	if ( intval($options[8]) == 1 )
	{
		$date_checked_1 = 'checked';
	}
	else
	{
		$date_checked_0 = 'checked';
	}

// mode url
	$url_sel_0 = '';
	$url_sel_1 = '';
	$url_sel_2 = '';
	if ( intval($options[9]) == 1 )
	{
		$url_sel_1 = 'selected';
	}
	elseif ( intval($options[9]) == 2 )
	{
		$url_sel_2 = 'selected';
	}
	else
	{
		$url_sel_0 = 'selected';
	}

// url empty
	$empty_checked_0 = '';
	$empty_checked_1 = '';
	if ( intval($options[10]) == 1 )
	{
		$empty_checked_1 = 'checked';
	}
	else
	{
		$empty_checked_0 = 'checked';
	}

// category
	$selbox = $category_handler->build_selbox( intval($options[11]), 1, "options[11]", '', 'TOP' );

// sub category
	$subcat_checked_0 = '';
	$subcat_checked_1 = '';
	if ( intval($options[12]) == 1 )
	{
		$subcat_checked_1 = 'checked';
	}
	else
	{
		$subcat_checked_0 = 'checked';
	}

// mode
	$mode_sel_recommend = '';
	$mode_sel_mutual    = '';
	if ( $options[13] == 'recommend' )
	{
		$mode_sel_recommend = 'selected';
	}
	elseif ( $options[13] == 'mutual' )
	{
		$mode_sel_mutual = 'selected';
	}

// random
	$random_checked_0 = '';
	$random_checked_1 = '';
	if ( intval($options[14]) == 1 )
	{
		$random_checked_1 = 'checked';
	}
	else
	{
		$random_checked_0 = 'checked';
	}

// order
	$order_sel_lid    = '';
	$order_sel_update = '';
	$order_sel_create = '';
	$order_sel_hits   = '';
	$order_sel_rating = '';
	$order_sel_title  = '';
	if ( $options[15] == 'time_update' )
	{
		$order_sel_update = 'selected';
	}
	elseif ( $options[15] == 'time_create' )
	{
		$order_sel_create = 'selected';
	}
	elseif ( $options[15] == 'hits' )
	{
		$order_sel_hits = 'selected';
	}
	elseif ( $options[15] == 'rating' )
	{
		$order_sel_rating = 'selected';
	}
	elseif ( $options[15] == 'title' )
	{
		$order_sel_title = 'selected';
	}
	else
	{
		$order_sel_lid = 'selected';
	}

// sort
	$sort_sel_asc  = '';
	$sort_sel_desc = '';
	if ( $options[16] == 'DESC' )
	{
		$sort_sel_desc = 'selected';
	}
	else
	{
		$sort_sel_asc = 'selected';
	}

	$form  = "<table><tr><td>";
	$form .= "Module Directory ";
	$form .= "</td><td>";
	$form .= $DIRNAME." ";
	$form .= '<input type="hidden" name="options[0]" value="'. $DIRNAME .'" />'."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_DISP;
	$form .= "</td><td>";
	$form .= '<input type="text" name="options[1]" value="'. intval($options[1]) .'" />'."\n";
	$form .= "&nbsp;". _MB_WEBLINKS_LINKS ."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_CHARS;
	$form .= "</td><td>";
	$form .= '<input type="text" name="options[2]" value="'. intval($options[2]) .'" />'."\n";
	$form .= "&nbsp;". _MB_WEBLINKS_LENGTH  ."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_MAX_DESC;
	$form .= "</td><td>";
	$form .= '<input type="text" name="options[3]" value="'. intval($options[3]) .'" />'."\n";
	$form .= "&nbsp;". _MB_WEBLINKS_LENGTH  ."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_NEWDAYS;
	$form .= "</td><td>";
	$form .= '<input type="text" name="options[4]" value="'. intval($options[4]) .'" />'."\n";
	$form .= "&nbsp;". _MB_WEBLINKS_DAYS ."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_POPULAR;
	$form .= "</td><td>";
	$form .= '<input type="text" name="options[5]" value="'. intval($options[5]) .'" />'."\n";
	$form .= "&nbsp;". _MB_WEBLINKS_HITS ."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_MAX_WIDTH;
	$form .= "</td><td>";
	$form .= '<input type="text" name="options[6]" value="'. intval($options[6]) .'" />'."\n";
	$form .= "&nbsp;". _MB_WEBLINKS_PIXEL ."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_WIDTH_DEFAULT;
	$form .= "</td><td>";
	$form .= '<input type="text" name="options[7]" value="'. intval($options[7]) .'" />'."\n";
	$form .= "&nbsp;". _MB_WEBLINKS_PIXEL ."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_SHOW_DATE;
	$form .= "</td><td>";
	$form .= '<input type="radio" name="options[8]" value="1" '. $date_checked_1 .' />'."\n";
	$form .= "&nbsp;". _YES ."\n";
	$form .= '<input type="radio" name="options[8]" value="0" '. $date_checked_0 .' />'."\n";
	$form .= "&nbsp;". _NO ."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_MODE_URL;
	$form .= "</td><td>";
	$form .= '<select name="options[9]">'."\n";
	$form .= '<option value="0" '. $url_sel_0 .'>';
	$form .= _MB_WEBLINKS_MODE_URL_SINGLE;
	$form .= "</option>\n";
	$form .= '<option value="1" '. $url_sel_1 .'>';
	$form .= _MB_WEBLINKS_MODE_URL_VISIT;
	$form .= "</option>\n";
	$form .= '<option value="2" '. $url_sel_2 .'>';
	$form .= _MB_WEBLINKS_MODE_URL_DIRECT;
	$form .= "</option>\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_URL_EMPTY;
	$form .= "</td><td>";
	$form .= '<input type="radio" name="options[10]" value="0" '. $empty_checked_0 .' />'."\n";
	$form .= "&nbsp;". _MB_WEBLINKS_URL_EMPTY_INCLUDE ."\n";
	$form .= '<input type="radio" name="options[10]" value="1" '. $empty_checked_1 .' />'."\n";
	$form .= "&nbsp;". _MB_WEBLINKS_URL_EMPTY_EXCLUDE ."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_CATEGORY;
	$form .= "</td><td>";
	$form .= $selbox;
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_WITH_SUBCAT;
	$form .= "</td><td>";
	$form .= '<input type="radio" name="options[12]" value="1" '. $subcat_checked_1 .' />'."\n";
	$form .= "&nbsp;". _YES ."\n";
	$form .= '<input type="radio" name="options[12]" value="0" '. $subcat_checked_0 .' />'."\n";
	$form .= "&nbsp;". _NO ."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_MODE;
	$form .= "</td><td>";
	$form .= '<select name="options[13]">'."\n";
	$form .= '<option value="-">---</option>'."\n";
	$form .= '<option value="recommend" '. $mode_sel_recommend .'>';
	$form .= _MB_WEBLINKS_RECOMMEND;
	$form .= "</option>\n";
	$form .= '<option value="mutual" '. $mode_sel_mutual .'>';
	$form .= _MB_WEBLINKS_MUTUAL;
	$form .= "</option>\n";
	$form .= "</select>\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_RANDOM;
	$form .= "</td><td>";
	$form .= '<input type="radio" name="options[14]" value="1" '. $random_checked_1 .' />'."\n";
	$form .= "&nbsp;". _YES ."\n";
	$form .= '<input type="radio" name="options[14]" value="0" '. $random_checked_0 .' />'."\n";
	$form .= "&nbsp;". _NO ."\n";
	$form .= "</td></tr>\n<tr><td>";
	$form .= _MB_WEBLINKS_ORDER;
	$form .= "</td><td>";
	$form .= _MB_WEBLINKS_ORDER_DESC ."<br />\n";;
	$form .= '<select size="1" name="options[15]">'."\n";
	$form .= '<option value="lid" '. $order_sel_lid .'>';
	$form .= _MB_WEBLINKS_LINK_ID;
	$form .= "</option>\n";
	$form .= '<option value="time_update" '. $order_sel_update .'>';
	$form .= _MB_WEBLINKS_TIME_UPDATE;
	$form .= "</option>\n";
	$form .= '<option value="time_create" '. $order_sel_create .'>';
	$form .= _MB_WEBLINKS_TIME_CREATE;
	$form .= "</option>\n";
	$form .= '<option value="hits" '. $order_sel_hits .'>';
	$form .= _MB_WEBLINKS_HITS;
	$form .= "</option>\n";
	$form .= '<option value="rating" '. $order_sel_rating .'>';
	$form .= _MB_WEBLINKS_RATING;
	$form .= "</option>\n";
	$form .= '<option value="title" '. $order_sel_title .'>';
	$form .= _MB_WEBLINKS_TITLE;
	$form .= "</option>\n";
	$form .= "</select> \n";
	$form .= '<select size="1" name="options[16]">'."\n";
	$form .= '<option value="ASC" '. $sort_sel_asc .'>';
	$form .= _MB_WEBLINKS_ASC;
	$form .= "</option>\n";
	$form .= '<option value="DESC" '. $sort_sel_desc .'>';
	$form .= _MB_WEBLINKS_DESC;
	$form .= "</option>\n";
	$form .= "</select>\n";
	$form .= "</td></tr></table>\n";

	return $form;
}

//---------------------------------------------------------
// utility
//---------------------------------------------------------
function b_weblinks_build_link($row, $param) 
{
	$myts =& MyTextSanitizer::getInstance();

	$order         = $param['order'];
	$max_title     = $param['max_title'];
	$max_desc      = $param['max_desc'];
	$newdays       = $param['newdays'];
	$popular       = $param['popular'];
	$max_width     = $param['max_width'];
	$width_default = $param['width_default'];

	$show_title   = 1;
	$show_desc    = 0;
	$show_banner  = 0;
	$show_new     = 0;
	$show_update  = 0;
	$show_popular = 0;
	$flag_gm_use  = 0;

	$lid         = $row['lid'];
	$title       = $row['title'];
	$url         = $row['url'];
	$banner      = $row['banner'];
	$width       = $row['width'];
	$height      = $row['height'];
	$hits        = $row['hits'];
	$rating      = $row['rating'];
	$votes       = $row['votes'];
	$comments    = $row['comments'];
	$desc        = $row['description'];
	$dohtml      = $row['dohtml'];
	$dosmiley    = $row['dosmiley'];
	$doxcode     = $row['doxcode'];
	$doimage     = $row['doimage'];
	$dobr        = $row['dobr'];
	$time_create = $row['time_create'];
	$time_update = $row['time_update'];

// google map
	$gm_latitude  = $row['gm_latitude'];
	$gm_longitude = $row['gm_longitude'];
	$gm_zoom      = $row['gm_zoom'];

	if ( (($gm_latitude != 0)||($gm_longitude != 0)||($gm_zoom != 0)) )
	{
		$flag_gm_use = 1;
	}

	$rates = sprintf("%.1f", $rating);

// unlimited when $max_title = -1 
	if ( $max_title == 0)
	{
		$show_title  = 0;
	}
	elseif ( ($max_title > 0) && (strlen( $title ) > $max_title) )
	{
		$title = strip_tags( $title );

// for multibyte environment
		if (function_exists('mb_strcut'))
		{
			$title = mb_strcut( $title, 0, $max_title) . " ...";
		}
		else
		{
			$title = substr( $title, 0, $max_title )." ...";
		}

		$title = $myts->makeTboxData4Show( $title );
	}

// description
	if ( $max_desc > 0 )
	{
		$show_desc = 1;
		$desc = $myts->displayTarea($desc, $dohtml, $dosmiley, $doxcode, $doimage, $dobr);
		$desc = preg_replace("/>/", '> ', $desc);
		$desc = strip_tags( $desc );

// for multibyte environment
		if (function_exists('mb_strcut'))
		{
			$desc = mb_strcut( $desc, 0, $max_desc) . " ...";
		}
		else
		{
			$desc = substr( $desc, 0, $max_desc ) . " ...";
		}

		$desc = $myts->makeTboxData4Show( $desc );
	}

// banner image
	if ( ($max_width > 0) && $banner )
	{
		$show_banner = 1;

		if ($width > $max_width)
		{
			$width = $max_width;
		}

		if (($width == 0) && ($width_default > 0))
		{
			$width = $width_default;
		}
	}

// new & update image
	if ( $newdays > 0)
	{
		$startdate = (time()-(86400 * $newdays));

		if ( $startdate < $time_create ) 
		{
			$show_new = 1;
		}
		elseif ( $startdate < $time_update )
		{
			$show_update = 1;
		}
	}

// popular image
	if ($popular > 0)
	{
		if ( $row['hits'] >= $popular )
		{
			$show_popular = 1;
		}
	}

// old style
	if ($order == "rating")
	{
		$hits = $rates;
	}

	$link = array(
		'id'          => $lid,
		'lid'         => $lid,
		'hits'        => $hits,
		'votes'       => $votes,
		'comments'    => $comments,
		'width'       => $width,
		'url'         => htmlspecialchars($url,    ENT_QUOTES),
		'banner'      => htmlspecialchars($banner, ENT_QUOTES),
		'date'        => formatTimestamp($time_update, 's'),
		'rates'       => $rates,
		'title'       => $title,
		'description' => $desc,
		'show_title'  => $show_title,
		'show_desc'   => $show_desc,
		'show_banner' => $show_banner,
		'show_new'    => $show_new,
		'show_update' => $show_update,
		'show_pop'    => $show_popular,

// google map
		'gm_latitude' => $gm_latitude,
		'gm_longitude'=> $gm_longitude,
		'gm_zoom'     => $gm_zoom,
		'flag_gm_use' => $flag_gm_use,
	);

	return $link;
}

// --- block function begin end ---
}

?>