<?php
// $Id: test_form_user_modify_link.php,v 1.2 2006/12/22 15:17:05 ohwada Exp $

//=========================================================
// WebLinks Module
// 2006-09-20 K.OHWADA
//=========================================================

//---------------------------------------------------------
// test parameter
//---------------------------------------------------------

$LID = 2;
$LID = 483;

//---------------------------------------------------------

include_once 'dev_header.php';
include_once 'test_form_class.php';

$test =& weblinks_test_form::getInstance();

dev_header();
echo "<h3>test form: user modify link</h3>\n";
echo "user: ".$test->get_user_uname()."<br />\n";

$link_url  = WEBLINKS_URL.'/modlink.php';
$list_url  = WEBLINKS_URL.'/admin/link_list.php?sortid=0';

$ret = $test->user_login();
if ( !$ret )
{
	dev_footer();
}

//---------------------------------------------------------
// not permit
//---------------------------------------------------------
echo "<h4>Test of not permit</h4>\n";

$test->update_config_by_name_array( 'auth_modify',      array(1) );
$test->update_config_by_name_array( 'auth_modify_auto', array(1) );

$link_form_url = $link_url.'?lid='.$LID;
$ret = $test->fetch( $link_form_url );
if ( !$ret )
{
	dev_footer();
}

if ( $test->match_result( _NOPERM ) )
{
	echo "<h4>Test OK !</h4>\n";
}
else
{
	echo "Error: test failed to fetch modify form <br />\n";
	$test->print_body( true );
	dev_footer();
}

//---------------------------------------------------------
// permit for registered user
//---------------------------------------------------------
echo "<h4>test of permit for registered user</h4>\n";

$test->update_config_by_name_array( 'auth_modify',      array(1,2) );

$title = 'req_'.$test->get_randum_title();

$ret = $test->user_modify_link( $LID, $title );
if ( !$ret )
{
	dev_footer();
}

if ( $test->match_return_msg( 'modify request link' ) )
{
	echo "<h4>Success !</h4>\n";
	echo "modify link: ".$title." <br /><br />\n";
}
else
{
	echo "Error: modify link form failed: <br />\n";
	$test->print_body( true );
	dev_footer();
}

//---------------------------------------------------------
// permit & approve for owner
//---------------------------------------------------------
echo "<h4>test of permit and approve for owner</h4>\n";

$test->update_config_by_name_array( 'auth_modify',      array(1, WEBLINKS_ID_AUTH_UID) );
$test->update_config_by_name_array( 'auth_modify_auto', array(1, WEBLINKS_ID_AUTH_UID) );

$flag_ok = false;

if ( $test->is_link_owner($LID) )
{
	echo "<b>".$test->get_user_uname()."</b> is owner <br />\n";

	$title = 'mod_'.$test->get_randum_title();

	$ret = $test->user_modify_link( $LID, $title );
	if ( !$ret )
	{
		dev_footer();
	}

	if ( $test->match_return_msg( 'modify approve link' ) )
	{
		$flag_ok = true;
		echo "<h4>Success !</h4>\n";
		echo "modify link: ".$title." <br /><br />\n";
	}
}
else
{
	echo "<b>".$test->get_user_uname()."</b> is not owner <br />\n";

	$link_form_url = $link_url.'?lid='.$LID;
	$ret = $test->fetch( $link_form_url );
	if ( !$ret )
	{
		dev_footer();
	}

	if ( $test->match_result( _NOPERM ) )
	{
		$flag_ok = true;
		echo "<h4>Test OK !</h4>\n";
	}
}

if ( !$flag_ok )
{
	echo "Error: modify link form failed: <br />\n";
	$test->print_body( true );
	dev_footer();
}

echo '<a href="'.$list_url.'" target="_blank" >goto link list</a>'."<br />\n";
dev_footer();
// --- end of main ---

?>