<?php
// $Id: test_form_class.php,v 1.2 2006/12/22 15:17:05 ohwada Exp $

// 2006-12-10 K.OHWADA
// use build_link_record

//=========================================================
// WebLinks Module
// 2006-09-20 K.OHWADA
//=========================================================

//=========================================================
// class weblinks_test_form
//=========================================================
class weblinks_test_form extends weblinks_gen_record
{
	var $_ADMIN_UNAME = 'admin';
	var $_ADMIN_PASS  = 'admin';
	var $_USER_UNAME  = 'tester';
	var $_USER_PASS   = 'tester';

	var $_snoopy;

	var $_user_submit_url;
	var $_user_modify_url;
	var $_admin_link_url;

	var $_flag_print_body = true;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_test_form()
{
	$this->weblinks_gen_record();

	$this->_snoopy   =& new Snoopy();

	$this->_user_submit_url = WEBLINKS_URL.'/submit.php';
	$this->_user_modify_url = WEBLINKS_URL.'/modlink.php';
	$this->_admin_link_url  = WEBLINKS_URL.'/admin/link_manage.php';
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_test_form();
	}
	return $instance;
}

//---------------------------------------------------------
// login
//---------------------------------------------------------
function admin_login()
{
	$ret = $this->login($this->_ADMIN_UNAME, $this->_ADMIN_PASS);
	return $ret;
}

function user_login()
{
	$ret = $this->login($this->_USER_UNAME, $this->_USER_PASS);
	return $ret;
}

function login($uname, $pass)
{
	$url = XOOPS_URL.'/user.php';

	$form = array(
		'uname' => $uname,
		'pass'  => $pass,
		'op'    => 'login',
	);

	$ret = $this->_snoopy->submit($url, $form);
	if ( !$ret )
	{
		echo "Error: cannnot connect login form: $url <br />\n";
		$this->print_body();
		return false;
	}

	$ret = $this->get_cookies();
	return $ret;
}

function get_cookies()
{
	$this->_snoopy->setcookies();
	$cookies = $this->_snoopy->cookies;
	if ( !is_array($cookies) || (count($cookies) == 0) )
	{
		echo "Error: login failed: cannot get cookie <br />\n";
		$this->print_body();
		return false;
	}
	return $cookies;
}

//---------------------------------------------------------
// fetch_form
//---------------------------------------------------------
function fetch($url)
{
	$ret = $this->_snoopy->fetch($url);
	if ( !$ret )
	{
		echo "Error: cannnot fetch : $url <br />\n";
		$this->print_body();
		return false;
	}
	return true;
}

function fetch_form($url)
{
	$this->print_debug( "fetch_form($url)" );

	$ret = $this->_snoopy->fetchform($url);
	if ( !$ret )
	{
		echo "Error: cannnot fetch form: $url <br />\n";
		$this->print_body();
		return false;
	}
	return true;
}

//---------------------------------------------------------
// get ticket
// < input type="hidden" name="XOOPS_G_TICKET" value="e1c3d9c1ece8114441b7ac68e90e429b" />
//---------------------------------------------------------
function get_ticket( $result=null )
{
	$val = $this->get_hidden_value( 'XOOPS_G_TICKET', $result );
	if ( !$val )
	{
		echo "Error: cannot get ticket <br />\n";
		$this->print_body();
		return false;
	}
	return $val;
}

//---------------------------------------------------------
// get_hidden_value
// < input type="hidden" name="lid" id="lid" value="155" />
//---------------------------------------------------------
function get_hidden_value( $name, $result=null )
{
	if (empty($result))
	{
		$result = $this->_snoopy->results;
	}

	$pattern = '<\/?input[\s+]type="hidden"[\s+]name="'.$name.'".*value="(\w+)"[\s+]/>';
	$pattern = "'$pattern'Usi";

	preg_match($pattern, $result, $match);

//print_r($match);
//echo "<br>\n";

	if ( isset($match[1]) && $match[1] )
	{
		$val = $match[1];
		return $val;
	}

	return false;
}

//---------------------------------------------------------
// submit_form
//---------------------------------------------------------
function submit_form($url, $form)
{
	$this->print_debug( "submit_form($url)" );

	$this->_snoopy->referer = $url;

	$ret = $this->_snoopy->submit($url, $form);
	if ( !$ret )
	{
		echo "Error: cannnot submit form: $url <br />\n";
		$this->print_body();
		return false;
	}
	return true;
}

//---------------------------------------------------------
// get_results
//---------------------------------------------------------
function get_results()
{
	return $this->_snoopy->results;
}

function get_body( $result=null )
{
	if (empty($result))
	{
		$result = $this->_snoopy->results;
	}

	$str = eregi_replace("^.*<body[^>]*>", "", $result);
	$str = eregi_replace("</body>.*$",     "", $str);
	return $str;
}

function print_body( $flag_print=false, $result=null )
{
	if ( $flag_print || $this->_flag_print_body )
	{
		echo "<hr />\n";
		echo $this->get_body( $result );
		echo "<hr />\n";
	}
}

function match_result($str, $result=null)
{
	if (empty($result))
	{
		$result = $this->_snoopy->results;
	}

	if ( preg_match( "/".$str."/", $result ) )
	{
		return true;
	}
	return false;
}

function match_return_msg($str, $result=null)
{
	if (empty($result))
	{
		$result = $this->_snoopy->results;
	}

	preg_match( "/<!-- weblinks : (.*?) -->/", $result, $match );

	if ( isset($match[1]) && ( $match[1] == $str ) )
	{
		return true;
	}
	return false;
}

//---------------------------------------------------------
// set param
//---------------------------------------------------------
function set_admin_uname_pass( $uname, $pass )
{
	$this->_ADMIN_UNAME = $uname;
	$this->_ADMIN_PASS  = $pass;
}

function set_user_uname_pass( $uname, $pass )
{
	$this->_USER_UNAME = $uanme;
	$this->_USER_PASS  = $pass;
}

function get_admin_uname()
{
	return $this->_ADMIN_UNAME;
}

function get_user_uname()
{
	return $this->_USER_UNAME;
}

//---------------------------------------------------------
// user submit
//---------------------------------------------------------
function user_submit_link( $title )
{
	$banner   = $this->get_randum_banner( 0 );
	$rss_url  = WEBLINKS_URL.'/dev/rss_2.xml';
	$rss_flag = 2;	// rss

	$ret = $this->fetch_form($this->_user_submit_url);
	if ( !$ret )
	{
		return false;
	}

	$form = $this->build_link_form($this->_USER_UNAME, $title, $banner, $rss_flag, $rss_url);

	$ret = $this->submit_form($this->_user_submit_url, $form);
	if ( !$ret )
	{
		return false;
	}

	return true;
}

//---------------------------------------------------------
// user modify
//---------------------------------------------------------
function user_modify_link( $lid, $title )
{
	$banner   = $this->get_randum_banner( 0 );
	$rss_url  = WEBLINKS_URL.'/dev/rss_3.xml';
	$rss_flag = 2;	// rss

	$link_form_url = $this->_user_modify_url.'?lid='.$lid;
	$ret = $this->fetch_form($link_form_url);
	if ( !$ret )
	{
		return false;
	}

	$form = $this->build_link_form($this->_USER_UNAME, $title, $banner, $rss_flag, $rss_url, $lid);
	$this->print_debug($form);

	$ret = $this->submit_form($this->_user_modify_url, $form);
	if ( !$ret )
	{
		return false;
	}

	return true;
}

function is_link_owner($lid, $uname=null)
{
	$link_uid = 0;
	$row =& $this->get_link($lid);
	if ( is_array($row) && isset($row['uid']) )
	{
		$link_uid = $row['uid'];
	}

	if ( empty($uname) )
	{
		$uname = $this->_USER_UNAME;
	}

	$user =& $this->_system->get_user_by_uname( $uname );
	$uname_uid = $user['uid'];

	if ( $link_uid && ( $link_uid == $uname_uid ) )
	{
		return true;
	}
	return false;
}

//---------------------------------------------------------
// admin add link
//---------------------------------------------------------
function admin_add_link_add_link($title, $banner, $rss_flag, $rss_url)
{
	$lid = 0;

	$ret = $this->fetch_form($this->_admin_link_url);
	if ( !$ret )
	{
		return false;
	}

	$form =& $this->build_link_form($this->_ADMIN_UNAME, $title, $banner, $rss_flag, $rss_url, $lid);

	$ret = $this->submit_form($this->_admin_link_url, $form);
	if ( !$ret )
	{
		return false;
	}

	return true;
}

function &build_link_form($name, $title, $banner, $rss_flag, $rss_url, $lid)
{
	$flag_uid      = 0;	// system param
	$mode_dhtml    = 1;	// all 1
	$flag_rssc_lid = 0;	// not update

	$arr =& $this->build_link_record( $title, $flag_uid, $mode_dhtml, $flag_rssc_lid );

    $arr['submit']         = 'submit';
    $arr['op']             = 'add_table';
	$arr['request']        = 1;
    $arr['XOOPS_G_TICKET'] = $this->get_ticket();

    $arr['passwd_new'] = $arr['passwd'];
    $arr['passwd_2']   = $arr['passwd'];
    $arr['lid']        = $lid;
    $arr['banner']     = $banner;
    $arr['rss_url']    = $rss_url;
    $arr['rss_flag']   = $rss_flag;

	return $arr;
}

function admin_add_link_add_banner($title, $banner='', $rss_flag=0, $rss_url='')
{
	$url    = "http://$title/";
	$width  = $this->_WIDTH;
	$height = $this->_HEIGHT;

	$ticket = $this->get_ticket();
	$lid    = $this->get_hidden_value( 'lid' );
	if ( !$lid )
	{
		echo "Error: cannot get lid <br />\n";
		echo $this->get_body() ."<br /><br />\n";
		return false;
	}

	$link_form = array(
   		'XOOPS_G_TICKET' => $ticket,
    	'op'       => 'add_banner',
    	'op_mode'  => 'add_banner',
    	'lid'      => $lid,
    	'title'    => $title,
    	'url'      => $url,
     	'banner'   => $banner,
    	'rss_url'  => $rss_url,
    	'rss_flag' => $rss_flag,
    	'width'    => $width,
		'height'   => $height,
	);

	$ret = $this->submit_form($this->_admin_link_url, $link_form);
	if ( !$ret )
	{
		return false;
	}

	return true;
}

function admin_add_link_add_rssc($title, $rss_flag=0, $rss_url='', $rssc_lid=0)
{
	$url      = "http://$title/";
	$rdf_url  = '';
	$atom_url = '';

	$ticket   = $this->get_ticket();
	$link_lid = $this->get_hidden_value( 'link_lid' );
	if ( !$link_lid )
	{
		echo "Error: cannot get lid <br />\n";
		echo $this->get_body() ."<br /><br />\n";
		return false;
	}

	$link_form_rssc = array(
		'XOOPS_G_TICKET' => $ticket,
		'op'           => 'add_rssc',
		'op_mode'      => 'add_link',
		'link_lid'     => $link_lid,
		'rssc_lid'     => $rssc_lid,
		'title'        => $title,
		'url'          => $url,
		'rdf_url'      => $rdf_url,
		'atom_url'     => $atom_url,
		'rss_url'      => $rss_url,
		'show_rss_url' => $rss_url,
		'rss_flag'     => $rss_flag,
	);

	$ret = $this->submit_form($this->_admin_link_url, $link_form_rssc);
	if ( !$ret )
	{
		return false;
	}

	$ticket   = $this->get_ticket();
	$rssc_lid = $this->get_hidden_value( 'rssc_lid' );
	if ( !$rssc_lid )
	{
		echo "Error: cannot get rssc_lid <br />\n";
		echo $this->get_body() ."<br /><br />\n";
		return false;
	}

	$link_form_refresh = array(
		'XOOPS_G_TICKET' => $ticket,
		'op'           => 'refresh_link',
		'op_mode'      => 'add_link',
		'rssc_lid'     => $rssc_lid,
	);

	$ret = $this->submit_form($this->_admin_link_url, $link_form_refresh);
	if ( !$ret )
	{
		return false;
	}

	return true;
}

// --- class end ---
}

?>