<?php
// $Id: happy_search_module_handler.php,v 1.1.1.1 2006/12/01 12:19:23 ohwada Exp $

//=========================================================
// Happy Search
// this file contain 2 class
//   happy_search_module 
//   happy_search_module_handler
// 2006-11-11 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('happy_search_module_handler') ) 
{

//=========================================================
// class happy_search_module
//=========================================================
class happy_search_module extends happy_linux_object
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_search_module()
{
	$this->happy_linux_object();

	$this->initVar('mid',     XOBJ_DTYPE_INT, 0, false);
	$this->initVar('notshow', XOBJ_DTYPE_INT, 0, false);
}

// --- class end ---
}

//=========================================================
// class happy_search_module_handler
//=========================================================
class happy_search_module_handler extends happy_linux_object_handler
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_search_module_handler( $dirname )
{
	$this->happy_linux_object_handler( $dirname, 'module', 'mid', 'happy_search_module' );

	$this->set_debug_db_sql(   HAPPY_SEARCH_DEBUG_SQL );
	$this->set_debug_db_error( HAPPY_SEARCH_DEBUG_ERROR );
}


//---------------------------------------------------------
// basic function
//---------------------------------------------------------
function _build_insert_sql(&$obj)
{
	foreach ($obj->gets() as $k => $v) 
	{	${$k} = $v;	}

	$notshow = empty($notshow) ? 0 : 1;

	$sql  = 'INSERT INTO '. $this->_table .' (';
	$sql .= 'mid, ';
	$sql .= 'notshow ';
	$sql .= ') VALUES ( ';
	$sql .= intval($mid) .', ';
	$sql .= $notshow .' ';
	$sql .= ')';

	return $sql;
}

function _build_update_sql(&$obj)
{
	foreach ($obj->gets() as $k => $v) 
	{	${$k} = $v;	}

	$notshow = empty($notshow) ? 0 : 1;

	$sql = 'UPDATE '. $this->_table .' SET ';
	$sql .= 'notshow='. $notshow. ' ';
	$sql .= 'WHERE mid='. intval($mid);

	return $sql;
}

//---------------------------------------------------------
// update
//---------------------------------------------------------
function update_by_mid_notshow($mid, $notshow)
{
	$count = $this->get_count_by_mid($mid);
	if ( $count > 0 )
	{
		$obj =& $this->get($mid);
		$obj->setVar('notshow', $notshow);
		$this->update($obj);
	}
	else
	{
		$obj =& $this->create();
		$obj->setVar('mid',     $mid);
		$obj->setVar('notshow', $notshow);
		$this->insert($obj);
	}
}

//---------------------------------------------------------
// get count
//---------------------------------------------------------
function get_count_by_mid($mid)
{
	$criteria = new CriteriaCompo();
	$criteria->add( new criteria('mid', $mid, '=') );
	$ret = $this->getCount($criteria);
	return $ret;
}

//---------------------------------------------------------
// get list
//---------------------------------------------------------
function &get_list_notshow()
{
	$criteria = new CriteriaCompo();
	$criteria->add( new criteria('notshow', 0, '!=') );
	$ret =& $this->getList($criteria);
	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>