<?php
// $Id: topten.php,v 1.8 2006/10/05 11:06:13 ohwada Exp $

// 2006-10-01 K.OHWADA
// use happy_linux

// 2006-05-15 K.OHWADA
// add class weblinks_topten()
// use new handler

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//================================================================
// WebLinks Module
// view top ten
// 2004/01/23 K.OHWADA
//================================================================

include "header.php";

$weblinks_template =& weblinks_template::getInstance( WEBLINKS_DIRNAME );
$weblinks_topten   =& new weblinks_topten();

// --- template start ---
// xoopsOption[template_main] should be defined before including header.php
$xoopsOption['template_main'] = $weblinks_topten->get_template_name();
include XOOPS_ROOT_PATH.'/header.php';

$weblinks_topten->set_highlight( true );
$weblinks_topten->set_keyword_by_request();
$keywords = $weblinks_topten->get_keywords_urlencode();

//generates top 10 charts by rating and hits for each main category
$weblinks_template->set_keywords_urlencode( $keywords );
$weblinks_template->assignIndex();
$weblinks_template->assignHeader();
$weblinks_template->assignDisplayLink();

$weblinks_topten->get_get_rate();
$topten_title = $weblinks_topten->get_topten_title();
$sort_name    = $weblinks_topten->get_sort_name();
list($links, $rankings) = $weblinks_topten->get_rankings();
$topten_error = $weblinks_topten->get_error();

$template_links_list = $weblinks_template->fetch_links_list( $links );

$i = 0;
$template_rankings = array();
foreach ($rankings as $rank)
{
	$template_rankings[$i]['cid']   = $rank['cid'];
	$template_rankings[$i]['title'] = $rank['title'];
	$template_rankings[$i]['links_list'] = $weblinks_template->fetch_links_list( $rank['links'] );
	$i ++;
}

$xoopsTpl->assign('keywords',            $keywords);
$xoopsTpl->assign('lang_topten_title',   $topten_title);
$xoopsTpl->assign('lang_sortby',         $sort_name);
$xoopsTpl->assign('lang_topten_error',   $topten_error);
$xoopsTpl->assign('weblinks_links_list', $template_links_list);
$xoopsTpl->assign('rankings',            $template_rankings);

include XOOPS_ROOT_PATH.'/footer.php';
exit();
// --- main end ---


//=========================================================
// class weblinks_topten
//=========================================================
class weblinks_topten
{
	var $_link_view_handler;
	var $_category_handler;
	var $_template;
	var $_post;

	var $_conf_topten_style;
	var $_conf_topten_cats;
	var $_conf_topten_links;

	var $_title;
	var $_sort_name;
	var $_sort_db;
	var $_error = '';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_topten()
{
	$config_basic_handler     =& weblinks_get_handler( 'config2_basic', WEBLINKS_DIRNAME );
	$this->_link_view_handler =& weblinks_get_handler( 'link_view',     WEBLINKS_DIRNAME );
	$this->_category_handler  =& weblinks_get_handler( 'category',      WEBLINKS_DIRNAME );

	$this->_template  =& weblinks_template::getInstance( WEBLINKS_DIRNAME );
	$this->_post      =& happy_linux_post::getInstance();

	$conf = $config_basic_handler->get_conf();
	$this->_conf_topten_style  = $conf['topten_style'];
	$this->_conf_topten_cats   = $conf['topten_cats'];
	$this->_conf_topten_links  = $conf['topten_links'];
}

//---------------------------------------------------------
// get_template_name
//---------------------------------------------------------
function get_template_name()
{
	if ( $this->_conf_topten_style )
	{
		$template = WEBLINKS_DIRNAME."_topten_mixed.html";
	}
	else
	{
		$template = WEBLINKS_DIRNAME."_topten.html";
	}

	return $template;
}

//---------------------------------------------------------
// get GET & POST
//---------------------------------------------------------
function get_get_rate()
{
	$rate = $this->_post->get_get_int('rate');

	if( $rate == 1 )
	{
		$this->_title     = _WLS_SITE_HIGHRATE;
		$this->_sort_name = _WLS_RATING;
		$this->_sort_db   = "rating";
	}
	else
	{
		$this->_title     = _WLS_SITE_POPULAR;
		$this->_sort_name = _WLS_HITS;
		$this->_sort_db   = "hits";
	}

}

function get_topten_title()
{
	$title = sprintf(_WLS_TOPTEN_TITLE, $this->_title, $this->_conf_topten_links );
	return $title;
}

function get_sort_name()
{
	return $this->_sort_name;
}

//---------------------------------------------------------
// get_rankings
//---------------------------------------------------------
function get_rankings()
{
	$links_list   = array();
	$rankings     = array();

	if ( $this->_conf_topten_style )
	{
		$links_list =& $this->_get_rankings_mixed();
	}
	else
	{
		$rankings =& $this->_get_rankings_each();
	}

	return array($links_list, $rankings);
}

function &_get_rankings_each()
{
	$i = 0;
	$rank_arr = array();

	$this->_category_handler->load();
	$cid_arr = $this->_category_handler->get_cid_array_by_pid(0);

	if ( count($cid_arr) > $this->_conf_topten_cats )
	{
		$this->_error = sprintf(_WLS_TOPTEN_ERROR, $this->_conf_topten_cats);
	}

	$orderby = $this->_sort_db.' DESC';

	foreach ($cid_arr as $cid)
	{
		$cat_obj =& $this->_category_handler->get($cid);
		$ctitle_s = $cat_obj->getVar('title', 's');

// get all child cat ids for a given cat id
		$links =& $this->_link_view_handler->get_link_parent_child_list_by_cid_orderby($cid, $orderby, $this->_conf_topten_links);

		$rank_arr[$i]['cid']   = $cid;
		$rank_arr[$i]['title'] = sprintf(_WLS_TOPTEN_TITLE, $ctitle_s, $this->_conf_topten_links);
		$rank_arr[$i]['links'] = $links;

		$i++;
		if ($i >= $this->_conf_topten_cats ) break;
	}

	return $rank_arr;
}

function &_get_rankings_mixed()
{
	$orderby = $this->_sort_db.' DESC';
	$this->_link_view_handler->init();
	$links =& $this->_link_view_handler->get_link_list_orderby($orderby, $this->_conf_topten_links);
	return $links;
}

function get_error()
{
	return $this->_error;
}

//---------------------------------------------------------
// set keyword property
//---------------------------------------------------------
function set_highlight($value)
{
	$this->_link_view_handler->set_highlight($value);
}

function set_keyword_by_request()
{
	$this->_link_view_handler->set_keyword_by_request();
}

function get_keywords_urlencode()
{
	return $this->_link_view_handler->get_keywords_urlencode();
}

// --- class end ---
}

?>