<?php
// $Id: search.php,v 1.10 2006/10/14 13:45:12 ohwada Exp $

// 2006-10-14 K.OHWADA
// show google search
// search with category, mark
// search in rssc
// show execution time

// 2006-10-01 K.OHWADA
// use happy_linux
// fazzy search

// 2006-07-23 K.OHWADA
// BUG 4153: not show catpath in search

// 2006-05-15 K.OHWADA
// add class weblinks_search()
// use class weblinks_pagenavi
// use new handler

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//================================================================
// WebLinks Module
// search
// porting from system
// 2004/01/14 K.OHWADA
//================================================================

include 'header.php';


//=========================================================
// class weblinks_search
//=========================================================
class weblinks_search extends happy_linux_search
{
	var $_link_view_handler;
	var $_rssc_handler;
	var $_pagenavi;

// config
	var $_conf;

	var $_link_query_array;
	var $_link_where;
	var $_feed_where;
	var $_start = 0;
	var $_cid = 0;
	var $_cid_arr = array();
	var $_subcat = 0;

	var $_orderby = 'time_update DESC';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_search()
{
	$this->happy_linux_search();
	$this->set_lang_zenkaku(_HAPPY_LINUX_ZENKAKU);
	$this->set_lang_hankaku(_HAPPY_LINUX_HANKAKU);

	$this->_link_view_handler =& weblinks_get_handler( 'link_view',     WEBLINKS_DIRNAME );
	$this->_rssc_handler      =& weblinks_get_handler( 'rssc',          WEBLINKS_DIRNAME );
	$config_handler           =& weblinks_get_handler( 'config2_basic', WEBLINKS_DIRNAME );

	$this->_pagenavi =& happy_linux_pagenavi::getInstance();

	$this->_conf = $config_handler->get_conf();

	$this->set_min_keyword( $this->_conf['search_min'] );
}

//---------------------------------------------------------
// get $_POST & $_GET
//---------------------------------------------------------
function get_post_get_mark()
{
	$mark = $this->_post->get_post_get_text('mark');
	return $mark;
}

function get_post_get_cid()
{
	$this->_cid = $this->_post->get_post_get_int('cid');
	return $this->_cid;
}

function get_post_get_subcat()
{
	$this->_subcat = $this->_post->get_post_get_int('subcat');
	return $this->_subcat;
}

//---------------------------------------------------------
// get param
//---------------------------------------------------------
function get_conf_search_min()
{
	return $this->_conf['search_min'];
}

function get_conf_google_server()
{
	return $this->_conf['google_server'];
}

//---------------------------------------------------------
// link handler
//---------------------------------------------------------
function get_link_total()
{
	$code = $this->check_build_sql_query_array();
	switch ($code)
	{
		case HAPPY_LINUX_SEARCH_CODE_SQL_NO_CAN:
		case HAPPY_LINUX_SEARCH_CODE_SQL_MERGE:
			$this->_build_sql_search($this->_sql_query_array, null, $this->_sql_andor);
			$this->_link_query_array = $this->_sql_query_array;
			break;

		case HAPPY_LINUX_SEARCH_CODE_SQL_CAN:
			$this->_build_sql_search($this->_query_array, $this->_candidate_keyword_array, $this->_mode_andor);
			$this->_link_query_array = $this->_query_array;
			break;
	}

	$this->_total = $this->_get_link_count();
	return $this->_total;
}

function get_link_list()
{
	$navi = '';

	$search_links = $this->_conf['search_links'];
	$this->_pagenavi->setPerpage( $search_links );
	$this->_pagenavi->setTotal(   $this->_total );

	$this->_pagenavi->getGetPage();
	$start = $this->_pagenavi->calcStart();
	$this->_start = $start;

	$this->_link_view_handler->set_keyword_array( $this->_merged_query_array );

// BUG: not show catpath in search
	$this->_link_view_handler->init();
	$link_list =& $this->_get_link_list($search_links, $start);

// next page
	if ( $this->_total > $search_links )
	{
		$script = $this->_build_script();
		$navi   = $this->_pagenavi->build($script);
	}

	return array($link_list, $navi);
}

function _build_script()
{
	$script  = WEBLINKS_URL.'/search.php?query=';
	$script .= $this->get_query_urlencode();
	$script .= '&amp;action=results&amp;andor=';
	$script .= $this->get_andor();
	return $script;
}

function _build_sql_search($query_array1, $query_array2=null, $andor='AND')
{
	$where  = '';
	$where1 = '';

	$cid = $this->get_post_get_cid();
	$mark = $this->get_post_get_mark();
	$where_single = $this->build_single_double_where('search', $query_array1, $query_array2, $andor);

	if ( $cid )
	{
		$where_single_2 = $this->build_single_double_where('l.search', $query_array1, $query_array2, $andor);
		if ( $where_single_2 )
		{
			$where .= $where_single_2;
		}

		if ( $mark )
		{
			if ( $where )
			{
				$where .= ' AND ';
			}

			$where .= 'l.'.$mark.'=1';
		}
	}
	else
	{
		$where .= 'broken < '.$this->_conf['broken_threshold'].' ';

		if ( $where_single )
		{
			$where .= ' AND '.$where_single;
		}

		if ( $mark )
		{
			$where .= ' AND '.$mark.'=1';
		}
	}

	$this->_link_where = $where;
	$this->_feed_where = $where_single;
}

function _get_link_count()
{
	if ( $this->_cid )
	{
		$subcat = $this->get_post_get_subcat();
		if ($subcat)
		{
			$this->_cid_arr =& $this->_link_view_handler->get_cid_array_patent_children( $this->_cid );
		}
		else
		{
			$this->_cid_arr = array( $this->_cid );
		}

		$lid_arr = $this->_link_view_handler->_link_catlink_handler->get_lid_array_by_cid_array_orderby_where($this->_cid_arr, $this->_orderby, $this->_link_where);
		$total = count($lid_arr);
	}
	else
	{
		$total = $this->_link_view_handler->get_count_by_where( $this->_link_where );
	}

	return $total;
}

function &_get_link_list($limit, $start)
{
	if ( $this->_cid )
	{
		$lid_arr = $this->_link_view_handler->_link_catlink_handler->get_lid_array_by_cid_array_orderby_where($this->_cid_arr, $this->_orderby, $this->_link_where, $limit, $start);
		$link_list =& $this->_link_view_handler->get_link_list_by_lid_array($lid_arr);
	}
	else
	{
		$link_list =& $this->_link_view_handler->get_link_list_by_where($this->_link_where, $limit, $start);
	}

	return $link_list;
}

//---------------------------------------------------------
// category handler
//---------------------------------------------------------
function build_selbox()
{
	$cid = $this->get_post_get_cid();
	$this->_link_view_handler->init();
	$selbox = $this->_link_view_handler->build_selbox( $cid );
	return $selbox;
}

//---------------------------------------------------------
// rssc handler
//---------------------------------------------------------
function get_feed_count()
{
	$count = $this->_rssc_handler->get_feed_count_by_where( $this->_feed_where );
	return $count;
}

function &get_feeds()
{
	$this->_rssc_handler->set_feed_max_summary( $this->_conf['rss_max_summary'] );

	$feeds =& $this->_rssc_handler->get_feeds_by_where( $this->_feed_where, $this->_sql_query_array, $this->_conf['search_links'], $this->_start );
	return $feeds;
}

//---------------------------------------------------------
// set keyword property
//---------------------------------------------------------
function set_view_highlight($value)
{
	$this->_link_view_handler->set_highlight($value);
}

//--------------------------------------------------------
// time
//--------------------------------------------------------
function start_measure_time()
{
	$this->_strings->start_measure_time();
}

function get_measure_time()
{
	$time = $this->_strings->get_measure_time();
	$time = sprintf("%6.3f", $time);
	return $time;
}

// --- class end ---
}


//================================================================
// main
//================================================================

$weblinks_template =& weblinks_template::getInstance( WEBLINKS_DIRNAME );
$weblinks_search   =& new weblinks_search();
$weblinks_search->start_measure_time();

// --- template start ---
// xoopsOption[template_main] should be defined before including header.php
$xoopsOption['template_main'] = WEBLINKS_DIRNAME."_search.html";
include XOOPS_ROOT_PATH.'/header.php';

// config
$conf_search_min = $weblinks_search->get_conf_search_min();

// not use extract
$action = $weblinks_search->get_post_get_action();
$query  = $weblinks_search->get_post_get_query();
$andor  = $weblinks_search->get_post_get_andor();
$mark   = $weblinks_search->get_post_get_mark();
$subcat = $weblinks_search->get_post_get_subcat();

$weblinks_template->assignIndex();
$weblinks_template->assignHeader();
$weblinks_template->assignDisplayLink();

// search form
$selbox = $weblinks_search->build_selbox();
$weblinks_template->assignSearch( $selbox, $subcat, $mark, $query, $andor );
$xoopsTpl->assign('lang_atomfeed', _WLS_ATOMFEED);

if ($action == 'search')
{
	$xoopsTpl->assign('search_show', 0);
	$xoopsTpl->assign('search_not_show_result', '');

	include XOOPS_ROOT_PATH."/footer.php";
	exit();
}

// if no query
// REQ 2933: easy to understand error message
if ( $query == '' ) 
{
	$xoopsTpl->assign('search_show', 0);
	$xoopsTpl->assign('search_not_show_result', _SR_PLZENTER);

	include XOOPS_ROOT_PATH."/footer.php";
	exit();
}

$ret = $weblinks_search->parse_query();

// if no query
// REQ 2933: easy to understand error message
if ( !$ret ) 
{
	$xoopsTpl->assign('search_show', 0);
	$xoopsTpl->assign('search_not_show_result', sprintf(_SR_KEYTOOSHORT, $conf_search_min));

	include XOOPS_ROOT_PATH."/footer.php";
	exit();
}

$merged_urlencode = $weblinks_search->get_merged_urlencode();
$weblinks_template->set_keywords_urlencode( $merged_urlencode );

$xoopsTpl->assign('search_show', 1);

$xoopsTpl->assign('search_keywords',             $weblinks_search->get_query_array() );
$xoopsTpl->assign('search_ignores',              $weblinks_search->get_ignore_array() );
$xoopsTpl->assign('search_candidates',           $weblinks_search->get_candidate_array() );
$xoopsTpl->assign('search_show_ignore',          $weblinks_search->get_count_ignore_array() );
$xoopsTpl->assign('search_show_candidate',       $weblinks_search->get_count_candidate_array() );
$xoopsTpl->assign('search_query_utf8_urlencode', $weblinks_search->get_query_utf8_urlencode() );
$xoopsTpl->assign('search_merged_urlencode',     $merged_urlencode );

$weblinks_search->set_view_highlight( true );

$total = $weblinks_search->get_link_total();

if ($total > 0)
{
	list($links, $navi) = $weblinks_search->get_link_list();
	$links_list = $weblinks_template->fetch_links_list( $links );

	$xoopsTpl->assign('search_found_show', 1);
	$xoopsTpl->assign('search_found', sprintf(_SR_FOUND, $total));
	$xoopsTpl->assign('weblinks_links_list', $links_list);
	$xoopsTpl->assign('page_navi', $navi);
}
else
{
// no match data
	$xoopsTpl->assign('search_found_show', 0);
	$xoopsTpl->assign('search_not_found_result', _SR_NOMATCH);	
}

// --- rss feed ---
$feed_show   = 0;
$feed_found  = '';
$feed_reason = '';

if ( WEBLINKS_RSSC_USE )
{
	$count = $weblinks_search->get_feed_count();

	if ($count > 0) 
	{
		$feed_show  = 1;
		$feed_found = sprintf(_SR_FOUND, $count);
		$feeds =& $weblinks_search->get_feeds();

		foreach ($feeds as $feed) 
		{
			$xoopsTpl->append('feeds', $feed);
		}
	}
	else
	{
		$feed_show = 2;
		$feed_reason = _SR_NOMATCH;
	}
}

$xoopsTpl->assign('feed_show',   $feed_show);
$xoopsTpl->assign('feed_found',  $feed_found);
$xoopsTpl->assign('feed_reason', $feed_reason);

$xoopsTpl->assign('execution_time', $weblinks_search->get_measure_time() );

include XOOPS_ROOT_PATH."/footer.php";
exit();
// --- main end ---

?>