<?php
// $Id: gm_get_location.php,v 1.5 2006/11/06 14:28:05 ohwada Exp $

// 2006-11-04 wye & K.OHWADA
// google map: inverse Geocoder
// google map: inline mode

// 2006-10-15 wye & K.OHWADA
// BUG 4313: in some enviroment, character code is judged by mistake.

//================================================================
// WebLinks Module
// 2006-10-01 wye <http://never-ever.info/>
//================================================================

//---------------------------------------------------------
// myself:     gm_get_location.php
// new window: gm_get_location.php?mode=opener
// inline:     gm_get_location.php?mode=parent
//---------------------------------------------------------

include "header.php";

$config_handler =& weblinks_get_handler( 'config2_basic', WEBLINKS_DIRNAME );
$post           =& happy_linux_post::getInstance();

$mode = $post->get_get_text('mode');
$conf = $config_handler->get_conf();

global $xoopsConfig;

$flag_inv_geo = false;
if ( $xoopsConfig['language'] == 'japanese' )
{
	$flag_inv_geo = true;
}

//---------------------------------------------------------
// Google Map Configurations
//---------------------------------------------------------
$gm_lang              = _LANGCODE;
$gm_apikey            = $conf['gm_apikey'];
$gm_server            = $conf['gm_server'];
$gm_default_latitude  = $conf['gm_latitude'];
$gm_default_longitude = $conf['gm_longitude'];
$gm_default_zoom      = $conf['gm_zoom'];
$gm_default_location  = happy_linux_convert_to_utf8( $conf['gm_location'] );

$gm_version = '2';
//---------------------------------------------------------

$gm_url = $gm_server.'maps?file=api&amp;hl='.$gm_lang.'&amp;v='.$gm_version.'&amp;key='.$gm_apikey;
$gm_lang_location = _WEBLINKS_GM_LATITUDE.': #lat# / '._WEBLINKS_GM_LONGITUDE.': #lng# / '._WEBLINKS_GM_ZOOM.': #zoom#';
$gm_lang_default_location = _WEBLINKS_GM_LATITUDE.': '.$gm_default_latitude.' / '._WEBLINKS_GM_LONGITUDE.': '.$gm_default_longitude.' / '._WEBLINKS_GM_ZOOM.': '.$gm_default_zoom;

$gm_lang_location         = happy_linux_convert_to_utf8( $gm_lang_location );
$gm_lang_default_location = happy_linux_convert_to_utf8( $gm_lang_default_location );

$lang_title            = happy_linux_convert_to_utf8( _WEBLINKS_GM_GET_LOCATION );
$lang_get_latitude     = happy_linux_convert_to_utf8( _WEBLINKS_GM_GET_LATITUDE );
$lang_get_addr         = happy_linux_convert_to_utf8( _WEBLINKS_GM_GET_ADDR );
$lang_default_location = happy_linux_convert_to_utf8( _WEBLINKS_GM_DEFAULT_LOCATION );
$lang_current_location = happy_linux_convert_to_utf8( _WEBLINKS_GM_CURRENT_LOCATION );
$lang_not_compatible   = happy_linux_convert_to_utf8( _WEBLINKS_GM_NOT_COMPATIBLE );
$lang_off              = happy_linux_convert_to_utf8( _WEBLINKS_GM_DISP_OFF );
$lang_js_invalid       = happy_linux_convert_to_utf8( _WEBLINKS_JAVASCRIPT_INVALID );
$lang_close            = happy_linux_convert_to_utf8( _CLOSE );

// BUG 4313: in some enviroment, character code is judged by mistake.
happy_linux_http_output('pass');
header ('Content-Type:text/html; charset=UTF-8');

echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">'."\n";

if ($gm_apikey)
{
// --- raw HTML begin ---
?>
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml">
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Cache-Control" content="no-cache">
<meta http-equiv="Expires" content="Thu, 01 Dec 1994 16:00:00 GMT">
<title>weblinks - <?php echo $lang_title; ?></title>
<script src="<?php echo $gm_url; ?>" type="text/javascript" charset="UTF-8"></script>

<script type="text/javascript">
//<![CDATA[
var opener_mode = "<?php echo $mode; ?>";
var gm_default_location = "<?php echo $gm_default_location; ?>";
var gm_default_latitude = <?php echo $gm_default_latitude; ?>;
var gm_default_longitude = <?php echo $gm_default_longitude; ?>;
var gm_default_zoom = <?php echo $gm_default_zoom; ?>;
var gm_lang_location = "<?php echo $gm_lang_location; ?>";
var centermarker, Dmarker;

// inverse Geocoder
var flag_inv_geo = "<?php echo $flag_inv_geo; ?>";
var address_html = '';
var pref_html    = '';
var city_html    = '';
var town_html    = '';
var number_html  = '';

function load() 
{
	if ( GBrowserIsCompatible() )
	{
		showGmap();
	}
	else
	{
		document.getElementById("not_compatible").innerHTML = "<?php echo $lang_not_compatible; ?>";
	}
}
function showGmap() 
{
	var nowlat  = 0;
	var nowlng  = 0;
	var nowzoom = 0;

	if ( opener_mode == 'opener' )
	{
// when parent exist
		if ( opener != null )
		{
// when element exist
			if ( opener.document.getElementById("gm_latitude") != null )
			{
				nowlat  = opener.document.getElementById("gm_latitude").value;
			}
			if ( opener.document.getElementById("gm_longitude") != null )
			{
				nowlng  = opener.document.getElementById("gm_longitude").value;
			}
			if ( opener.document.getElementById("gm_zoom") != null )
			{
				nowzoom = opener.document.getElementById("gm_zoom").value;
			}
		}
	}
	else if ( opener_mode == 'parent' )
	{
// when parent exist
		if ( parent != null )
		{
// when element exist
			if ( parent.document.getElementById("gm_latitude") != null )
			{
				nowlat  = parent.document.getElementById("gm_latitude").value;
			}
			if ( parent.document.getElementById("gm_longitude") != null )
			{
				nowlng  = parent.document.getElementById("gm_longitude").value;
			}
			if ( parent.document.getElementById("gm_zoom") != null )
			{
				nowzoom = parent.document.getElementById("gm_zoom").value;
			}
		}
	}

	var map = new GMap2( document.getElementById("map") );
	map.addControl(new GLargeMapControl());
	map.addControl(new GMapTypeControl());

	//center marker
	var center_icon = new GIcon();
	center_icon.image = "./images/cicon.png";
	center_icon.iconSize = new GSize(15, 15);
	center_icon.iconAnchor = new GPoint(8, 8);

	GEvent.addListener(map, "moveend", function() {
		var center = map.getCenter();
		var zl = map.getZoom();

		set_address = '';
		if ( flag_inv_geo )
		{
			inverseGeocoder( center.y , center.x );
			set_address = '<input type="button" value="<?php echo $lang_get_addr; ?>" onclick="setAddress()"> ';
		}

		var message = sprintf( gm_lang_location , { lat:center.y, lng:center.x, zoom:zl} ) + '<br /><br />';
		message += '<input type="button" value="<?php echo $lang_get_latitude; ?>" onclick="setLatitude('+center.y+','+center.x+','+zl+')"> ';
		message += set_address;
		if (( opener_mode == '' )||( opener_mode == 'opener' ))
		{
			message += '<input type="button" value="<?php echo $lang_close; ?>" onclick="window.close()"> ';
		}
		else if ( opener_mode == 'parent' )
		{
			message += '<input type="button" value="<?php echo $lang_off; ?>" onClick="dispOff()"> ';
		}
		document.getElementById("message").innerHTML = message; 

	//Center marker
		map.removeOverlay( centermarker );
		centermarker = new GMarker( map.getCenter(), center_icon );
		map.addOverlay( centermarker );

	//Draggable marker
		map.removeOverlay( Dmarker );
		Dmarker = new GMarker( map.getCenter(), { draggable:true , bouncy:true , bounceGravity:0.5 } );
		map.addOverlay( Dmarker );

		GEvent.addListener( Dmarker, "dragend", function() {
			window.setTimeout( function() {
				map.panTo( Dmarker.getPoint() );
			}, 1000 );
		});

	});

	if( (nowlat != 0) || (nowlng != 0) || (nowzoom != 0) )
	{
		gm_default_latitude  = nowlat;
		gm_default_longitude = nowlng;
		gm_default_zoom      = nowzoom;
	}

	map.setCenter( new GLatLng( gm_default_latitude, gm_default_longitude ), Math.floor( gm_default_zoom ) );

}
function inverseGeocoder( lat , lng )
{
	var url = 'gm_invgeo.php?lon='+ lng +'&lat='+ lat;
	GDownloadUrl( url , function( data , responseCode ) {
		if( responseCode == 200 )
		{
			var xml = GXml.parse( data );
			if ( xml.documentElement.getElementsByTagName("address")[0] != null) 
			{
				address_val  = xml.documentElement.getElementsByTagName("address")[0].firstChild.nodeValue;
				address_html = address_val.htmlspecialchars();
			}
			if ( xml.documentElement.getElementsByTagName("pref")[0] != null) 
			{
				pref_val  = xml.documentElement.getElementsByTagName("pref")[0].firstChild.nodeValue;
				pref_html = pref_val.htmlspecialchars();
			}
			if ( xml.documentElement.getElementsByTagName("city")[0] != null) 
			{
				city_val  = xml.documentElement.getElementsByTagName("city")[0].firstChild.nodeValue;
				city_html = city_val.htmlspecialchars();
			}
			if ( xml.documentElement.getElementsByTagName("town")[0] != null) 
			{
				town_val  = xml.documentElement.getElementsByTagName("town")[0].firstChild.nodeValue;;
				town_html = town_val.htmlspecialchars();
			}
			if ( xml.documentElement.getElementsByTagName("number")[0] != null) 
			{
				number_val  = xml.documentElement.getElementsByTagName("number")[0].firstChild.nodeValue;
				number_html = number_val.htmlspecialchars();
			}
		}
		document.getElementById("current_address").innerHTML = address_html;
	});
}
function setLatitude( yyy , xxx , zzz )
{
	//xxx=Math.floor(xxx * 100000000)/100000000;
	//yyy=Math.floor(yyy * 100000000)/100000000;
	if ( opener_mode == 'opener' )
	{
// when parent exist
		if ( opener != null) 
		{
// when element exist
			if ( opener.document.getElementById("gm_latitude") != null) 
			{
				opener.document.getElementById( "gm_latitude" ).value = yyy;
			}
			if ( opener.document.getElementById("gm_longitude") != null)
			{
				opener.document.getElementById( "gm_longitude" ).value = xxx;
			}
			if ( opener.document.getElementById("gm_zoom") != null)
			{
				opener.document.getElementById( "gm_zoom" ).value = Math.floor( zzz );
			}
		}
	}
	else if ( opener_mode == 'parent' )
	{
// when parent exist
		if ( parent != null) 
		{
// when element exist
			if ( parent.document.getElementById("gm_latitude") != null) 
			{
				parent.document.getElementById( "gm_latitude" ).value = yyy;
			}
			if ( parent.document.getElementById("gm_longitude") != null)
			{
				parent.document.getElementById( "gm_longitude" ).value = xxx;
			}
			if ( parent.document.getElementById("gm_zoom") != null)
			{
				parent.document.getElementById( "gm_zoom" ).value = Math.floor( zzz );
			}
		}
	}
}
function setAddress()
{
	if ( opener_mode == 'opener' )
	{
// when parent exist
		if ( opener != null) 
		{
// when element exist
			if (( opener.document.getElementById("gm_location") != null)&&(address_html != ''))
			{
				opener.document.getElementById( "gm_location" ).value = address_html;
			}
			if (( opener.document.getElementById("state") != null)&&(pref_html != ''))
			{
				opener.document.getElementById( "state" ).value = pref_html;
			}
			if (( opener.document.getElementById("city") != null)&&(city_html != ''))
			{
				opener.document.getElementById( "city" ).value = city_html;
			}
			if (( opener.document.getElementById("addr") != null)&&(town_html != ''))
			{
				opener.document.getElementById( "addr" ).value = town_html + number_html;
			}
		}
	}
	else if ( opener_mode == 'parent' )
	{
// when parent exist
		if ( parent != null) 
		{
// when element exist
			if (( parent.document.getElementById("gm_location") != null)&&(address_html != ''))
			{
				parent.document.getElementById( "gm_location" ).value = address_html;
			}
			if (( parent.document.getElementById("state") != null)&&(pref_html != ''))
			{
				parent.document.getElementById( "state" ).value = pref_html;
			}
			if (( parent.document.getElementById("city") != null)&&(city_html != ''))
			{
				parent.document.getElementById( "city" ).value = city_html;
			}
			if (( parent.document.getElementById("addr") != null)&&(town_html != ''))
			{
				parent.document.getElementById( "addr" ).value = town_html + number_html;
			}
		}
	}
}
function dispOff()
{
	if ( opener_mode == 'parent' )
	{
// when parent exist
		if ( parent != null) 
		{
			if ( parent.document.getElementById("weblinks_gm_iframe") != null)
			{
				parent.document.getElementById("weblinks_gm_iframe").innerHTML = '';
			}
		}
	}
}
//#xxx# of the character string is replaced by data
//by gijyutsuhyouron [Ajax] chap.5
function sprintf( template, obj )
{
	var rslt = template;
	for( var Name in obj )
	{
		value = obj[Name];
		reg = new RegExp( "#" + Name + "#", "g" );
		rslt = rslt.replace( reg, value );
	}
	return rslt;
}
// reference: mygmap module's mygmap.js
String.prototype.htmlspecialchars = function() {
	var tmp = this.toString();
	tmp = tmp.replace(/\//g, "");
	tmp = tmp.replace(/&/g, "&amp;");
	tmp = tmp.replace(/"/g, "&quot;");
	tmp = tmp.replace(/'/g, "&#39;");
	tmp = tmp.replace(/</g, "&lt;");
	tmp = tmp.replace(/>/g, "&gt;");
	return tmp;
}
window.onload = load;
window.onunload = GUnload;
//]]>
</script>

</head>
<body>
<h3><?php echo $lang_title; ?></h3>

<noscript>
  <h4 style="color: #ff0000;"><?php echo $lang_js_invalid; ?></h4>
</noscript>

<h4 id="not_compatible" style="color: #ff0000;"></h4>
<div id="map" style="width:98%; height: 480px; border:1px solid #999999;"></div>
<br />
<b><?php echo $lang_default_location; ?></b><br />
<?php echo $gm_default_location; ?><br />
<?php echo $gm_lang_default_location; ?><br /><br />
<b><?php echo $lang_current_location; ?></b><br />
<div id="current_address"></div>
<div id="message"></div>
</body>
</html>

<?php
// --- raw HTML end ---

}
else
{

// --- raw HTML begin ---
?>
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml">
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
<title>weblinks - <?php echo $lang_title; ?></title>
</head>
<body>
<h3><?php echo $lang_title; ?></h3>
<h4 style="color: #ff0000;">not set google map api key</h4>
</body>
</html>
<?php
// --- raw HTML end ---

}
exit();
?>