<?php
// $Id: weblinks_modify_handler.php,v 1.4 2006/10/05 11:06:13 ohwada Exp $

// 2006-10-01 K.OHWADA
// use happy_linux
// use rssc
// google map

// 2006-05-15 K.OHWADA
// new handler
// not use weblinks_module_base

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// this file contain 2 class
//   weblinks_modify 
//   weblinks_modify_handler
// 2004/01/14 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_modify_handler') ) 
{

//=========================================================
// class weblinks_modify
//=========================================================
class weblinks_modify extends weblinks_link_base
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_modify()
{
	$this->weblinks_link_base();

	$this->initVar('mid',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('mode',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('muid',   XOBJ_DTYPE_INT, 0, false);

	$this->initVar('lid',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('uid',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('cids',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('title',  XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('url',    XOBJ_DTYPE_URL,    null, false, 255);
	$this->initVar('banner', XOBJ_DTYPE_URL,    null, false, 255);
	$this->initVar('description',  XOBJ_DTYPE_TXTAREA);
	$this->initVar('name',     XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('nameflag', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('mail',     XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('mailflag', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('company',  XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('addr',     XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('tel',      XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('search',     XOBJ_DTYPE_TXTAREA);
	$this->initVar('passwd',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('admincomment',   XOBJ_DTYPE_TXTAREA);
	$this->initVar('mark',         XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('time_create',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('time_update',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('hits',     XOBJ_DTYPE_INT, 0, false);
	$this->initVar('rating',   XOBJ_DTYPE_FLOAT, 0.0, false);
	$this->initVar('votes',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('comments', XOBJ_DTYPE_INT, 0, false);
//	$this->initVar('width',    XOBJ_DTYPE_INT, 0, false);
//	$this->initVar('height',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('recommend',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('mutual',     XOBJ_DTYPE_INT, 0, false);
	$this->initVar('broken',     XOBJ_DTYPE_INT, 0, false);
	$this->initVar('rss_url',    XOBJ_DTYPE_URL, null, false, 255);
	$this->initVar('rss_flag',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('rss_xml',    XOBJ_DTYPE_TXTAREA);
	$this->initVar('rss_update', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('usercomment',  XOBJ_DTYPE_TXTAREA);
	$this->initVar('zip',    XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('state',  XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('city',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('addr2',  XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('fax',    XOBJ_DTYPE_TXTBOX, null, false, 255);

// html
	$this->initVar('dohtml',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('dosmiley', XOBJ_DTYPE_INT, 1, false);
	$this->initVar('doxcode',  XOBJ_DTYPE_INT, 1, false);
	$this->initVar('doimage',  XOBJ_DTYPE_INT, 1, false);
	$this->initVar('dobr',     XOBJ_DTYPE_INT, 1, false);
	$this->initVar('etc1',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('etc2',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('etc3',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('etc4',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('etc5',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('notify',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('map_use',  XOBJ_DTYPE_INT, 1);

// rssc
	$this->initVar('rssc_lid',  XOBJ_DTYPE_INT,   0);

// google map: hacked by wye
	$this->initVar('gm_latitude',  XOBJ_DTYPE_FLOAT, 0, false );
	$this->initVar('gm_longitude', XOBJ_DTYPE_FLOAT, 0, false );
	$this->initVar('gm_zoom',      XOBJ_DTYPE_INT,   0, false );

// aux
	$this->initVar('aux_int_1',  XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_int_2',  XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_text_1', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('aux_text_2', XOBJ_DTYPE_TXTBOX, null, false, 255);
}

//---------------------------------------------------------
// set var
//---------------------------------------------------------
function assign_vars_post( &$post )
{
	$this->set_var_key($post, 'mid');
	$this->set_var_key($post, 'mode');
	$this->set_var_key($post, 'lid');
	$this->set_var_key($post, 'uid');
	$this->set_var_key($post, 'title');
	$this->set_var_key($post, 'name');
	$this->set_var_key($post, 'nameflag');
	$this->set_var_key($post, 'mail');
	$this->set_var_key($post, 'mailflag');
	$this->set_var_key($post, 'company');
	$this->set_var_key($post, 'addr');
	$this->set_var_key($post, 'tel');
	$this->set_var_key($post, 'search');
	$this->set_var_key($post, 'passwd');
	$this->set_var_key($post, 'admincomment');
	$this->set_var_key($post, 'mark');
	$this->set_var_key($post, 'time_create');
	$this->set_var_key($post, 'time_update');
	$this->set_var_key($post, 'hits');
	$this->set_var_key($post, 'rating');
	$this->set_var_key($post, 'votes');
	$this->set_var_key($post, 'comments');
//	$this->set_var_key($post, 'width');
//	$this->set_var_key($post, 'height');
	$this->set_var_key($post, 'recommend');
	$this->set_var_key($post, 'mutual');
	$this->set_var_key($post, 'broken');
	$this->set_var_key($post, 'rss_flag');
	$this->set_var_key($post, 'rss_xml');
	$this->set_var_key($post, 'rss_update');
	$this->set_var_key($post, 'usercomment');
	$this->set_var_key($post, 'zip');
	$this->set_var_key($post, 'state');
	$this->set_var_key($post, 'city');
	$this->set_var_key($post, 'addr2');
	$this->set_var_key($post, 'fax');

	$this->set_var_key($post, 'etc1');
	$this->set_var_key($post, 'etc2');
	$this->set_var_key($post, 'etc3');
	$this->set_var_key($post, 'etc4');
	$this->set_var_key($post, 'etc5');
	$this->set_var_key($post, 'notify');

	$this->set_var_key($post, 'url');
	$this->set_var_key($post, 'banner');
	$this->set_var_key($post, 'rss_url');
	$this->set_var_key($post, 'map_use');

	$this->set_muid($post);
	$this->set_desc($post);

	$this->set_cids($post);

// after set_conf_desc_option()
	$this->set_desc_option($post, 'dohtml');
	$this->set_desc_option($post, 'dosmiley');
	$this->set_desc_option($post, 'doxcode');
	$this->set_desc_option($post, 'doimage');
	$this->set_desc_option($post, 'dobr');

// google map
	$this->set_var_key($post, 'gm_latitude');
	$this->set_var_key($post, 'gm_longitude');
	$this->set_var_key($post, 'gm_zoom');
}

function set_muid($post)
{
	list($uid, $name, $mail) = $this->get_system_param();

	if ( isset($post['muid']) )
	{
		$uid = $post['muid'];
	}

	$this->setVar('muid', $uid);
}

//---------------------------------------------------------
// show mode
//---------------------------------------------------------

// --- class end ---
}

//=========================================================
// class weblinks_modify_handler
//=========================================================
class weblinks_modify_handler extends happy_linux_object_handler
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_modify_handler( $dirname )
{
	$this->happy_linux_object_handler( $dirname, 'modify', 'mid', 'weblinks_modify' );

	$this->set_debug_db_sql(   WEBLINKS_DEBUG_MODIFY_SQL );
	$this->set_debug_db_error( WEBLINKS_DEBUG_ERROR );

}


//---------------------------------------------------------
// insert
//---------------------------------------------------------
function _build_insert_sql(&$obj)
{
	foreach ($obj->gets() as $k => $v) 
	{	${$k} = $v;	}

	$sql  = 'INSERT INTO '.$this->_table.' (';

	$sql .= 'mode, ';
	$sql .= 'muid, ';
	$sql .= 'lid, ';

	$sql .= 'uid, ';
	$sql .= 'cids, ';
	$sql .= 'title, ';
	$sql .= 'url, ';
	$sql .= 'banner, ';
	$sql .= 'description, ';
	$sql .= 'name, ';
	$sql .= 'nameflag, ';
	$sql .= 'mail, ';
	$sql .= 'mailflag, ';

	$sql .= 'company, ';
	$sql .= 'addr, ';
	$sql .= 'tel, ';
	$sql .= 'search, ';
	$sql .= 'passwd, ';
	$sql .= 'admincomment, ';
	$sql .= 'mark, ';
	$sql .= 'time_create, ';
	$sql .= 'time_update, ';
	$sql .= 'hits, ';

	$sql .= 'rating, ';
	$sql .= 'votes, ';
	$sql .= 'comments, ';
//	$sql .= 'width, ';
//	$sql .= 'height, ';
	$sql .= 'recommend, ';
	$sql .= 'mutual, ';
	$sql .= 'broken, ';
	$sql .= 'rss_url, ';
	$sql .= 'rss_flag, ';

	$sql .= 'rss_xml, ';
	$sql .= 'rss_update, ';
	$sql .= 'usercomment, ';
	$sql .= 'zip, ';
	$sql .= 'state, ';
	$sql .= 'city, ';
	$sql .= 'addr2, ';
	$sql .= 'fax, ';

// html
	$sql .= 'dohtml, ';
	$sql .= 'dosmiley, ';
	$sql .= 'doxcode, ';
	$sql .= 'doimage, ';
	$sql .= 'dobr, ';
	$sql .= 'etc1, ';
	$sql .= 'etc2, ';
	$sql .= 'etc3, ';
	$sql .= 'etc4, ';
	$sql .= 'etc5, ';
	$sql .= 'notify, ';
	$sql .= 'map_use, ';

// rssc
	$sql .= 'rssc_lid, ';

// google map
	$sql .= 'gm_latitude, ';
	$sql .= 'gm_longitude, ';
	$sql .= 'gm_zoom, ';

// aux
	$sql .= 'aux_int_1, ';
	$sql .= 'aux_int_2, ';
	$sql .= 'aux_text_1, ';
	$sql .= 'aux_text_2 ';

	$sql .= ') VALUES (';

	$sql .= intval($mode).', ';
	$sql .= intval($muid).', ';
	$sql .= intval($lid).', ';

	$sql .= intval($uid).', ';
	$sql .= $this->quote($cids).', ';
	$sql .= $this->quote($title).', ';
	$sql .= $this->quote($url).', ';
	$sql .= $this->quote($banner).', ';
	$sql .= $this->quote($description).', ';
	$sql .= $this->quote($name).', ';
	$sql .= intval($nameflag).', ';
	$sql .= $this->quote($mail).', ';
	$sql .= intval($mailflag).', ';

	$sql .= $this->quote($company).', ';
	$sql .= $this->quote($addr).', ';
	$sql .= $this->quote($tel).', ';
	$sql .= $this->quote($search).', ';
	$sql .= $this->quote($passwd).', ';
	$sql .= $this->quote($admincomment).', ';
	$sql .= $this->quote($mark).', ';
	$sql .= intval($time_create).', ';
	$sql .= intval($time_update).', ';
	$sql .= intval($hits).', ';

	$sql .= floatval($rating).', ';
	$sql .= intval($votes).', ';
	$sql .= intval($comments).', ';
//	$sql .= intval($width).', ;
//	$sql .= intval($height).', ';
	$sql .= intval($recommend).', ';
	$sql .= intval($mutual).', ';
	$sql .= intval($broken).', ';
	$sql .= $this->quote($rss_url).', ';
	$sql .= intval($rss_flag).', ';

	$sql .= intval($rss_xml).', ';
	$sql .= intval($rss_update).', ';
	$sql .= $this->quote($usercomment).', ';
	$sql .= $this->quote($zip).', ';
	$sql .= $this->quote($state).', ';
	$sql .= $this->quote($city).',';
	$sql .= $this->quote($addr2).', ';
	$sql .= $this->quote($fax).', ';

// html
	$sql .= intval($dohtml).', ';
	$sql .= intval($dosmiley).', ';
	$sql .= intval($doxcode).', ';
	$sql .= intval($doimage).', ';
	$sql .= intval($dobr).', ';
	$sql .= $this->quote($etc1).', ';
	$sql .= $this->quote($etc2).', ';
	$sql .= $this->quote($etc3).', ';
	$sql .= $this->quote($etc4).', ';
	$sql .= $this->quote($etc5).', ';
	$sql .= intval($notify).', ';
	$sql .= intval($map_use).', ';

// rssc
	$sql .= intval($rssc_lid).', ';

// google map
	$sql .= floatval($gm_latitude).', ';
	$sql .= floatval($gm_longitude).', ';
	$sql .= intval($gm_zoom).', ';

// aux
	$sql .= intval($aux_int_1).', ';
	$sql .= intval($aux_int_2).', ';
	$sql .= $this->quote($aux_text_1).', ';
	$sql .= $this->quote($aux_text_2).' ';

	$sql .= ')';

	return $sql;
}

//---------------------------------------------------------
// update
//---------------------------------------------------------
function _build_update_sql(&$obj)
{
	foreach ($obj->gets() as $k => $v) 
	{	${$k} = $v;	}

	$sql = 'UPDATE '.$this->_table.' SET ';

	$sql .= 'mode='.intval($mode).', ';
	$sql .= 'muid='.intval($muid).', ';
	$sql .= 'lid='.intval($lid).', ';

	$sql .= 'uid='.intval($uid).', ';
	$sql .= 'cids='.$this->quote($cids).', ';
	$sql .= 'title='.$this->quote($title).', ';
	$sql .= 'url='.$this->quote($url).', ';
	$sql .= 'banner='.$this->quote($banner).', ';
	$sql .= 'description='.$this->quote($description).', ';
	$sql .= 'name='.$this->quote($name).', ';
	$sql .= 'nameflag='.intval($nameflag).', ';
	$sql .= 'mail='.$this->quote($mail).', ';
	$sql .= 'mailflag='.intval($mailflag).', ';

	$sql .= 'company='.$this->quote($company).', ';
	$sql .= 'addr='.$this->quote($addr).', ';
	$sql .= 'tel='.$this->quote($tel).', ';
	$sql .= 'search='.$this->quote($search).', ';
	$sql .= 'passwd='.$this->quote($passwd).', ';
	$sql .= 'admincomment='.$this->quote($admincomment).', ';
	$sql .= 'mark='.$this->quote($mark).', ';
	$sql .= 'time_create='.intval($time_create).', ';
	$sql .= 'time_update='.intval($time_update).', ';
	$sql .= 'hits='.intval($hits).', ';

	$sql .= 'rating='.floatval($rating).', ';
	$sql .= 'votes='.intval($votes).', ';
	$sql .= 'comments='.intval($comments).', ';
//	$sql .= 'width='.intval($width).', ';
//	$sql .= 'height='.intval($height).', ';
	$sql .= 'recommend='.intval($recommend).', ';
	$sql .= 'mutual='.intval($mutual).', ';
	$sql .= 'broken='.intval($broken).', ';
	$sql .= 'rss_url='.$this->quote($rss_url).', ';
	$sql .= 'rss_flag='.intval($rss_flag).', ';

	$sql .= 'rss_update='.intval($rss_update).', ';
	$sql .= 'rss_xml='.$this->quote($rss_xml).', ';
	$sql .= 'usercomment='.$this->quote($usercomment).', ';
	$sql .= 'zip='.$this->quote($zip).', ';
	$sql .= 'state='.$this->quote($state).', ';
	$sql .= 'city='.$this->quote($city).', ';
	$sql .= 'addr2='.$this->quote($addr2).', ';
	$sql .= 'fax='.$this->quote($fax).', ';

// html
	$sql .= 'dohtml='.intval($dohtml).', ';
	$sql .= 'dosmiley='.intval($dosmiley).', ';
	$sql .= 'doxcode='.intval($doxcode).', ';
	$sql .= 'doimage='.intval($doimage).', ';
	$sql .= 'dobr='.intval($dobr).', ';
	$sql .= 'etc1='.$this->quote($etc1).', ';
	$sql .= 'etc2='.$this->quote($etc2).', ';
	$sql .= 'etc3='.$this->quote($etc3).', ';
	$sql .= 'etc4='.$this->quote($etc4).', ';
	$sql .= 'etc5='.$this->quote($etc5).' ';
	$sql .= 'notify='.intval($notify).', ';
	$sql .= 'map_use='.intval($map_use).', ';

// rssc
	$sql .= 'rssc_lid='.intval($rssc_lid).', ';

// google map
	$sql .= 'gm_latitude='.floatval($gm_latitude).', ';
	$sql .= 'gm_longitude='.floatval($gm_longitude).', ';
	$sql .= 'gm_zoom='.intval($gm_zoom).', ';

// aux
	$sql .= 'aux_int_1='.intval($aux_int_1).', ';
	$sql .= 'aux_int_2='.intval($aux_int_2).', ';
	$sql .= 'aux_text_1='.$this->quote($aux_text_1).', ';
	$sql .= 'aux_text_2='.$this->quote($aux_text_2).' ';

	$sql .= ' WHERE mid='.intval($mid);

	return $sql;
}

//---------------------------------------------------------
// delete
//---------------------------------------------------------
function delete_by_lid($lid)
{
	$sql = 'DELETE FROM '.$this->_table.' WHERE lid='.intval($lid);

	if ( !$this->query($sql) )
	{	return false;	}

	return true;
}

//---------------------------------------------------------
// get count
//---------------------------------------------------------
function get_count_by_mode($mode)
{
	$mode = intval($mode);
	$criteria = new CriteriaCompo();
	$criteria->add( new criteria('mode', $mode, '=') );
	$count = $this->getCount($criteria);
	return $count;
}

function get_count_new()
{
	$count = $this->get_count_by_mode(0);
	return $count;
}

function get_count_mod()
{
	$count = $this->get_count_by_mode(1);
	return $count;
}


//---------------------------------------------------------
// get object
//---------------------------------------------------------
function &get_objects_by_mode($mode, $limit=0, $start=0)
{
	$mode = intval($mode);
	$criteria = new CriteriaCompo();
	$criteria->add( new criteria('mode', $mode, '=') );
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_new($limit=0, $start=0)
{
	$objs =& $this->get_objects_by_mode(0, $limit, $start);
	return $objs;
}

function &get_objects_mod($limit=0, $start=0)
{
	$objs =& $this->get_objects_by_mode(1, $limit, $start);
	return $objs;
}

//---------------------------------------------------------
// get mid list
//---------------------------------------------------------
function &get_mid_array_by_mode($mode, $limit=0, $start=0)
{
	$mode = intval($mode);
	$criteria = new CriteriaCompo();
	$criteria->add( new criteria('mode', $mode, '=') );
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$list =& $this->getList($criteria);
	return $list;
}

function &get_mid_array_new($limit=0, $start=0)
{
	$mid_arr =& $this->get_mid_array_by_mode(0, $limit, $start);
	return $mid_arr;
}

function &get_mid_array_mod($limit=0, $start=0)
{
	$mid_arr =& $this->get_mid_array_by_mode(1, $limit, $start);
	return $mid_arr;
}


//=========================================================
// alter table
//=========================================================
function check_version_120()
{
	$ret = $this->existsFieldName( 'map_use' );
	return $ret;
}

function check_version_110()
{
	$ret = $this->existsFieldName( 'dohtml' );
	return $ret;
}

function add_column_table_120()
{
// rssc_lid
// google map

$sql = "
  ALTER TABLE ".$this->_table." ADD COLUMN (
  map_use  tinyint(2)       NOT NULL default '1',
  rssc_lid int(11) unsigned NOT NULL default '0',
  gm_latitude  double(10,8) NOT NULL default '0',
  gm_longitude double(11,8) NOT NULL default '0',
  gm_zoom      tinyint(2)   NOT NULL default '0',
  aux_int_1 int(5) default '0',
  aux_int_2 int(5) default '0',
  aux_text_1 varchar(255) default '',
  aux_text_2 varchar(255) default ''
)";

	$ret = $this->query($sql);
	return $ret;
}

function add_column_table_110()
{
$sql1 = "
  ALTER TABLE ".$this->_table." ADD COLUMN (
  dohtml   tinyint(1) NOT NULL default 0,
  dosmiley tinyint(1) NOT NULL default 1,
  doxcode  tinyint(1) NOT NULL default 1,
  doimage  tinyint(1) NOT NULL default 1,
  dobr     tinyint(1) NOT NULL default 1,
  etc1 varchar(255) default NULL,
  etc2 varchar(255) default NULL,
  etc3 varchar(255) default NULL,
  etc4 varchar(255) default NULL,
  etc5 varchar(255) default NULL,
  notify   tinyint(1) NOT NULL default 0
)";

	$ret1 = $this->query($sql1);

	$sql2 = "ALTER TABLE ".$this->_table." MODIFY cids varchar(255) default NULL ";
	$ret2 = $this->query($sql2);

	$sql3 = "ALTER TABLE ".$this->_table." MODIFY title varchar(255) NOT NULL default '' ";
	$ret3 = $this->query($sql3);

	$sql4 = "ALTER TABLE ".$this->_table." MODIFY zip varchar(255) default NULL ";
	$ret4 = $this->query($sql4);

	$sql5 = "ALTER TABLE ".$this->_table." MODIFY state varchar(255) default NULL ";
	$ret5 = $this->query($sql5);

	$sql6 = "ALTER TABLE ".$this->_table." MODIFY city varchar(255) default NULL ";
	$ret6 = $this->query($sql6);

	if ( $ret1 && $ret2 && $ret3 && $ret4 && $ret5 && $ret6 )
	{
		return true;
	}

	return false;
}

// --- class end ---
}

// === class end ===
}

?>