<?php
// $Id: weblinks_link.php,v 1.3 2006/10/14 03:01:10 ohwada Exp $

// 2006-10-12 K.OHWADA
// BUG 4318: cannot register bulk links.
// add set_not_gpc()

// 2006-10-01 K.OHWADA
// divided from weblinks_link_handler
// google map
// change addr_urlencode()

//=========================================================
// WebLinks Module
// this file contain 2 class
//   weblinks_link_base
//   weblinks_link 
// 2006-09-20 K.OHWADA
//=========================================================

//---------------------------------------------------------
// TODO
// global $xoopsUser
// get_system_param()
//---------------------------------------------------------

// === class begin ===
if( !class_exists('weblinks_link') ) 
{

//=========================================================
// class weblinks_link_base
//=========================================================
class weblinks_link_base extends happy_linux_object
{
	var $_conf_desc_option = array(
		'dohtml'   => false,
		'dosmiley' => false,
		'doxcode'  => false,
		'doimage'  => false,
		'dobr'     => false,
	);

	var $_not_gpc = false;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_base()
{
	$this->happy_linux_object();
}

//---------------------------------------------------------
// system
//---------------------------------------------------------
function get_system_param()
{
	global $xoopsUser;

	$uid   = 0;
	$uname = '';
	$email = '';

	if ( is_object($xoopsUser) )
	{
		$uid   = $xoopsUser->getVar('uid');
		$uname = $xoopsUser->getVar('uname');
		$email = $xoopsUser->getVar('email');
	}

	return array($uid, $uname, $email);
}

//---------------------------------------------------------
// set var
//---------------------------------------------------------
function set_not_gpc( $val )
{
	$this->_not_gpc = (bool)$val;
}

function set_var_key(&$post, $key)
{
	if ( isset($post[$key]) )
	{
		$this->setVar( $key, $post[$key], $this->_not_gpc );
	}
}

function set_uid(&$post)
{
	list($uid, $name, $mail) = $this->get_system_param();

	if ( isset($post['uid']) )
	{
		$uid = $post['uid'];
	}

	$this->setVar('uid', $uid);
}

function set_desc(&$post)
{
	if ( isset($post['description']) )
	{
		$this->setVar( 'description', $post['description'], $this->_not_gpc  );
	}
	elseif ( isset($post['description_text']) )
	{
		$this->setVar( 'description', $post['description_text'], $this->_not_gpc  );
	}
}

function set_desc_option(&$post, $key)
{
	$val = 0;

	if ( $this->_conf_desc_option[$key] && isset($post[$key]) )
	{
		$val = $post[$key];
	}

	$this->setVar( $key, $val );
}

function set_conf_desc_option($arr)
{
	$this->_conf_desc_option = $arr;
}

// BUG 4030: cannot change recommend, mutual
function set_checkbox( &$post, $key )
{
	$val = 0;

	if ( isset($post[$key]) )
	{
		$val = $post[$key];
	}

	$this->setVar( $key, $val );
}

//---------------------------------------------------------
// get var
//---------------------------------------------------------
function description_disp()
{
	$myts =& MyTextSanitizer::getInstance();

	$description = $this->get('description');
	$dohtml   = $this->get('dohtml');
	$dosmiley = $this->get('dosmiley');
	$doxcode  = $this->get('doxcode');
	$doimage  = $this->get('doimage');
	$dobr     = $this->get('dobr');

	$text = $myts->displayTarea($description, $dohtml, $dosmiley, $doxcode, $doimage, $dobr);
	return $text;
}

function time_create($format='l', $timeoffset='')
{
	$time = $this->get('time_create');
	$ret = formatTimestamp($time, $format, $timeoffset);
	return $ret;
}

function time_update($format='l', $timeoffset='')
{
	$time = $this->get('time_update');
	$ret = formatTimestamp($time, $format, $timeoffset);
	return $ret;
}

function votes_disp()
{
	$votes = $this->get('votes');

	if ($votes == 1) 
	{
		$votes_disp = _WLS_ONEVOTE;
	} 
	else
	{
		$votes_disp = sprintf(_WLS_NUMVOTES, $votes);
	}
	return $votes_disp;
}

function rating_disp()
{
	$DECIMALS = 2;
	$rating = $this->get('rating');
	$ret = number_format($rating, $DECIMALS);
	return $ret;
}

function addr_urlencode()
{
// bug fix: Mapfan disregards a space or subsequent ones. 

	$zip   = $this->get('zip');
	$state = $this->get('state');
	$city  = $this->get('city');
	$addr  = $this->get('addr');
	$addr2 = $this->get('addr2');

	$flag_addr      = 0;
	$en_join           = '';
	$jp_join           = '';
	$en_urlencode      = '';
	$jp_urlencode      = '';
	$en_utf8_urlencode = '';
	$jp_utf8_urlencode = '';
	$en_csz            = '';
	$en_csz_urlencode  = '';

	if ( $state || $city || $addr || $addr2 )
	{
		$flag_addr = 1;	
	}

	if ( $city && $state && $zip)
	{
		$en_csz = $city.', '.$state.' '.$zip;
	}
	elseif ( $city && $state)
	{
		$en_csz = $city.', '.$state;
	}
	elseif ( $city && $zip)
	{
		$en_csz = $city.', '.$zip;
	}

	$en_csz_urlencode = urlencode( $en_csz );

	if ( $state || $city || $addr)
	{
		$en_join = $addr.' '.$en_csz;
		$jp_join = $state . $city . $addr;
		$en_utf8 = happy_linux_convert_to_utf8($en_join);
		$jp_utf8 = happy_linux_convert_to_utf8($jp_join);
		$en_urlencode      = urlencode( $en_join );
		$jp_urlencode      = urlencode( $jp_join );
		$en_utf8_urlencode = urlencode( $en_utf8 );
		$jp_utf8_urlencode = urlencode( $jp_utf8 );
	}

	$arr = array(
		'flag_addr'              => $flag_addr,
		'addr_urlencode'         => urlencode( $addr ),
		'addr2_urlencode'        => urlencode( $addr2 ),
		'city_urlencode'         => urlencode( $city ),
		'state_urlencode'        => urlencode( $state ),
		'zip_urlencode'          => urlencode( $zip ),
		'addr_utf8_urlencode'    => urlencode( happy_linux_convert_to_utf8( $addr ) ),
		'addr2_utf8_urlencode'   => urlencode( happy_linux_convert_to_utf8( $addr2 ) ),
		'city_utf8_urlencode'    => urlencode( happy_linux_convert_to_utf8( $city ) ),
		'state_utf8_urlencode'   => urlencode( happy_linux_convert_to_utf8( $state ) ),
		'zip_utf8_urlencode'     => urlencode( happy_linux_convert_to_utf8( $zip ) ),
		'addr_en_join'           => $en_join,
		'addr_jp_join'           => $jp_join,
		'addr_en_urlencode'      => $en_urlencode,
		'addr_jp_urlencode'      => $jp_urlencode,
		'addr_en_utf8_urlencode' => $en_utf8_urlencode,
		'addr_jp_utf8_urlencode' => $jp_utf8_urlencode,
		'addr_en_csz'            => $en_csz,
		'addr_en_csz_urlencode'  => $en_csz_urlencode,
	);

	return $arr; 
}

function name_mail_disp()
{
	$name     = $this->get('name');
	$mail     = $this->get('mail');
	$nameflag = $this->get('nameflag');
	$mailflag = $this->get('mailflag');

	$name_disp = '';
	$mail_disp = '';

	if ( $nameflag && $name && $mailflag && $mail )
	{
		$name_disp = $this->getVar('name');
		$mail_disp = $this->getVar('mail');
	}
	elseif ( $mailflag && $mail )
	{
		$name_disp = 'Email';
		$mail_disp = $this->getVar('mail');
	}
	elseif ( $nameflag && $name )
	{
		$name_disp = $this->getVar('name');
	}

	return array($name_disp, $mail_disp);
}

function name_edit_for_others()
{
	$nameflag = $this->get('nameflag');

	$name_edit     = '';
	$nameflag_edit = 0;

	if ($nameflag == 1)
	{
		$name_edit     = $this->getVar('name');
		$nameflag_edit = 1;
	}

	return array($name_edit, $nameflag_edit);
}

function mail_edit_for_others()
{
	$mailflag = $this->get('mailflag');

	$mail_edit     = '';
	$mailflag_edit = 0;

	if ($mailflag == 1)
	{
		$mail_edit     =  $this->getVar('mail');
		$mailflag_edit = 1;
	}

	return array($mail_edit, $mailflag_edit);
}

//---------------------------------------------------------
// cid array for modify
//---------------------------------------------------------
function cid_array()
{
	$cids = $this->get('cids');
	$arr  = $this->_convert_string_to_array($cids);
	return $arr;
}

function set_cids( &$post )
{
	$arr = $this->get_cid_array_by_post($post);
	$val = $this->set_cids_by_cid_array($arr);
	$this->setVar( 'cids', $val );
}

function set_cids_by_cid_array( $arr )
{
	$val = $this->_convert_array_to_string( $arr );
	$this->setVar( 'cids', $val );
}

function get_cid_array_by_post( &$post )
{
	$arr = array();

	if ( isset($post['cid']) )
	{
		$arr = $this->_build_unique_cid_array( $post['cid'] );
	}

	return $arr;
}

function _build_unique_cid_array( $cid_arr_in )
{
	$cid_arr_out = array();

	if ( is_array($cid_arr_in) )
	{
		foreach ($cid_arr_in as $cid)
		{
			$cid = intval($cid);
			if ($cid != 0)
			{
				$cid_arr_out[] = $cid;
			}
		}
	}
	else
	{
		$cid = intval($cid_arr_in);
		if ($cid != 0)
		{
			$cid_arr_out[] = $cid;
		}
	}

	$cid_arr_out = array_unique($cid_arr_out);

	return $cid_arr_out;
}

//---------------------------------------------------------
// convert array to string
// array($a, $b, $c)  ==> $a & $b & $c
//---------------------------------------------------------
function _convert_array_to_string($arr, $pattern='&')
{
	if ( is_array($arr) )
	{
		$str = $pattern;

		foreach ($arr as $value)
		{
			$str .= intval($value).$pattern;
		}
	}
	elseif ( is_int($arr) )
	{
		$str = $pattern.intval($arr).$pattern;
	}
	else
	{
		$str = $arr;
	}

	return $str;
}

function _convert_string_to_array($str, $pattern='&')
{
	$str_arr = split($pattern, $str);

	$i = 0;	
	$arr = array();
	foreach ($str_arr as $value)
	{
		$value = trim($value);

		if ($value == '')  continue;

		$arr[$i++] = $value;
	}

	return $arr;
}

//---------------------------------------------------------
// XOOPS user
//---------------------------------------------------------
function user_name_mail( $format='n' )
{
	$uid   = $this->get('uid');
	$title = $this->get('title');
	$name  = $this->get('name');
	$mail  = $this->get('mail');

	list($system_uname, $system_email) = $this->system_uname_email($format);

	if ($name)
	{
		$user_name = $name;
	}
	elseif ($uid && $system_uname)
	{
		$user_name = $system_uname;
	}
	else
	{
		$user_name = $title;
	}

	$user_mail = '';
	if ($mail)
	{
		$user_mail = $mail;
	}
	elseif ($uid && $system_email)
	{
		$user_mail = $system_email;
	}
	else
	{
		$user_mail = $title;
	}

	return array($user_name, $user_mail);
}

function system_uname_email( $format='n' )
{
	$uname = '';
	$email = '';

	$uid = $this->get('uid');
	$user_handler =& xoops_gethandler('user');

	$user_obj = $user_handler->get( $uid );
	if ( is_object($user_obj) )
	{
		$uname = $user_obj->getVar( 'uname', $format );
		$email = $user_obj->getVar( 'email', $format );
	}

	return array($uname, $email);
}

// --- class end ---
}

//=========================================================
// class weblinks_link
//=========================================================
class weblinks_link extends weblinks_link_base
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link()
{
	$this->weblinks_link_base();

	$this->initVar('lid',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('uid',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('cids',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('title',  XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('url',    XOBJ_DTYPE_URL,    null, false, 255);
	$this->initVar('banner', XOBJ_DTYPE_URL,    null, false, 255);
	$this->initVar('description',  XOBJ_DTYPE_TXTAREA);
	$this->initVar('name',     XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('nameflag', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('mail',     XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('mailflag', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('company',  XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('addr',     XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('tel',      XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('search',     XOBJ_DTYPE_TXTAREA);
	$this->initVar('passwd',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('admincomment',   XOBJ_DTYPE_TXTAREA);
	$this->initVar('mark',         XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('time_create',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('time_update',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('hits',     XOBJ_DTYPE_INT, 0, false);
	$this->initVar('rating',   XOBJ_DTYPE_FLOAT, 0.0, false);
	$this->initVar('votes',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('comments', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('width',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('height',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('recommend',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('mutual',     XOBJ_DTYPE_INT, 0, false);
	$this->initVar('broken',     XOBJ_DTYPE_INT, 0, false);
	$this->initVar('rss_url',    XOBJ_DTYPE_URL, null, false, 255);
	$this->initVar('rss_flag',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('rss_xml',    XOBJ_DTYPE_TXTAREA);
	$this->initVar('rss_update', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('usercomment',  XOBJ_DTYPE_TXTAREA);
	$this->initVar('zip',    XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('state',  XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('city',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('addr2',  XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('fax',    XOBJ_DTYPE_TXTBOX, null, false, 255);

// html
	$this->initVar('dohtml',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('dosmiley', XOBJ_DTYPE_INT, 1, false);
	$this->initVar('doxcode',  XOBJ_DTYPE_INT, 1, false);
	$this->initVar('doimage',  XOBJ_DTYPE_INT, 1, false);
	$this->initVar('dobr',     XOBJ_DTYPE_INT, 1, false);
	$this->initVar('etc1',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('etc2',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('etc3',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('etc4',   XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('etc5',   XOBJ_DTYPE_TXTBOX, null, false, 255);

// rssc
	$this->initVar('rssc_lid',  XOBJ_DTYPE_INT,   0);
	$this->initVar('map_use',   XOBJ_DTYPE_INT,   1);

// google map: hacked by wye
	$this->initVar('gm_latitude',  XOBJ_DTYPE_FLOAT, 0, false );
	$this->initVar('gm_longitude', XOBJ_DTYPE_FLOAT, 0, false );
	$this->initVar('gm_zoom',      XOBJ_DTYPE_INT,   0, false );

// aux
	$this->initVar('aux_int_1',  XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_int_2',  XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_text_1', XOBJ_DTYPE_TXTBOX, null, false, 255);
	$this->initVar('aux_text_2', XOBJ_DTYPE_TXTBOX, null, false, 255);

}

//---------------------------------------------------------
// set var
//---------------------------------------------------------
function assign_vars_post( &$post, $not_gpc = false )
{
	$this->set_not_gpc($not_gpc);

	$this->set_var_key($post, 'lid');
	$this->set_var_key($post, 'cids');
	$this->set_var_key($post, 'title');
	$this->set_var_key($post, 'name');
	$this->set_var_key($post, 'nameflag');
	$this->set_var_key($post, 'mail');
	$this->set_var_key($post, 'mailflag');
	$this->set_var_key($post, 'company');
	$this->set_var_key($post, 'addr');
	$this->set_var_key($post, 'tel');
	$this->set_var_key($post, 'search');
	$this->set_var_key($post, 'passwd');
	$this->set_var_key($post, 'admincomment');
	$this->set_var_key($post, 'mark');
	$this->set_var_key($post, 'time_create');
	$this->set_var_key($post, 'time_update');
	$this->set_var_key($post, 'hits');
	$this->set_var_key($post, 'rating');
	$this->set_var_key($post, 'votes');
	$this->set_var_key($post, 'comments');
	$this->set_var_key($post, 'width');
	$this->set_var_key($post, 'height');

// BUG 4030: cannot change recommend, mutual
//	$this->set_var_key($post, 'recommend');
//	$this->set_var_key($post, 'mutual');

	$this->set_var_key($post, 'broken');
	$this->set_var_key($post, 'usercomment');
	$this->set_var_key($post, 'zip');
	$this->set_var_key($post, 'state');
	$this->set_var_key($post, 'city');
	$this->set_var_key($post, 'addr2');
	$this->set_var_key($post, 'fax');
	$this->set_var_key($post, 'etc1');
	$this->set_var_key($post, 'etc2');
	$this->set_var_key($post, 'etc3');
	$this->set_var_key($post, 'etc4');
	$this->set_var_key($post, 'etc5');
	$this->set_var_key($post, 'url');
	$this->set_var_key($post, 'banner');
	$this->set_var_key($post, 'map_use');

	$this->set_uid($post);
	$this->set_desc($post);

// after set_conf_desc_option()
	$this->set_desc_option($post, 'dohtml');
	$this->set_desc_option($post, 'dosmiley');
	$this->set_desc_option($post, 'doxcode');
	$this->set_desc_option($post, 'doimage');
	$this->set_desc_option($post, 'dobr');

// google map
	$this->set_var_key($post, 'gm_latitude');
	$this->set_var_key($post, 'gm_longitude');
	$this->set_var_key($post, 'gm_zoom');
}

//---------------------------------------------------------
// show mode
//---------------------------------------------------------
function &build_show()
{
	$arr_db   =& $this->getVarAll('s');
	$arr_cont =  $this->build_show_items('s');
	$arr_out  =  array_merge($arr_db, $arr_cont);
	$arr_out['description'] = $this->description_disp();

	return $arr_out;
}

//---------------------------------------------------------
// item
//---------------------------------------------------------
function build_show_items( $format='n' )
{
	$create   = $this->time_create('m');
	$create_s = $this->time_create('s');
	$update   = $this->time_update('m');
	$update_s = $this->time_update('s');

	list($name_disp, $mail_disp)  = $this->name_mail_disp( $format );

	$arr = array(
		'create'           => $create,
		'create_short'     => $create_s,
		'update'           => $update,
		'update_short'     => $update_s,
		'votes_disp'       => $this->votes_disp(),
		'rating_disp'      => $this->rating_disp(),
		'name_disp'        => htmlspecialchars($name_disp, ENT_QUOTES),
		'mail_disp'        => htmlspecialchars($mail_disp, ENT_QUOTES),

// BUG 4130: cannot show recommend mark
		'flag_recommend'   => $this->getVar('recommend'),
		'flag_mutual'      => $this->getVar('mutual'),
	);

	$addr = $this->addr_urlencode();

	$arr_out = array_merge($arr, $addr);
	return $arr_out;
}

// --- class end ---
}

// === class end ===
}

?>