<?php
// $Id: modify_manage_class.php,v 1.1 2006/09/30 03:15:20 ohwada Exp $

// 2006-09-20 K.OHWADA
// use happy_linux
// use rssc WEBLINKS_RSSC_USE
// use XoopsGTicket

// 2006-07-01 K.OHWADA
// BUG 4085: Fatal error: Call to undefined function: weblinks_page_frame_basic()

// 2006-05-15 K.OHWADA
// new handler

// 2006-03-15 K.OHWADA
// BUG 3743: fatal error ocucred when six or more links waiting to apoval

// 2005-10-20 K.OHWADA
// REQ 3028: send apoval email to anonymous user
// add send_approved_to_anonymous()
// add send_refused_to_user() 

// 2005-09-27 K.OHWADA
// BUG 3031: timeout occurs if many waiting links
// add function list_xxx_link_xxx() print_xxx()

// 2005-01-20 K.OHWADA
// getErrorMsgAddLink

// 2004-12-14 K.OHWADA
// change caller index.php -> link_manage.php 

// 2004-10-20 K.OHWADA
// URL-less mode
// bug fix: approve notify mail dont send

//=========================================================
// admin modify
// 2006-09-01 K.OHWADA
//=========================================================

//=========================================================
// class admin_modify_manage
//=========================================================
class admin_modify_manage extends happy_linux_manage
{
	var $_DEBUG_DELETE_EXEC = true;

	var $_FLAG_EVENT_USER      = 1;	// send email to user
	var $_FLAG_EVENT_ANONYMOUS = 1;	// send email to anonymous

	var $_link_edit_handler;
	var $_link_form_handler;
	var $_check_handler;
	var $_rssc_manage;
	var $_sendmail;
	var $_post;

// local
	var $_tags;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_modify_manage()
{
	$this->happy_linux_manage( WEBLINKS_DIRNAME );
	$this->set_handler( 'modify', WEBLINKS_DIRNAME, 'weblinks' );
	$this->set_id_name( 'mid' );

	$this->_link_edit_handler =& weblinks_get_handler('link_edit', WEBLINKS_DIRNAME);
	$this->_form              =& weblinks_get_handler('link_form_admin', WEBLINKS_DIRNAME );
	$this->_check_handler     =& weblinks_get_handler('link_form_check', WEBLINKS_DIRNAME);

	$this->_sendmail    =& weblinks_sendmail::getInstance( WEBLINKS_DIRNAME );
	$this->_rssc_manage =& admin_rssc_manage::getInstance();
	$this->_post        =& happy_linux_post::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_modify_manage();
	}
	return $instance;
}

//---------------------------------------------------------
// POST param
//---------------------------------------------------------
function get_post_op()
{
	$op = 'main';
	if     ( isset($_POST['del_link']) )     $op = 'del_link';
	elseif ( isset($_POST['delete_link']) )  $op = 'del_link';
	elseif ( isset($_POST['delete_new']) )   $op = 'delete_new';
	elseif ( isset($_POST['ignore']) )       $op = 'ignore';
	elseif ( isset($_POST['cancel']) )       $op = 'cancel';
	elseif ( isset($_POST['op']) )           $op = $_POST['op'];
	elseif ( isset($_GET['op']) )            $op = $_GET['op'];
	return $op;
}

function get_post_mid()
{
	return $this->_post->get_post_get_int('mid');
}

function get_post_lid()
{
	return $this->_post->get_post_get_int('lid');
}

function get_post_rss_flag()
{
	return $this->_post->get_post_get_int('rss_flag');
}

function get_post_uid()
{
	return $this->_post->get_post_int('uid');
}

function get_post_mail()
{
	return $this->_post->get_post_text('mail');
}

//---------------------------------------------------------
// list New Links
//---------------------------------------------------------
function list_new()
{
	$total = $this->_handler->get_count_new();
	$mid   = $this->get_post_mid();

	if ( $total > 0 ) 
	{
		if ( $mid > 0 )
		{
			$obj =& $this->_handler->get($mid);
			if ( !is_object($obj) )
			{
				redirect_header( 'modify_list.php', 3, _WLS_ERRORNOLINK );
				exit();
			}
		}
		else
		{
			$mid_arr = $this->_handler->get_mid_array_new(1);
			if ( !isset($mid_arr[0]) )
			{
				redirect_header( 'modify_list.php', 3, _WLS_ERRORNOLINK );
				exit();
			}
			$mid = $mid_arr[0];
		}

		$total_s = $this->_form->build_html_highlight_number($total);

		$this->_print_cp_header();
		$this->_print_bread_op( _WLS_LINKSWAITING, 'list_new');
		echo "<h4>"._WLS_LINKSWAITING."</h4>\n";
		echo sprintf(_HAPPY_LINUX_THERE_ARE, $total_s)."<br /><br />\n";
		$this->_form->show_admin_form('approve', $mid);
		echo "<br /><br />\n";
	}
	else 
	{
		echo _WLS_NOSUBMITTED."<br />\n";
	}

	$this->_print_cp_footer();
}

//---------------------------------------------------------
// approve New Link
//---------------------------------------------------------
function approve_new()
{
	$rss_flag = $this->get_post_rss_flag();

	if ( !$this->_get_obj() )
	{
		$redirect = $this->_get_redirect_at_new();
		redirect_header( $redirect, 3, _WLS_ERRORNOLINK );
		exit();
	}

	if ( !$this->_check_token() || !$this->_check_approve_new() )
	{
		$this->_print_approve_new_preview();
		exit();
	}

	if ( $this->_exec_approve_new() )
	{
		if ( $this->_send_approve_new() )
		{
			if ( WEBLINKS_RSSC_USE && $rss_flag )
			{
				$this->_rssc_manage->add_link( $this->_newid, 'approve_new' );
				exit();
			}
			else
			{
				$redirect = $this->_get_redirect_at_new();
				redirect_header( $redirect, 1, _WLS_NEWLINKADDED);
				exit();
			}
		}
		else
		{
			$this->_print_approve_new_error( "Mailer Error" );
			exit();
		}
	}
	else
	{
		$this->_print_approve_new_error( "DB Error" );
		exit();
	}
}

function _exec_approve_new()
{
	$newid = $this->_link_edit_handler->add_link_by_post();
	if (!$newid)
	{
		$this->_set_errors( $this->_link_edit_handler->getErrors() );
		return false;
	}

	$mid = $this->_post->get_post_get_int('mid');
	$this->_delete_modify_by_mid($mid);

// notification
	list($tags, $cid) = $this->_link_edit_handler->build_tags_addlink($newid);

	$notification_handler =& xoops_gethandler('notification');
	$notification_handler->triggerEvent('global', 0, 'new_link', $tags);
	$notification_handler->triggerEvent('category', $cid, 'new_link', $tags);

// send email to user, appoval to new link
// bug fix: approve notify mail dont send
	$notification_handler->triggerEvent('link', $mid, 'approve', $tags);

	$this->_tags  = $tags;
	$this->_newid = $newid;

	return $newid;
}

function _send_approve_new()
{
// send email to anonymous, appoval to new link
// REQ 3028: send appoval email to anonymous user

	$uid  = $this->get_post_uid();
	$mail = $this->get_post_mail();

	if( $this->_FLAG_EVENT_ANONYMOUS && ($uid == 0) && $mail )
	{
		$ret = $this->_sendmail->send_approved_to_anonymous( $this->_tags );
		if ( !$ret )
		{
			$this->_set_errors( $this->_sendmail->getErrors() );
		}

		return $ret;
	}

	return true;	// no action
}

function _check_approve_new()
{
	return $this->_check_handler->check_form_modlink_by_post();
}

function _print_approve_new_preview()
{
	$this->_print_cp_header();
	$this->_print_bread_op( _AM_WEBLINKS_APPROVE, 'list_new');
	$this->_print_title(    _AM_WEBLINKS_APPROVE );
	echo "<hr />\n";
	echo $this->_check_handler->get_error_msg_modlink();
	echo "<hr />\n";
	$this->_form->show_admin_form('approve_preview');
	$this->_print_cp_footer();
}

function _print_approve_new_error( $title )
{
	$this->_print_cp_header();
	$this->_print_bread_op( _AM_WEBLINKS_APPROVE, 'list_new');
	$this->_print_title(    _AM_WEBLINKS_APPROVE );
	xoops_error( $title );
	$this->_print_error();
	$this->_print_cp_footer();
}

//---------------------------------------------------------
// delete New Link
//---------------------------------------------------------
function del_new()
{
	if ( !$this->_get_obj() )
	{
		$redirect = $this->_get_redirect_at_new();
		redirect_header($redirect, 3, _WLS_ERRORNOLINK );
		exit();
	}

	if( !$this->_check_token() ) 
	{
		redirect_header("link_list.php", 5, "Token Error");
		exit();
	}

	$mid = $this->get_post_mid();

	if ( $this->_delete_modify_by_mid($mid) )
	{
		if ( $this->_send_del_new() )
		{
			$redirect = $this->_get_redirect_at_new();
			redirect_header($redirect, 1, _WLS_LINKDELETED);
		}
		else
		{
			$this->_print_del_new_error( "Mailer Error" );
		}
	}
	else
	{
		$this->_print_del_new_error( "DB Error" );
	}
}

function _send_del_new()
{
// send email to user and anonymous, refused to new link
// REQ 3028: send refused email to registered user and anonymous user

	$uid  = $this->get_post_uid();
	$mail = $this->get_post_mail();

	$flag_send = false;
	if( $this->_FLAG_EVENT_USER && $uid )
	{
		$flag_send = true;
	}
	elseif( $this->_FLAG_EVENT_ANONYMOUS && ($uid == 0) && $mail )
	{
		$flag_send = true;
	}

	if ($flag_send)
	{
		$ret = $this->_sendmail->send_refused_to_user();
		if ( !$ret )
		{
			$this->_set_errors( $this->_sendmail->getErrors() );
		}

		return $ret;
	}

	return true;	// no action
}

function _print_del_new_error( $title )
{
	$this->_print_cp_header();
	$this->_print_bread_op( _AM_WEBLINKS_APPROVE, 'list_new');
	$this->_print_title(    _AM_WEBLINKS_APPROVE );
	xoops_error( $title );
	$this->_print_error();
	$this->_print_cp_footer();
}

function _delete_modify_by_mid($mid)
{
	$obj = $this->_handler->get($mid);
	if ( !is_object($obj) )
	{
		$msg = "no modify record mid=$mid ";
		$this->_set_errors($msg);
		return false;
	}

	if ( $this->_DEBUG_DELETE_EXEC )
	{
		$ret = $this->_handler->delete($obj);
		if ( !$ret )
		{
			$this->_set_errors( $this->_handler->getErrors() );
			return false;
		}
	}

	return true;
}

//---------------------------------------------------------
// list Modify Request
//---------------------------------------------------------
function list_mod()
{
	$total = $this->_handler->get_count_mod();
	$mid   = $this->get_post_mid();

	if ( $total > 0 ) 
	{
		if ( $mid > 0 )
		{
			$obj =& $this->_handler->get($mid);
			if ( !is_object($obj) )
			{
				redirect_header("modify_list.php", 3, _WLS_ERRORNOLINK );
				exit();
			}
		}
		else
		{
			$mid_arr = $this->_handler->get_mid_array_mod(1);
			if ( !isset($mid_arr[0]) )
			{
				redirect_header("modify_list.php", 3, _WLS_ERRORNOLINK );
				exit();
			}
			$mid = $mid_arr[0];
		}

		$total_s = $this->_form->build_html_highlight_number($total);

		$this->_print_cp_header();
		$this->_print_bread_op( _WLS_MODREQUESTS, 'list_mod');
		echo "<h4>"._WLS_MODREQUESTS."</h4>\n";
		echo sprintf(_HAPPY_LINUX_THERE_ARE, $total_s)."<br /><br />\n";
		$this->_form->show_admin_mod_approve_form('approve', $mid);
		echo "<br /><br />\n";
	}
	else 
	{
		echo _WLS_NOMODREQ."<br />\n";
	}

	$this->_print_cp_footer();
}

//---------------------------------------------------------
// approve Modify Request
// modLinkS and ignoreModReq
//---------------------------------------------------------
function approve_mod()
{
	if ( !$this->_get_obj() )
	{
		$redirect = $this->_get_redirect_at_mod();
		redirect_header( $redirect, 3, _WLS_ERRORNOLINK );
		exit();
	}

	if ( !$this->_check_token() || !$this->_check_approve_mod() )
	{
		$this->_print_approve_mod_preview();
		exit();
	}

	if ( $this->_exec_approve_mod() )
	{
		if ( $this->_send_approve_mod() )
		{
			if ( WEBLINKS_RSSC_USE )
			{
				$this->_rssc_manage->mod_link( 'approve_mod' );
				exit();
			}
			else
			{
				$redirect = $this->_get_redirect_at_mod();
				redirect_header( $redirect, 1, _WLS_DBUPDATED);
				exit();
			}
		}
		else
		{
			$this->_print_approve_mod_error( "Mailer Error" );
			exit();
		}
	}
	else
	{
		$this->_print_approve_mod_error( "DB Error" );
		exit();
	}
}

function _exec_approve_mod()
{
	$this->_clear_errors();

	$mid = $this->get_post_mid();
	$lid = $this->get_post_lid();

// update link
	$ret = $this->_link_edit_handler->mod_link_by_post( $lid );
	if ( !$ret )
	{
		$this->_set_errors( $this->_link_edit_handler->getErrors() );
	}

// delete modify
	$this->_delete_modify_by_mid($mid);

	return $this->returnExistError();
}

function _send_approve_mod()
{
	return true;	// dummy
}

function _check_approve_mod()
{
	return $this->_check_handler->check_form_modlink_for_owner_by_post();
}

function _print_approve_mod_preview()
{
	$this->_print_cp_header();
	$this->_print_bread_op( _WLS_MODREQUESTS, 'list_mod');
	$this->_print_title(    _WLS_MODREQUESTS );
	echo "<hr />\n";
	echo $this->_check_handler->get_error_msg_modlink();
	echo "<hr />\n";
	$this->_form->show_admin_mod_approve_form('preview');
	$this->_print_cp_footer();
}

function _print_approve_mod_error( $title )
{
	$this->_print_cp_header();
	$this->_print_bread_op( _WLS_MODREQUESTS, 'list_mod');
	$this->_print_title(    _WLS_MODREQUESTS );
	xoops_error( $title );
	$this->_print_error();
	$this->_print_cp_footer();
}

//---------------------------------------------------------
// ignore Modify Request
//---------------------------------------------------------
function del_mod()
{
	if ( !$this->_get_obj() )
	{
		$redirect = $this->_get_redirect_at_mod();
		redirect_header( $redirect, 3, _WLS_ERRORNOLINK );
		exit();
	}

	if( !$this->_check_token() ) 
	{
		$redirect = $this->_get_redirect_at_mod();
		redirect_header( $redirect, 3, _WLS_ERRORNOLINK );
		exit();
	}

	$mid = $this->get_post_mid();

	if ( $this->_delete_modify_by_mid($mid) )
	{
		if ( $this->_send_del_mod() )
		{
			$redirect = $this->_get_redirect_at_mod();
			redirect_header($redirect, 1, _WLS_MODREQDELETED);
		}
		else
		{
			$this->_print_del_mod_error( "Mailer Error" );
		}
	}
	else
	{
		$this->_print_del_mod_error( "DB Error" );
	}
}

function _send_del_mod()
{
	return true;	// dummy
}

function _print_del_mod_error( $title )
{
	$this->_print_cp_header();
	$this->_print_bread_op( _WLS_MODREQUESTS, 'list_mod');
	$this->_print_title(    _WLS_MODREQUESTS );
	xoops_error( $title );
	$this->_print_error();
	$this->_print_cp_footer();
}

//---------------------------------------------------------
// redirect URL
//---------------------------------------------------------
function _get_redirect_at_new()
{
	$total = $this->_handler->get_count_new();
	$ret   = 'link_list.php?sortid=1';

// jump same page when remain New link
	if ($total > 0)
	{
		$ret  = 'link_manage.php?op=list_new';
		$ret .= $this->_get_redirect_by_mid();
	}

	return $ret;

}

function _get_redirect_at_mod()
{
	$total = $this->_handler->get_count_mod();
	$ret   = 'link_list.php';

// jump same page when remain Mod link
	if ($total > 0)
	{
		$ret  = 'link_manage.php?op=list_mod';
		$ret .= $this->_get_redirect_by_mid();
	}

	return $ret;
}

function _get_redirect_by_mid()
{
	$ret = '';
	$mid = $this->get_post_mid();

	$obj =& $this->_handler->get($mid);
	if ( is_object($obj) )
	{
		$ret = '&amp;mid='.$mod;
	}

	return $ret;
}

//---------------------------------------------------------
// private print
//---------------------------------------------------------
function _print_menu()
{
	weblinks_admin_print_header();
	weblinks_admin_print_menu();
}

// --- class end ---
}

?>