<?php
// $Id: submit_form.php,v 1.4 2005/10/28 11:56:05 ohwada Exp $

// 2005-10-20 K.OHWADA
// REQ 3028: send apoval email to anonymous user
// add get_dir_mail_template() 

// 2005-08-09 K.OHWADA
// BUG 2828: submit form is not displayed correctly

// 2005-01-20 K.OHWADA
// use $weblinksConfig
// add zip, state, city, addr2, fax

//================================================================
// submit form
// divid from functions.php
// created since v0.9
// 2004-12-14 K.OHWADA
//================================================================

//-------------------------------------------------------------------
// submit form
//-------------------------------------------------------------------
function printSubmitForm($arr)
{

	global $MODULE_ROOT, $MODULE_URL;

	$SIZE_TEXT =  50;
	$MAX_TEXT  = 100;
	$SIZE_URL  =  80;
	$MAX_URL   = 250;

	global $weblinksConfig;
	$post_url     = $weblinksConfig['post_url'];
	$post_banner  = $weblinksConfig['post_banner'];
	$post_rss_url = $weblinksConfig['post_rss_url'];
	$post_name    = $weblinksConfig['post_name'];
	$post_mail    = $weblinksConfig['post_mail'];
	$post_company = $weblinksConfig['post_company'];
	$post_zip     = $weblinksConfig['post_zip'];
	$post_state   = $weblinksConfig['post_state'];
	$post_city    = $weblinksConfig['post_city'];
	$post_addr    = $weblinksConfig['post_addr'];
	$post_addr2   = $weblinksConfig['post_addr2'];
	$post_tel     = $weblinksConfig['post_tel'];
	$post_fax     = $weblinksConfig['post_fax'];
	$post_desc    = $weblinksConfig['post_desc'];
	$post_usercomment = $weblinksConfig['post_usercomment'];
	$type_desc    = $weblinksConfig['type_desc'];

	global $tbl_category;
	$selbox = $tbl_category->makeEditSelboxMulti( $arr['cid_arr'] );


// --- form start ---
	$builder = new xoops_form_extend();
	$builder->set_param_text(     $SIZE_TEXT, $MAX_TEXT );
	$builder->set_param_text_url( $SIZE_URL,  $MAX_URL  );
	$builder->start_theme_form( $arr['linkhead'], 'submitform' );

	$builder->add_hidden('updateflag', 1);	// update

	$builder->add_hidden('lid',          $arr['lid']);
	$builder->add_hidden('uid',          $arr['uid']);
	$builder->add_hidden('passwd',       $arr['passwd']);
	$builder->add_hidden('request',      $arr['request']);
	$builder->add_hidden('recommend',    $arr['recommend']);
	$builder->add_hidden('mutual',       $arr['mutual']);
	$builder->add_hidden('admincomment', $arr['admincomment']);

// title
	$builder->add_text( "* "._WLS_SITETITLE." *", 'title', $arr['title'], true );

// url
	if ( $post_url )
	{
		list($cap_url, $flag_url) = make_caption($post_url, _WLS_SITEURL);
		$builder->add_text_url( $cap_url, 'url', $arr['url'], $flag_url );
	}
	else
	{
		$builder->add_hidden('url', $arr['url']);
	}

// banner
	if ( $post_banner )
	{
		list($cap_banner, $flag_banner) = make_caption($post_banner, _WLS_BANNERURL);
		$builder->add_text_url( $cap_banner, 'banner', $arr['banner'], $flag_banner );
	}
	else
	{
		$builder->add_hidden('banner', $arr['banner']);
	}

// RSS/ATOM URL
	if ( $post_rss_url )
	{
		list($cap_rss_url, $flag_rss_url) = make_caption($post_rss_url, _WLS_RSS_URL);
		$builder->add_text_url_radio( $cap_rss_url, 'rss_url', $arr['rss_url'], 'rss_flag', $arr['rss_flag'], get_opt_rss_flag() );
	}
	else
	{
		$builder->add_hidden('rss_url',  $arr['rss_url']);
		$builder->add_hidden('rss_flag', $arr['rss_flag']);
	}

// name
	if ( $post_name )
	{
		list($cap_name, $flag_name) = make_caption($post_name, _WLS_NAME);
		$builder->add_text_radio( $cap_name, 'name', $arr['name'], 'nameflag', $arr['nameflag'], get_opt_name_mail_flag() );
	}
	else
	{
		$builder->add_hidden('name',     $arr['name']);
		$builder->add_hidden('nameflag', $arr['nameflag']);
	}

// mail
	if ( $post_mail )
	{
		global $xoopsUser;
		if ( is_object($xoopsUser) )
		{
			$mail_title = _WLS_EMAIL;
		}
		else
		{
			$mail_title = _WLS_EMAIL."<br />("._WLS_EMAIL_APPROVE.")";
		}

		list($cap_mail, $flag_mail) = make_caption($post_mail, $mail_title);
		$builder->add_text_radio($cap_mail, 'mail', $arr['mail'], 'mailflag', $arr['mailflag'], get_opt_name_mail_flag() );
	}
	else
	{
		$builder->add_hidden('mail',     $arr['mail']);
		$builder->add_hidden('mailflag', $arr['mailflag']);
	}

// company
	if ( $post_company )
	{
		list($cap_company, $flag_company) = make_caption($post_company, _WLS_COMPANY);
		$builder->add_text($cap_company, 'company', $arr['company'], $flag_company);
	}
	else
	{
		$builder->add_hidden('company', $arr['company']);
	}

// zip
	if ( $post_zip )
	{
		list($cap_zip, $flag_zip) = make_caption($post_zip, _WLS_ZIP);
		$builder->add_text($cap_zip, 'zip', $arr['zip'], $flag_zip);
	}
	else
	{
		$builder->add_hidden('zip', $arr['zip']);
	}

// state
	if ( $post_state )
	{
		list($cap_state, $flag_state) = make_caption($post_state, _WLS_STATE);
		$builder->add_text($cap_state, 'state', $arr['state'], $flag_state);
	}
	else
	{
		$builder->add_hidden('state', $arr['state']);
	}

// city
	if ( $post_city )
	{
		list($cap_city, $flag_city) = make_caption($post_city, _WLS_CITY);
		$builder->add_text($cap_city, 'city', $arr['city'], $flag_city);
	}
	else
	{
		$builder->add_hidden('city', $arr['city']);
	}

// addr
	if ( $post_addr )
	{
		list($cap_addr, $flag_addr) = make_caption($post_addr, _WLS_ADDR);
		$builder->add_text($cap_addr, 'addr', $arr['addr'], $flag_addr);
	}
	else
	{
		$builder->add_hidden('addr', $arr['addr']);
	}

// addr2
	if ( $post_addr2 )
	{
		list($cap_addr2, $flag_addr2) = make_caption($post_addr2, _WLS_ADDR2);
		$builder->add_text($cap_addr2, 'addr2', $arr['addr2'], $flag_addr2);
	}
	else
	{
		$builder->add_hidden('addr2', $arr['addr2']);
	}

// tel
	if ( $post_tel )
	{
		list($cap_tel, $flag_tel) = make_caption($post_tel, _WLS_TEL);
		$builder->add_text($cap_tel, 'tel', $arr['tel'], $flag_tel);
	}
	else
	{
		$builder->add_hidden('tel', $arr['tel']);
	}

// fax
	if ( $post_fax )
	{
		list($cap_fax, $flag_fax) = make_caption($post_fax, _WLS_FAX);
		$builder->add_text($cap_fax, 'fax', $arr['fax'], $flag_fax);
	}
	else
	{
		$builder->add_hidden('fax', $arr['fax']);
	}

// category
	$builder->add_label("* "._WLS_CATEGORY." *", make_category($selbox) );

// description
	if ( $post_desc )
	{
		list($cap_desc, $flag_desc) = make_caption($post_desc, _WLS_DESCRIPTION);

		if ( $type_desc )
		{
			$field_desc = new XoopsFormDhtmlTextArea($cap_desc, 'description_text', $arr['description'], 15, 60);
		}
		else
		{
			$field_desc = new XoopsFormTextArea($cap_desc, 'description_text', $arr['description'], 15, 60);
		}

		$builder->add_element( $field_desc, $flag_desc );
	}
	else
	{
		$builder->add_hidden('description_text', $arr['description']);
	}

// user comment
	if ($post_usercomment)
	{
		list($cap_usercomment, $flag_usercomment) = make_caption($post_usercomment, _WLS_USER_COMMENT);
		$cap_usercomment = $builder->make_caption( $cap_usercomment, _WLS_NOT_DISPLAY );
		$builder->add_textarea($cap_usercomment, 'usercomment', $arr['usercomment'], $flag_usercomment);
	}
	else
	{
		$builder->add_hidden('usercomment', $arr['usercomment']);
	}

	if ( $arr['notify_show'] )
	{
		$opt_notify = array( 1 => ' '._WLS_NOTIFYAPPROVE );
		$builder->add_checkbox_array(_WLS_OPTIONS, 'notify', $arr['notify'], $opt_notify);
	}

// BUG 2828: submit form is not displayed correctly
// not use add_tray_xxx
//	$builder->start_tray('');
//	$builder->add_tray_submit_button('', 'post',    $arr['post'] );
//	$builder->add_tray_submit_button('', 'preview', _PREVIEW );
//	$builder->add_tray_cancel_button('', 'cancel',  _CANCEL );

// button
	$tray_button = new XoopsFormElementTray( '' );
	$tray_button->addElement( $builder->make_submit_button( '', 'post',    $arr['post']  ) );
	$tray_button->addElement( $builder->make_submit_button( '', 'preview', _PREVIEW ) );
	$tray_button->addElement( $builder->make_cancel_button( '', 'cancel',  _CANCEL ) );
	$builder->add_element( $tray_button );

//	if ( $arr['flag_ignore'] == 2 )
//	{
//		$builder->add_submit_button('', 'ignore', 'ignore' );
//	}

//	$builder->add_element_tray();

	$builder->display();
// --- form start ---

}

function make_caption($use, $cap)
{
	$flag = false;

	if ($use == 2)
	{
		$cap  = "* $cap *";
		$flag = true;
	}

	return array($cap, $flag);
}

function get_opt_rss_flag()
{
	$opt = array(
		0 => _WLS_RSS_URL_0,
		3 => _WLS_RSS_URL_3,
		1 => _WLS_RSS_URL_1,
		2 => _WLS_RSS_URL_2,
	);

	return $opt;
}

function get_opt_name_mail_flag()
{
	$opt = array(
		0 => _WLS_NOTPUBLIC,
		1 => _WLS_PUBLIC,
	);

	return $opt;
}

function make_category($selbox)
{
	global $MODULE_URL;

	$file_popup = $MODULE_URL.'/catlist_popup.php';
	$value  = "<a href='#catlist' onclick='javascript:openWithSelfMain(\"$file_popup\",\"help\",400,500);'>"._WLS_CATLIST."</a><br />";
	$value .= $selbox;

	return $value;
}


//-------------------------------------------------------------------
// REQ 3028: send apoval email to anonymous user
// get_dir_mail_template
//-------------------------------------------------------------------
function get_dir_mail_template($file_tpl) 
{
	global $xoopsConfig, $xoopsModule;
	global $MODULE_URL;

	$MODULE_ROOT = XOOPS_ROOT_PATH."/modules/".$xoopsModule->dirname();

	$dir_tpl_lang = $MODULE_ROOT."/language/".$xoopsConfig['language']."/mail_template/";

	if ( file_exists( $dir_tpl_lang.$file_tpl ) )
	{
		return $dir_tpl_lang;
	}
	else
	{
		return $MODULE_ROOT."/language/english/mail_template/";
	}
}


?>