<?php
// $Id: module_base.php,v 1.3 2005/10/28 11:56:02 ohwada Exp $

// 2005-01-20 K.OHWADA
// add prepare_strip_tags()

// 2004-12-31 K.OHWADA
// add $module_name $xoops_module_name
// $xoops_site_language -> $xoops_site_lang_code

//=========================================================
// class module_base
// divid from link.php
// created since v0.8
// 2004-11-28 K.OHWADA
//=========================================================

class module_base
{
// module parameter
	var $module_name;
	var $module_dirname;
	var $module_root;
	var $module_url;

// system parameter
	var $xoops_site_lang_code;
	var $xoops_site_language;
	var $xoops_site_url;
	var $xoops_site_name;
	var $xoops_site_email;
	var $xoops_site_slogan;
	var $xoops_site_author;
	var $xoops_site_description;
	var $xoops_site_anonymous;
	var $xoops_group_list;
	var $xoops_module_dirname;
	var $xoops_module_name;

// user parameter
	var $is_xoops_user_admin;
	var $xoops_user_uid;
	var $xoops_user_uname;
	var $xoops_user_email;
	var $xoops_user_groups;

// user list
	var $xoops_uid_list;
	var $xoops_user_list;

	var $table;
	var $newid;

// error msg
	var $error_msg_arr;
   	var $error_msg_flag;

// class instance
	var $xoops_db;
	var $xoops_myts;
	var $lang;

// debug
	var $flag_print_db_error = 1;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function module_base( $tablename='' )
{
	$this->set_xoops_system_param();
	$this->set_module_param();
	$this->set_system_instance();

	$this->set_tablename( $tablename );

}

function &getInstance()
{
// dummy
}

function set_system_instance()
{
// For called by bin. 
// Don't incorporate, if the corresponding class does not exist.

	if ( class_exists('Database') )
	{
		$this->xoops_db =& Database::getInstance();
	}

	if ( class_exists('MyTextSanitizer') )
	{
		$this->xoops_myts =& MyTextSanitizer::getInstance();
	}

	if ( class_exists('language_convert') )
	{
		$this->lang =& language_convert::getInstance();
	}
}

//---------------------------------------------------------
// set_module_param
//---------------------------------------------------------
function set_module_param()
{
	if ( $this->xoops_module_name )
	{
		$name = $this->xoops_module_name;
	}
	else
	{
		$name = WEBLINKS_NAME;
	}

	if ( $this->xoops_module_dirname )
	{
		$dirname = $this->xoops_module_dirname;
	}
	else
	{
		$dirname = WEBLINKS_MODULE_NAME;
	}

	$this->module_name    = $name;
	$this->module_dirname = $dirname;
	$this->module_root    = XOOPS_ROOT_PATH."/modules/".$dirname;
	$this->module_url     = XOOPS_URL."/modules/".$dirname;
}

//---------------------------------------------------------
// make field value
//---------------------------------------------------------
function make_field_value($array)
{
	if ( !is_array($array) )  return;

	foreach($array as $key => $value)
	{  $this->$key = $value;  }
}

function set_field_value($array, $key)
{
	$this->set_field_value_text($array, $key);
}

function set_field_value_text($array, $key)
{
   	if ( isset($array[$key]) )
	{  $this->$key = $array[$key];  }
}

function set_field_value_intval($array, $key)
{
   	if ( isset($array[$key]) )
	{  $this->$key = intval( $array[$key] );  }
}

function set_field_value_addslashes($array, $key)
{
   	if ( isset($array[$key]) )
	{  $this->$key = addslashes( $array[$key] );  }
}

function set_field_value_url($array, $key)
{
	if ( isset($array[$key]) && ( $array[$key] != "http://" ) )
	{  $this->$key = addslashes( $array[$key] );  }
}

function get_field_value($value)
{
	return $this->$value;
}


//---------------------------------------------------------
// convert_list_to_array
//---------------------------------------------------------
function convert_list_to_array($list, $pattern='&')
{
	$list_arr = split($pattern, $list);

	$i = 0;	
	$arr = array();
	foreach ($list_arr as $value)
	{
		$value = trim($value);
		if ($value == '')  continue;
		$arr[$i++] = $value;
	}

	return $arr;
}

function convert_array_to_list($arr, $pattern='&')
{
	if ( is_array($arr) )
	{
		$list = $pattern;

		foreach ($arr as $value)
		{
			$list .= intval($value).$pattern;
		}
	}
	elseif ( is_int($arr) )
	{
		$list = $pattern.intval($arr).$pattern;
	}
	else
	{
		$list = $arr;
	}

	return $list;
}

//---------------------------------------------------------
// image
//---------------------------------------------------------
function build_image_link($image_url, $width=0, $height=0, $border=0, $alt='image')
{
	if ( !$image_url )               return false;
	if (  $image_url == "http://" )  return false;

	$image_p = htmlspecialchars($image_url, ENT_QUOTES);

	$link  = "<img ";
	$link .= "src='$image_p' ";

	if ($width)
	{	$link .= "width='$width' ";	}

	if ($height)
	{	$link .= "height='$height' ";	}

	$link .= "border='$border' ";
	$link .= "alt='$alt' ";
	$link .= "/>";

	return $link;
}

//---------------------------------------------------------
// convert array from utf8
//---------------------------------------------------------
function convert_array_array_from_utf8($in_arr)
{
	$out_arr = array();

	foreach ($in_arr as $key => $value)
	{
		$out_arr[$key] = $this->convert_array_from_utf8($value);
	}

	return $out_arr;
}

function convert_array_from_utf8($in_arr)
{
	$out_arr = array();

	foreach ($in_arr as $key => $value)
	{
		$out_arr[$key] = $this->convert_from_utf8($value);
	}

	return $out_arr;
}

//---------------------------------------------------------
// convert array to utf8
//---------------------------------------------------------
function convert_array_array_to_utf8($in_arr)
{
	$out_arr = array();

	foreach ($in_arr as $key => $value)
	{
		$out_arr[$key] = $this->convert_array_to_utf8($value);
	}

	return $out_arr;
}

function convert_array_to_utf8($in_arr)
{
	$out_arr = array();

	foreach ($in_arr as $key => $value)
	{
		$out_arr[$key] = $this->convert_to_utf8($value);
	}

	return $out_arr;
}

function convert_to_utf8($value)
{
	$value = $this->strip_control_code($value);
	$value = xoops_utf8_encode($value);	// system function
	return $value;
}

// --------------------------------------------------------
// strip control code
// except 0A,0D (return code)
// --------------------------------------------------------
function strip_control_code($text)
{
	$text = preg_replace('/[\x00-\x09]/',' ',$text);
	$text = preg_replace('/[\x0B-\x0C]/',' ',$text);
	$text = preg_replace('/[\x0E-\x1F]/',' ',$text);
	$text = preg_replace('/[\x7F]/',     ' ',$text);
	return $text;
}

function prepare_strip_tags($text)
{
	$text = str_replace(">", "> ", $text);
	return $text;
}

//---------------------------------------------------------
// make_passwd
//---------------------------------------------------------
function make_passwd_md5()
{
	return md5( $this->make_passwd() );
}

function make_passwd()
{
	srand( (double)microtime()*1000000 );
	return rand(10000000,99999999);
}


//-------------------------------------------------------------------
// HTML link
//-------------------------------------------------------------------
function make_html_link_name($url, $name='', $target='' )
{
	$url  = $this->conv_js( $url );
	$url  = $this->makeData4Show( $url );
	$name = $this->makeData4Show( $name );
	
	if ( $url && $name && $target )
	{
		$link = "<a href='".$url."' target='".$target."'>".$name."</a>";
	}
	elseif ( $url && $name )
	{
		$link = "<a href='".$url."'>".$name."</a>";
	}
	elseif ( $url && $target )
	{
		$link = "<a href='".$url."' target='".$target."'>".$url."</a>";
	}
	elseif ( $url )
	{
		$link = "<a href='".$url."'>".$url."</a>";
	}
	elseif ( $name )
	{
		$link = $name;
	}
	else
	{
		$link = '';
	}

	return $link;
}

function make_html_link_email($url, $name='', $target='' )
{
	$url  = $this->conv_js( $url );
	$url  = $this->makeData4Show( $url );
	$name = $this->makeData4Show( $name );

	if ( $url && $name &&  $target )
	{
		$link = "<a href='mailto:".$url."' target='".$target."'>".$name."</a>";
	}
	elseif ( $url && $name )
	{
		$link = "<a href='mailto:".$url."'>".$name."</a>";
	}
	elseif ( $url &&  $target )
	{
		$link = "<a href='mailto:".$url."' target='".$target."'>".$url."</a>";
	}
	elseif ( $url )
	{
		$link = "<a href='mailto:".$url."'>".$url."</a>";
	}
	elseif ( $name )
	{
		$link = $name;
	}
	else
	{
		$link = '';
	}

	return $link;
}

function makeData4Show($text)
{
	return htmlspecialchars($text,  ENT_QUOTES);
}

//-------------------------------------
// measures for XSS
//-------------------------------------
function conv_js($text)
{
	return preg_replace('/javascript:/si' , 'java script:', $text);
}

//-------------------------------------------------------------------
// error message
//-------------------------------------------------------------------
function clear_error_msg()
{
	$this->error_msg_arr  = array();
	$this->error_msg_flag = false;	// no error
}

function set_error_msg($msg)
{
	$this->error_msg_arr[] = $msg;
	$this->error_msg_flag  = true;	// error
}

function get_error_msg_array()
{
	return $this->error_msg_arr;
}

function get_error_msg()
{
	$text = '';

	foreach( $this->error_msg_arr as $msg )
	{
		$text .= $this->make_error_msg($msg);
	}

	return $text;
}

function get_error_msg_2()
{
	$text  = "<H4>$this->xoops_site_name</h4>";
	$text .= $this->get_error_msg();
	$text .= "[ <a href='JavaScript:history.back()'>"._BACK."</a> ]";
	return $text;
}

function make_error_msg($msg)
{
	$msg = "<h4 style='color: #ff0000'>$msg</h4>\n";
	return $msg;
}

//=========================================================
// use class ConvertLanguage
//=========================================================
//function convert_telafriend_body($text)
//function convert_download_filename($text)
//function convert_space_zen_to_han($text)
//function convert_encode_to_utf8($text, $encode)

function convert_from_utf8($text)
{
	return $this->lang->convert_from_utf8($text);
}

function shorten_text($text, $max=100)
{
	return $this->lang->shorten_text($text, $max);
}


//=========================================================
// use Database class
//=========================================================
function set_tablename( $tablename='' )
{
	if ($tablename)
	{
		$this->table_short_name = $tablename;
		$this->table = $this->xoops_db->prefix( $this->module_dirname."_".$tablename );
	}

}

function query_insert($sql)
{
	$this->newid = 0;

	$ret = $this->query_false($sql);
	if (!$ret) return false;

	$this->newid = $this->xoops_db->getInsertId();
	return true;
}

function query_false($sql)
{
	$result = $this->xoops_db->queryF($sql);
	if ( !$result )
	{
		$this->_print_db_error($sql);
		return false; 
	}

	return true;
}

function query($sql)
{
	$result = $this->xoops_db->queryF($sql);
	if ( !$result )
	{
		$this->_print_db_error($sql);
		return false; 
	}

	return $result;
}

function get_num_by_sql($sql)
{
	$result = $this->xoops_db->query($sql);
	if ( !$result )
	{
		$this->_print_db_error($sql);
		return false;
	}

	$array  = $this->xoops_db->fetchRow( $result );
	$num    = $array[0];
	if (empty($num)) $num = 0;

	$this->xoops_db->freeRecordSet($result);

	return $num;
}

function get_row_by_sql($sql)
{
	$result = $this->xoops_db->query($sql);
	$array  = $this->xoops_db->fetchArray( $result );
	$this->make_field_value($array);
	return $array;
}

function get_row_array_by_sql($sql,$limit=0,$offset=0)
{
	$result = $this->xoops_db->query($sql,$limit,$offset);
	if ( !$result )
	{
		$this->_print_db_error($sql);
		return false; 
	}

	$i = 0;
	$rec = array();
	while ( $row = $this->xoops_db->fetchArray($result) ) 
	{  $rec[$i++] = $row;  }

	$this->xoops_db->freeRecordSet($result);

	return $rec;
}

function get_first_row_by_sql($sql,$limit=0,$offset=0)
{
	$result = $this->xoops_db->query($sql,$limit,$offset);
	if ( !$result )
	{
		$this->_print_db_error($sql);
		return false; 
	}

	$i = 0;
	$rec = array();
	while ( $row = $this->xoops_db->fetchRow($result) ) 
	{  $rec[$i++] = $row[0];  }

	$this->xoops_db->freeRecordSet($result);

	return $rec;
}

//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function getNewid()
{
	return $this->newid;
}

//---------------------------------------------------------
// debug
//---------------------------------------------------------
function _print_db_error($sql='')
{
	if ( !$this->flag_print_db_error )  return;

	if ($sql)
	{
		echo "sql: $sql <br />\n";
	}

	echo "error: ".$this->xoops_db->error()," <br />\n";	
}

//=========================================================
// use MyTextSanitizer class
//=========================================================
function get_field_value_text($name, $format='')
{
	if ( !isset( $this->$name ) )  return false;
	return $this->make_text_to_format($this->$name, $format);
}

function get_field_value_textarea($name, $format='')
{
	if ( !isset( $this->$name ) )  return false;
	return $this->make_textarea_to_format($this->$name, $format);
}

function make_text_to_format($value, $format='')
{
	switch($format)
	{
		case "S":
			$ret = $this->xoops_myts->makeTboxData4Show($value);
			break;

		case "E":
			$ret = $this->xoops_myts->makeTboxData4Edit($value);
			break;

		case "P":
			$ret = $this->xoops_myts->makeTboxData4Preview($value);
			break;

		case "F":
			$ret = $this->xoops_myts->makeTboxData4PreviewInForm($value);
			break;

		default:
			$ret = $value;
			break;

	}

	return $ret;
}

function make_textarea_to_format($value, $format='')
{
	switch($format)
	{
		case "S":
			$ret = $this->xoops_myts->makeTareaData4Show($value);
			break;

		case "E":
			$ret = $this->xoops_myts->makeTareaData4Edit($value);
			break;

		case "P":
			$ret = $this->xoops_myts->makeTareaData4Preview($value);
			break;

		case "F":
			$ret = $this->xoops_myts->makeTareaData4PreviewInForm($value);
			break;

		default:
			$ret = $value;
			break;
	}

	return $ret;
}

//=========================================================
// use $xoopsConfig
// use xoops_gethandler
// use $xoopsUser, $xoopsModule;
//=========================================================
function set_xoops_system_param()
{
	$this->xoops_site_url         = '';
	$this->xoops_site_language    = '';
	$this->xoops_site_lang_code   = '';
	$this->xoops_site_author      = '';
	$this->xoops_site_description = '';
	$this->xoops_group_list       = '';
	$this->xoops_site_name        = '';
	$this->xoops_site_email       = '';
	$this->xoops_site_slogan      = '';
	$this->xoops_module_dirname   = '';
	$this->xoops_module_name      = '';
	$this->xoops_user_uname       = '';
	$this->xoops_user_email       = '';
	$this->xoops_user_groups      = '';
	$this->xoops_user_uid         = 0;
	$this->is_xoops_user_admin    = false;

	if ( defined("XOOPS_URL") )
	{
		$this->xoops_site_url = XOOPS_URL.'/';
	}

	if ( defined("_LANGCODE") )
	{
		$this->xoops_site_lang_code = _LANGCODE;
	}

	if ( function_exists('xoops_gethandler') )
	{
		$config_handler =& xoops_gethandler('config');
		$xoopsConfigMetaFooter =& $config_handler->getConfigsByCat(XOOPS_CONF_METAFOOTER);
		$this->xoops_site_author      = $xoopsConfigMetaFooter['meta_author'];
		$this->xoops_site_description = $xoopsConfigMetaFooter['meta_description'];

		$member_handler =& xoops_gethandler('member');
		$this->xoops_group_list = $member_handler->getGroupList();
	}

	global $xoopsConfig;
	if ( is_array($xoopsConfig) )
	{
		$this->xoops_site_name      = $xoopsConfig['sitename'];
		$this->xoops_site_email     = $xoopsConfig['adminmail'];
		$this->xoops_site_slogan    = $xoopsConfig['slogan'];
		$this->xoops_site_language  = $xoopsConfig['language'];
 		$this->xoops_site_anonymous = $xoopsConfig['anonymous'];
 	}

	global $xoopsModule;
	if ( is_object($xoopsModule) )
	{
		$this->xoops_module_dirname = $xoopsModule->dirname();
		$this->xoops_module_name    = $xoopsModule->getVar('name');
	}

	global $xoopsUser;
	if ( is_object($xoopsUser) )
	{
		if ( $xoopsModule && $xoopsUser->isAdmin( $xoopsModule->mid() )) 
		{
			$this->is_xoops_user_admin = true;
		}

		$this->xoops_user_uid    = $xoopsUser->getVar('uid');
		$this->xoops_user_uname  = $xoopsUser->getVar('uname');
		$this->xoops_user_email  = $xoopsUser->getVar('email');
		$this->xoops_user_groups = $xoopsUser->getGroups();

	}
	else
	{
		$this->xoops_user_groups = array( XOOPS_GROUP_ANONYMOUS );
	}

}

function get_xoops_user_param_by_uid($uid)
{
	$email = '';

	$uname = XoopsUser::getUnameFromId($uid);

	if ($uid)
	{
		$sql = "select email from ".$this->xoops_db->prefix("users")." where uid='$uid'";
		$res = $this->xoops_db->query($sql);
		list($email) = $this->xoops_db->fetchRow($res);
	}

	return array($uname, $email);
}

function get_xoops_user_list()
{
	$this->xoops_uid_list  = array();
	$this->xoops_user_list = array();

	$sql = "SELECT * FROM ".$this->xoops_db->prefix("users")." ORDER BY uid";
	$res = $this->xoops_db->query($sql);

	while ( $row = $this->xoops_db->fetchArray($res) )
	{
		$uid   = $row['uid'];
		$uname = $row['uname'];
		$email = $row['email'];

		$this->xoops_uid_list[]               = $uid;
		$this->xoops_user_list[$uid]['uname'] = $uname;
		$this->xoops_user_list[$uid]['email'] = $email;
	}

	$this->xoops_user_list[0]['uname'] = $this->xoops_site_anonymous;
	$this->xoops_user_list[0]['email'] = '';

	return $this->xoops_user_list;
}

function get_xoops_uid_list()
{
	return $this->xoops_uid_list;
}

//---------------------------------------------------------
}
?>
