<?php
// $Id: table_link_base.php,v 1.3 2005/10/28 11:56:02 ohwada Exp $

// 2005-01-20 K.OHWADA
// use class image_size, remote_file
// add updateImageSize()
// add $updateflag
// add zip, state, city, addr2, fax

//=========================================================
// class table_link_base
// divid from link.php
// created since v0.9
// 2004-11-28 K.OHWADA
//=========================================================
class table_link_base extends module_base
{
// table field
	var $lid;
	var $uid;
	var $cids;	// for modify
	var $title;
	var $url;
	var $banner;
	var $name;
	var $nameflag;
	var $mail;
	var $mailflag;
	var $company;
	var $addr;
	var $tel;
	var $description;
	var $search;
	var $passwd;
	var $admincomment;
	var $mark;	// not use
	var $time_create;
	var $time_update;
	var $hits;
	var $rating;
	var $votes;
	var $comments;
	var $width;
	var $height;
	var $recommend;
	var $mutual;
	var $broken;
	var $rss_url;
	var $rss_flag;
	var $rss_xml;
	var $rss_update;
	var $usercomment;
	var $zip;
	var $state;
	var $city;
	var $addr2;
	var $fax;

// local
	var $cid_arr;

// display
	var $image_url;
	var $image_link_width;
	var $image_link_height;
	var $image_list_width;
	var $image_list_height;
	var $image_list_width_5;

// edit
	var $name_edit;
	var $mail_edit;
	var $nameflag_edit;
	var $mailflag_edit;
	var $usercomment_edit;

// preview
	var $updateflag;

// class instance
	var $tbl_category;
	var $tbl_catlink;
	var $tbl_catlink_table;
	var $image;
	var $remote;

// xoopsModuleConfig
	var $config_listimage_width;
	var $config_listimage_height;
	var $config_linkimage_width;
	var $config_linkimage_height;


//-----------------------------------------------
// This is for lower compatibility of mylinks
//-----------------------------------------------
	var $shotdir = 'images/shots/';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function table_link_base($name)
{
	module_base::module_base( $name );

	global $xoopsModuleConfig;
	$this->config_listimage_width  = $xoopsModuleConfig['listimage_width'];
	$this->config_listimage_height = $xoopsModuleConfig['listimage_height'];
	$this->config_linkimage_width  = $xoopsModuleConfig['linkimage_width'];
	$this->config_linkimage_height = $xoopsModuleConfig['linkimage_height'];

// depress unnecessary warning
	$this->banner     = '';
	$this->width      = 0;
	$this->height     = 0;
	$this->updateflag = 0;

	$this->set_instance_base();

}

function set_instance_base()
{
// For called by bin. 
// Don't incorporate, if the corresponding class does not exist.

	if ( class_exists('table_category') )
	{
		$this->tbl_category =& table_category::getInstance();
	}

	if ( class_exists('table_catlink') )
	{	
		$this->tbl_catlink  =& table_catlink::getInstance();
		$this->tbl_catlink_table = $this->tbl_catlink->table;
	}

	if ( class_exists('image_size') )
	{
		$this->image =& image_size::getInstance();
	}

	if ( class_exists('remote_file') )
	{
		$this->remote =& remote_file::getInstance();
	}
}

//---------------------------------------------------------
// add new link
// for submit.php
//---------------------------------------------------------
function addLinkLink( $post )
{
	$this->clear_items(); 
	$this->set_items( $post );
	$this->uid = $this->xoops_user_uid;	// new owner

	$this->make_tbox_data_4_save();
	$this->get_and_set_banner_size();

	return $this->insert();
}

function addLinkLinkAppove( $post )
{
	$this->clear_items(); 
	$this->set_items( $post );

	$this->make_tbox_data_4_save();
	$this->get_and_set_banner_size();

	return $this->insert();
}

function clear_items()
{
	$this->lid       = 0;
	$this->uid       = 0;
	$this->nameflag  = 0;
	$this->mailflag  = 0;
	$this->width     = 0;
	$this->height    = 0;
	$this->recommend = 0;
	$this->mutual    = 0;
	$this->broken    = 0;
	$this->rss_flag  = 0;

	$this->cids    = '';
	$this->url     = '';
	$this->title   = '';
	$this->name    = '';
	$this->mail    = '';
	$this->company = '';
	$this->zip     = '';
	$this->state   = '';
	$this->city    = '';
	$this->addr    = '';
	$this->addr2   = '';
	$this->tel     = '';
	$this->fax     = '';
	$this->banner  = '';
	$this->description  = '';
	$this->admincomment = '';
	$this->usercomment  = '';
	$this->rss_url      = '';

	$time = time();
	$this->time_create = $time;
	$this->time_update = $time;

	$this->cid_arr = array();

// preview
	$this->hits       = 0;
	$this->rating     = 0;
	$this->votes      = 0;
	$this->comments   = 0;

// admin
	$this->updateflag = 0;

}

function set_items($array)
{

// int
	$this->set_field_value_intval($array, 'lid');
	$this->set_field_value_intval($array, 'uid');
	$this->set_field_value_intval($array, 'nameflag');
	$this->set_field_value_intval($array, 'mailflag');
	$this->set_field_value_intval($array, 'time_create');
	$this->set_field_value_intval($array, 'recommend');
	$this->set_field_value_intval($array, 'mutual');
	$this->set_field_value_intval($array, 'broken');
	$this->set_field_value_intval($array, 'rss_flag');
	$this->set_field_value_intval($array, 'updateflag');

// not update
	if ( isset($array['time_update']) && ( $this->updateflag == 0 ) )
	{
		$this->time_update = intval($array['time_update']);
	}
// update
	else
	{
		$this->time_update = time();
	}

// text
	$this->set_field_value_text($array, 'title');
	$this->set_field_value_text($array, 'name');
	$this->set_field_value_text($array, 'mail');
	$this->set_field_value_text($array, 'company');
	$this->set_field_value_text($array, 'zip');
	$this->set_field_value_text($array, 'state');
	$this->set_field_value_text($array, 'city');
	$this->set_field_value_text($array, 'addr');
	$this->set_field_value_text($array, 'addr2');
	$this->set_field_value_text($array, 'tel');
	$this->set_field_value_text($array, 'fax');
	$this->set_field_value_text($array, 'admincomment');
	$this->set_field_value_text($array, 'usercomment');

	if ( isset($array['description']) )
	{	
		$this->description = $array['description'];
	}
	elseif ( isset($array['description_text']) )
	{
		$this->description = $array['description_text'];
	}

// URL
	$this->set_field_value_url($array, 'url');
	$this->set_field_value_url($array, 'banner');
	$this->set_field_value_url($array, 'rss_url');

// cid array
	if ( isset($array['cid']) )
	{	
		$this->cid_arr = $this->_make_cid_array( $array['cid'] );
	}

}

function _make_cid_array($array)
{
	$cid_arr = array();

	if (is_array($array))
	{
		foreach ($array as $cid)
		{
			$cid = intval($cid);
			if ($cid != 0)
			{
				$cid_arr[] = $cid;
			}
		}
	}
	else
	{
		$cid = intval($array);
		if ($cid != 0)
		{
			$cid_arr[] = $cid;
		}
	}

	$cid_arr = array_unique($cid_arr);

	return $cid_arr;
}

function make_tbox_data_4_save()
{
	$this->search  = $this->make_search();	// this statement first

	$this->title   = $this->xoops_myts->makeTboxData4Save($this->title);
	$this->url     = $this->xoops_myts->makeTboxData4Save($this->url);
	$this->banner  = $this->xoops_myts->makeTboxData4Save($this->banner);
	$this->name    = $this->xoops_myts->makeTboxData4Save($this->name);
	$this->mail    = $this->xoops_myts->makeTboxData4Save($this->mail);
	$this->company = $this->xoops_myts->makeTboxData4Save($this->company);
	$this->zip     = $this->xoops_myts->makeTboxData4Save($this->zip);
	$this->state   = $this->xoops_myts->makeTboxData4Save($this->state);
	$this->city    = $this->xoops_myts->makeTboxData4Save($this->city);
	$this->addr2   = $this->xoops_myts->makeTboxData4Save($this->addr2);
	$this->tel     = $this->xoops_myts->makeTboxData4Save($this->tel);
	$this->fax     = $this->xoops_myts->makeTboxData4Save($this->fax);
	$this->rss_url = $this->xoops_myts->makeTboxData4Save($this->rss_url);
	$this->description  = $this->xoops_myts->makeTareaData4Save($this->description);
	$this->admincomment = $this->xoops_myts->makeTareaData4Save($this->admincomment);

}

//---------------------------------------------------------
// edit display
//---------------------------------------------------------
function make_data_4_edit()
{
	$arr_out = array(

// over write
		'linkhead' => '',
		'post'     => '',
		'passwd'   => '',
		'user'     => '',
		'cid_arr'  => '',
		'notify_show' => 0,

// table field
		'lid'       => $this->lid,
		'uid'       => $this->uid,
		'recommend' => $this->recommend,
		'mutual'    => $this->mutual,
		'rss_flag'  => $this->rss_flag,

		'url'       => $this->xoops_myts->makeTboxData4Edit($this->url),
		'banner'    => $this->xoops_myts->makeTboxData4Edit($this->banner),
		'rss_url'   => $this->xoops_myts->makeTboxData4Edit($this->rss_url),
		'title'     => $this->xoops_myts->makeTboxData4Edit($this->title),
		'company'   => $this->xoops_myts->makeTboxData4Edit($this->company),
		'zip'       => $this->xoops_myts->makeTboxData4Edit($this->zip),
		'state'     => $this->xoops_myts->makeTboxData4Edit($this->state),
		'city'      => $this->xoops_myts->makeTboxData4Edit($this->city),
		'addr'      => $this->xoops_myts->makeTboxData4Edit($this->addr),
		'addr2'     => $this->xoops_myts->makeTboxData4Edit($this->addr2),
		'tel'       => $this->xoops_myts->makeTboxData4Edit($this->tel),
		'fax'       => $this->xoops_myts->makeTboxData4Edit($this->fax),

		'description'  => $this->xoops_myts->makeTareaData4Edit($this->description),
		'admincomment' => $this->xoops_myts->makeTareaData4Edit($this->admincomment),

// arrenge
		'nameflag' => $this->nameflag_edit,
		'mailflag' => $this->mailflag_edit,

		'name'     => $this->xoops_myts->makeTboxData4Edit($this->name_edit),
		'mail'     => $this->xoops_myts->makeTboxData4Edit($this->mail_edit),

		'usercomment' => $this->xoops_myts->makeTareaData4Edit($this->usercomment_edit),

		);

	return $arr_out;
}

function make_data_4_edit_admin()
{
	list($link_uname, $link_email) = $this->make_xoops_guest_link($this->uid);

	$rating  = number_format($this->rating, 2);
	$update  = formatTimestamp($this->time_update, "m");
	$create  = formatTimestamp($this->time_create, "m");

	$arr_out = array(
		'mid' => 0,

		'link_uname'   => $link_uname,
		'link_email'   => $link_email,
		'rating'       => $rating,
		'updated'      => $update,
		'created'      => $create,

		'hits'         => $this->hits,
		'votes'        => $this->votes,
		'broken'       => $this->broken,
		'time_update'  => $this->time_update,
		'time_create'  => $this->time_create,
		'updateflag'   => $this->updateflag,

		);

	return $arr_out;
}

function make_name_mail_edit($owner=0)
{

	if ($owner)
	{
		$this->make_name_mail_edit_for_owner();
	}
	else
	{
		$this->make_name_mail_edit_for_others();
	}
}

function make_name_mail_edit_for_owner()
{
	$this->name_edit     = $this->name;
	$this->mail_edit     = $this->mail;
	$this->nameflag_edit = $this->nameflag;
	$this->mailflag_edit = $this->mailflag;
	$this->usercomment_edit = $this->usercomment;
}

function make_name_mail_edit_for_others()
{
	$this->name_edit     = '';
	$this->mail_edit     = '';
	$this->nameflag_edit = 0;
	$this->mailflag_edit = 0;

	if ($this->nameflag == 1)
	{
		$this->name_edit     = $this->name;
		$this->nameflag_edit = 1;
	}

	if ($this->mailflag == 1)
	{
		$this->mail_edit     = $this->mail;
		$this->mailflag_edit = 1;
	}

	$this->usercomment_edit = '';
}

function make_xoops_guest_link($uid)
{

	list($uname, $email) = $this->get_xoops_user_param_by_uid($uid);

	if ($uid == 0)
	{
		$link_uname = $uname;
		$link_email = '';
	}
	else
	{
		$url = XOOPS_URL."/userinfo.php?uid=".$uid;
		$link_uname = $this->make_html_link_name( $url, $uname, '_blank' );

		if ( $email )
		{
			$link_email = $this->make_html_link_email( $email, '', '_blank' );
		}
		else
		{
			$link_email = '';
		}
	}

	return array($link_uname, $link_email);
}


//=========================================================
// use cateogry class
//=========================================================
// for submit.php
function makeTagsAddLink($newid)
{
	$cid   = $this->cid_arr[0];
	$title = $this->title;
	$row   = $this->tbl_category->getRowByCid($cid);

	$tags = array();
	$tags['LINK_NAME'] = $title;
	$tags['LINK_URL']  = $this->module_url."/singlelink.php?lid=$newid";
	$tags['CATEGORY_NAME'] = $row['title'];
	$tags['CATEGORY_URL']  = $this->module_url."/viewcat.php?cid=$cid";

	return array($tags,$cid);
}

function make_search()
{
	$path_array = $this->tbl_category->getAll();

	$search  = '';
	$search .= "$this->url ";
	$search .= "$this->title ";
	$search .= "$this->company ";
	$search .= "$this->zip ";
	$search .= "$this->state ";
	$search .= "$this->city ";
	$search .= "$this->addr ";
	$search .= "$this->addr2 ";
	$search .= "$this->tel ";
	$search .= "$this->fax ";
	$search .= "$this->description ";

	if ($this->nameflag) $search .= "$this->name ";
	if ($this->mailflag) $search .= "$this->mail ";

// change a category path
	foreach ($this->cid_arr as $cid)
	{
		$path_array = $this->tbl_category->getParentPath($cid);
	
		foreach ($path_array as $path)
		{
			$search .= $path['title']." ";
		}
	}

	$search = preg_replace("/\n|\r/",' ',$search);
	$search = $this->xoops_myts->makeTboxData4Save($search);

	return $search;
}

//=========================================================
// use catlink class
//=========================================================
function get_cid_array_from_catlink($lid=0)
{
	if (empty($lid)) $lid = $this->lid;

	return $this->tbl_catlink->getCidArrayByLid($lid);
}

//=========================================================
// image
//=========================================================
function get_and_set_banner_size()
{
	$image_url = $this->assume_banner_url();
	list($this->width, $this->height) = $this->remote->get_image_size($image_url);

	return;
}

function make_image($image_data='')
{
	$this->image_url          = '';
	$this->image_link_width   = 0;
	$this->image_link_height  = 0;
	$this->image_list_width   = 0;
	$this->image_list_height  = 0;
	$this->image_list_width_5 = 0;

	$image_url    = '';
	$link_width   = 0;
	$link_height  = 0;
	$list_width   = 0;
	$list_height  = 0;
	$list_width_5 = 0;

	$ret_false = array('',0,0,0,0,0);

	if (empty($image_data))  $image_data = $this->banner;
	if (empty($image_data))  return $ret_false;

	$image_url  = $this->assume_banner_url($image_data);

	$width  = $this->width;
	$height = $this->height;

// read remote file, when not set
	if (empty($width) && empty($height))
	{
		list($width, $height) = $this->remote->get_image_size($image_url);
	
		if ($width && $height)
		{
			$this->updateImageSize($this->lid, $width, $height);
		}
	}

// size exist
	if ($width && $height)
	{
		list ($list_width, $list_height) = 
			$this->image->adjust_size($width, $height, $this->config_listimage_width, $this->config_listimage_height);

		$list_width_5 = $list_width + 5;

		list ($link_width, $link_height) = 
			$this->image->adjust_size($width, $height, $this->config_linkimage_width, $this->config_linkimage_height);
	}

	$this->image_url          = $image_url;
	$this->image_link_width   = $link_width;
	$this->image_link_height  = $link_height;
	$this->image_list_width   = $list_width;
	$this->image_list_height  = $list_height;
	$this->image_list_width_5 = $list_width_5;

	return array($image_url,$link_width,$link_height,$list_width,$list_height,$list_width_5);
}

function assume_banner_url( $banner='' )
{
	if (empty($banner))  $image = $this->banner;
	if (empty($banner)) { return $banner; }

// URL style
	$url = $banner;
	if ( preg_match("/^https?:/", $url) )
	{
		return $url;
	}

// elliptical style
	$url = XOOPS_URL.$banner;
	$fp = fopen($url,"r");
	if ($fp)
  	{
		return $url;
  	}

// mylinks style
	$url = $this->module_url. "/".$this->shotdir."/".$banner;
	return $url;

}

//---------------------------------------------------------
}
?>
