<?php
// $Id: weblinks_template.php,v 1.9 2006/10/14 13:45:12 ohwada Exp $

// 2006-10-14 K.OHWADA
// add assignSearch()

// 2006-10-05 K.OHWADA
// use happy_linux
// use rssc WEBLINKS_RSSC_USE
// google map
// add fetch_link_map()
// use weblinks_locate_factory

// 2006-07-30 K.OHWADA
// BUG 4169: not show total in index

// 2006-05-15 K.OHWADA
// use new handler

// 2006-03-26 K.OHWADA
// REQ 3807: Description in main page

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication
// move from include/functions

//================================================================
// WebLinks Module
// 2004/01/23 K.OHWADA
//================================================================

//---------------------------------------------------------
// TODO
// global $xoopsTpl, $xoopsConfig, $xoopsModule, $xoopsUser
// class language_convert get_country()
//---------------------------------------------------------

// === class begin ===
if( !class_exists('weblinks_template') ) 
{

//=========================================================
// class weblinks_template
//=========================================================
class weblinks_template
{
// handler
	var $_link_handler;
	var $_category_handler;
	var $_config_basic_handler;
	var $_linkitem_handler;
	var $_rssc_handler;
	var $_menu;
	var $_system;

// dirname
	var $_DIRNAME;

// template
	var $_template_header       = null;
	var $_template_search_form  = null;
	var $_template_guidance     = null;
	var $_template_link_single  = null;
	var $_template_links_list   = null;
	var $_template_link_map     = null;

// system variable
	var $_module_name;
	var $_xoops_language;
	var $_happy_linux_url;

// local variable
	var $_time_start = 0;
	var $_time_prev  = 0;

// config
	var $_conf;

	var $_total_site_recommend;
	var $_total_site_mutual;
	var $_total_site_rss;
	var $_total_feed;

// keyword
	var $_keywords_urlencode = null;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_template( $dirname )
{
	$this->_DIRNAME = $dirname ;

// handler
	$this->_config_basic_handler  =& weblinks_get_handler( 'config2_basic',  $dirname );
	$this->_linkitem_handler      =& weblinks_get_handler( 'linkitem',       $dirname );
	$this->_link_handler          =& weblinks_get_handler( 'link',           $dirname );
	$this->_rssc_handler          =& weblinks_get_handler( 'rssc',           $dirname );

	$locate        =& weblinks_locate_factory::getInstance( $dirname );
	$this->_system =& happy_linux_system::getInstance();
	$this->_menu   =& weblinks_menu::getInstance( $dirname );

	$this->_conf = $this->_config_basic_handler->get_conf();
	$conf_map_template = $this->_conf['map_template'];

// system
	$this->_module_name    = $this->_system->get_module_name();
	$this->_xoops_language = $this->_system->get_language();

// locate
	$locate->weblinks_init();
	$this->_happy_linux_url = $locate->get_var('happy_linux_url');

// template
	$this->_template_header      = XOOPS_ROOT_PATH.'/modules/'.$dirname.'/templates/parts/weblinks_header.html';
	$this->_template_search_form = XOOPS_ROOT_PATH.'/modules/'.$dirname.'/templates/parts/weblinks_search_form.html';
	$this->_template_guidance    = XOOPS_ROOT_PATH.'/modules/'.$dirname.'/templates/parts/weblinks_guidance.html';
	$this->_template_link_single = XOOPS_ROOT_PATH.'/modules/'.$dirname.'/templates/parts/weblinks_link_single.html';
	$this->_template_links_list  = XOOPS_ROOT_PATH.'/modules/'.$dirname.'/templates/parts/weblinks_links_list.html';

	if ($conf_map_template)
	{
		$this->_template_link_map = XOOPS_ROOT_PATH.'/modules/'.$dirname.'/templates/map/'.$conf_map_template;
	}

}

function &getInstance( $dirname )
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_template( $dirname );
	}

	return $instance;
}

//-------------------------------------------------------------------
// total number
//-------------------------------------------------------------------
function load_total()
{
	$this->_total_site_recommend = $this->_link_handler->get_count_by_mark('recommend');
	$this->_total_site_mutual    = $this->_link_handler->get_count_by_mark('mutual');
	$this->_total_site_rss       = $this->_link_handler->get_count_rss_flag();
	$this->_total_feed           = $this->_rssc_handler->get_feed_count();
}

//-------------------------------------------------------------------
// assign template
//-------------------------------------------------------------------
function assignPageTitle( $title, $format=true )
{
	global $xoopsTpl;

	$module_name = htmlspecialchars($this->_module_name, ENT_QUOTES);

	if ($format)
	{
		$title = htmlspecialchars($title, ENT_QUOTES);
	}

	$pagetitle = $module_name.' - '.$title;
	$xoopsTpl->assign('xoops_pagetitle', $pagetitle);
}

function assignIndex()
{
	global $xoopsTpl;
	$this->_assign_header_common( $xoopsTpl );
}

function assignHeader( $flag_desc=false )
{
	global $xoopsTpl;
	$this->load_total();

	$header   = $this->fetch_header( $flag_desc );
	$guidance = $this->fetch_guidance();
	$search   = $this->fetch_search_form();

	$xoopsTpl->assign('weblinks_header',      $header);
	$xoopsTpl->assign('weblinks_guidance',    $guidance);
	$xoopsTpl->assign('weblinks_search_form', $search);

// BUG: not show total in index
	$this->_assign_header_total( $xoopsTpl );
}

function assignSearch( $selbox=null, $subcat=0, $mark=null, $query=null, $andor='and' )
{
	global $xoopsTpl;
	$this->_assign_search_common( $xoopsTpl );
	$xoopsTpl->assign('search_query',    htmlspecialchars($query, ENT_QUOTES) );
	$xoopsTpl->assign('search_selected', $this->_get_search_selected( $andor, $mark ) );
	$xoopsTpl->assign('search_checked',  $this->_get_search_checked( $subcat ) );
	$xoopsTpl->assign('search_selbox',   $selbox);
}

function assignDisplayLink()
{
	global $xoopsTpl;
	$this->_assign_link_common( $xoopsTpl );
}

function fetch_header( $flag_desc=false )
{
	$tpl = new XoopsTpl();
	$this->_assign_header_common( $tpl );
	$this->_assign_header_total(  $tpl );

	$tpl->assign( 'keywords', $this->_keywords_urlencode );

// REQ 3807: Description in main page
	if ( $flag_desc && $this->_conf['index_desc'] )
	{
		$tpl->assign('index_desc', $this->_conf['index_desc'] );
	}
	else
	{
		$tpl->assign('index_desc', '');
	}

	$text = $tpl->fetch( $this->_template_header );
	return $text;
}

function fetch_guidance()
{
	$tpl = new XoopsTpl();
	$this->_assign_header_common( $tpl );
	$this->_assign_header_total(  $tpl );

	$tpl->assign( 'keywords', $this->_keywords_urlencode );

	$text = $tpl->fetch( $this->_template_guidance );
	return $text;
}

function fetch_search_form()
{
	$tpl = new XoopsTpl();
	$this->_assign_header_common( $tpl );
	$this->_assign_search_common( $tpl );
	$text = $tpl->fetch( $this->_template_search_form );
	return $text;
}

function fetch_link_single( &$link )
{
	$tpl = new XoopsTpl();

	$link['map'] = $this->fetch_link_map( $link );
	$this->_assign_link_common( $tpl );
	$tpl->assign('link',     $link);
	$tpl->assign('keywords', $this->_keywords_urlencode );
	$text = $tpl->fetch( $this->_template_link_single );
	return $text;
}

function fetch_link_map( &$link )
{
	$text = '';
	if ( $this->_template_link_map )
	{
		$tpl = new XoopsTpl();
		$this->_assign_link_common( $tpl );
		$tpl->assign('link', $link);
		$text = $tpl->fetch( $this->_template_link_map );
	}
	return $text;
}

function fetch_links_full( &$links )
{
	$text = '';
	foreach ($links as $link) 
	{
		$text .= $this->fetch_link_single( $link );
	}
	return $text;
}

function fetch_links_list( &$links )
{
	$tpl = new XoopsTpl();
	$this->_assign_link_common( $tpl );
	$tpl->assign('keywords', $this->_keywords_urlencode );

	if ( is_array($links) )
	{
		foreach ($links as $link) 
		{
			$tpl->append('links', $link);
		}
	}

	$text = $tpl->fetch( $this->_template_links_list );
	return $text;
}

//=========================================================
// private
//=========================================================

function _assign_header_common( &$tpl )
{
	$show_site_rss = 0;
	$show_atomfeed = 0;

	if ( WEBLINKS_RSSC_USE )
	{
		$show_site_rss = 1;
		$show_atomfeed = 1;
	}

// system parameter
	$tpl->assign('xoops_url',      XOOPS_URL );
	$tpl->assign('xoops_language', $this->_xoops_language );
	$tpl->assign('module_name',    $this->_module_name );
	$tpl->assign('dirname',        $this->_DIRNAME );

// menu show
	$tpl->assign('show_submit',        $this->_menu->show_submit() );
	$tpl->assign('show_site_popular',  $this->_menu->show_hits() );
	$tpl->assign('show_site_higtrate', $this->_menu->show_rating() );

// config
	$tpl->assign('logoshow',            $this->_conf['logoshow'] );
	$tpl->assign('titleshow',           $this->_conf['titleshow'] );
	$tpl->assign('show_site_recommend', $this->_conf['recommend_pri'] );
	$tpl->assign('show_site_mutual',    $this->_conf['mutual_pri'] );
	$tpl->assign('show_site_rss',  $show_site_rss );
	$tpl->assign('show_atomfeed',  $show_atomfeed );

	$tpl->assign('happy_linux_url',  $this->_happy_linux_url );

// REQ 3110: Add in this category
	if ( isset($_GET['cid']) )
	{
		$tpl->assign('cid', intval($_GET['cid']) );
	}

// --- lang ---
	$tpl->assign('lang_home',     _HOME);
	$tpl->assign('lang_nomatch',  _WLS_NOMATCH);

// guidance bar
	$tpl->assign('lang_main',           _WLS_MAIN);
	$tpl->assign('lang_submitlink',     _WLS_SUBMIT_NEW_LINK);
	$tpl->assign('lang_site_popular',   _WLS_SITE_POPULAR);	
	$tpl->assign('lang_site_highrate',  _WLS_SITE_HIGHRATE);
	$tpl->assign('lang_site_recommend', _WLS_SITE_RECOMMEND);
	$tpl->assign('lang_site_mutual',    _WLS_SITE_MUTUAL);

// second guidance bar
	$tpl->assign('lang_catlist',        _WLS_CATLIST);
	$tpl->assign('lang_site_rss',       _WLS_SITE_RSS);
	$tpl->assign('lang_atomfeed',       _WLS_ATOMFEED);
	$tpl->assign('lang_site_random',    _WLS_SITE_RANDOM);

// index.php
	$tpl->assign('lang_new_sitelist',   _WLS_NEW_SITELIST);
	$tpl->assign('lang_new_atomfeed',   _WLS_NEW_ATOMFEED);

}

function _assign_header_total( &$tpl )
{
	$total_site_topten    = "top".intval( $this->_conf['topten_links'] );

	$tpl->assign('total_site_recommend', $this->_total_site_recommend);
	$tpl->assign('total_site_mutual',    $this->_total_site_mutual);
	$tpl->assign('total_site_rss',       $this->_total_site_rss);
	$tpl->assign('total_atomfeed',       $this->_total_feed);

// BUG 3111: timeout occurs in popular site if many top categories
	$tpl->assign('total_site_topten', $total_site_topten);
}

function _assign_search_common( &$tpl )
{
	$tpl->assign('search_google_server', $this->_conf['google_server'] );

// --- lang ---
	$tpl->assign('lang_search_search',  _SR_SEARCH);
	$tpl->assign('lang_search_all',     _SR_ALL);
	$tpl->assign('lang_search_any',     _SR_ANY);
	$tpl->assign('lang_search_exact',   _SR_EXACT);
	$tpl->assign('lang_search_result',  _SR_SEARCHRESULTS);
	$tpl->assign('lang_search_showall', _SR_SHOWALLR);
	$tpl->assign('lang_search_prev',    _SR_PREVIOUS);
	$tpl->assign('lang_search_next',    _SR_NEXT);
	$tpl->assign('lang_search_keyword', _SR_KEYWORDS.':');
	$tpl->assign('lang_search_ignore',  sprintf(_SR_IGNOREDWORDS, $this->_conf['search_min']) );

	$tpl->assign('lang_search_google',      _HAPPY_LINUX_SEARCH_GOOGLE );
	$tpl->assign('lang_search_with_subcat', _HAPPY_LINUX_SEARCH_WITH_SUBCAT );
	$tpl->assign('lang_search_not_select',  _HAPPY_LINUX_SEARCH_NOT_SELECT);
	$tpl->assign('lang_search_candidate',   _HAPPY_LINUX_SEARCH_CANDICATE );
}

function _get_search_selected( $andor, $mark )
{
	$selected = array();

	if ($andor == 'exact') 
	{
		$selected['exact'] = 'selected';
	}
	elseif ($andor == 'OR')
	{
		$selected['or'] = 'selected';
	}
	else
	{
		$selected['and'] = 'selected';
	}

	if ($mark == 'recommend') 
	{
		$selected['recommend'] = 'selected';
	}
	elseif ($mark == 'mutual')
	{
		$selected['mutual'] = 'selected';
	}

	return $selected;
}

function _get_search_checked( $subcat )
{
	$checked = array();

	if ($subcat == 1) 
	{
		$checked['subcat'] = 'checked';
	}

	return $checked;
}

function _assign_link_common( &$tpl )
{
	$show_atomfeed = 0;

	if ( WEBLINKS_RSSC_USE )
	{
		$show_atomfeed = 1;
	}

	$this->_linkitem_handler->load();

// system parameter
	$tpl->assign('xoops_url',       XOOPS_URL );
	$tpl->assign('xoops_language',  $this->_xoops_language );
	$tpl->assign('is_module_admin', $this->_system->is_module_admin() );
	$tpl->assign('module_name',     $this->_module_name );
	$tpl->assign('dirname',         $this->_DIRNAME );
	$tpl->assign('country_code',    $this->_conf['country_code'] );
	$tpl->assign('flag_map_use',    $this->_conf['map_use'] );

// show ratelink
	$show_ratelink = false;
	$show_rating   = false;
	if ( $this->_menu->show_rating() )
	{
		$show_rating = true;

		$has_auth_ratelink = $this->_config_basic_handler->has_auth_ratelink();
		if ( $has_auth_ratelink )
		{
			$show_ratelink = true;
		}
	}

// menu show
	$tpl->assign('show_hits',       $this->_menu->show_hits() );
	$tpl->assign('show_rating',     $show_rating );
	$tpl->assign('show_ratelink',   $show_ratelink );
	$tpl->assign('show_brokenlink', $this->_conf['use_brokenlink'] );
	$tpl->assign('show_atomfeed',   $show_atomfeed );

	$tpl->assign('dirname',    $this->_DIRNAME);

// index
	$tpl->assign('lang_more',            _WLS_MORE);
	$tpl->assign('lang_image_new',       _WLS_SITE_NEW);
	$tpl->assign('lang_image_update',    _WLS_SITE_UPDATE);
	$tpl->assign('lang_image_popular',   _WLS_SITE_POPULAR);
	$tpl->assign('lang_image_recommend', _WLS_SITE_RECOMMEND);
	$tpl->assign('lang_image_mutual',    _WLS_SITE_MUTUAL);

// singlelink
	$tpl->assign('lang_visit' ,          _WLS_VISIT);
	$tpl->assign('lang_promoter',        _WLS_PROMOTER);
	$tpl->assign('lang_modify',          _WLS_MODIFY);
	$tpl->assign('lang_editthislink' ,   _WLS_EDITTHISLINK);
	$tpl->assign('lang_ratethissite',    _WLS_RATETHISSITE);
	$tpl->assign('lang_reportbroken',    _WLS_REPORTBROKEN);
	$tpl->assign('lang_tellafriend',     _WLS_TELLAFRIEND);
	$tpl->assign('lang_print',          _PRINT);

	$lang_title        = $this->_get_title_by_name('title');
	$lang_url          = $this->_get_title_by_name('url');
	$lang_description  = $this->_get_title_by_name('description');
	$lang_category     = $this->_get_title_by_name('cat');
	$lang_banner       = $this->_get_title_by_name('banner');
	$lang_name         = $this->_get_title_by_name('name');
	$lang_mail         = $this->_get_title_by_name('mail');
	$lang_zip          = $this->_get_title_by_name('zip');
	$lang_state        = $this->_get_title_by_name('state');
	$lang_city         = $this->_get_title_by_name('city');
	$lang_addr         = $this->_get_title_by_name('addr');
	$lang_addr2        = $this->_get_title_by_name('addr2');
	$lang_tel          = $this->_get_title_by_name('tel');
	$lang_fax          = $this->_get_title_by_name('fax');
	$lang_etc1         = $this->_get_title_by_name('etc1');
	$lang_etc2         = $this->_get_title_by_name('etc2');
	$lang_etc3         = $this->_get_title_by_name('etc3');
	$lang_etc4         = $this->_get_title_by_name('etc4');
	$lang_etc5         = $this->_get_title_by_name('etc5');
	$lang_usercomment  = $this->_get_title_by_name('usercomment');
	$lang_admincomment = $this->_get_title_by_name('admincomment');
	$lang_lastupdate   = $this->_get_title_by_name('time_update');
	$lang_hits         = $this->_get_title_by_name('hits');
	$lang_rating       = $this->_get_title_by_name('rating');
	$lang_votes        = $this->_get_title_by_name('votes');
	$lang_comments     = $this->_get_title_by_name('comments');

// google map: hacked by wye
	$lang_gm_latitude  = $this->_get_title_by_name('gm_latitude');
	$lang_gm_longitude = $this->_get_title_by_name('gm_longitude');
	$lang_gm_zoom      = $this->_get_title_by_name('gm_zoom');

// the item which user can set up 
	$tpl->assign('lang_category' ,       $lang_category );
	$tpl->assign('lang_title',           $lang_title );
	$tpl->assign('lang_url',             $lang_url );
	$tpl->assign('lang_description',     $lang_description );
	$tpl->assign('lang_banner',          $lang_banner );
	$tpl->assign('lang_name',            $lang_name );
	$tpl->assign('lang_mail',            $lang_mail);
	$tpl->assign('lang_zip',             $lang_zip );
	$tpl->assign('lang_state',           $lang_state );
	$tpl->assign('lang_city',            $lang_city );
	$tpl->assign('lang_addr',            $lang_addr );
	$tpl->assign('lang_addr2',           $lang_addr2 );
	$tpl->assign('lang_tel',             $lang_tel );
	$tpl->assign('lang_fax',             $lang_fax );
	$tpl->assign('lang_etc1',            $lang_etc1 );
	$tpl->assign('lang_etc2',            $lang_etc2 );
	$tpl->assign('lang_etc3',            $lang_etc3 );
	$tpl->assign('lang_etc4',            $lang_etc4 );
	$tpl->assign('lang_etc5',            $lang_etc5 );
	$tpl->assign('lang_usercomment',     $lang_usercomment );

// google map
	$tpl->assign('lang_gm_latitude',     $lang_gm_latitude );
	$tpl->assign('lang_gm_longitude',    $lang_gm_longitude );
	$tpl->assign('lang_gm_zoom',         $lang_gm_zoom );

// the item which admin can set up 
	$tpl->assign('lang_admincommnet',    $lang_admincomment );

// the item which module can set up 
	$tpl->assign('lang_lastupdate',      $lang_lastupdate );
	$tpl->assign('lang_hits',            $lang_hits );
	$tpl->assign('lang_rating',          $lang_rating );
	$tpl->assign('lang_votes',           $lang_votes );
	$tpl->assign('lang_comments',        $lang_comments );

// banner
	$tpl->assign('link_image_use', $this->_conf['link_image_use'] );
	$tpl->assign('list_image_use', $this->_conf['list_image_use'] );
}

function _get_title_by_name( $name )
{
	$title = $this->_linkitem_handler->get_cache_by_name_key($name, 'title');
	$title = htmlspecialchars($title, ENT_QUOTES);
	return $title;
}

//---------------------------------------------------------
// set keyword property
//---------------------------------------------------------
function set_keywords_urlencode($val)
{
	$this->_keywords_urlencode = $val;
}

// --- class end ---
}

// === class end ===
}

?>