<?php
// $Id: weblinks_singlelink.php,v 1.3 2006/09/30 03:15:21 ohwada Exp $

// 2006-09-25 K.OHWADA
// use happy_linux
// use rssc WEBLINKS_RSSC_USE
// highlight_keyword

// 2006-09-24 K.OHWADA
// BUG 4279: Undefined index: rss_num in file singlelink.php

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//================================================================
// WebLinks Module
// move from singlelink.php
// 2006-05-15 K.OHWADA
//================================================================

// === class begin ===
if( !class_exists('weblinks_singlelink') ) 
{

//=========================================================
// class weblinks_singlelink
//=========================================================
class weblinks_singlelink
{
	var $_DIRNAME;

	var $_link_view_handler;
	var $_link_edit_handler;
	var $_rssc_handler;
	var $_system;
	var $_post;

	var $_conf;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_singlelink( $dirname )
{
	$this->_DIRNAME = $dirname;

	$config_basic_handler     =& weblinks_get_handler( 'config2_basic', $dirname );
	$this->_link_view_handler =& weblinks_get_handler( 'link_view',     $dirname );
	$this->_link_edit_handler =& weblinks_get_handler( 'link_edit',     $dirname );
	$this->_rssc_handler      =& weblinks_get_handler( 'rssc',          $dirname );

	$this->_system =& happy_linux_system::getInstance();
	$this->_post   =& happy_linux_post::getInstance();

	$this->_conf =& $config_basic_handler->get_conf();

	$this->_link_view_handler->init();
}

function &getInstance( $dirname )
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_singlelink( $dirname );
	}

	return $instance;
}

//---------------------------------------------------------
// wrapper
//---------------------------------------------------------
function get_get_lid()
{
	$lid = $this->_link_view_handler->get_get_lid();
	return $lid;
}

function &get_catpath_arr($lid)
{
	$catpath =& $this->_link_view_handler->get_catpath_array_by_lid($lid);
	return $catpath;
}

function get_get_keywords()
{
	return $this->_post->get_get_keywords();
}

//---------------------------------------------------------
// get_link
//---------------------------------------------------------
function &get_link($lid)
{
	if ( $this->_conf['link_image_auto'] )
	{
		$this->_link_edit_handler->update_banner_size_for_singlelink($lid);
	}

	$link =& $this->_link_view_handler->build_link_show_by_lid($lid);
	return $link;
}

//---------------------------------------------------------
// get ATOM feed
// RSS/ATOM auto discovery
//---------------------------------------------------------
function get_atomfeed($lid)
{
// BUG 4279: Undefined index: rss_num in file singlelink.php
	$arr = array(
		'rss_show'   => false,
		'rss_num'    => 0,
		'rss_flag'   => 0,
		'rss_url'    => '',
		'rss_update' => '',
		'feeds'      => array(),
	);

	if ( WEBLINKS_RSSC_USE )
	{
		$arr = $this->get_atomfeed_auto($lid);
	}

	return $arr;
}

function get_atomfeed_auto($lid)
{
	$arr = array(
		'rss_show'   => false,
		'rss_num'    => 0,
		'rss_flag'   => 0,
		'rss_url'    => '',
		'rss_update' => '',
		'feeds'      => array(),
	);

	$link_obj =& $this->_link_view_handler->get($lid);
	if ( !is_object($link_obj) )
	{
		return $arr;
	}

	$rssc_lid = $link_obj->getVar('rssc_lid');

	if ( $rssc_lid )
	{
		$feeds = array();

		$this->_rssc_handler =& weblinks_get_handler( 'rssc', $this->_DIRNAME );

		if ( $this->_conf['rss_mode_auto'] )
		{
			$this->_rssc_handler->refresh_link( $rssc_lid );
		}

		$this->_rssc_handler->set_feed_flag_title_html(   $this->_conf['rss_mode_title'] );
		$this->_rssc_handler->set_feed_flag_content_html( $this->_conf['rss_mode_content'] );
		$this->_rssc_handler->set_feed_max_content(       $this->_conf['rss_max_content'] );
		$this->_rssc_handler->set_feed_max_summary(       $this->_conf['rss_max_summary'] );

// current record
		$feeds =& $this->_rssc_handler->get_feed_list_latest_by_rssclid($rssc_lid, $this->_conf['rss_perpage'] );

// new record after refresh
		$rssc_obj =& $this->_rssc_handler->get_rssc_link($rssc_lid);
		if ( !is_object($rssc_obj) )
		{
			return $arr;
		}

		$show        = $rssc_obj->build_show();
		$rss_flag    = $show['mode'];
		$rss_url     = $show['url_xml'];
		$rss_update  = $show['updated_long'];

		$rss_show = false;
		if ( is_array($feeds) && count($feeds) )
		{
			$rss_show = true;
		}

		$arr = array(
			'rss_num'      => $this->_conf['rss_num_content'],
			'rss_show'     => $rss_show,
			'rss_flag'     => $rss_flag,
			'rss_url'      => $rss_url,
			'rss_update'   => $rss_update,
			'feeds'        => $feeds,
		);
	}

	return $arr;
}

//---------------------------------------------------------
// system parameter
//---------------------------------------------------------
function get_site_name()
{
	$ret = $this->_system->get_sitename();
	return $ret;
}

function get_module_name()
{
	$ret = $this->_system->get_module_name();
	return $ret;
}

//---------------------------------------------------------
// set keyword property
//---------------------------------------------------------
function set_highlight($value)
{
	$this->_link_view_handler->set_highlight($value);
}

function set_keyword_by_request()
{
	$this->_link_view_handler->set_keyword_by_request();
}

function get_keywords_urlencode()
{
	return $this->_link_view_handler->get_keywords_urlencode();
}

// --- class end ---
}

// === class end ===
}

?>