<?php
// $Id: search.php,v 1.9 2006/10/05 11:06:13 ohwada Exp $

// 2006-10-01 K.OHWADA
// use happy_linux
// fazzy search

// 2006-07-23 K.OHWADA
// BUG 4153: not show catpath in search

// 2006-05-15 K.OHWADA
// add class weblinks_search()
// use class weblinks_pagenavi
// use new handler

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//================================================================
// WebLinks Module
// search
// porting from system
// 2004/01/14 K.OHWADA
//================================================================

include 'header.php';


//=========================================================
// class weblinks_search
//=========================================================
class weblinks_search extends happy_linux_search
{
	var $_link_view_handler;
	var $_pagenavi;

// config
	var $_conf_search_min;
	var $_conf_search_links;

	var $_link_query_array;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_search()
{
	$this->happy_linux_search();
	$this->set_lang_zenkaku(_HAPPY_LINUX_ZENKAKU);
	$this->set_lang_hankaku(_HAPPY_LINUX_HANKAKU);

	$this->_link_view_handler =& weblinks_get_handler( 'link_view',     WEBLINKS_DIRNAME );
	$config_handler           =& weblinks_get_handler( 'config2_basic', WEBLINKS_DIRNAME );

	$this->_pagenavi =& happy_linux_pagenavi::getInstance();

	$conf = $config_handler->get_conf();
	$this->_conf_search_min   = $conf['search_min'];
	$this->_conf_search_links = $conf['search_links'];
	
	$this->set_min_keyword($this->_conf_search_min);
}

//---------------------------------------------------------
// get oaram
//---------------------------------------------------------
function get_conf_search_min()
{
	return $this->_conf_search_min;
}

//---------------------------------------------------------
// link handler
//---------------------------------------------------------
function get_link_total()
{
	$ret = $this->check_build_sql_query_array();
	switch ($ret)
	{
		case HAPPY_LINUX_SEARCH_CODE_SQL_NO_CAN:
		case HAPPY_LINUX_SEARCH_CODE_SQL_MERGE:
			list($sql_total, $sql_links) 
				= $this->_link_view_handler->build_sql_search($this->_sql_query_array, null, $this->_sql_andor);
			$total = $this->_link_view_handler->getCountBySql($sql_total);
			$this->_link_query_array = $this->_sql_query_array;
			break;

		case HAPPY_LINUX_SEARCH_CODE_SQL_CAN:
			list($sql_total, $sql_links) 
				= $this->_link_view_handler->build_sql_search($this->_query_array, $this->_candidate_keyword_array, $this->_mode_andor);
			$total = $this->_link_view_handler->getCountBySql($sql_total);
			$this->_link_query_array = $this->_query_array;
			break;
	}

	$this->_sql_links = $sql_links;
	$this->_total     = $total;

	return $total;
}

function get_link_list()
{
	$navi = '';

	$this->_pagenavi->setPerpage( $this->_conf_search_links );
	$this->_pagenavi->setTotal(   $this->_total );

	$this->_pagenavi->getGetPage();
	$start = $this->_pagenavi->calcStart();

	$this->_link_view_handler->set_keyword_array( $this->_merged_query_array );

// BUG: not show catpath in search
	$this->_link_view_handler->init();
	$link_objs =& $this->_link_view_handler->get_objects_by_sql($this->_sql_links, $this->_conf_search_links, $start);
	$link_list =& $this->_link_view_handler->get_link_list_by_objs($link_objs);

// next page
	if ($this->_total > $this->_conf_search_links)
	{
		$script = $this->_build_script();
		$navi   = $this->_pagenavi->build($script);
	}

	return array($link_list, $navi);
}

function _build_script()
{
	$script  = WEBLINKS_URL.'/search.php?query=';
	$script .= $this->get_query_urlencode();
	$script .= '&amp;action=results&amp;andor=';
	$script .= $this->get_andor();
	return $script;
}


//---------------------------------------------------------
// set keyword property
//---------------------------------------------------------
function set_view_highlight($value)
{
	$this->_link_view_handler->set_highlight($value);
}

// --- class end ---
}


//================================================================
// main
//================================================================

$weblinks_template =& weblinks_template::getInstance( WEBLINKS_DIRNAME );
$weblinks_search   =& new weblinks_search();

// --- template start ---
// xoopsOption[template_main] should be defined before including header.php
$xoopsOption['template_main'] = WEBLINKS_DIRNAME."_search.html";
include XOOPS_ROOT_PATH.'/header.php';

// config
$conf_search_min = $weblinks_search->get_conf_search_min();

// not use extract
$action = $weblinks_search->get_post_get_action();
$query  = $weblinks_search->get_post_get_query();
$andor  = $weblinks_search->get_post_get_andor();

$weblinks_template->set_search($query, $andor);
$weblinks_template->assignIndex();
$weblinks_template->assignHeader();
$weblinks_template->assignDisplayLink();

$xoopsTpl->assign('lang_result',  _SR_SEARCHRESULTS);
$xoopsTpl->assign('lang_showall', _SR_SHOWALLR);
$xoopsTpl->assign('lang_prev',    _SR_PREVIOUS);
$xoopsTpl->assign('lang_next',    _SR_NEXT);
$xoopsTpl->assign('lang_keyword', _SR_KEYWORDS.':');
$xoopsTpl->assign('lang_ignore',  sprintf(_SR_IGNOREDWORDS, $conf_search_min) );
$xoopsTpl->assign('lang_candidate', _HAPPY_LINUX_SEARCH_CANDICATE );

// search form
if ($action == 'search')
{
	$xoopsTpl->assign('search_show', 0);
	$xoopsTpl->assign('search_not_show_result', '');

	include XOOPS_ROOT_PATH."/footer.php";
	exit();
}

// if no query
// REQ 2933: easy to understand error message
if ( $query == '' ) 
{
	$xoopsTpl->assign('search_show', 0);
	$xoopsTpl->assign('search_not_show_result', _SR_PLZENTER);

	include XOOPS_ROOT_PATH."/footer.php";
	exit();
}

$ret = $weblinks_search->parse_query();

// if no queriy
// REQ 2933: easy to understand error message
if ( !$ret ) 
{
	$xoopsTpl->assign('search_show', 0);
	$xoopsTpl->assign('search_not_show_result', sprintf(_SR_KEYTOOSHORT, $conf_search_min));

	include XOOPS_ROOT_PATH."/footer.php";
	exit();
}


$merged_urlencode = $weblinks_search->get_merged_urlencode();
$weblinks_template->set_keywords_urlencode( $merged_urlencode );

$xoopsTpl->assign('search_show', 1);

$xoopsTpl->assign('search_keywords',         $weblinks_search->get_query_array() );
$xoopsTpl->assign('search_ignores',          $weblinks_search->get_ignore_array() );
$xoopsTpl->assign('search_candidates',       $weblinks_search->get_candidate_array() );
$xoopsTpl->assign('search_show_ignore',      $weblinks_search->get_count_ignore_array() );
$xoopsTpl->assign('search_show_candidate',   $weblinks_search->get_count_candidate_array() );
$xoopsTpl->assign('search_merged_urlencode', $merged_urlencode );

$weblinks_search->set_view_highlight( true );

$total = $weblinks_search->get_link_total();

if ($total > 0)
{
	list($links, $navi) = $weblinks_search->get_link_list();
	$links_list = $weblinks_template->fetch_links_list( $links );

	$xoopsTpl->assign('search_found_show', 1);
	$xoopsTpl->assign('search_found', sprintf(_SR_FOUND, $total));
	$xoopsTpl->assign('weblinks_links_list', $links_list);
	$xoopsTpl->assign('page_navi', $navi);
}
else
{
// no match data
	$xoopsTpl->assign('search_found_show', 0);
	$xoopsTpl->assign('search_not_found_result', _SR_NOMATCH);	
}

include XOOPS_ROOT_PATH."/footer.php";
exit();
// --- main end ---

?>