<?php
// $Id: weblinks_link_view_handler.php,v 1.4 2006/10/05 11:06:13 ohwada Exp $

// 2006-10-01 K.OHWADA
// use happy_linux
// weblinks_criteria_compo -> criteriaCompo
// highlight_keyword
// add get_link_by_obj()
// add get_objects_by_sql() : remove get_link_list_by_sq()

// 2006-07-22 K.OHWADA
// BUG 4152: not show catpath in link list

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//=========================================================
// WebLinks Module
// 2006-05-15 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_link_view_handler') ) 
{

//=========================================================
// class weblinks_link_view_handler
//=========================================================
class weblinks_link_view_handler
{
	var $_DIRNAME;

	var $_config_handler;
	var $_link_handler;
	var $_category_handler;
	var $_catlink_handler;
	var $_link_catlink_handler;

	var $_system;
	var $_strings;
	var $_remote_image;
	var $_image_size;
	var $_post;
	var $_form;

// config
	var $_conf_array = array();
	var $_conf_cat_img_width     = 0;
	var $_conf_cat_img_height    = 0;
	var $_conf_list_image_width  = 0;
	var $_conf_list_image_height = 0;
	var $_conf_link_image_width  = 0;
	var $_conf_link_image_height = 0;
	var $_conf_link_image_auto;
	var $_conf_descshort;
	var $_conf_newdays;
	var $_conf_popular;
	var $_conf_view_url;
	var $_conf_broken;
	var $_conf_recommend_pri;
	var $_conf_mutual_pri;

// system
	var $_system_is_admin;
	var $_system_uid;

// keyword
	var $_flag_highlight = false;
	var $_keyword_array  = null;

// atomfeed
	var $_feed_mode_title    = 0;	// not allow HTML tag
	var $_feed_mode_content  = 0;	// not allow HTML tag
	var $_feed_max_content   = 100;
	var $_feed_max_summary   = 100;
	var $_feed_title_default = '---';


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_view_handler( $dirname )
{
	$this->_DIRNAME = $dirname;

	$this->_config_handler       =& weblinks_get_handler( 'config2_basic', $dirname );
	$this->_link_handler         =& weblinks_get_handler( 'link',          $dirname );
	$this->_category_handler     =& weblinks_get_handler( 'category',      $dirname );
	$this->_catlink_handler      =& weblinks_get_handler( 'catlink',       $dirname );
	$this->_link_catlink_handler =& weblinks_get_handler( 'link_catlink',  $dirname );

	$this->_system       =& happy_linux_system::getInstance();
	$this->_strings      =& happy_linux_strings::getInstance();
	$this->_remote_image =& happy_linux_remote_image::getInstance();
	$this->_image_size   =& happy_linux_image_size::getInstance();
	$this->_post         =& happy_linux_post::getInstance();
	$this->_form         =& happy_linux_form::getInstance();

	$conf = $this->_config_handler->get_conf();
	$this->_conf_array             = $conf;
	$this->_conf_cat_img_width     = $conf['cat_img_width'];
	$this->_conf_cat_img_height    = $conf['cat_img_height'];
	$this->_conf_list_image_width  = $conf['list_image_width'];
	$this->_conf_list_image_height = $conf['list_image_height'];
	$this->_conf_link_image_width  = $conf['link_image_width'];
	$this->_conf_link_image_height = $conf['link_image_height'];
	$this->_conf_link_image_auto   = $conf['link_image_auto'];
	$this->_conf_descshort         = $conf['descshort'];
	$this->_conf_newdays           = $conf['newdays'];
	$this->_conf_popular           = $conf['popular'];
	$this->_conf_view_url          = $conf['view_url'];
	$this->_conf_broken            = $conf['broken_threshold'];
	$this->_conf_recommend_pri     = $conf['recommend_pri'];
	$this->_conf_mutual_pri        = $conf['mutual_pri'];

	$this->_system_is_admin = $this->_system->is_module_admin();
	$this->_system_uid      = $this->_system->get_uid();

}


//---------------------------------------------------------
// init
//---------------------------------------------------------
function init()
{
	$this->_category_handler->load();
}

//---------------------------------------------------------
// link count
//---------------------------------------------------------
function get_link_count_public()
{
	$count = $this->_link_handler->get_count_public();
	return $count;
}

function get_link_count_by_cid($cid)
{
	$cid = intval($cid);
	$cid_arr   = $this->_category_handler->getAllChildId($cid);
	$cid_arr[] = $cid;
	$count = $this->_catlink_handler->get_count_by_cid_array($cid_arr);
	return $count;
}

//---------------------------------------------------------
// category_link count
//---------------------------------------------------------
function get_catlink_count_by_cid($cid)
{
	$count = $this->_catlink_handler->get_count_by_cid($cid);
	return $count;
}

//---------------------------------------------------------
// get category list
//---------------------------------------------------------
function get_cid_array_by_lid($lid, $limit=0, $start=0)
{
	$lid   = intval($lid);
	$limit = intval($limit);
	$start = intval($start);
	$arr   = $this->_catlink_handler->get_cid_array_by_lid($lid, $limit, $start);
	return $arr;
}

function show_cid_selbox_by_lid($lid=0, $limit=0, $start=0)
{
	$lid   = intval($lid);
	$limit = intval($limit);
	$start = intval($start);
	$cid_arr = array();

	if ($lid)
	{
		$cid_arr = $this->_catlink_handler->get_cid_array_by_lid($lid, $limit, $start);
	}

// show always, if cid array is empty
	$selbox = $this->_category_handler->showSelboxMulti($cid_arr);
	return $selbox;
}

//=========================================================
// category
//=========================================================
//---------------------------------------------------------
// get category
//---------------------------------------------------------
function get_category_by_cid($cid, $flag_image=0, $flag_catpath=0)
{
	$cid = intval($cid);

	$arr = $this->_category_handler->get_cache_var_all($cid, 'n');
	$title   = $arr['title'];
	$imgurl  = $arr['imgurl'];
	$title_s = $this->sanitize_text($title);

	$link_count = $this->get_link_count_by_cid($cid);
	$image_link = '';
	$catpath    = '';

// image
	if ($flag_image)
	{
		$image_link = $this->build_category_image_link($imgurl, $title);
	}

	if ($flag_catpath)
	{
		$catpath = $this->_category_handler->get_parent_path($cid);
	}

	$arr = array(
		'cid'        => $cid,
		'title'      => $title,
		'title_s'    => $title_s,
		'link_count' => $link_count,
		'image_link' => $image_link,
		'catpath'    => $catpath,
	);

	return $arr;
}

function build_category_image_link($url, $alt='')
{
	$image_link = '';

	if ( empty($url) || ($url == "http://") || ($url == "https://")  )
	{
		return '';
	}

	list($width, $height) = 
		$this->_remote_image->get_image_size($url);

	list($width, $height) = 
		$this->_image_size->adjust_size( $width, $height, $this->_conf_cat_img_width, $this->_conf_cat_img_height );

	$image_link = $this->_form->build_html_img_tag($url, $width, $height, 0, $alt);

	return $image_link;
}

//---------------------------------------------------------
// get category list
//---------------------------------------------------------
function get_category_list_by_pid($pid, $flag_image=0, $flag_catpath=0, $max_sub=-1)
{
	$pid = intval($pid);
	$cid_arr = $this->_category_handler->get_cid_array_by_pid($pid);

	$category_list = array();

	$flag_image   = 1;
	$flag_catpath = 0;

	foreach ($cid_arr as $cid)
	{
		$cat = $this->get_category_by_cid($cid, $flag_image, $flag_catpath);
		$title_s    = $cat['title_s'];
		$link_count = $cat['link_count'];
		$image_link = $cat['image_link'];

// by Tom
// admin can change the display number of subcategory 
		list ($space, $chcount, $subcategories) =
			$this->_category_handler->build_sub_categorys($cid, $max_sub);

		$category = array(
			'cid'            => $cid,
			'title_s'        => $title_s,
			'image_link'     => $image_link,
			'link_count'     => $link_count,
			'subcategories'  => $subcategories,
		);

		$category_list[] = $category;
	}

	return $category_list;
}

//---------------------------------------------------------
// category path
//---------------------------------------------------------
function &get_catpath_array_by_lid($lid)
{
	$cid_arr = $this->_catlink_handler->get_cid_array_by_lid($lid);
	$catpath_arr = array();

	foreach ($cid_arr as $cid)
	{
		if ( $this->_category_handler->cache_exists($cid) )
		{
			$catpath_arr[] =& $this->_category_handler->get_parent_path($cid);
		}
	}

	return $catpath_arr;
}

function get_all_catlist()
{
	$tree_array = $this->_category_handler->get_tree();

	$catlist = array();

	foreach ($tree_array as $cid) 
	{
		$catpath = $this->_category_handler->build_cat_path($cid, 's');
		$count   = $this->get_link_count_by_cid($cid);

		$catlist[] = array(
			'cid'   => $cid,
			'count' => $count,
			'path'  => $catpath,
		);
	}

	return $catlist;
}

//=========================================================
// link
//=========================================================
//---------------------------------------------------------
// get link object
//---------------------------------------------------------
function &get($lid)
{
	$ret =& $this->_link_handler->get($lid);
	return $ret;
}

function &getVarAll($lid, $format='n')
{
	$ret =& $this->_link_handler->getVarAll($lid, $format);
	return $ret;
}

//---------------------------------------------------------
// get link count
//---------------------------------------------------------
function get_count_by_mark( $mark )
{
	if ($mark == 'rss')
	{
		$count = $this->_link_handler->get_count_rss_flag();
	}
	else
	{
		$count = $this->_link_handler->get_count_by_mark($mark);
	}

	return $count;
}


//---------------------------------------------------------
// lid array
//---------------------------------------------------------
function &get_lid_array_by_cid($cid, $orderby, $limit=0, $start=0)
{
	$cid   = intval($cid);
	$limit = intval($limit);
	$start = intval($start);
	$arr    =& $this->_link_catlink_handler->get_lid_array_by_cid($cid, $orderby, $limit, $start);
	return $arr;
}

//---------------------------------------------------------
// build link show
//---------------------------------------------------------
function &create_view()
{
	$view_obj =& new weblinks_link_view( $this->_DIRNAME );
	return $view_obj;
}

function &get_view($lid)
{
	$obj  = $this->_link_handler->get($lid);
	if ( !is_object($obj) )
	{	return false;	}

	$view_obj =& $this->create_view();
	$view_obj->set_object($obj);

	return $view_obj;
}

function &build_link_show_by_lid($lid)
{
	$view_obj =& $this->get_view($lid);
	if ( !is_object($view_obj) )
	{	return false;	}

	$view_obj->build_show( $this->_flag_highlight, $this->_keyword_array );
	$show =& $view_obj->get_vars();

	return $show;
}

//---------------------------------------------------------
// link list orderby xxx
// for index, topt ten
//---------------------------------------------------------
function &get_link_list_latest($limit=0, $start=0)
{
	$objs =& $this->_link_handler->get_objects_latest($limit, $start);
	$list =& $this->get_link_list_by_objs($objs);
	return $list;
}

function &get_link_list_orderby($orderby, $limit=0, $start=0)
{
	$objs =& $this->_link_handler->get_objects_orderby($orderby, $limit=0, $start=0);
	$list =& $this->get_link_list_by_objs($objs);
	return $list;
}

function &get_link_list_by_objs(&$objs)
{
	$link_list = array();

	if ( is_array($objs) && ( count($objs) > 0 ) )
	{
		foreach ($objs as $obj)
		{
			$link_list[] =& $this->get_link_by_obj( $obj );
		}
	}

	return $link_list;
}

function &get_link_by_obj( &$obj )
{
	$show = array();
	if ( is_object($obj) )
	{
		$view_obj =& $this->create_view();
		$view_obj->set_object($obj);
		$view_obj->build_show( $this->_flag_highlight, $this->_keyword_array );
		$show =& $view_obj->get_vars();
	}
	return $show;
}

//---------------------------------------------------------
// link list
// for serach
//---------------------------------------------------------
function &get_objects_by_sql($sql, $limit=0, $start=0)
{
	$objs =& $this->_link_handler->get_objects_by_sql($sql, $limit, $start);
	return $objs;
}

//---------------------------------------------------------
// view mark & rss : link list orderby xxx
//---------------------------------------------------------
function &get_link_by_mark_sort($mark, $sort, $limit=0, $start=0)
{
	$orderby = 'lid ASC';
	if ( isset($sort['sort']) && isset($sort['order']) )
	{
		$orderby = $sort['sort'].' '.$sort['order'];
	}

	if ($mark == 'rss')
	{
		$objs =& $this->_link_handler->get_objects_rss_by_orderby($orderby, $limit, $start);
	}
	else
	{
		$objs  =& $this->_link_handler->get_objects_by_mark_orderby($mark, $orderby, $limit, $start);
	}

	$list  =& $this->get_link_list_by_objs($objs);
	return $list;
}

//---------------------------------------------------------
// link list belongs category
//---------------------------------------------------------
function &get_link_list_by_cid_sort($cid, $sort, $limit=0, $start=0)
{
	$sort_arr = array();

	if ( $this->_conf_recommend_pri == 2 )
	{
		$sort_arr[] = 'recommend DESC';
	}

	if ( $this->_conf_mutual_pri == 2 )
	{
		$sort_arr[] = 'mutual DESC';
	}

	if ( isset($sort['sort']) && isset($sort['order']) )
	{
		$sort_arr[] = $sort['sort'].' '.$sort['order'];
	}
	else
	{
		$sort_arr[] = 'lid ASC';
	}

	$orderby = implode(',', $sort_arr);

	$lid_arr =& $this->_link_catlink_handler->get_lid_array_by_cid_orderby($cid, $orderby, $limit, $start);
	$link_list =& $this->get_link_list_by_lid_array($lid_arr);
	return $link_list;
}

function &get_link_all_child_list_latest_by_cid($cid, $limit=0, $start=0)
{
	$cid_arr = $this->_category_handler->getAllChildId($cid);
	$orderby = 'time_update DESC';

	$lid_arr   = $this->_link_catlink_handler->get_lid_array_by_cid_array_orderby($cid_arr, $orderby, $limit, $start);
	$link_list =& $this->get_link_list_by_lid_array($lid_arr);

	return $link_list;
}

function &get_link_list_by_lid_array($lid_arr)
{
	$link_list = array();

	foreach ($lid_arr as $lid) 
	{
		$show = $this->build_link_show_by_lid($lid);
		$link_list[] = $show;
	}

	return $link_list;
}

//---------------------------------------------------------
// Top Ten: link list belongs parent & child category
//---------------------------------------------------------
function &get_link_parent_child_list_by_cid_orderby($cid, $orderby, $limit=0, $start=0)
{
	$ch_arr   =& $this->_category_handler->getAllChildId($cid);
	$chid_arr =  array_merge( array($cid), $ch_arr );
	$lid_arr  =& $this->_link_catlink_handler->get_lid_array_by_cid_array_orderby($chid_arr, $orderby,$limit, $start);
	$link_list =& $this->get_link_list_by_lid_array($lid_arr);

	return $link_list;
}

//---------------------------------------------------------
// search
//---------------------------------------------------------
function build_sql_search($queryarray1, $queryarray2=null, $andor='AND', $uid=0)
{
	$ret = $this->_link_handler->build_sql_search($queryarray1, $queryarray2, $andor, $uid);
	return $ret;
}

function getCountBySql($sql)
{
	$ret = $this->_link_handler->get_count_by_sql($sql);
	return $ret;
}

//=========================================================
// others
//=========================================================

//---------------------------------------------------------
// sanitize
//---------------------------------------------------------
function sanitize_text($text)
{
	$text = $this->_strings->sanitize_text($text);
	return $text;
}

function sanitize_url($text)
{
	$text = $this->_strings->sanitize_url($text);
	return $text;
}

function shorten_text($text, $max)
{
	$text = $this->_strings->shorten_text($text, $max);
	return $text;
}

//---------------------------------------------------------
// get GET & POST
//---------------------------------------------------------
function get_get_lid()
{
	$ret = $this->_post->get_get_int('lid');
	return $ret;
}

function get_get_cid()
{
	$ret = $this->_post->get_get_int('cid');
	return $ret;
}

function get_get_mark()
{
	$ret = $this->_post->get_get_text('mark');
	return $ret;
}

function get_get_keyword_array()
{
	return $this->_post->get_get_keyword_array();
}

//---------------------------------------------------------
// get property
//---------------------------------------------------------
function is_admin()
{
	return $this->_system_is_admin;
}

function get_config()
{
	return $this->_conf_array;
}

//---------------------------------------------------------
// set property
//---------------------------------------------------------
function set_feed_mode_title($value)
{
	$this->_feed_mode_title = intval($value);
}

function set_feed_mode_content($value)
{
	$this->_feed_mode_content = intval($value);
}

function set_feed_max_content($value)
{
	$this->_feed_max_content = intval($value);
}

function set_feed_max_summary($value)
{
	$this->_feed_max_summary = intval($value);
}

function set_feed_title_default($value)
{
	$this->_feed_title_default = $value;
}

//---------------------------------------------------------
// set keyword property
//---------------------------------------------------------
function set_highlight($value)
{
	$this->_flag_highlight = (bool)$value;
}

function set_keyword_array($arr)
{
	if ( is_array($arr) && count($arr) )
	{
		$this->_keyword_array = $arr;
	}
}

function set_keyword_by_request()
{
	$this->set_keyword_array( $this->get_get_keyword_array() );
}

function get_keywords_urlencode()
{
	return $this->_strings->urlencode_from_array( $this->_keyword_array );
}

// --- class end ---
}

// === class end ===
}

?>