<?php
// $Id: weblinks_link_form_check_handler.php,v 1.1 2006/09/30 03:15:21 ohwada Exp $

// 2006-09-20 K.OHWADA
// this is new file
// move from weblinks_link_edit_handler.php

//=========================================================
// WebLinks Module
// 2006-05-20 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_link_form_check_handler') ) 
{

//=========================================================
// class weblinks_link_form_check_handler
//=========================================================
class weblinks_link_form_check_handler extends happy_linux_error
{
	var $_DIRNAME;

	var $_config_handler;
	var $_link_handler;
	var $_linkitem_handler;

	var $_system;
	var $_post;

// config
	var $_conf_check_double;
	var $_conf_use_passwd;
	var $_conf_passwd_min;
	var $_conf_desc_option = array();

// error message
	var $error_msg_flag_lid_full = 0;
	var $error_msg_flag_lid_part = 0;
	var $error_msg_lid_arr_full  = array();
	var $error_msg_lid_arr_part  = array();

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_form_check_handler( $dirname )
{
	$this->happy_linux_error();

	$this->_DIRNAME = $dirname;

	$this->_config_handler   =& weblinks_get_handler( 'config2_basic',   $dirname );
	$this->_link_handler     =& weblinks_get_handler( 'link',            $dirname );
	$this->_linkitem_handler =& weblinks_get_handler( 'linkitem_define', $dirname );

	$this->_system  =& happy_linux_system::getInstance();
	$this->_post    =& happy_linux_post::getInstance();

	$conf = $this->_config_handler->get_conf();
	$this->_conf_check_double = $conf['check_double'];
	$this->_conf_use_passwd   = $conf['use_passwd'];
	$this->_conf_passwd_min   = $conf['passwd_min'];
}

//---------------------------------------------------------
// POST param
//---------------------------------------------------------
function get_post_url()
{
	$url = $this->_post->get_post_text('url');
	return $url;
}

//---------------------------------------------------------
// check form
//---------------------------------------------------------
function check_form_addlink_by_post()
{
	$ret = $this->check_form_common( true, true );
	return $ret;
}

function check_form_modlink_for_owner_by_post()
{
	$ret = $this->check_form_common( true, false );
	return $ret;
}

function check_form_modlink_by_post( $is_owner=true )
{
	$ret = $this->check_form_common( $is_owner, false);
	return $ret;
}

function check_form_common( $is_owner=true, $flag_new=true )
{
	$linkitem_arr =& $this->_get_linkitem_load();

	$this->_clear_errors();

	foreach ($linkitem_arr as $id => $v )
	{
		$name  = $this->_get_linkitem_by_itemid($id, 'name');
		$mode  = $this->_get_linkitem_by_itemid($id, 'user_mode');
		$form  = $this->_get_linkitem_by_itemid($id, 'user_form');
		$title = $this->_get_linkitem_by_itemid($id, 'title');

		switch ($name)
		{
			case 'name':
			case 'mail':
			case 'usercomment':
				if (( $mode == 2 )&& $is_owner )
				{
					$this->_check_fill_by_post( $name, $title);
				}
				break;

			case 'banner':
			case 'rss_url':
				$this->_check_url_form_by_post( $name, $title, $mode);
				break;

			case 'description':
				$this->_check_desc_by_post( $name, $title, $mode);
				break;

			case 'cat':
				$this->_check_cat_by_post( $name, $title, $mode);
				break;

			case 'url':
				$this->_check_url_by_post( $name, $title, $mode, $flag_new);
				break;

			case 'passwd':
				$this->_check_passwd_by_post( $name, $title, $flag_new);
				break;

			default:
				if ( $mode == 2 )
				{
					$this->_check_fill_by_post( $name, $title);
				}
				break;
		}
	}

	if ( $this->_error_flag )  { return false; }
	return true;
}

//---------------------------------------------------------
// check routine
//---------------------------------------------------------
function _check_fill_by_post($name, $title)
{
	if ( !$this->_post->is_post_fill($name) )
	{
		$msg = sprintf(_WLS_ERROR_FILL, $title);
		$this->_set_errors( $msg );
		return false;
	}

	return true;
}

function _check_desc_by_post($name, $title, $mode)
{
	$desc = '';
	if ( isset($_POST['description']) )
	{
		$desc = $_POST['description'];
	}
	elseif ( isset($_POST['description_text']) )
	{
		$desc = $_POST['description_text'];
	}

	if ( ( $mode == 2 ) && ($desc === '') )
	{
		$msg = sprintf(_WLS_ERROR_FILL, $title);
		$this->_set_errors( $msg );
	}
}

function _check_cat_by_post( $name, $title, $mode)
{
	$flag_cid = false;
	foreach ($_POST['cid'] as $cid)
	{
		if ( intval($cid) != 0 )
		{	$flag_cid = true;	}
	}

	if ( !$flag_cid )
	{
		$msg = sprintf(_WLS_ERROR_FILL, $title);
		$this->_set_errors( $msg );
	}
}

function _check_url_form_by_post( $name, $title, $mode)
{
// bug fix: misjudge to check url

	$flag_err = false;

	if ( $mode == 2 )
	{
		if ( !$this->_post->is_post_url_fill($name) )
		{
			$msg1 = sprintf( _WLS_ERROR_FILL, $title);
			$this->_set_errors( $msg1 );
			$flag_err = true;
		}
	}

	if ( !$this->_post->is_post_url_llegal($name) )
	{
		$msg1 = sprintf( WLS_ERROR_ILLEGAL, $title);
		$this->_set_errors( $msg1 );
		$flag_err = true;
	}

	if ( $flag_err )
	{
		return false;
	}
	return true;
}

function _check_url_by_post( $name, $title, $mode, $flag_new)
{
	$this->_check_url_form_by_post( $name, $title, $mode);

	if ($flag_new)
	{
		$url = $this->get_post_url();
		$this->_check_url_double($url);
	}
}

function _check_url_double($url)
{
	$this->error_msg_flag_lid_full = 0;
	$this->error_msg_flag_lid_part = 0;
	$this->error_msg_lid_arr_full  = array();
	$this->error_msg_lid_arr_part  = array();

	if ( $this->_conf_check_double >= 1 )
	{
		$ret = $this->_check_url_full( $url );
		if ( !$ret )
		{
			return false;	// error
		}
	}

	if ( $this->_conf_check_double == 2 )
	{
		$ret = $this->_check_url_part( $url );
		if ( !$ret )
		{
			return false;	// warning
		}
	}

	return true;	// OK
}

function _check_url_full($url)
{
	if (( $url == "" )||( $url == "http://" ))
	{	return true;	}	// no check

	$this->error_msg_lid_arr_full =& $this->_get_link_lid_array_by_url($url);

	if ( count($this->error_msg_lid_arr_full) ) 
	{
		$this->error_msg_flag_lid_full = 1;
		return false;	// NG
	}

	return true;	// OK
}

function _check_url_part($url)
{
	if (( $url == "" )||( $url == "http://" ))
	{	return true;	}	// no check

	$arr_out = array();

	$lid_arr =& $this->_get_link_lid_array();

	foreach ($lid_arr as $lid)
	{
		$flag = 0;

		$obj = $this->get($lid);
		if ( !is_object($obj) )  { continue; }

		$url_db   = $obj->get('url');
		$url_db_r = str_replace("|", '\|', $url_db);
		$url_r    = str_replace("|", '\|', $url);

		if ( preg_match("|$url_db_r|", $url) )
		{	$flag = 1;	}

		if ( preg_match("|$url_r|", $url_db) )
		{	$flag = 1;	}

		if ($flag)
		{
			$arr_out[] = $lid;
		}
	}

	$this->error_msg_lid_arr_part = $arr_out;
	if ( count($this->error_msg_lid_arr_part) > 0 ) 
	{
		$this->error_msg_flag_lid_part = 1;
		return false;	// NG
	}

	return true;	// OK
}

function _check_passwd_by_post( $name, $title, $flag_new)
{
	$name1 = 'passwd_new';
	$name2 = 'passwd_2';

	if ( !isset( $_POST[$name1] ) || ( $_POST[$name1] == '') )
	{
		if ( $flag_new && $this->_conf_use_passwd && !($this->_system->is_user()) )
		{
			$msg = sprintf(_WLS_ERROR_FILL, $title);
			$this->_set_errors( $msg );
			return false;
		}

		return true;	// no check
	}

	$pass1 = $this->_post->get_post_text( $name1 );
	$pass2 = $this->_post->get_post_text( $name2 );

	if ( strlen($pass1) < $this->_conf_passwd_min ) 
	{
		$msg = sprintf(_US_PWDTOOSHORT, $this->_conf_passwd_min );
		$this->_set_errors( $msg );
		return false;
	}

	if ($pass1 != $pass2) 
	{
		$this->_set_errors( _US_PASSNOTSAME );
		return false;
	}

	return true;
}

//---------------------------------------------------------
// error message
//---------------------------------------------------------
function get_error_msg_addlink()
{
	$text = '';

	if ( $this->_error_flag )
	{
		$text .= $this->get_error_msg_modlink();
	}

	if ( $this->error_msg_flag_lid_full ) 
	{
		$text .= $this->_build_html_error_msg(_WLS_ERROR_URL_EXIST );
		$text .= $this->_build_html_error_url( $this->error_msg_lid_arr_full );
	}

	if ( $this->error_msg_flag_lid_part ) 
	{
		$text .= $this->_build_html_error_msg(_WLS_WARNING_URL_EXIST );
		$text .= $this->_build_html_error_url( $this->error_msg_lid_arr_part );
	}

	return $text;
}

function get_error_msg_modlink()
{
	$text = $this->_build_html_error_msg( $this->getErrors('s') );
	return $text;
}

function _build_html_error_msg($msg)
{
	$msg = '<h4 style="color: #ff0000;">'.$msg."</h4>\n";
	return $msg;
}

function _build_html_error_url($lid_arr)
{
	$text = "<ul>";

	foreach( $lid_arr as $lid )
	{
		$text .= $this->_build_html_error_url_single($lid);
	}

	$text .= "</ul>\n";

	return $text;
}

function _build_html_error_url_single($lid)
{
	$obj = $this->get($lid);
	if ( !is_object($obj) )  { return ''; }

	$title_s = $obj->getVar('title');
	$url_s   = $obj->getVar('url');
	$text = "<li><a href='$url_s' target='_blank'>$title_s</a></li>\n";
	return $text;
}

//---------------------------------------------------------
// link_handler
//---------------------------------------------------------
function &_get_link_lid_array()
{
	$ret =& $this->_link_handler->getList();
	return $ret;
}

function &_get_link_lid_array_by_url($url)
{
	$criteria = new criteriaCompo();
	$criteria->add( new criteria('url', $url, '=') );
	$ret =& $this->_link_handler->getList($criteria);
	return $ret;
}

//---------------------------------------------------------
// linkitem_define_handler
//---------------------------------------------------------
function &_get_linkitem_load()
{
	$ret =& $this->_linkitem_handler->load();
	return $ret;
}

function _get_linkitem_by_itemid($id, $key)
{
	return $this->_linkitem_handler->get_by_itemid($id, $key);
}

function _get_linkitem_by_name($name, $key)
{
	return $this->_linkitem_handler->get_by_name($name, $key);
}

// --- class end ---
}

// === class end ===
}

?>