<?php
// $Id: weblinks_link_handler.php,v 1.7 2006/10/07 05:05:11 ohwada Exp $

// 2006-10-05 K.OHWADA
// use happy_linux
// use rssc
// divided weblinks_link to weblinks_link_handler
// add get_objects_latest() isset_rss_flag()
// reomove rss_update()
// google map

// 2006-07-15 K.OHWADA
// BUG 4130: cannot show recommend mark

// 2006-06-10 K.OHWADA
// BUG 4030: cannot change recommend, mutual
//   add set_checkbox()

// 2006-05-15 K.OHWADA
// new handler
// not use weblinks_module_base
// NOT use other handler

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// 2004/01/14 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_link_handler') ) 
{

//=========================================================
// class weblinks_link_handler
// NOT use other handler
//=========================================================
class weblinks_link_handler extends happy_linux_object_handler
{
	var $_system;
	var $_strings;
	var $_search;
	var $_lang;

	var $_lid_array_with_email;

// config
	var $_conf_use_hits;
	var $_conf_use_ratelink;
	var $_conf_use_broken;
	var $_conf_broken;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_handler( $dirname )
{
	$this->happy_linux_object_handler( $dirname, 'link', 'lid', 'weblinks_link' );

	$this->set_debug_db_sql(   WEBLINKS_DEBUG_LINK_SQL );
	$this->set_debug_db_error( WEBLINKS_DEBUG_ERROR );

	$config_basic_handler =& weblinks_get_handler( 'config2_basic', $dirname );

	$this->_system   =& happy_linux_system::getInstance();
	$this->_strings  =& happy_linux_strings::getInstance();
	$this->_search   =& happy_linux_search::getInstance();
	$lang_factory    =& happy_linux_language_factory::getInstance();
	$this->_lang     =& $lang_factory->get_local_instance();

	$conf = $config_basic_handler->get_conf();
	if ( is_array($conf) && (count($conf) > 0) )
	{
		$this->_conf_use_hits     = $conf['use_hits'];
		$this->_conf_use_ratelink = $conf['use_ratelink'];
		$this->_conf_broken       = $conf['broken_threshold'];
	}
}

//---------------------------------------------------------
// insert
// $flag_lid : for import from mylinks
//---------------------------------------------------------
function _build_insert_sql(&$obj, $flag_lid=false)
{
	foreach ($obj->gets() as $k => $v) 
	{	${$k} = $v;	}

	$sql  = 'INSERT INTO '.$this->_table.' (';

	if ( $flag_lid )
	{
		$sql .= 'lid, ';
	}

	$sql .= 'uid, ';
	$sql .= 'cids, ';
	$sql .= 'title, ';
	$sql .= 'url, ';
	$sql .= 'banner, ';
	$sql .= 'description, ';
	$sql .= 'name, ';
	$sql .= 'nameflag, ';
	$sql .= 'mail, ';
	$sql .= 'mailflag, ';
	$sql .= 'company, ';
	$sql .= 'addr, ';
	$sql .= 'tel, ';
	$sql .= 'search, ';
	$sql .= 'passwd, ';
	$sql .= 'admincomment, ';
	$sql .= 'mark, ';
	$sql .= 'time_create, ';
	$sql .= 'time_update, ';
	$sql .= 'hits, ';
	$sql .= 'rating, ';
	$sql .= 'votes, ';
	$sql .= 'comments, ';
	$sql .= 'width, ';
	$sql .= 'height, ';
	$sql .= 'recommend, ';
	$sql .= 'mutual, ';
	$sql .= 'broken, ';
	$sql .= 'rss_url, ';
	$sql .= 'rss_flag, ';
	$sql .= 'rss_xml, ';
	$sql .= 'rss_update, ';
	$sql .= 'usercomment, ';
	$sql .= 'zip, ';
	$sql .= 'state, ';
	$sql .= 'city, ';
	$sql .= 'addr2, ';
	$sql .= 'fax, ';

// html
	$sql .= 'dohtml, ';
	$sql .= 'dosmiley, ';
	$sql .= 'doxcode, ';
	$sql .= 'doimage, ';
	$sql .= 'dobr, ';
	$sql .= 'etc1, ';
	$sql .= 'etc2, ';
	$sql .= 'etc3, ';
	$sql .= 'etc4, ';
	$sql .= 'etc5, ';
	$sql .= 'map_use, ';

// rssc
	$sql .= 'rssc_lid, ';

// google map
	$sql .= 'gm_latitude, ';
	$sql .= 'gm_longitude, ';
	$sql .= 'gm_zoom, ';

// aux
	$sql .= 'aux_int_1, ';
	$sql .= 'aux_int_2, ';
	$sql .= 'aux_text_1, ';
	$sql .= 'aux_text_2 ';

	$sql .= ') VALUES (';

	if ( $flag_lid )
	{
		$sql .= intval($lid).', ';
	}

	$sql .= intval($uid).', ';
	$sql .= $this->quote($cids).', ';
	$sql .= $this->quote($title).', ';
	$sql .= $this->quote($url).', ';
	$sql .= $this->quote($banner).', ';
	$sql .= $this->quote($description).', ';
	$sql .= $this->quote($name).', ';
	$sql .= intval($nameflag).', ';
	$sql .= $this->quote($mail).', ';
	$sql .= intval($mailflag).', ';
	$sql .= $this->quote($company).', ';
	$sql .= $this->quote($addr).', ';
	$sql .= $this->quote($tel).', ';
	$sql .= $this->quote($search).', ';
	$sql .= $this->quote($passwd).', ';
	$sql .= $this->quote($admincomment).', ';
	$sql .= $this->quote($mark).', ';
	$sql .= intval($time_create).', ';
	$sql .= intval($time_update).', ';
	$sql .= intval($hits).', ';
	$sql .= floatval($rating).', ';
	$sql .= intval($votes).', ';
	$sql .= intval($comments).', ';
	$sql .= intval($width).', ';
	$sql .= intval($height).', ';
	$sql .= intval($recommend).', ';
	$sql .= intval($mutual).', ';
	$sql .= intval($broken).', ';
	$sql .= $this->quote($rss_url).', ';
	$sql .= intval($rss_flag).', ';
	$sql .= intval($rss_xml).', ';
	$sql .= intval($rss_update).', ';
	$sql .= $this->quote($usercomment).', ';
	$sql .= $this->quote($zip).', ';
	$sql .= $this->quote($state).', ';
	$sql .= $this->quote($city).',';
	$sql .= $this->quote($addr2).', ';
	$sql .= $this->quote($fax).', ';

// html
	$sql .= intval($dohtml).', ';
	$sql .= intval($dosmiley).', ';
	$sql .= intval($doxcode).', ';
	$sql .= intval($doimage).', ';
	$sql .= intval($dobr).', ';
	$sql .= $this->quote($etc1).', ';
	$sql .= $this->quote($etc2).', ';
	$sql .= $this->quote($etc3).', ';
	$sql .= $this->quote($etc4).', ';
	$sql .= $this->quote($etc5).', ';
	$sql .= intval($map_use).', ';

// rssc
	$sql .= intval($rssc_lid).', ';

// google map
	$sql .= floatval($gm_latitude).', ';
	$sql .= floatval($gm_longitude).', ';
	$sql .= intval($gm_zoom).', ';

// aux
	$sql .= intval($aux_int_1).', ';
	$sql .= intval($aux_int_2).', ';
	$sql .= $this->quote($aux_text_1).', ';
	$sql .= $this->quote($aux_text_2).' ';

	$sql .= ')';

	return $sql;
}

//---------------------------------------------------------
// update
//---------------------------------------------------------
function _build_update_sql(&$obj)
{
	foreach ($obj->gets() as $k => $v) 
	{	${$k} = $v;	}

	$sql = 'UPDATE '.$this->_table.' SET ';
	$sql .= 'uid='.intval($uid).', ';
	$sql .= 'cids='.$this->quote($cids).', ';
	$sql .= 'title='.$this->quote($title).', ';
	$sql .= 'url='.$this->quote($url).', ';
	$sql .= 'banner='.$this->quote($banner).', ';
	$sql .= 'description='.$this->quote($description).', ';
	$sql .= 'name='.$this->quote($name).', ';
	$sql .= 'nameflag='.intval($nameflag).', ';
	$sql .= 'mail='.$this->quote($mail).', ';
	$sql .= 'mailflag='.intval($mailflag).', ';
	$sql .= 'company='.$this->quote($company).', ';
	$sql .= 'addr='.$this->quote($addr).', ';
	$sql .= 'tel='.$this->quote($tel).', ';
	$sql .= 'search='.$this->quote($search).', ';
	$sql .= 'passwd='.$this->quote($passwd).', ';
	$sql .= 'admincomment='.$this->quote($admincomment).', ';
	$sql .= 'mark='.$this->quote($mark).', ';
	$sql .= 'time_create='.intval($time_create).', ';
	$sql .= 'time_update='.intval($time_update).', ';
	$sql .= 'hits='.intval($hits).', ';
	$sql .= 'rating='.floatval($rating).', ';
	$sql .= 'votes='.intval($votes).', ';
	$sql .= 'comments='.intval($comments).', ';
	$sql .= 'width='.intval($width).', ';
	$sql .= 'height='.intval($height).', ';
	$sql .= 'recommend='.intval($recommend).', ';
	$sql .= 'mutual='.intval($mutual).', ';
	$sql .= 'broken='.intval($broken).', ';
	$sql .= 'rss_url='.$this->quote($rss_url).', ';
	$sql .= 'rss_flag='.intval($rss_flag).', ';
	$sql .= 'rss_update='.intval($rss_update).', ';
	$sql .= 'rss_xml='.$this->quote($rss_xml).', ';
	$sql .= 'usercomment='.$this->quote($usercomment).', ';
	$sql .= 'zip='.$this->quote($zip).', ';
	$sql .= 'state='.$this->quote($state).', ';
	$sql .= 'city='.$this->quote($city).', ';
	$sql .= 'addr2='.$this->quote($addr2).', ';
	$sql .= 'fax='.$this->quote($fax).', ';

// html
	$sql .= 'dohtml='.intval($dohtml).', ';
	$sql .= 'dosmiley='.intval($dosmiley).', ';
	$sql .= 'doxcode='.intval($doxcode).', ';
	$sql .= 'doimage='.intval($doimage).', ';
	$sql .= 'dobr='.intval($dobr).', ';
	$sql .= 'etc1='.$this->quote($etc1).', ';
	$sql .= 'etc2='.$this->quote($etc2).', ';
	$sql .= 'etc3='.$this->quote($etc3).', ';
	$sql .= 'etc4='.$this->quote($etc4).', ';
	$sql .= 'etc5='.$this->quote($etc5).', ';
	$sql .= 'map_use='.intval($map_use).', ';

// rssc
	$sql .= 'rssc_lid='.intval($rssc_lid).', ';

// google map
	$sql .= 'gm_latitude='.floatval($gm_latitude).', ';
	$sql .= 'gm_longitude='.floatval($gm_longitude).', ';
	$sql .= 'gm_zoom='.intval($gm_zoom).', ';

// aux
	$sql .= 'aux_int_1='.intval($aux_int_1).', ';
	$sql .= 'aux_int_2='.intval($aux_int_2).', ';
	$sql .= 'aux_text_1='.$this->quote($aux_text_1).', ';
	$sql .= 'aux_text_2='.$this->quote($aux_text_2).' ';

	$sql .= ' WHERE lid='.intval($lid);

	return $sql;
}

//---------------------------------------------------------
// update
//---------------------------------------------------------
// for visit.php
function countup_hits($lid)
{
	if ( !$this->_conf_use_hits )
	{
		return true;	// no action
	}

	$sql = 'UPDATE '.$this->_table.' SET hits = hits+1 WHERE lid='.intval($lid);
	$ret = $this->queryF($sql);
	return $ret;

}

// for link_check.php
function countup_broken($lid)
{
	$sql = 'UPDATE '.$this->_table.' SET broken = broken+1 WHERE lid='.intval($lid);
	$ret = $this->queryF($sql);
	return $ret;
}

// for ratelink.php, admin/votedate.php
function update_rating($lid, $rating, $votes)
{
	if ( !$this->_conf_use_ratelink )
	{
		return true;	// no action
	}

	$lid = intval($lid);

	$obj =& $this->get($lid);
	if ( !is_object($obj) )
	{
		return true;	// no action
	}

	$obj->setVar('rating', $rating);
	$obj->setVar('votes',  $votes);
	$ret = $this->update($obj);
	return $ret;
}

function update_rssc_lid( $lid, $rssc_lid )
{
	$obj =& $this->get( $lid );
	if ( !is_object($obj) )
	{
		return true;	// no action
	}

	$obj->setVar('rssc_lid', $rssc_lid);
	$ret = $this->update($obj);
	return $ret;
}

//---------------------------------------------------------
// delete
//---------------------------------------------------------
function delete_by_lid($lid)
{
	$obj = $this->get($lid);
	if ( is_object($obj) )
	{
		$ret = $this->delete($obj);
		return $ret;
	}

	return true;	// no action
}

//---------------------------------------------------------
// get count
//---------------------------------------------------------
// except broken link
function get_count_rss_flag($flag_broken=true)
{
	$criteria = new CriteriaCompo();
	$criteria->add( new criteria('rssc_lid', 0, '!=') );

	if ($flag_broken)
	{
		$criteria->add( new criteria('broken', $this->_conf_broken, '<') );
	}

	$count = $this->getCount($criteria);
	return $count;

}

function get_count_non_url()
{
// XOOPS 2.2.3 dont accept value = ''

	$sql  = "SELECT COUNT(*) FROM ".$this->_table." WHERE (url = '') ";
	$count = $this->get_count_by_sql($sql);
	return $count;
}

// except broken link
function get_count_public()
{
	$criteria = new CriteriaCompo();
	$criteria->add( new criteria('broken', $this->_conf_broken, '<') );
	$count = $this->getCount($criteria);
	return $count;
}

// except broken link
function get_count_by_mark($mark)
{
	$criteria = new CriteriaCompo();
	$criteria->add( new criteria('broken', $this->_conf_broken, '<') );
	$criteria->add( new criteria($mark, 1, '=') );
	$count = $this->getCount($criteria);
	return $count;
}

function get_count_broken()
{
	$criteria = new CriteriaCompo();
	$criteria->add( new criteria('broken', 0, '>') );
	$count = $this->getCount($criteria);
	return $count;
}

function get_count_by_uid($uid)
{
	$uid = intval($uid);
	$criteria = new CriteriaCompo();
	$criteria->add( new criteria('uid', $uid, '=') );
	$count = $this->getCount($criteria);
	return $count;
}

// --- previous version 1.10 ---
function get_count_rss_flag_prev_ver()
{
	$sql  = "SELECT COUNT(*) FROM ".$this->_table." ";
	$sql .= "WHERE ( rss_url != '' AND rss_flag != 0 AND broken < ". $this->_conf_broken ." ) ";
	$count = $this->get_count_by_sql($sql);
	return $count;
}

//---------------------------------------------------------
// get objects
//---------------------------------------------------------
// bug fix: except broken link
// BUG 2790: not show rss site
function  &get_objects_rss_by_orderby($orderby, $limit=0, $start=0)
{
	$criteria = new CriteriaCompo();
	$criteria->add( new criteria('rssc_lid', 0, '!=') );
	$criteria->add( new criteria('broken', $this->_conf_broken, '<') );

	if ( $orderby )
	{
		$criteria->setSort( $orderby );
	}

	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function  &get_objects_rss_flag($limit=0, $start=0)
{
	$criteria = new CriteriaCompo();
	$criteria->add( new criteria('rssc_lid', 0, '!=') );
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

// except broken link
function &get_objects_by_mark_orderby($mark, $orderby, $limit=0, $start=0)
{
	$criteria = new CriteriaCompo();
	$criteria->add( new criteria($mark, 1, '=') );
	$criteria->add( new criteria('broken', $this->_conf_broken, '<') );

	if ( $orderby )
	{
		$criteria->setSort( $orderby );
	}

	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_non_url($limit=0, $start=0)
{
// XOOPS 2.2.3 dont accept value = ''

	$sql = "SELECT * FROM ".$this->_table." WHERE (url = '') ORDER BY lid";
	$objs =& $this->get_objects_by_sql($sql, $limit, $start);
	return $objs;
}

function &get_objects_all($limit=0, $start=0)
{
	$criteria = new CriteriaCompo();
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_desc($limit=0, $start=0)
{
	$criteria = new CriteriaCompo();
	$criteria->setSort( 'lid DESC' );
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_latest($limit=0, $start=0)
{
	$criteria = new criteriaCompo();
	$criteria->add( new criteria('broken', $this->_conf_broken, '<') );
	$criteria->setSort('time_update DESC, lid DESC');
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_orderby($orderby, $limit=0, $start=0)
{
	$criteria = new criteriaCompo();
	$criteria->add( new criteria('broken', $this->_conf_broken, '<') );
	$criteria->setSort($orderby);
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}



function &get_objects_broken($limit=0, $start=0)
{
	$criteria = new CriteriaCompo();
	$criteria->add( new criteria('broken', 0, '>') );
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_by_uid($uid, $limit=0, $start=0)
{
	$uid = intval($uid);
	$criteria = new CriteriaCompo();
	$criteria->add( new criteria('uid', $uid, '=') );
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

// --- previous version 1.10 ---
function &get_objects_rss_flag_prev_ver($limit=0, $start=0)
{
	$sql  = "SELECT * FROM ".$this->_table." ";
	$sql .= "WHERE ( rss_url != '' AND rss_flag != 0 AND broken < ". $this->_conf_broken ." ) ";
	$sql .= "ORDER BY lid";
	$objs =& $this->get_objects_by_sql($sql, $limit, $start);
	return $objs;
}

//---------------------------------------------------------
// get lid list
//---------------------------------------------------------
function &get_lid_array_by_random($limit=0, $start=0)
{
// except broken link & without url
// XOOPS 2.2.3 dont accept value = ''

	$sql  = "SELECT lid FROM ".$this->_table." ";
	$sql .= "WHERE (url != '' AND broken < ".$this->_conf_broken.") ";
	$sql .= "ORDER BY rand()";
	$arr  =& $this->get_first_rows_by_sql($sql, $limit, $start);
	return $arr;
}

function &get_lid_array($limit=0, $start=0)
{
	$limit = intval($limit);
	$start = intval($start);
	$criteria = new CriteriaCompo();
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$arr =& $this->getList($criteria);
	return $arr;
}

//---------------------------------------------------------
// get link item
//---------------------------------------------------------
// visit.php
function get_sanitized_url_by_lid($lid)
{
	$lid = intval($lid);
	$obj =& $this->get($lid);
	if ( !is_object($obj) )  { return false; }

	$url = $obj->get('url');
	$url = $this->_strings->sanitize_url($url);
	return $url;
}

//---------------------------------------------------------
// search
// for search.php
//---------------------------------------------------------
function build_sql_search($query_array1, $query_array2=null, $andor='AND', $uid=0)
{
	$where  = '';
	$where1 = '';

	$where .= 'broken < '.$this->_conf_broken.' ';

	if ( $uid != 0 ) 
	{
		$where .= 'AND uid='.$uid.' ';
	}

	$where1 = $this->_search->build_single_double_where('search', $query_array1, $query_array2, $andor);
	if ( $where1 )
	{
		$where .= ' AND '.$where1;
	}

	$sql_total = 'SELECT COUNT(*) FROM '.$this->_table.' WHERE '.$where;
	$sql_links = 'SELECT * FROM '.$this->_table.' WHERE '.$where.' ORDER BY time_update DESC';

	return array($sql_total, $sql_links);
}

//---------------------------------------------------------
// this function dont work well, when too much links
//---------------------------------------------------------
function &get_lid_array_with_email($limit=0, $start=0)
{
	$user_list            = array();
	$lid_array_with_email = array();
	$email_store          = array();

	$objs =& $this->get_objects_all($limit, $start);
	foreach ($objs as $obj)
	{
		$lid  = $obj->get('lid');
		list($name, $email) = $obj->user_name_mail();
		$user_list[$lid] = $email;
	}

	foreach ($user_list as $lid => $email)
	{
// check duplication
		if ( empty($email) )  continue;

		if ( in_array($email, $email_store) )
		{
//			echo "omit $lid $email <br />\n";
			continue;
		}

		$email_store[]  = $email;
		$lid_array_with_email[] = $lid;
	}

	return $lid_array_with_email;
}


//=========================================================
// use language_convert class
//=========================================================
// visit.php
function build_link_mail($lid)
{
	$sitename = $this->_system->get_sitename();
	$subject  = sprintf(_WLS_INTRESTLINK,  $sitename);
	$body     = sprintf(_WLS_INTLINKFOUND, $sitename).": ".$this->build_single_link($lid);

// --- effective only in Japanese environment ---
// convert EUC-JP to SJIS
	$subject = $this->_lang->convert_telafriend_subject($subject);
	$body    = $this->_lang->convert_telafriend_body($body);

	$subject = rawurlencode($subject);
	$body    = rawurlencode($body);

	return array($subject, $body);
}

function build_single_link($lid)
{
	$link = XOOPS_URL.'/modules/'.$this->_DIRNAME.'/singlelink.php?lid='.$lid;
	return $link;
}

//---------------------------------------------------------
// create & drop table
//---------------------------------------------------------
function create_table()
{
$sql = "
CREATE TABLE ".$this->_table." (
  lid int(11) unsigned NOT NULL auto_increment,
  uid int(5) unsigned NOT NULL default '0',
  cids   varchar(255) default NULL,
  title  varchar(255) NOT NULL default '',
  url    varchar(255) NOT NULL default '',
  banner varchar(255) NOT NULL default '',
  description text default NULL,
  name varchar(255) default NULL,
  nameflag tinyint(2) NOT NULL default '0',
  mail varchar(255) default NULL,
  mailflag tinyint(2) NOT NULL default '0',
  company varchar(255) default NULL,
  addr varchar(255) default NULL,
  tel varchar(255) default NULL,
  search text default NULL,
  passwd varchar(255) default NULL,
  admincomment text default NULL,
  mark char(3) default NULL,
  time_create int(10) NOT NULL default '0',
  time_update int(10) NOT NULL default '0',
  hits int(11) unsigned NOT NULL default '0',
  rating double(6,4) NOT NULL default '0.0000',
  votes int(11) unsigned NOT NULL default '0',
  comments int(11) unsigned NOT NULL default '0',
  width  int(5) unsigned NOT NULL default '0',
  height int(5) unsigned NOT NULL default '0',
  recommend tinyint(2) NOT NULL default '0',
  mutual    tinyint(2) NOT NULL default '0',
  broken int(11) unsigned NOT NULL default '0',
  rss_url  varchar(255) NOT NULL default '',
  rss_flag tinyint(3) NOT NULL default '0',
  rss_xml  mediumtext NOT NULL default '',
  rss_update int(10) NOT NULL default'0',
  usercomment text default NULL,
  zip    varchar(255) default NULL,
  state  varchar(255) default NULL,
  city   varchar(255) default NULL,
  addr2  varchar(255) default NULL,
  fax    varchar(255) default NULL,
  dohtml   tinyint(1) NOT NULL default '0',
  dosmiley tinyint(1) NOT NULL default '1',
  doxcode  tinyint(1) NOT NULL default '1',
  doimage  tinyint(1) NOT NULL default '1',
  dobr     tinyint(1) NOT NULL default '1',
  etc1   varchar(255) default NULL,
  etc2   varchar(255) default NULL,
  etc3   varchar(255) default NULL,
  etc4   varchar(255) default NULL,
  etc5   varchar(255) default NULL,
  map_use  tinyint(2)       NOT NULL default '1',
  rssc_lid int(11) unsigned NOT NULL default '0',
  gm_latitude  double(10,8) NOT NULL default '0',
  gm_longitude double(11,8) NOT NULL default '0',
  gm_zoom      tinyint(2) NOT NULL default '0',
  aux_int_1 int(5) default '0',
  aux_int_2 int(5) default '0',
  aux_text_1 varchar(255) default '',
  aux_text_2 varchar(255) default '',
  PRIMARY KEY  (lid),
  KEY uid (uid),
  KEY cids (cids),
  KEY title (title(40))
) TYPE=MyISAM
";

	$ret = $this->query($sql);
	return $ret;
}

//---------------------------------------------------------
// add_column_table
//---------------------------------------------------------
function check_version_120()
{
	$ret = $this->existsFieldName( 'map_use' );
	return $ret;
}

function check_version_110()
{
	$ret = $this->existsFieldName( 'dohtml' );
	return $ret;
}

function add_column_table_120()
{
// rssc_lid
// google map

$sql = "
  ALTER TABLE ".$this->_table." ADD COLUMN (
  map_use  tinyint(2)       NOT NULL default '1',
  gm_latitude  double(10,8) NOT NULL default '0',
  gm_longitude double(11,8) NOT NULL default '0',
  gm_zoom      tinyint(2)   NOT NULL default '0'
)";

	$ret = $this->query($sql);
	return $ret;
}

function add_column_table_110()
{
$sql1 = "
  ALTER TABLE ".$this->_table." ADD COLUMN (
  dohtml   tinyint(1) NOT NULL default 0,
  dosmiley tinyint(1) NOT NULL default 1,
  doxcode  tinyint(1) NOT NULL default 1,
  doimage  tinyint(1) NOT NULL default 1,
  dobr     tinyint(1) NOT NULL default 1,
  etc1 varchar(255) default NULL,
  etc2 varchar(255) default NULL,
  etc3 varchar(255) default NULL,
  etc4 varchar(255) default NULL,
  etc5 varchar(255) default NULL
)";

	$ret1 = $this->query($sql1);

	$sql2 = "ALTER TABLE ".$this->_table." MODIFY cids varchar(255) default NULL ";
	$ret2 = $this->query($sql2);

	$sql3 = "ALTER TABLE ".$this->_table." MODIFY title varchar(255) NOT NULL default '' ";
	$ret3 = $this->query($sql3);

	$sql4 = "ALTER TABLE ".$this->_table." MODIFY zip varchar(255) default NULL ";
	$ret4 = $this->query($sql4);

	$sql5 = "ALTER TABLE ".$this->_table." MODIFY state varchar(255) default NULL ";
	$ret5 = $this->query($sql5);

	$sql6 = "ALTER TABLE ".$this->_table." MODIFY city varchar(255) default NULL ";
	$ret6 = $this->query($sql6);

	if ( $ret1 && $ret2 && $ret3 && $ret4 && $ret5 && $ret6 )
	{
		return true;
	}

	return false;
}

// --- class end ---
}

// === class end ===
}

?>