<?php
// $Id: mail_users.php,v 1.7 2006/09/30 03:15:20 ohwada Exp $

// 2006-09-20 K.OHWADA
// use happy_linux
// use XoopsGTicket

// 2006-05-15 K.OHWADA
// new handler
// add class admin_mail_users
// use token ticket

// 2006-03-15 K.OHWADA
// use weblinks_pagenavi_basic::getInstance()

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// mailusers
// porting from xoops mailusers.php
// 2005-01-20 K.OHWADA
//=========================================================
include 'admin_header.php';
include_once XOOPS_ROOT_PATH.'/class/xoopsformloader.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_mailer.php';

$XOOPS_LANGUAGE = $xoopsConfig['language'];

if ( file_exists(XOOPS_ROOT_PATH.'/modules/system/language/'.$XOOPS_LANGUAGE.'/admin.php') ) 
{
	include_once XOOPS_ROOT_PATH.'/modules/system/language/'.$XOOPS_LANGUAGE.'/admin.php';
}
else
{
	include_once XOOPS_ROOT_PATH.'/modules/system/language/english/admin.php';
}

if ( file_exists(XOOPS_ROOT_PATH.'/modules/system/language/'.$XOOPS_LANGUAGE.'/admin/mailusers.php') ) 
{
	include_once XOOPS_ROOT_PATH.'/modules/system/language/'.$XOOPS_LANGUAGE.'/admin/mailusers.php';
}
else
{
	include_once XOOPS_ROOT_PATH.'/modules/system/language/english/admin/mailusers.php';
}

$mail_users =& admin_mail_users::getInstance();


$op       = $mail_users->get_post_op();
$to_email = $mail_users->get_post_to_email();
$lid_arr  = $mail_users->get_post_lid_arr();

$total = 0;
if ( is_array($lid_arr) )
{
	$total = count($lid_arr);
}

if (( $op == 'send' )&&($total > 0))
{
	if ( !( $mail_users->check_token() ) )
	{
		redirect_header("user_list.php", 5, "Token Error");
		exit();
	}

	xoops_cp_header();
	weblinks_admin_print_header();
	weblinks_admin_print_menu();
	echo "<h4>"._WEBLINKS_ADMIN_SENDMAIL."</h4>\n";
	$mail_users->send_users($lid_arr);
}
elseif (( $op == 'send' )&&( $to_email )) 
{
	if ( !( $mail_users->check_token() ) )
	{
		redirect_header("mail_users.php", 5, "Token Error");
		exit();
	}

	xoops_cp_header();
	weblinks_admin_print_header();
	weblinks_admin_print_menu();
	echo "<h4>"._WEBLINKS_ADMIN_SENDMAIL."</h4>\n";
	$mail_users->send_mail($to_email);
}
else
{
	xoops_cp_header();
	weblinks_admin_print_header();
	weblinks_admin_print_menu();
	echo "<h4>"._WEBLINKS_ADMIN_SENDMAIL."</h4>\n";

	if ( $op == 'send' )
	{
		echo "NOT set lid list or email address <br /><br />\n";
	}

	$mail_users->print_form();
}

xoops_cp_footer();
exit();


//=========================================================
// class admin_mail_users
//=========================================================
class admin_mail_users
{
	var $MAX_USER = 50;

	var $_link_handler;
	var $_form;
	var $_post;
	var $_system;
	var $_pagenavi;
	var $_myts;

	var $SITENAME;
	var $ADMINMAIL;
	var $AUTHOR;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_mail_users()
{
	$this->_link_handler  =& weblinks_get_handler('link', WEBLINKS_DIRNAME);

	$this->_form     =& happy_linux_form::getInstance();
	$this->_post     =& happy_linux_post::getInstance();
	$this->_system   =& happy_linux_system::getInstance();
	$this->_pagenavi =& happy_linux_pagenavi::getInstance();

	$this->_myts     =& MyTextSanitizer::getInstance(); 

	$this->SITENAME  = $this->_system->get_sitename();
	$this->ADMINMAIL = $this->_system->get_adminmail();
	$this->AUTHOR    = $this->_system->get_meta_author();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_mail_users();
	}
	return $instance;
}

//---------------------------------------------------------
// post parameter
//---------------------------------------------------------
function get_post_op()
{
	return $this->_post->get_post_text('op');
}

function get_post_to_email()
{
	return $this->_post->get_post_text('to_email');
}

function get_post_lid_arr()
{
	return $this->_post->get_post('lid_arr');
}

//---------------------------------------------------------
// send_users
//---------------------------------------------------------
function send_users($lid_arr)
{
	$total = 0;
	if ( is_array($lid_arr) )
	{
		$total = count($lid_arr);
	}

	$from_name  = $this->_post->get_post_text('from_name');
	$from_email = $this->_post->get_post_text('from_email');
	$subject    = $this->_post->get_post_text('subject');
	$body       = $this->_post->get_post_text('body');

	$this->_pagenavi->setPerpage( $this->MAX_USER );
	$this->_pagenavi->setTotal( $total );
	$page  = $this->_pagenavi->getGetPage();
	$start = $this->_pagenavi->calcStart();
	$end   = $this->_pagenavi->calcEnd();

	printf(_WEBLINKS_THERE_ARE_EMAIL, $total);
	echo "<br />\n";
	printf(_WEBLINKS_SEND_NUM, $start + 1, $end);
	echo "<br /><br />\n";

	$users = array();

	for ( $i=$start; $i<$end; $i++) 
	{
		$lid = $lid_arr[$i];
		$obj =& $this->_link_handler->get($lid);
		list($name, $mail) = $obj->user_name_mail('n');

		$users[] = array(
			'lid'   => $lid,
			'name'  => $name,
			'email' => $mail,
		);
	}

// mail start
	$mailer = new weblinks_mailer();
	$mailer->set_flag_send(1);

	$mailer->setFromName( $from_name );
	$mailer->setFromEmail( $from_email );
	$mailer->setSubject( $subject );
	$mailer->setBody( $body );
	$mailer->prepare();

	foreach ( $users as $user ) 
	{
		$mailer->send_user( $user );
	}

	echo $mailer->getSuccess();
	echo $mailer->getErrors();
// mail end

	echo "<h4>"._AM_SENDCOMP."</h4>\n";

	if ($total > $end)
	{
		$this->print_form_next($page, $this->MAX_USER, $lid_arr);
	}
	else
	{
		echo "<hr /><br />\n";
		echo "<a href='index.php'>"._WEBLINKS_ADMIN_GOTO_ADMIN_INDEX."</a></br />\n";
	}
}

//---------------------------------------------------------
// send_mail
//---------------------------------------------------------
function send_mail($to_email)
{
	$from_name  = $this->_post->get_post_text('from_name');
	$from_email = $this->_post->get_post_text('from_email');
	$subject    = $this->_post->get_post_text('subject');
	$body       = $this->_post->get_post_text('body');

// mail start
	$mailer = new weblinks_mailer();

	$mailer->setFromName(  $from_name );
	$mailer->setFromEmail( $from_email );
	$mailer->setSubject( $subject );
	$mailer->setBody( $body );
	$mailer->useMail();
	$mailer->setToEmails( $to_email );
	$mailer->send( true );

	echo $mailer->getSuccess();
	echo $mailer->getErrors();
// mail end

	echo "<h4>"._AM_SENDCOMP."</h4>\n";
	echo "<hr /><br />\n";
	echo "<a href='index.php'>"._WEBLINKS_ADMIN_GOTO_ADMIN_INDEX."</a></br />\n";

}

//---------------------------------------------------------
// form
//---------------------------------------------------------
function print_form()
{
	$total = 0;
	if ( isset($_POST['memberslist_id']) ) 
	{
		$lid_list = $_POST['memberslist_id'];
		$total    = count( $lid_list );
	}

	if ( $total > 0 ) 
	{
		printf(_WEBLINKS_THERE_ARE_EMAIL, $total);
		echo "<br /><br />\n";
	}

	list($token_name, $token_value) = $this->_form->get_token();

	$form = new XoopsThemeForm(_AM_SENDMTOUSERS, 'mailusers', 'mail_users.php');

	$form->addElement( new XoopsFormHidden('op',  'send') );
	$form->addElement( new XoopsFormHidden('page', 1) );
	$form->addElement( new XoopsFormHidden($token_name, $token_value) );

// from finduser section
	if ( $total > 0 ) 
	{
		$display_names = '';

		for ( $i=0; $i<$total; $i++ ) 
		{
			$lid = intval( $lid_list[$i] );
			$lid_hidden = new XoopsFormHidden('lid_arr[]', $lid);
			$form->addElement($lid_hidden);
			unset($lid_hidden);

			$obj =& $this->_link_handler->get($lid);
			list($name_s, $mail_s) = $obj->user_name_mail('s');

			if ( $name_s )
			{
				$name_d = $name_s;

				if ( $mail_s )
				{
					$name_d = "<a href='mailto:".$mail_s."'>".$name_s."</a>";
				}
			}
			else
			{
				$name_d = "<font color='#ff0000'>---</b>";
			}

			$display_names .= $name_d .', ';
		}

		$display_names = substr($display_names, 0, -2);

		$users_label = new XoopsFormLabel(_AM_SENDTOUSERS2, $display_names );
		$form->addElement( $users_label );
	}
	else
	{
		$mail_to_text = new XoopsFormText(_AM_SENDTOUSERS2, 'to_email', 30, 255 );
		$form->addElement(  $mail_to_text );
		$form->setRequired( $mail_to_text );
	}

	$fname_text = new XoopsFormText(_AM_MAILFNAME, 'from_name', 30, 255, $this->SITENAME );
	$form->addElement($fname_text);

	$femail_text = new XoopsFormText(_AM_MAILFMAIL, 'from_email', 30, 255, $this->ADMINMAIL );
	$form->addElement($femail_text);

	$subject_caption  = _AM_MAILSUBJECT."<br /><br />\n";
	$subject_caption .= "<span style='font-size:x-small;font-weight:bold;'>"._AM_MAILTAGS."</span><br />\n";
	$subject_caption .= "<span style='font-size:x-small;font-weight:normal;'>"._WEBLINKS_MAIL_TAGS1."</span><br />\n";
	$subject_text = new XoopsFormText($subject_caption, 'subject', 50, 255, $this->get_subject() );
	$form->addElement($subject_text);
	$form->setRequired($subject_text);

	$body_caption  = _AM_MAILBODY."<br /><br />\n";
	$body_caption .= "<span style='font-size:x-small;font-weight:bold;'>"._AM_MAILTAGS."</span><br />\n";
	$body_caption .= "<span style='font-size:x-small;font-weight:normal;'>"._WEBLINKS_MAIL_TAGS1."<br />\n";
	$body_caption .= _WEBLINKS_MAIL_TAGS2."<br />\n";
	$body_caption .= _WEBLINKS_MAIL_TAGS3."<br />\n";
	$body_text = new XoopsFormTextArea($body_caption, 'body', $this->get_body(), 10);
	$form->addElement($body_text);
	$form->setRequired($body_text);

	$submit_button = new XoopsFormButton('', 'submit', _WEBLINKS_SENDMAIL, 'submit');
	$form->addElement($submit_button);

	$form->display();

}

function get_subject()
{
	$text = sprintf(_WEBLINKS_SUBJECT_FROM, $this->SITENAME);
	return $text;
}

function get_body()
{
	$SITE_URL = XOOPS_URL.'/';

	$hello     = sprintf(_WEBLINKS_HELLO, '{W_NAME}');
	$webmaster = _WEBLINKS_WEBMASTER;

	$text = <<<END_OF_TEXT
$hello

-----------
$this->SITENAME ({$SITE_URL}) 
$webmaster  $this->AUTHOR
$this->ADMINMAIL
-----------
END_OF_TEXT;

	return $text;
}

function print_form_next($page, $show, $lid_arr)
{
	$from_name  = $this->_myts->makeTboxData4PreviewInForm(  $_POST['from_name'] );
	$from_email = $this->_myts->makeTboxData4PreviewInForm(  $_POST['from_email'] );
	$subject    = $this->_myts->makeTboxData4PreviewInForm(  $_POST['subject'] );
	$body       = $this->_myts->makeTareaData4PreviewInForm( $_POST['body'] );

	$action    = xoops_getenv('PHP_SELF');
	$page_next = $page + 1;
	$submit    = sprintf(_WEBLINKS_SEND_NEXT, $show);

?>
<form action='<?php echo $action; ?>' method='post'>
<input type='hidden' name='op'   value='send'>
<input type='hidden' name='page' value='<?php echo $page_next; ?>'>
<input type='hidden' name='from_name'  value='<?php echo $from_name; ?>'>
<input type='hidden' name='from_email' value='<?php echo $from_email; ?>'>
<input type='hidden' name='subject'    value='<?php echo $subject; ?>'>
<input type='hidden' name='body'       value='<?php echo $body; ?>'>
<?php

	foreach ( $lid_arr as $lid ) 
	{
		$lid = intval($lid);
		echo "<input type='hidden' name='lid_arr[]' value='". $lid ."'>\n";
	}

?>
<input type='submit' value='<?php echo $submit; ?>'>
</form>
<?php

}

function check_token()
{
	$ret = $this->_form->check_token();
	return $ret;
}

// --- class end ---
}

?>