<?php
// $Id: link_manage.php,v 1.11 2006/10/07 06:20:16 ohwada Exp $

// 2006-10-05 K.OHWADA
// use happy_linux
// use rssc WEBLINKS_RSSC_USE
// move delVote to votadata_manage

// 2006-05-15 K.OHWADA
// new handler
// add class admin_link_manage
// use token ticket

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// admin link manage
// divid this file from index.php
// 2004/01/14 K.OHWADA
//=========================================================

include 'admin_header.php';
include_once XOOPS_ROOT_PATH.'/include/xoopscodes.php';
include_once XOOPS_ROOT_PATH.'/class/xoopsformloader.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_votedata_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_sendmail.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_rssc_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_view_edit.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_form_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_form_admin_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_form_check_handler.php';

include_once WEBLINKS_ROOT_PATH.'/admin/modify_manage_class.php';

include_once WEBLINKS_ROOT_PATH.'/admin/rssc_manage_class.php';
include_once WEBLINKS_ROOT_PATH.'/admin/votedata_list_class.php';


//=========================================================
// class admin_link_manage
//=========================================================
class admin_link_manage extends happy_linux_manage
{
	var $_check_handler;
	var $_votedata_handler;
	var $_broken_handler;
	var $_form;
	var $_rssc_edit_handler;

	var $_rssc_modid;

	var $_lid;
	var $_rssc_obj;

	var $_parse_result = null;
	var $_error_title  = null;

	var $_check_param = false;
	var $_check_exist = false;

	var $_ret_add_rssc = 0;
	var $_ret_mod_rssc = 0;
	var $_ret_code_add_rssc_check = false;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_link_manage()
{
	$this->happy_linux_manage( WEBLINKS_DIRNAME );
	$this->set_handler( 'link_edit', WEBLINKS_DIRNAME, 'weblinks' );
	$this->set_id_name( 'lid' );
	$this->set_script(   'link_manage.php' );
	$this->set_redirect( 'link_list.php', 'link_list.php?sortid=1' );
	$this->set_title( _WEBLINKS_ADMIN_ADD_LINK, _WLS_MODLINK, _AM_WEBLINKS_DEL_LINK );
	$this->set_err_no_record( _WLS_ERRORNOLINK );

	$this->_votedata_handler  =& weblinks_get_handler('votedata',        WEBLINKS_DIRNAME);
	$this->_broken_handler    =& weblinks_get_handler('broken',          WEBLINKS_DIRNAME);
	$this->_check_handler     =& weblinks_get_handler('link_form_check', WEBLINKS_DIRNAME);
	$this->_form              =& weblinks_get_handler('link_form_admin', WEBLINKS_DIRNAME );

	$this->_rssc_manage =& admin_rssc_manage::getInstance();

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_link_manage();
	}
	return $instance;
}

//---------------------------------------------------------
// POST param
//---------------------------------------------------------
function get_post_op()
{
	$op = 'main';
	if     ( isset($_POST['del_link']) )  $op = 'del_link';
	elseif ( isset($_POST['delete_link']) )  $op = 'del_link';
	elseif ( isset($_POST['delete_new']) )   $op = 'delete_new';
	elseif ( isset($_POST['ignore']) )       $op = 'ignore';
	elseif ( isset($_POST['cancel']) )       $op = 'cancel';
	elseif ( isset($_POST['op']) )           $op = $_POST['op'];
	elseif ( isset($_GET['op']) )            $op = $_GET['op'];
	return $op;
}

function get_post_lid()
{
	$lid = 0;
	if     ( isset($_POST['link_lid']) )  $lid = $_POST['link_lid'];
	elseif ( isset($_POST['lid']) )       $lid = $_POST['lid'];
	elseif ( isset($_GET['lid']) )        $lid = $_GET['lid'];
	$this->_lid = intval($lid);
	return $this->_lid;
}

function get_post_mid()
{
	return $this->_post->get_post_get_int('mid');
}

function get_post_rssc_lid()
{
	return $this->_post->get_post_get_int('rssc_lid');
}

function get_post_rss_flag()
{
	return $this->_post->get_post_get_int('rss_flag');
}

function get_post_op_modeg()
{
	return $this->_post->get_post_get_text('op_mode');
}

function get_post_banner()
{
	return $this->_post->get_post_url('banner');
}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init()
{
	$this->_handler->init();
}

//---------------------------------------------------------
// add_form
//---------------------------------------------------------
function add_form()
{
	$this->_main_add_form();
}

function _print_add_form()
{
	$this->_form->show_admin_form('submit');
	return true;
}

//---------------------------------------------------------
// add_link
//---------------------------------------------------------
function add_link()
{
	$rss_flag = $this->get_post_rss_flag();

	if ( !$this->_check_token() || !$this->_check_add_link() )
	{
		$this->_print_add_preview();
		exit();
	}

	if ( $this->_exec_add_link() )
	{
// when set banner
		if ( $this->get_post_banner() )
		{
			$this->_print_add_banner_form( $this->_newid, 'add_banner' );
			exit();
		}
// when set rss flag
		elseif ( WEBLINKS_RSSC_USE && $rss_flag )
		{
			$this->_rssc_manage->add_link( $this->_newid, 'add_link' );
			exit();
		}
// finish
		else
		{
			$msg = _WLS_NEWLINKADDED;
			$msg .= " <!-- weblinks : add link -->";	// for test form
			redirect_header($this->_redirect_desc, 1, $msg);
			exit();
		}
	}
	else
	{
		$this->_print_add_table_error();
		exit();
	}
}

function _exec_add_link()
{
// add link & catlink
	$newid = $this->_handler->add_link_by_post();
	if (!$newid)
	{
		$this->_set_errors( $this->_handler->getErrors() );
		return false;
	}

// notification
	list($tags, $cid) = $this->_handler->build_tags_addlink($newid);

	$notification_handler =& xoops_gethandler('notification');
	$notification_handler->triggerEvent('global', 0, 'new_link', $tags);
	$notification_handler->triggerEvent('category', $cid, 'new_link', $tags);

	$this->_newid = $newid;
	return $newid;
}

function _check_add_link()
{
	$ret = $this->_check_handler->check_form_addlink_by_post();
	if (!$ret)
	{	
		$this->_set_errors( $this->_check_handler->get_error_msg_addlink() );
		return false;
	}
	return true;
}

function _print_add_preview_form()
{
	$this->_form->show_admin_form('submit_preview');
}

//---------------------------------------------------------
// mod_form
//---------------------------------------------------------
function mod_form()
{
	if ( !$this->_get_obj() )
	{
		redirect_header( 'link_list.php', 2, _WLS_ERRORNOLINK );
		exit();
	}

	$this->_print_cp_header();
	$this->_print_bread_op( _WLS_MODLINK, 'mod_form');
	$this->_print_title(    _WLS_MODLINK );

	if ( WEBLINKS_RSSC_USE )
	{
		$this->_rssc_manage->check_mod_form( $this->_obj );
	}

	$this->_print_mod_form();
	$this->_print_cp_footer();
}

function _print_mod_form()
{
	$MAX_RECORD = 5;

	$lid = $this->get_post_lid();

	$this->_form->show_admin_form('modify', $lid);
	echo "<hr />\n";

	$list =& admin_votedata_list::getInstance();
	$list->set_perpage( $MAX_RECORD );
	$list->set_flag_get_sortid( false );
	$list->set_flag_print_top(  false );
	$list->set_flag_print_navi( false );

	$totalvotes = $this->_votedata_handler->get_count_by_lid($lid);
	echo "<h4>". sprintf(_WLS_TOTALVOTES, $totalvotes). "</h4>\n";

// Show Registered Users Votes
	$votes1 = $this->_votedata_handler->get_count_user_by_lid($lid);
	echo "<h4>". sprintf(_WLS_USERTOTALVOTES, $votes1). "</h4>\n";

	if ($votes1)
	{
		$list->set_form_name('votedata_user');
		$list->_show_by_sortid(2);
	}
	else
	{
		echo "<b>" ._WLS_NOREGVOTES."</b><br />\n";
	}
	
	if ($votes1 > $MAX_RECORD)
	{
		$url = 'votedata_list.php?sortid=2&amp;lid='.$lid;
		echo '<a href="'.$url.'">'. 'more ...' ."</a><br />\n";
	}

// Show Unregistered Users Votes
	$votes2 = $this->_votedata_handler->get_count_by_lid_uid($lid, 0);
	echo "<h4>". sprintf(_WLS_ANONTOTALVOTES, $votes2). "</h4>\n";

    if ( $votes2 )
    { 
		$list->set_form_name('votedata_anoymous');
		$list->_show_by_sortid(3);
    }
    else 
    {
		echo "<b>" ._WLS_NOUNREGVOTES."</b><br />\n";
    }
    
    if ($votes2 > $MAX_RECORD)
	{
		$url = 'votedata_list.php?sortid=3&amp;lid='.$lid;
		echo '<a href="'.$url.'">'. 'more ...' ."</a><br />\n";
	}
}

//---------------------------------------------------------
// mod_link
//---------------------------------------------------------
function mod_link()
{
	if ( !$this->_get_obj() )
	{
		redirect_header("link_list.php", 3, _WLS_ERRORNOLINK);
		exit();
	}

	if ( !$this->_check_token() || !$this->_check_mod_link() )
	{
		$this->_print_mod_preview();
		exit();
	}

	if ( $this->_exec_mod_link() )
	{
// when set banner
		if ( $this->get_post_banner() )
		{
			$this->_print_mod_banner_form( 'mod_banner' );
			exit();
		}
// when rssc use
		elseif ( WEBLINKS_RSSC_USE )
		{
			$this->_rssc_manage->mod_link( 'mod_link' );
			exit();
		}
// finish
		else
		{
			redirect_header('link_list.php', 1, _WLS_DBUPDATED);
			exit();
		}
	}
	else
	{
		$this->_print_mod_table_error();
		exit();
	}
}

function _exec_mod_link()
{
	$this->_clear_errors();
	$lid = $this->get_post_lid();

// update link & catlink
	$ret = $this->_handler->mod_link_by_post( $lid );
	if (!$ret)
	{
		$this->_set_errors( $this->_handler->getErrors() );
	}

// delete broken
	$broken_count = $this->_broken_handler->get_count_by_lid($lid);
	if ( $broken_count > 0 )
	{
		$ret = $this->_broken_handler->delete_by_lid($lid);
		if (!$ret)
		{
			$this->_set_errors( $this->_broken_handler->getErrors() );
		}
	}

	return $this->returnExistError();
}

function _check_mod_link()
{
	$ret = $this->_check_handler->check_form_modlink_for_owner_by_post();
	if (!$ret)
	{
		$this->_set_errors( $this->_check_handler->get_error_msg_modlink() );
		return false;
	}
	return true;
}

function _print_mod_preview_form()
{
	$this->_form->show_admin_form('modify_preview');
}

//---------------------------------------------------------
// add_banner
//---------------------------------------------------------
function _print_add_banner_form( $lid, $op_mode )
{
	$this->_print_cp_header();
	$this->_print_bread_op( $this->_LANG_TITLE_MOD, 'add_form', _AM_WEBLINKS_ADD_BANNER );

	if ( $op_mode == 'add_banner' )
	{
		echo "<h4>"._WLS_NEWLINKADDED."</h4>\n";
		echo "<hr />\n";
	}

	$this->_print_title( 'add banner' );

	if ( $op_mode == 'add_banner_preview' )
	{
			$this->_print_token_error(1);
			$this->_print_error(1);
	}

	$this->_print_banner_form( $lid, $op_mode );

	$this->_print_cp_footer();
}

function _print_banner_form( $lid, $op_mode )
{
	switch ($op_mode)
	{
		case 'add_banner_preview':
		case 'mod_banner_preview':
			$this->_print_token_error(1);
			$this->_print_error(1);
			break;
	}

	$banner = $this->get_post_banner();
	$width  = 0;
	$height = 0;

	$size =& $this->_handler->get_remote_banner_size($banner);
	if ( is_array($size) && isset($size[0]) && isset($size[1]) )
	{
		$width  = $size[0];
		$height = $size[1];
	}
	elseif ( !$size )
	{
		$this->_set_error_title( _WEBLINKS_WARN_BANNER_NOT_GET_SIZE );
		$this->_set_errors( $this->_handler->get_banner_errors() );
		$this->_print_error(1);
	}

	$this->_form->show_admin_banner_form( $lid, $width, $height, $op_mode );

}

function add_banner()
{
	$lid      = $this->get_post_lid();
	$rss_flag = $this->get_post_rss_flag();

	if ( !$this->_check_token() )
	{
		$this->_print_add_banner_form( $this->_lid, 'add_banner_preview' );
		exit();
	}

	if ( $this->_exec_add_mod_banner() )
	{
// when set rss flag
		if ( WEBLINKS_RSSC_USE && $rss_flag )
		{
			$this->_rssc_manage->add_link($lid, 'add_link');
			exit();
		}
// finish
		else
		{
			$msg = _WLS_NEWLINKADDED;
			$msg .= " <!-- weblinks : add banner -->";	// for test form
			redirect_header($this->_redirect_desc, 1, $msg);
			exit();
		}
	}
	else
	{
		$this->_print_add_table_error();
		exit();
	}
}

function _exec_add_mod_banner()
{
	$ret = $this->_handler->update_banner_and_size_by_post();
	if (!$ret)
	{
		$this->_set_errors( $this->_handler->getErrors() );
		return false;
	}
	return true;
}

//---------------------------------------------------------
// mod_banner
//---------------------------------------------------------
function _print_mod_banner_form( $op_mode )
{
	$this->_print_cp_header();
	$this->_print_bread_op( $this->_LANG_TITLE_MOD, 'mod_form', _AM_WEBLINKS_MOD_BANNER );

	if ( $op_mode == 'mod_banner' )
	{
		echo "<h4>"._WLS_DBUPDATED."</h4>\n";
		echo "<hr />\n";
	}

	$this->_print_title( 'mod banner' );

	if ( $op_mode == 'mod_banner_preview' )
	{
		$this->_print_token_error(1);
		$this->_print_error(1);
	}

	$this->_print_banner_form( $this->_lid, $op_mode );

	$this->_print_cp_footer();
}

function mod_banner()
{
	$lid      = $this->get_post_lid();
	$rss_flag = $this->get_post_rss_flag();

	if ( !$this->_check_token() )
	{
		$this->_print_mod_banner_preview( 'mod_banner_preview' );
		exit();
	}

	if ( $this->_exec_add_mod_banner() )
	{
// when rssc use
		if ( WEBLINKS_RSSC_USE )
		{
			$this->_rssc_manage->mod_link( 'mod_link' );
			exit();
		}
// finish
		else
		{
			redirect_header('link_list.php', 1, _WLS_DBUPDATED);
			exit();
		}
	}
	else
	{
		$this->_print_add_table_error();
		exit();
	}
}

//---------------------------------------------------------
// delLink
//---------------------------------------------------------
function del_link()
{
	$this->_main_del_table();
}

function _exec_del_table()
{
	$lid = $this->get_post_lid();

// BUG 3095: the number of links does not change, if delete link
	$ret = $this->_handler->del_link_vote_comm_catlink_by_lid($lid);
	if (!$ret)
	{
		$this->_set_errors( $this->_handler->getErrors() );
		return false;
	}

	return true;
}

function _print_del_error()
{
	xoops_error("DB Error");
	echo $this->getErrors(1);
}

function _check_del_table()
{
	return true;
}

//---------------------------------------------------------
// handler
//---------------------------------------------------------
function _get_obj()
{
	$lid = $this->get_post_lid();
	$obj = $this->_handler->get($lid);
	if ( is_object($obj) ) 
	{
		$this->_obj =& $obj;
	}
	return $obj;
}

//---------------------------------------------------------
// private print
//---------------------------------------------------------
function _print_menu()
{
	weblinks_admin_print_header();
	weblinks_admin_print_menu();
}

// --- class end ---
}


//=========================================================
// main
//=========================================================

$link_manage    =& admin_link_manage::getInstance();
$modify_manage  =& admin_modify_manage::getInstance();
$rssc_manage    =& admin_rssc_manage::getInstance();

$op  = $link_manage->get_post_op();
$mid = $link_manage->get_post_mid();

// start
$link_manage->init();

switch ($op) 
{
case 'addLinkS':
case 'add_link':
case 'add_table':
	$link_manage->add_link();
	break;

case 'modLink':
case 'mod_form':
	$link_manage->mod_form();
	break;

case 'modLinkS':
case 'mod_link':
case 'mod_table':
	$link_manage->mod_link();
	break;

case 'add_banner':
	$link_manage->add_banner();
	break;

case 'mod_banner':
	$link_manage->mod_banner();
	break;
	
case 'delLink':
case 'delete_link';
case 'del_link';
case 'del_table';
	$link_manage->del_link();
	break;

case 'add_rssc':
	$rssc_manage->add_rssc();
	break;

case 'mod_rssc':
	$rssc_manage->mod_rssc();
	break;

case 'refresh_link':
	$rssc_manage->refresh_link();
	break;

case 'listNewLinks':
case 'list_new':
	$modify_manage->list_new();
	break;

case 'approve':
case 'approve_new':
	$modify_manage->approve_new();
	break;

case 'delNewLink':
case 'delete_new';
case 'del_new';
	$modify_manage->del_new();
	break;

case 'listModReq':
case 'list_mod':
	$modify_manage->list_mod();
	break;

case 'approveModReq':
case 'approve_mod':
	$modify_manage->approve_mod();
	break;

case 'ignore';
case 'ignoreModReq':
case 'del_mod':
	$modify_manage->del_mod();
	break;

case 'main':
case 'add_form':
default:
	$link_manage->add_form();
	break;

}

exit();
// --- end of main ---

?>