<?php
// $Id: language.php,v 1.4 2006/10/07 04:56:50 ohwada Exp $

// 2006-10-05 K.OHWADA
// add happy_linux_language_factory
// move get_google_url() to locate.php

// 2006-09-10 K.OHWADA
// this is new file
// porting from weblinks_language.php

//=========================================================
// Happy Linux Framework Module
// 2006-09-10 K.OHWADA
//=========================================================

//=========================================================
// class happy_linux_language_base
//=========================================================
class happy_linux_language_base
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_linux_language_base()
{
	// dummy
}

//---------------------------------------------------------
// convert encoding
//---------------------------------------------------------
function convert_telafriend_subject($text)
{
	return $text;
}

function convert_telafriend_body($text)
{
	return $text;
}

function convert_download_filename($text)
{
	return $text;
}

//---------------------------------------------------------
// system param
//---------------------------------------------------------
function get_language()
{
	global $xoopsConfig;
	return $xoopsConfig['language'];
}

function get_langcode()
{
	return _LANGCODE;
}

//---------------------------------------------------------
// country code
//---------------------------------------------------------
function get_country_code()
{
	return 'us';	// USA
}

// --- class end ---
}

//=========================================================
// class happy_linux_language_factory
//=========================================================
class happy_linux_language_factory extends happy_linux_language_base
{
	var $_DEFAULT_LANGAGE = 'english';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_linux_language_factory()
{
	$this->happy_linux_language_base();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new happy_linux_language_factory();
	}
	return $instance;
}

function &get_local_instance()
{
	static $local;
	if (!isset($local)) 
	{
		$local =& $this->get_instance( $this->get_language() );
	}
	return $local;
}

//---------------------------------------------------------
// get_instance
//---------------------------------------------------------
function &get_instance( $language=null, $prefix='happy_linux', $dirname='happy_linux' )
{
	if ( $language )
	{
		$instance =& $this->get_instance_by_language( $language, $prefix, $dirname );
		if ( $instance )
		{
			return $instance;
		}
	}

	$instance =& $this->get_instance_by_language( $this->_DEFAULT_LANGAGE, $prefix, $dirname  );
	if ( $instance )
	{
		return $instance;
	}

	$instance =& new happy_linux_language_base();
	return $instance;
}

function &get_instance_by_language( $language, $prefix='happy_linux', $dirname='happy_linux' )
{
	$instance = false;
	$file     = XOOPS_ROOT_PATH.'/modules/'.$dirname.'/language/'.$language.'/language_local.php';
	$class    = $prefix.'_language_local';

	if ( file_exists($file) ) 
	{
		include_once $file;

		if ( class_exists($class) )
		{
			$instance =& new $class();
		}
	}

	return $instance;
}

// --- class end ---
}

?>