<?php
// $Id: whatsnew_config_handler.php,v 1.4 2006/06/21 05:26:53 ohwada Exp $

// 2006-06-20 K.OHWADA
// suppress following messages
//   Warning: Call-time pass-by-reference has been deprecated
//   Notice: Only variable references should be returned by reference
// use WHATSNEW_DEBUG_ERROR

//================================================================
// What's New Module
// class config handler
// 2005-10-01 K.OHWADA
//================================================================

class Whatsnew_Config_Handler extends XoopsObjectHandler
{
	var $_table;
	var $_class_name;
	var $_flag_print_db_error;

// class
	var $_config_define;

// cache
	var $_define_id_cache   = array();
	var $_config_id_cache   = array();
	var $_config_name_cache = array();
	var $_config_data_cache = array();


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function Whatsnew_Config_Handler()
{
	XoopsObjectHandler::XoopsObjectHandler( $GLOBALS['xoopsDB'] );

	$this->_table = $this->db->prefix('whatsnew_config');
	$this->_class_name = 'whatsnew_config_table';

	$this->_flag_print_db_error = WHATSNEW_DEBUG_ERROR;

// class
	$this->_config_define =& Whatsnew_Config_Define::getInstance();

// load to cache
	$this->load();

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new Whatsnew_Config_Handler();
	}

	return $instance;
}

//---------------------------------------------------------
// load to cache
//---------------------------------------------------------
function load()
{
	$this->init_define();

	$id_arr = array();

// create from MySQL
	$sql = 'SELECT * FROM '.$this->_table.' ORDER BY conf_id ASC';

	$res = $this->db->query($sql, 0, 0);
	if ( !$res )
	{
		$this->_print_db_error($sql);
		return false;
	}

// list from MySQL
	while ( $myrow = $this->db->fetchArray($res) ) 
	{
		$id    = $myrow['conf_id'];
		$name  = $myrow['conf_name'];
		$value = $myrow['conf_value'];

		$title     = $this->get_define_var($id, 'title');
		$desc      = $this->get_define_var($id, 'description');
		$catid     = $this->get_define_var($id, 'catid');
		$valuetype = $this->get_define_var($id, 'valuetype');
		$formtype  = $this->get_define_var($id, 'formtype');
		$options   = $this->get_define_var($id, 'options');

		$id_arr[$id] = 1;

		$config =& $this->create( false );	// not new
		$config->assignVars($myrow);
		$config->setVar('conf_exist',     1 );
		$config->setVar('conf_catid',     $catid );
		$config->setVar('conf_valuetype', $valuetype );
		$config->setVar('conf_formtype',  $formtype );
		$config->setVar('conf_options',   $options );
		$config->setVar('conf_title',     $title );
		$config->setVar('conf_desc',      $desc );

		$this->_config_id_cache[$id]     =& $config;
		$this->_config_name_cache[$name] =& $config;
		$this->_config_data_cache[$name] =  $value;
		unset($config);
	}

// list from define
	foreach ($this->_define_id_cache as $id => $define) 
	{
		if ( isset($id_arr[$id]) && $id_arr[$id] ) continue;

		$title     = $this->get_define_var($id, 'title');
		$desc      = $this->get_define_var($id, 'description');
		$name      = $this->get_define_var($id, 'name');
		$catid     = $this->get_define_var($id, 'catid');
		$default   = $this->get_define_var($id, 'default');
		$valuetype = $this->get_define_var($id, 'valuetype');
		$formtype  = $this->get_define_var($id, 'formtype');
		$options   = $this->get_define_var($id, 'options');

// create, when not in MySQL
		$config =& $this->create();
		$config->setVar('conf_id',        $id );
		$config->setVar('conf_name',      $name);
		$config->setVar('conf_catid',     $catid );
		$config->setVar('conf_valuetype', $valuetype );
		$config->setVar('conf_formtype',  $formtype );
		$config->setVar('conf_options',   $options );
		$config->setVar('conf_title',     $title );
		$config->setVar('conf_desc',      $desc );
		$config->setConfValueForInput($default, true);

		$this->_config_id_cache[$id]     =& $config;
		$this->_config_name_cache[$name] =& $config;
		$this->_config_data_cache[$name] =  $default;
		unset($config);
	}

}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function &create($isNew = true)
{
	$config = new $this->_class_name();

	if ($isNew) 
	{
		$config->setNew();
	}

	return $config;
}

function insert(&$config)
{
	if ( !$this->_check_class( $config ) )  return false;
	if ( !$config->isDirty() )    return true;
	if ( !$config->cleanVars() )  return false;

	foreach ($config->cleanVars as $k => $v) 
	{	${$k} = $v;	}

	if ( !$config->isNew() )   return false;

	$sql = sprintf("INSERT INTO %s (conf_id, conf_name, conf_value, aux_int_1, aux_int_2, aux_text_1, aux_text_2) VALUES (%u, %s, %s, %u, %u, %s, %s)", $this->_table, $conf_id, $this->db->quoteString($conf_name), $this->db->quoteString($conf_value), $aux_int_1, $aux_int_2, $this->db->quoteString($aux_text_1), $this->db->quoteString($aux_text_2) );

//	echo "$sql <br>";

	if ( !$result = $this->db->query($sql))
	{
		$this->_print_db_error($sql);
		return false;
	}

	if ( !empty($this->_config_id_cache[$conf_id]) ) 
	{
		unset ($this->_config_id_cache[$conf_id]);
	}

	return true;
}

function update(&$config)
{
	if ( !$this->_check_class( $config ) )  return false;
	if ( !$config->isDirty() )    return true;
	if ( !$config->cleanVars() )  return false;

	foreach ($config->cleanVars as $k => $v) 
	{	${$k} = $v;	}

	$sql = sprintf("UPDATE %s SET conf_name = %s, conf_value = %s, aux_int_1 = %u, aux_int_2 = %u, aux_text_1 = %s, aux_text_2 = %s WHERE conf_id = %u", $this->_table, $this->db->quoteString($conf_name), $this->db->quoteString($conf_value), $aux_int_1, $aux_int_2, $this->db->quoteString($aux_text_1), $this->db->quoteString($aux_text_2), $conf_id);

//	echo "$sql <br>";

	if ( !$result = $this->db->query($sql))
	{
		$this->_print_db_error($sql);
		return false;
	}

	if ( !empty($this->_config_id_cache[$conf_id]) ) 
	{
		unset ($this->_config_id_cache[$conf_id]);
	}

	return true;
}

function update_by_id($id, $value)
{
	$id = intval($id);
	if ($id <= 0) return false;

	$config =& $this->_config_handler->get($id);
	$config->setConfValueForInput($value, true);
	return $this->update($config);
}

function update_by_name($name, $value)
{
	$id = $this->get_id_by_name($name);
	return $this->update_by_id($id, $value);
}

function delete(&$config)
{
	if ( !$this->_check_class( $config ) )  return false;

	$id  = $config->getVar('conf_id');
	$sql = sprintf("DELETE FROM %s WHERE conf_id = %u", $this->_table, $conf_id);

	if ( !$result = $this->db->query($sql) )
	{
		$this->_print_db_error($sql);
		return false;
	}

	if ( !empty($this->_config_id_cache[$conf_id]) ) 
	{
		unset ($this->_config_id_cache[$conf_id]);
	}

	return true;
}

function &get_all()
{
	return $this->_config_id_cache;
}

function &get_config_name_data()
{
	return $this->_config_name_cache;
}

function &get_config_data()
{
	return $this->_config_data_cache;
}

function &get($id)
{
	$val = false;
	$id  = intval($id);

	if ( ($id > 0) && isset($this->_config_id_cache[$id]) )
	{
		$val = $this->_config_id_cache[$id];
	}

	return $val;
}

function &get_by_catid($catid)
{
	$catid = intval($catid);
	$config_arr = array();

	if ($catid > 0)
	{
		foreach ($this->_config_id_cache as $id => $config)
		{
			if ( $catid == $config->getVar('conf_catid') )
			{
				$config_arr[$id] =& $config;
			}
		}
	}

	return $config_arr;
}

function get_num()
{
	$sql = "SELECT count(*) FROM ". $this->_table;

	$result = $this->db->query($sql);
	if ( !$result )
	{
		$this->_print_db_error($sql);
		return false;
	}

	$array = $this->db->fetchRow( $result );
	$num   = $array[0];
	if (empty($num)) $num = 0;

	return $num;
}

function get_id_by_name($name)
{
	if ( isset( $this->_config_name_cache[$name] ) )
	{
		return $this->_config_name_cache[$name]->getVar('conf_id');
	}
	return false;
}

function is_exist_by_name($name)
{
	$id = $this->get_id_by_name($name);

	if ( !isset($this->_config_id_cache[$id]) )
	{
		return false;
	}

	if ( $this->_config_id_cache[$id]->isNew() )
	{
		return false;
	}

	return true;
}

function _check_class( &$config )
{
	if (strtolower(get_class($config)) == $this->_class_name) 
	{
		return true;
	}

	return false;
}

//---------------------------------------------------------
// debug
//---------------------------------------------------------
function _print_db_error($sql='')
{
	if ( !$this->_flag_print_db_error )  return;

	if ($sql)
	{
		echo "sql: $sql <br />\n";
	}

	echo "error: ".$this->db->error()," <br />\n";	
}

//---------------------------------------------------------
// config define
//---------------------------------------------------------
function init_define()
{
	$this->_define_id_cache = $this->_config_define->get_define();
}

function &get_define_all()
{
	return $this->_define_id_cache;
}

function get_define_var($id, $key)
{
	$id = intval($id);
	if ($id <= 0) return false;

	if ( !isset($this->_define_id_cache[$id][$key]) )
	{
		return false;;
	}

	$value = $this->_define_id_cache[$id][$key];

	switch ($key)
	{
		case 'title':
		case 'description':
			if ( defined( $value ) )
			{
				return constant( $value );
			}
			else
			{
				return $value;
			}
			break;

		default:
			return $value;
			break;
	}

	return false;	// dummy
}

function get_value_for_save($id, $post)
{
	$name = $this->_config_id_cache[$id]->getVar('conf_name');
	return $this->_config_define->get_conf_value_by_name( $name, $post );
}

// --- class end ---
}

?>