<?php
// $Id: viewfeed.php,v 1.7 2006/05/24 13:22:59 ohwada Exp $

// 2006-05-15 K.OHWADA
// add weblinks_viewfeed_main()
// use new handler

// 2006-03-15 K.OHWADA
// use weblinks_pagenavi_basic::getInstance()

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//================================================================
// WebLinks Module
// view atom feed
// 2004-11-28 K.OHWADA
//================================================================

include "header.php";
include_once WEBLINKS_ROOT_PATH."/class/weblinks_pagenavi.php";

$weblinks_atomfeed_handler =& weblinks_get_handler( 'atomfeed',  WEBLINKS_DIRNAME );
$weblinks_template =& weblinks_template::getInstance( WEBLINKS_DIRNAME );

// --- template start ---
include XOOPS_ROOT_PATH."/header.php";
$xoopsOption['template_main'] = WEBLINKS_DIRNAME."_viewfeed.html";

// rss/atom auto discovery
$xoopsTpl->assign('xoops_rss',  'modules/'.WEBLINKS_DIRNAME.'/rss.php' );
$xoopsTpl->assign('xoops_atom', 'modules/'.WEBLINKS_DIRNAME.'/atom.php' );
$xoopsTpl->assign('lang_atomfeed_distribute', _WLS_ATOMFEED_DISTRIBUTE);

$weblinks_template->assignIndex();
$weblinks_template->assignDisplayLink();
$weblinks_template->assignHeader();

$total = $weblinks_atomfeed_handler->getCount();
$xoopsTpl->assign('total_atomfeed', $total);

if ($total > 0)
{
	weblinks_viewfeed_main($total);
}

include XOOPS_ROOT_PATH.'/footer.php';
exit();
// --- main end ---


//---------------------------------------------------------
// function
//---------------------------------------------------------
function weblinks_viewfeed_main($total)
{
	global $xoopsTpl;

	$link_view_handler =& weblinks_get_handler( 'link_view',      WEBLINKS_DIRNAME );
	$pagenavi =& weblinks_pagenavi::getInstance();

	$conf = $link_view_handler->get_config();
	$conf_rss_perpage      = $conf['rss_perpage'];
	$conf_rss_mode_title   = $conf['rss_mode_title'];
	$conf_rss_mode_content = $conf['rss_mode_content'];
	$conf_rss_max_content  = $conf['rss_max_content'];
	$conf_rss_max_summary  = $conf['rss_max_summary'];

	$link_view_handler->set_feed_mode_title(   $conf_rss_mode_title );
	$link_view_handler->set_feed_mode_content( $conf_rss_mode_content );
	$link_view_handler->set_feed_max_content(  $conf_rss_max_content );
	$link_view_handler->set_feed_max_summary(  $conf_rss_max_summary );

	$pagenavi->setPerpage( $conf_rss_perpage );
	$pagenavi->setTotal($total);

	$pagenavi->getGetPage();
	$start = $pagenavi->calcStart();

	$xoopsTpl->assign('show_feeds', true);

	$feed_list =& $link_view_handler->get_feed_list_latest($conf_rss_perpage, $start);

	foreach ($feed_list as $feed) 
	{
		$xoopsTpl->append('feeds', $feed);
	}

//if 2 or more items in result, show page navi
	if($total > 1)
	{
		$navi = $pagenavi->build();
		$xoopsTpl->assign('page_navi', $navi);
	}

}

?>