<?php
// $Id: index.php,v 1.8 2006/09/24 06:28:48 ohwada Exp $

// 2006-09-24 K.OHWADA
// BUG 4278: cannot set no link list on the top page

// 2006-05-15 K.OHWADA
// new handler

// 2006-03-26 K.OHWADA
// REQ 3807: Description in main page

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//================================================================
// WebLinks Module
// 2004/01/14 K.OHWADA
//================================================================

include "header.php";
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_form.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_config2_define_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_linkitem_define_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_config_check_handler.php';

$weblinks_view_handler     =& weblinks_get_handler( 'link_view',     WEBLINKS_DIRNAME );
$weblinks_check_handler    =& weblinks_get_handler( 'config_check',  WEBLINKS_DIRNAME );
$weblinks_template =& weblinks_template::getInstance( WEBLINKS_DIRNAME );


//---------------------------------------------------------
// config check
//---------------------------------------------------------

include XOOPS_ROOT_PATH."/header.php";

$is_admin = $weblinks_view_handler->is_admin();

if ( $is_admin && !$weblinks_check_handler->exist_config() )
{
	$weblinks_check_handler->print_form_init( 'admin/index.php' );
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

if ( $is_admin && !$weblinks_check_handler->check_version() )
{
	$weblinks_check_handler->print_form_upgrade( 'admin/index.php' );
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}


//---------------------------------------------------------
// main
//---------------------------------------------------------

$conf = $weblinks_view_handler->get_config();
$conf_cat_sub         = $conf['cat_sub'];
$conf_cat_img_mode    = $conf['cat_img_mode'];
$conf_newlinks        = $conf['newlinks'];
$conf_rss_use         = $conf['rss_use'];
$conf_rss_max_summary = $conf['rss_max_summary'];
$conf_rss_new         = $conf['rss_new'];

// for debug
// print_time('start');

$xoopsOption['template_main'] = WEBLINKS_DIRNAME."_index.html";

// Index
$weblinks_template->assignIndex();
$weblinks_template->assignDisplayLink();

// REQ 3807: Description in main page
$weblinks_template->assignHeader( true );

$xoopsTpl->assign('category_image_mode', $conf_cat_img_mode);

// --- category list ---
$weblinks_view_handler->init();

$pid          = 0;
$flag_image   = 1;
$flag_catpath = 0;
$category_list = $weblinks_view_handler->get_category_list_by_pid($pid, $flag_image, $flag_catpath, $conf_cat_sub);

$count = 1;
foreach ($category_list as $list)
{
	$ch_id         = $list['cid'];
	$title_s       = $list['title_s'];
	$link_count    = $list['link_count'];
	$image_link    = $list['image_link'];
	$subcategories = $list['subcategories'];

	$xoopsTpl->append('categories', array(
		'id'            => $ch_id,
		'title'         => $title_s,
		'totallink'     => $link_count,
		'image'         => $image_link,
		'subcategories' => $subcategories,
		'count'         => $count,
		));

	$count++;
}

// --- link list ---
$total_link = $weblinks_view_handler->get_link_count_public();
$xoopsTpl->assign('lang_thereare', sprintf(_WLS_THEREARE, $total_link));

// BUG 4278: cannot set no link list on the top page
$show_links_list = 0;
$links_list      = '';

if ($conf_newlinks)
{
	$link_list =& $weblinks_view_handler->get_link_list_latest( $conf_newlinks );
	if ( is_array($link_list) && count($link_list) )
	{
		$show_links_list = 1;
		$links_list = $weblinks_template->fetch_links_list( $link_list );
	}
}

$xoopsTpl->assign('show_links_list',     $show_links_list);
$xoopsTpl->assign('weblinks_links_list', $links_list);

// --- atomfeed list ---
$show_new_atomfeed = 0;
$show_feeds_list   = 1;

if ( $conf_rss_use && $conf_rss_new )
{
	$show_new_atomfeed = 1;

	$weblinks_view_handler->set_feed_mode_title( 0 );	// not allow HTML tag
	$weblinks_view_handler->set_feed_max_summary(  $conf_rss_max_summary );
	$feed_list = $weblinks_view_handler->get_feed_list_latest( $conf_rss_new );

	if ( count($feed_list) > 0 )
	{
		foreach ($feed_list as $feed) 
		{
			$xoopsTpl->append('feeds', $feed);
		}

		$show_feeds_list = 1;
	}
}

$xoopsTpl->assign('show_new_atomfeed', $show_new_atomfeed);
$xoopsTpl->assign('show_feeds_list',   $show_feeds_list);

// for debug
// print_time('end');

include XOOPS_ROOT_PATH.'/footer.php';
exit();
// --- main end ---

?>