<?php
// $Id: weblinks_rss_atom_collect_handler.php,v 1.3 2006/09/16 04:16:55 ohwada Exp $

// 2006-07-31 K.OHWADA
// not clean old feeds in singlelink
// add clean_old_feeds()

// 2006-05-15 K.OHWADA
// use new handler

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication


//=========================================================
// WebLinks Module
// assign RSS / ATOM to template
// use class ConvertLanguage, atom_parser, rss_parser
// 2004-10-24 K.OHWADA
//=========================================================

//---------------------------------------------------------
// TODO
// class language_convert convert_from_utf8()
//---------------------------------------------------------


// === class begin ===
if( !class_exists('weblinks_rss_atom_collect_handler') ) 
{

//=========================================================
// weblinks_rss_atom_collect_handler
//=========================================================
class weblinks_rss_atom_collect_handler extends weblinks_rss_atom_parser_base
{
// link table
	var $lid;
	var $title;
	var $url;
	var $broken;
	var $rss_flag;
	var $rss_url;
	var $rss_update;
	var $rss_xml;

// parameter
	var $cache_time;
	var $mode_auto;
	var $flag_rss_xml_save;
	var $mode_data;
	var $num_feed;

// counter
	var $count_refresh_rss_url;
	var $count_refresh_rss_update;
	var $count_refresh_atom_site;
	var $count_refresh_atomfeed;

// class instance
	var $_link_handler;
	var $_atomfeed_handler;

	var $rss;
	var $atom;
	var $remote;
	var $lang;

	var $_conf_rss_black_arr;
	var $_conf_rss_white_arr;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_rss_atom_collect_handler( $dirname )
{

// count
	$this->count_refresh_rss_url    = 0;
	$this->count_refresh_rss_update = 0;
	$this->count_refresh_atom_site  = 0;
	$this->count_refresh_atomfeed   = 0;

// class instance
	$config_basic_handler    =& weblinks_get_handler( 'config2_basic',  $dirname );
	$this->_link_handler     =& weblinks_get_handler( 'link_basic',     $dirname );
	$this->_atomfeed_handler =& weblinks_get_handler( 'atomfeed_basic', $dirname );

	$this->rss     =& weblinks_rss_parser::getInstance();
	$this->atom    =& weblinks_atom_parser::getInstance();
	$this->remote  =& weblinks_remote_file::getInstance();
	$this->lang    =& weblinks_language_convert::getInstance();

	$conf = $config_basic_handler->get_cached();
	$this->_conf_rss_black_arr = $conf['rss_black_arr'];
	$this->_conf_rss_white_arr = $conf['rss_white_arr'];
	$this->_conf_rss_limit     = $conf['rss_limit'];

// parameter
	$this->set_mode_auto(  1 );	// auto
	$this->set_mode_data(  0 );	// atomfeed
	$this->set_cache_time( 24 );	// 24 hours
	$this->set_num_feed( 10 );

	$this->set_mode_title(   0 );	// not allow HTML tag
	$this->set_mode_content( 0 );	// not allow HTML tag
	$this->set_mode_arrange( 0 );	// raw data
	$this->set_max_content( 100 );
	$this->set_max_summary( 100 );
	$this->set_title_default( "---" );

// for debug
// 0=no save, 1=save
	$this->flag_rss_xml_save = 1;

}

//---------------------------------------------------------
// refresh and parse XML
//---------------------------------------------------------
function parse_xml_for_singlelink($lid)
{

	$this->lid = $lid;
	$this->get_link_by_lid($lid);

// refresh RSS/ATOM URL
	if ( $this->mode_auto && ($this->rss_flag == 3) )
	{
		$this->refresh_rss_url($lid, $this->url);
	}

	if ( empty($this->rss_url) )   return false;
	if ( ($this->rss_flag != 1) && ($this->rss_flag != 2) )  return false;


// refresh ATOM feed
	if ( $this->check_refresh_time( $this->rss_update ) )
	{
		$this->refresh_atom_site($lid, $this->rss_url);
		$this->clean_old_feeds();
	}

	$feeds = array();

// parse XML
	if ( $this->mode_data )
	{
		$this->set_mode_arrange( 1 );	// view data
		$feeds = $this->parse_xml($this->rss_xml);
		if (!$feeds)  { return array(); }
	}

	return $feeds;

}

function parse_xml_for_block($lid)
{
	$this->lid      = $lid;

	$this->get_link_by_lid($lid);

	if ( empty($this->rss_url) )   return false;
	if ( ($this->rss_flag != 1) && ($this->rss_flag != 2) )  return false;

// refresh ATOM feed
	if ( $this->check_refresh_time( $this->rss_update ) )
	{
		$this->refresh_atom_site($lid, $this->rss_url);
		$this->clean_old_feeds();
	}

	$feeds = array();

// parse XML
	if ( $this->mode_data )
	{
		$feeds = $this->parse_xml($this->rss_xml);
		if (!$feeds)  { return array(); }
	}

	return $feeds;
}

function refresh_xml_for_admin($lid, $xml_data)
{
	$this->get_link_by_lid($lid);

// refresh ATOM feed
	$this->refresh_atom_cache($lid, $xml_data);
}

function refresh_xml_for_admin_2($xml_data)
{
	$this->rss_flag = 1;
	$this->refresh_atomfeed(0, $xml_data);
}

//---------------------------------------------------------
// get link data
//---------------------------------------------------------
function get_link_by_lid($lid)
{
	$row = $this->_link_handler->get_row_by_lid($lid);
	$this->set_link_value_by_row($row);
}

function set_link_value_by_row($row)
{
	$this->lid        = $row['lid'];
	$this->title      = $row['title'];
	$this->url        = $row['url'];
	$this->broken     = $row['broken'];
	$this->rss_flag   = $row['rss_flag'];
	$this->rss_url    = $row['rss_url'];
	$this->rss_update = $row['rss_update'];
	$this->rss_xml    = $row['rss_xml'];
}

//---------------------------------------------------------
// refresh URL
//---------------------------------------------------------
function refresh_rss_url($lid, $url_html)
{

	$data_html = $this->read_remote_file($url_html);
	if ( empty($data_html) )
	{
		return false;
	}

	list($url_rss, $url_atom) = $this->find_rss_atom_link($data_html);

// BUG 3106: cannot find a relative RSS url correctly.
// patch by SnAKes
	$url_rss  = $this->relative_to_full_url($url_rss,  $url_html);
	$url_atom = $this->relative_to_full_url($url_atom, $url_html);

	if ($url_atom)
	{
		$this->update_link_rssurl($lid, 2, $url_atom);

		$this->rss_flag = 2;
		$this->rss_url  = $url_atom;
		$this->count_refresh_rss_url ++;
		return true;
	}
	elseif ($url_rss)
	{
		$this->update_link_rssurl($lid, 1, $url_rss);

		$this->rss_flag = 1;
		$this->rss_url  = $url_rss;
		$this->count_refresh_rss_url ++;
		return true;
	}

	return false;
}

//---------------------------------------------------------
// refresh XML
//---------------------------------------------------------
function check_refresh_time($update)
{
	if ( time() > ($update + $this->cache_time) )
	{	return true;	}

	return false;
}

function refresh_atom_site($lid, $rss_url)
{
// get remote XML
	$xml_data = $this->read_remote_xml($rss_url);
	if (!$xml_data)
	{
		return false;
		// set no use RSS ( in future)
	}

// refresh XML cache
	$ret = $this->refresh_atom_cache($lid, $xml_data);
	return $ret;
}

function refresh_atom_cache($lid, $xml_data)
{
// refresh XML cache
	$this->rss_update = time();
	$this->rss_xml    = $xml_data;

	if ( $this->flag_rss_xml_save )
	{
		$this->update_link_rssxml($lid, $this->rss_update, addslashes($xml_data) );
	}
	else
	{
		$this->update_link_rss_update($lid, $this->rss_update);
	}

	$this->count_refresh_rss_update ++;

	$ret = $this->refresh_atomfeed($lid, $xml_data);
	return $ret;
}

// refresh ATOM feed
function refresh_atomfeed($lid, $xml_data)
{
// parse XML
	$items = $this->parse_xml($xml_data);

	if (empty($items))  return false;

// refresh ATOM feed
	foreach($items as $item)
	{
		$ret1 = $this->check_black( $item['url'] );
		if ( $ret1 )  continue;

		$item['lid'] = $lid;

		$ret2 = $this->_atomfeed_handler->refresh($item);
		if ($ret2)
		{	$this->count_refresh_atomfeed ++;	}

	}

	$this->count_refresh_atom_site ++;
	return true;
}

function check_black($url)
{
	if ( count( $this->_conf_rss_black_arr ) == 0 )
	{	return false;	}

	foreach ( $this->_conf_rss_black_arr as $black )
	{
		$black = str_replace("|", '\|', $black);

		if ( preg_match("|$black|i", $url) )
		{
			$ret = $this->check_white($url);
			if ( !$ret )
			{
//				echo "<font color='red'>".$url."</font><br />\n";
				return true;
			}
		}
	}

	return false;
}

function check_white($url)
{
	if ( count( $this->_conf_rss_white_arr ) == 0 )
	{	return false;	}

	foreach ( $this->_conf_rss_white_arr as $white )
	{
		$white = str_replace("|", '\|', $white);

		if ( preg_match("|$white|i", $url) )
		{
//			echo "<font color='blue'>".$url."</font><br />\n";
			return true;
		}
	}

	return false;
}

//---------------------------------------------------------
// clean old feeds
//---------------------------------------------------------
// not clean old feeds in singlelink
function clean_old_feeds()
{
	$del = $this->_atomfeed_handler->clear_over_num( $this->_conf_rss_limit );
	return $del;
}

//---------------------------------------------------------
// parse XML
//---------------------------------------------------------
function parse_xml($xml_data)
{
	if ($this->rss_flag == 2)
	{
		$ret = $this->parse_atom( $xml_data );
	}
	elseif ($this->rss_flag == 1)
	{
		$ret = $this->parse_rss( $xml_data );
	}
	else
	{
		$ret = false;
	}
	return $ret;
}

function parse_atom($xml_data)
{
	$ret = $this->atom->parse_data($xml_data);
	if (!$ret) return false;

	$feed = $this->atom->get_feed();
	$feed = $this->convert_array_from_utf8( $feed );
	$site_title = $feed['title'];
	$site_url   = $feed['link'];

	$entrys = $this->atom->get_entrys();
	$entrys = $this->convert_array_array_from_utf8( $entrys );
	$entrys = $this->atom->arrange_entrys( $entrys, $site_title, $site_url );
	return $entrys;
}

function parse_rss($xml_data)
{

	$ret = $this->rss->parse($xml_data);
	if (!$ret)
	{
		$error = $this->rss->get_parse_error();
	
		echo "$error <br>";
		return false;
	}

	$channel = $this->rss->get_channel();
	$channel = $this->convert_array_from_utf8( $channel );
	$site_title = $channel['title'];
	$site_url   = $channel['link'];

	$items = $this->rss->get_items();
	$items = $this->convert_array_array_from_utf8( $items );
	$items = $this->rss->arrange_items( $items, $site_title, $site_url );
	return $items;
}

//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function set_mode_auto($value)
{
	$this->mode_auto = intval($value);
}

function set_mode_data($value)
{
	$this->mode_data = intval($value);
}

function set_cache_time($value)
{
	$this->cache_time = 3600 * intval($value);	// hour
}

function set_num_feed($value)
{
	$this->num_feed = intval($value);
}

function set_mode_title($value)
{
	$mode = intval($value);
	$this->rss->set_mode_title(  $mode );
	$this->atom->set_mode_title( $mode );
}

function set_mode_content($value)
{
	$mode = intval($value);
	$this->rss->set_mode_content(  $mode );
	$this->atom->set_mode_content( $mode );
}

function set_mode_arrange($value)
{
	$mode = intval($value);
	$this->rss->set_mode_arrange(  $mode );
	$this->atom->set_mode_arrange( $mode );
}

function set_max_content($value)
{
	$max = intval($value);
	$this->rss->set_max_content(  $max );
	$this->atom->set_max_content( $max );
}

function set_max_summary($value)
{
	$max = intval($value);
	$this->rss->set_max_summary(  $max );
	$this->atom->set_max_summary( $max );
}


function set_title_default($value)
{
	$this->rss->set_title_default( $value );
}

function set_max_summary_collect($value)
{
	$max_summary = intval($value);

	$this->rss->set_max_summary($max_summary);
	$this->atom->set_max_summary($max_summary);
}

//=========================================================
// use class ConvertLanguage
// override rss_atom_parser_base
//=========================================================
function convert_from_utf8($text)
{
	$text = $this->lang->convert_from_utf8($text);
	return $text;
}

//---------------------------------------------------------
// multibyte
//---------------------------------------------------------
function convert($text, $to, $from)
{
	if ( $to == $from )
	{
		return $text;
	}

	if ( function_exists('mb_convert_encoding') )
	{
		$text = mb_convert_encoding($text, $to, $from);
	}
	elseif ( $to == 'utf-8' )
	{
		$text = utf8_encode($text);
	}
	elseif ( $from == 'utf-8' )
	{
		$text = utf8_decode($text);
	}

	return $text;
}

//=========================================================
// use link handler
//=========================================================
function update_link_rssurl($lid, $rss_flag, $rss_url)
{
	$ret = $this->_link_handler->update_rssflag_rssurl($lid, $rss_flag, $rss_url);
	return $ret;
}

function update_link_rssxml($lid, $rss_update, $rss_xml)
{
	$ret = $this->_link_handler->update_rssupdate_rssxml($lid, $rss_update, $rss_xml);
	return $ret;
}

function update_link_rss_update($lid, $rss_update)
{
	$ret = $this->_link_handler->_rssupdate($lid, $rss_update);
	return $ret;
}

//=========================================================
// use class remote_file
// override rss_atom_parser_base
//=========================================================
function read_remote_file($url)
{
	$ret = $this->remote->read_file( $url );
	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>