<?php
// $Id: weblinks_post.php,v 1.2 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// add get_post_array_int(), etc

//================================================================
// WebLinks Module
// portint from RSSC
// 2006-01-01 K.OHWADA
//================================================================

// === class begin ===
if( !class_exists('weblinks_post') ) 
{

//=========================================================
// class weblinks_post
//=========================================================
class weblinks_post
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_post()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_post();
	}

	return $instance;
}

//=========================================================
// Public
//=========================================================
//---------------------------------------------------------
// get $_POST
//---------------------------------------------------------
function get_post($key, $default='')
{
	if ( isset($_POST[$key]) )
	{
		$val = $_POST[$key];
	}
	else
	{
		$val = $default;
	}
	
	return $val;
}

function get_post_int($key, $default=0)
{
	if ( isset($_POST[$key]) )
	{
		$val = intval($_POST[$key]);
	}
	else
	{
		$val = intval($default);
	}

	return $val;
}

function get_post_float($key, $default=0)
{
	if ( isset($_POST[$key]) )
	{
		return floatval($_POST[$key]);
	}
	else
	{
		$val = floatval($default);
	}

	return $val;
}

function get_post_text($key, $default='')
{
	if (isset($_POST[$key])) 
	{
		$text = $this->strip_slashes_gpc( $_POST[$key] );
		$text = $this->strip_control_code($text);
	}
	else
	{
		$text = $default;
	}

	return $text;
}

function get_post_trim($key, $default='')
{
	if ( isset($_POST[$key]) )
	{
		$val = trim($_POST[$key]);
	}
	else
	{
		$val = trim($default);
	}

	return $val;
}

function get_post_array_int($key)
{
	if ( isset($_POST[$key]) && is_array($_POST[$key]) )
	{
		$arr = array();
		foreach ( $_POST[$key] as $k => $v )
		{
			$arr[$k] = intval($v);
		}
		return $arr;
	}

	return false;
}

function get_post_array_float($key)
{
	if ( isset($_POST[$key]) && is_array($_POST[$key]) )
	{
		$arr = array();
		foreach ( $_POST[$key] as $k => $v )
		{
			$arr[$k] = floatval($v);
		}
		return $arr;
	}

	return false;
}

function get_post_array_text($key)
{
	if ( isset($_POST[$key]) && is_array($_POST[$key]) )
	{
		$arr = array();
		foreach ( $_POST[$key] as $k => $v )
		{
			$text = $this->strip_slashes_gpc( $v );
			$text = $this->strip_control_code($text);
			$arr[$k] = $text;
		}
		return $arr;
	}

	return false;
}

function get_post_text_split($key, $pattern="\n")
{
	$arr = array();

	if ( isset($_POST[$key]) )
	{
		$val = $this->strip_slashes_gpc( $_POST[$key] );
		$arr = split($pattern, $val );
	}

	return $arr;
}

//---------------------------------------------------------
// get $_GET
//---------------------------------------------------------
function get_get($key, $default='')
{
	if ( isset($_GET[$key]) )
	{
		$val = $_GET[$key];
	}
	else
	{
		$val = $default;
	}

	return $val;
}

function get_get_int($key, $default=0)
{
	if ( isset($_GET[$key]) )
	{
		$val = intval($_GET[$key]);
	}
	else
	{
		$val = intval($default);
	}

	return $val;
}

function get_get_float($key, $default=0)
{
	if ( isset($_GET[$key]) )
	{
		$val = floatval($_GET[$key]);
	}
	else
	{
		$val = floatval($default);
	}

	return $val;
}

function get_get_text($key, $default='')
{
	if (isset($_GET[$key])) 
	{
		$text = $this->strip_slashes_gpc( $_GET[$key] );
		$text = $this->strip_control_code($text);
	}
	else
	{
		$text = $default;
	}

	return $text;
}

function get_get_trim($key, $default='')
{
	if ( isset($_GET[$key]) )
	{
		$val = trim($_GET[$key]);
	}
	else
	{
		$val = trim($default);
	}

	return $val;
}

//---------------------------------------------------------
// get $_POST & $_GET
//---------------------------------------------------------
function get_post_get($key, $default='')
{
	if (isset($_POST[$key])) 
	{
		$val = $_POST[$key];
	}
	elseif (isset($_GET[$key])) 
	{
		$val= $_GET[$key];
	}
	else
	{
		$val = $default;
	}

	return $val;
}

function get_post_get_int($key, $default=0)
{
	if (isset($_POST[$key])) 
	{
		$val = intval($_POST[$key]);
	}
	elseif (isset($_GET[$key])) 
	{
		$val = intval($_GET[$key]);
	}
	else
	{
		$val = intval($default);
	}

	return $val;
}

function get_post_get_float($key, $default=0)
{
	if (isset($_POST[$key])) 
	{
		$val = floatval($_POST[$key]);
	}
	elseif (isset($_GET[$key])) 
	{
		$val = floatval($_GET[$key]);
	}
	else
	{
		$val = floatval($default);
	}

	return $val;
}

function get_post_get_text($key, $default='')
{
	if (isset($_POST[$key])) 
	{
		$text = $this->strip_slashes_gpc( $_POST[$key] );
		$text = $this->strip_control_code($text);
	}
	elseif (isset($_GET[$key])) 
	{
		$text = $this->strip_slashes_gpc( $_GET[$key] );
		$text = $this->strip_control_code($text);
	}
	else
	{
		$text = $default;
	}

	return $text;
}

function get_post_get_trim($key, $default='')
{
	if (isset($_POST[$key])) 
	{
		$val = trim($_POST[$key]);
	}
	elseif (isset($_GET[$key])) 
	{
		$val = trim($_GET[$key]);
	}
	else
	{
		$val = trim($default);
	}

	return $val;

}

function get_post_get_passwd_old()
{
	$flag_passwd = false;
	$flag_code   = false;
	$passwd      = '';

	if ( isset( $_POST['passwd_old'] ) )
	{
		$flag_passwd = true;
		$passwd = $this->get_post_text('passwd_old');
	}
	elseif ( isset( $_GET['code'] ) )
	{
		$flag_code = true;
		$passwd = $this->get_get_text('code');
	}

	return array($passwd, $flag_passwd, $flag_code);
}

//---------------------------------------------------------
// utility
//---------------------------------------------------------
function strip_slashes_gpc($text)
{
	if (get_magic_quotes_gpc()) 
	{
		$text = stripslashes($text);
	}
	return $text;
}

function strip_control_code($text)
{
	$text = preg_replace('/[\x00-\x09]/',' ',$text);
	$text = preg_replace('/[\x0B-\x0C]/',' ',$text);
	$text = preg_replace('/[\x0E-\x1F]/',' ',$text);
	$text = preg_replace('/[\x7F]/',     ' ',$text);
	return $text;
}

// --- class end ---
}

// === class end ===
}

?>