<?php
// $Id: weblinks_linkitem_define_handler.php,v 1.1 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//================================================================
// WebLinks Module
// this file contain 2 class
//   weblinks_linkitem_define
//   weblinks_linkitem_define_handler
// 2006-05-15 K.OHWADA
//================================================================

// === class begin ===
if( !class_exists('weblinks_linkitem_define_handler') ) 
{

//=========================================================
// class weblinks_linkitem_define
//=========================================================
class weblinks_linkitem_define
{
// user_mode
//   0: not use
//   1: use
//   2: indispensable
//
// conf_form
//   0: not show
//   1: show
//   2: fixed

	var $_cached = array();

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_linkitem_define()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_linkitem_define();
	}

	return $instance;
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function get_define()
{

//---------------------------------------------------------
// basic config
//---------------------------------------------------------
	 $config[1]['name']       = 'mid';
	 $config[1]['title']      = _WEBLINKS_MID;
	 $config[1]['user_mode']  = 1;
	 $config[1]['user_form']  = 'mid';
	 $config[1]['admin_form'] = 'mid';
	 $config[1]['conf_form']  = 0;

	 $config[2]['name']       = 'lid';
	 $config[2]['title']      = _WLS_LINKID;
	 $config[2]['user_mode']  = 1;
	 $config[2]['user_form']  = 'lid';
	 $config[2]['admin_form'] = 'lid';
	 $config[2]['conf_form']  = 0;

	 $config[3]['name']       = 'uid';
	 $config[3]['title']      = _WEBLINKS_USERID;
	 $config[3]['user_mode']  = 0;
	 $config[3]['user_form']  = 'none';
	 $config[3]['admin_form'] = 'uid';
	 $config[3]['conf_form']  = 0;

	 $config[4]['name']       = 'time_create';
	 $config[4]['title']      = _WEBLINKS_CREATE;
	 $config[4]['user_mode']  = 0;
	 $config[4]['admin_form'] = 'time_create';
	 $config[4]['conf_form']  = 0;

	 $config[5]['name']       = 'time_update';
	 $config[5]['title']      = _WLS_LASTUPDATE;
	 $config[5]['user_mode']  = 0;
	 $config[5]['user_form']  = 'none';
	 $config[5]['admin_form'] = 'time_update';
	 $config[5]['conf_form']  = 2;
	 $config[5]['options']    = array(
		_WLS_NOTTIMEUPDATE => 0,
		_WLS_TIMEUPDATE    => 1
	);

	 $config[6]['name']       = 'recommend';
	 $config[6]['title']      = _WLS_SITE_RECOMMEND;
	 $config[6]['user_mode']  = 0;
	 $config[6]['user_form']  = 'none';
	 $config[6]['admin_form'] = 'checkbox';
	 $config[6]['conf_form']  = 0;
	 $config[6]['options']     = array(
		_WLS_SITE_RECOMMEND => 1,
	);

	 $config[7]['name']       = 'mutual';
	 $config[7]['title']      = _WLS_SITE_MUTUAL;
	 $config[7]['user_mode']  = 0;
	 $config[7]['user_form']  = 'none';
	 $config[7]['admin_form'] = 'checkbox';
	 $config[7]['conf_form']  = 0;
	 $config[7]['options']     = array(
		_WLS_SITE_MUTUAL => 1,
	);

	 $config[8]['name']       = 'cids';
	 $config[8]['title']      = _WLS_CATEGORY;
	 $config[8]['user_mode']  = 0;
	 $config[8]['user_form']  = 'none';
	 $config[8]['admin_form'] = 'none';
	 $config[8]['conf_form']  = 0;

	 $config[9]['name']      = 'title';
	 $config[9]['title']      = _WLS_SITETITLE;
	 $config[9]['user_mode']  = 2;
	 $config[9]['user_form']  = 'text';
	 $config[9]['admin_form'] = 'text';
	 $config[9]['conf_form']  = 2;

	 $config[11]['name']       = 'cat';
	 $config[11]['title']      = _WLS_CATEGORY;
	 $config[11]['user_mode']  = 2;
	 $config[11]['user_form']  = 'cat';
	 $config[11]['admin_form'] = 'cat';
	 $config[11]['conf_form']  = 2;

	 $config[12]['name']       = 'url';
	 $config[12]['title']      = _WLS_SITEURL;
	 $config[12]['user_mode']  = 2;
	 $config[12]['user_form']  = 'url';
	 $config[12]['admin_form'] = 'url';
	 $config[12]['conf_form']  = 1;

	 $config[13]['name']       = 'description';
	 $config[13]['title']      = _WLS_DESCRIPTION;
	 $config[13]['user_mode']  = 2;
	 $config[13]['user_form']  = 'desc';
	 $config[13]['admin_form'] = 'desc';
	 $config[13]['conf_form']  = 1;

	 $config[14]['name']       = 'dohtml';
	 $config[14]['title']      = 'dohtml';
	 $config[14]['user_mode']  = 0;
	 $config[14]['user_form']  = 'none';
	 $config[14]['admin_form'] = 'none';
	 $config[14]['conf_form']  = 0;
	 $config[14]['options']    = array(
		_WEBLINKS_DOHTML => 1,
	);

	 $config[15]['name']       = 'dosmiley';
	 $config[15]['title']      = 'dosmiley';
	 $config[15]['user_mode']  = 0;
	 $config[15]['user_form']  = 'none';
	 $config[15]['admin_form'] = 'none';
	 $config[15]['conf_form']  = 0;
	 $config[15]['options']    = array(
		_WEBLINKS_DOSMILEY => 1,
	);

	 $config[16]['name']       = 'doxcode';
	 $config[16]['title']      = 'doxcode';
	 $config[16]['user_mode']  = 0;
	 $config[16]['user_form']  = 'none';
	 $config[16]['admin_form'] = 'none';
	 $config[16]['conf_form']  = 0;
	 $config[16]['options']    = array(
		_WEBLINKS_DOXCODE => 1,
	);

	 $config[17]['name']       = 'doimage';
	 $config[17]['title']      = 'doimage';
	 $config[17]['user_mode']  = 0;
	 $config[17]['user_form']  = 'none';
	 $config[17]['admin_form'] = 'none';
	 $config[17]['conf_form']  = 0;
	 $config[17]['options']    = array(
		_WEBLINKS_DOIMAGE => 1,
	);

	 $config[18]['name']       = 'dobr';
	 $config[18]['title']      = 'dobr';
	 $config[18]['user_mode']  = 0;
	 $config[18]['user_form']  = 'none';
	 $config[18]['admin_form'] = 'none';
	 $config[18]['conf_form']  = 0;
	 $config[18]['options']    = array(
		_WEBLINKS_DOBREAK => 1,
	);

	 $config[19]['name']       = 'broken';
	 $config[19]['title']      = _WLS_BROKEN_COUNTER;
	 $config[19]['user_mode']  = 0;
	 $config[19]['user_form']  = 'none';
	 $config[19]['admin_form'] = 'broken';
	 $config[19]['conf_form']  = 0;

//---------------------------------------------------------
// admin can change title & mode
//---------------------------------------------------------
	 $config[21]['name']       = 'banner';
	 $config[21]['title']      = _WLS_BANNERURL;
	 $config[21]['user_mode']  = 1;
	 $config[21]['user_form']  = 'url';
	 $config[21]['admin_form'] = 'banner';
	 $config[21]['conf_form']  = 1;

	 $config[22]['name']       = 'width';
	 $config[22]['title']      = 'width';
	 $config[22]['user_mode']  = 0;
	 $config[22]['user_form']  = 'none';
	 $config[22]['admin_form'] = 'banner_size';
	 $config[22]['conf_form']  = 0;

	 $config[23]['name']       = 'height';
	 $config[23]['title']      = 'height';
	 $config[23]['user_mode']  = 0;
	 $config[23]['user_form']  = 'none';
	 $config[23]['admin_form'] = 'banner_size';
	 $config[23]['conf_form']  = 0;

	 $config[24]['name']       = 'rss_url';
	 $config[24]['title']      = _WLS_RSS_URL;
	 $config[24]['user_mode']  = 1;
	 $config[24]['user_form']  = 'rss_url';
	 $config[24]['admin_form'] = 'rss_url';
	 $config[24]['conf_form']  = 1;

	 $config[25]['name']       = 'rss_flag';
	 $config[25]['title']      = 'rss_flag';
	 $config[25]['user_mode']  = 1;
	 $config[25]['user_form']  = 'none';
	 $config[25]['admin_form'] = 'none';
	 $config[25]['conf_form']  = 0;
	 $config[25]['options']    = array(
		_WLS_RSS_URL_0 => 0,
		_WLS_RSS_URL_3 => 3,
		_WLS_RSS_URL_1 => 1,
		_WLS_RSS_URL_2 => 2,
	);

	 $config[26]['name']       = 'name';
	 $config[26]['title']      = _WLS_NAME;
	 $config[26]['user_mode']  = 1;
	 $config[26]['user_form']  = 'name';
	 $config[26]['admin_form'] = 'name';
	 $config[26]['conf_form']  = 1;

	 $config[27]['name']       = 'nameflag';
	 $config[27]['title']      = 'nameflag';
	 $config[27]['user_mode']  = 0;
	 $config[27]['user_form']  = 'none';
	 $config[27]['admin_form'] = 'none';
	 $config[27]['conf_form']  = 0;
	 $config[27]['options']    = array(
		_WLS_NOTPUBLIC => 0,
		_WLS_PUBLIC    => 1,
	);

	 $config[28]['name']       = 'mail';
	 $config[28]['title']      = _WLS_EMAIL;
	 $config[28]['user_mode']  = 1;
	 $config[28]['user_form']  = 'mail';
	 $config[28]['admin_form'] = 'mail';
	 $config[28]['conf_form']  = 1;

	 $config[29]['name']       = 'mailflag';
	 $config[29]['title']      = 'mailflag';
	 $config[29]['user_mode']  = 0;
	 $config[29]['user_form']  = 'none';
	 $config[29]['admin_form'] = 'none';
	 $config[29]['conf_form']  = 0;
	 $config[29]['options']    = array(
		_WLS_NOTPUBLIC => 0,
		_WLS_PUBLIC    => 1,
	);

	 $config[31]['name']       = 'company';
	 $config[31]['title']      = _WLS_COMPANY;
	 $config[31]['user_mode']  = 1;
	 $config[31]['user_form']  = 'text';
	 $config[31]['admin_form'] = 'text';
	 $config[31]['conf_form']  = 1;

	 $config[32]['name']       = 'zip';
	 $config[32]['title']      = _WLS_ZIP;
	 $config[32]['user_mode']  = 1;
	 $config[32]['user_form']  = 'text';
	 $config[32]['admin_form'] = 'text';
	 $config[32]['conf_form']  = 1;

	 $config[33]['name']       = 'state';
	 $config[33]['title']      = _WLS_STATE;
	 $config[33]['user_mode']  = 1;
	 $config[33]['user_form']  = 'text';
	 $config[33]['admin_form'] = 'text';
	 $config[33]['conf_form']  = 1;

	 $config[34]['name']       = 'city';
	 $config[34]['title']      = _WLS_CITY;
	 $config[34]['user_mode']  = 1;
	 $config[34]['user_form']  = 'text';
	 $config[34]['admin_form'] = 'text';
	 $config[34]['conf_form']  = 1;

	 $config[35]['name']       = 'addr';
	 $config[35]['title']      = _WLS_ADDR;
	 $config[35]['user_mode']  = 1;
	 $config[35]['user_form']  = 'text';
	 $config[35]['admin_form'] = 'text';
	 $config[35]['conf_form']  = 1;

	 $config[36]['name']       = 'addr2';
	 $config[36]['title']      = _WLS_ADDR2;
	 $config[36]['user_mode']  = 1;
	 $config[36]['user_form']  = 'text';
	 $config[36]['admin_form'] = 'text';
	 $config[36]['conf_form']  = 1;

	 $config[37]['name']       = 'tel';
	 $config[37]['title']      = _WLS_TEL;
	 $config[37]['user_mode']  = 1;
	 $config[37]['user_form']  = 'text';
	 $config[37]['admin_form'] = 'text';
	 $config[37]['conf_form']  = 1;

	 $config[38]['name']       = 'fax';
	 $config[38]['title']      = _WLS_FAX;
	 $config[38]['user_mode']  = 1;
	 $config[38]['user_form']  = 'text';
	 $config[38]['admin_form'] = 'text';
	 $config[38]['conf_form']  = 1;

	 $config[41]['name']       = 'etc1';
	 $config[41]['title']      = _WEBLINKS_ETC.' 1';
	 $config[41]['user_mode']  = 0;
	 $config[41]['user_form']  = 'text';
	 $config[41]['admin_form'] = 'text';
	 $config[41]['conf_form']  = 1;

	 $config[42]['name']       = 'etc2';
	 $config[42]['title']      = _WEBLINKS_ETC.' 2';
	 $config[42]['user_mode']  = 0;
	 $config[42]['user_form']  = 'text';
	 $config[42]['admin_form'] = 'text';
	 $config[42]['conf_form']  = 1;

	 $config[43]['name']       = 'etc3';
	 $config[43]['title']      = _WEBLINKS_ETC.' 3';
	 $config[43]['user_mode']  = 0;
	 $config[43]['user_form']  = 'text';
	 $config[43]['admin_form'] = 'text';
	 $config[43]['conf_form']  = 1;

	 $config[44]['name']       = 'etc4';
	 $config[44]['title']      = _WEBLINKS_ETC.' 4';
	 $config[44]['user_mode']  = 0;
	 $config[44]['user_form']  = 'text';
	 $config[44]['admin_form'] = 'text';
	 $config[44]['conf_form']  = 1;

	 $config[45]['name']       = 'etc5';
	 $config[45]['title']      = _WEBLINKS_ETC.' 5';
	 $config[45]['user_mode']  = 0;
	 $config[45]['user_form']  = 'text';
	 $config[45]['admin_form'] = 'text';
	 $config[45]['conf_form']  = 1;

	 $config[46]['name']        = 'usercomment';
	 $config[46]['title']       = _WLS_USER_COMMENT;
	 $config[46]['description'] = _WLS_NOT_DISPLAY;
	 $config[46]['user_mode']   = 1;
	 $config[46]['user_form']   = 'textarea';
	 $config[46]['admin_form']  = 'textarea';
	 $config[46]['conf_form']   = 1;

	 $config[48]['name']       = 'passwd';
	 $config[48]['title']      = _US_PASSWORD;
	 $config[48]['user_mode']  = 1;
	 $config[48]['user_form']  = 'passwd';
	 $config[48]['admin_form'] = 'passwd';
	 $config[48]['conf_form']  = 2;

	 $config[49]['name']        = 'notify';
	 $config[49]['title']       = _WLS_OPTIONS;
	 $config[49]['user_mode']   = 1;
	 $config[49]['user_form']   = 'notify';
	 $config[49]['admin_form']  = 'notify';
	 $config[49]['conf_form']   = 0;
	 $config[49]['options']     = array(
		_WLS_NOTIFYAPPROVE => 1,
	);

//---------------------------------------------------------
// admin cannot change
//---------------------------------------------------------
	 $config[51]['name']       = 'hits';
	 $config[51]['title']      = _WLS_HITS;
	 $config[51]['user_mode']  = 0;
	 $config[51]['user_form']  = 'none';
	 $config[51]['admin_form'] = 'label';
	 $config[51]['conf_form']  = 2;

	 $config[52]['name']       = 'rating';
	 $config[52]['title']      = _WLS_RATING;
	 $config[52]['user_mode']  = 0;
	 $config[52]['user_form']  = 'none';
	 $config[52]['admin_form'] = 'label_float';
	 $config[52]['conf_form']  = 2;

	 $config[53]['name']       = 'votes';
	 $config[53]['title']      = _WLS_VOTE;
	 $config[53]['user_mode']  = 0;
	 $config[53]['user_form']  = 'none';
	 $config[53]['admin_form'] = 'label_float';
	 $config[53]['conf_form']  = 0;

	 $config[54]['name']       = 'comments';
	 $config[54]['title']      = _COMMENTS;
	 $config[54]['user_mode']  = 0;
	 $config[54]['user_form']  = 'none';
	 $config[54]['admin_form'] = 'label';
	 $config[54]['conf_form']  = 2;

	 $config[55]['name']       = 'admincomment';
	 $config[55]['title']      = _WLS_ADMINCOMMENT;
	 $config[55]['user_mode']  = 0;
	 $config[55]['user_form']  = 'none';
	 $config[55]['admin_form'] = 'admincomment';
	 $config[55]['conf_form']  = 2;

//---------------------------------------------------------
// admin cannot change
// program create automatically
//---------------------------------------------------------
	 $config[61]['name']       = 'search';
	 $config[61]['title']      = 'search';
	 $config[61]['user_mode']  = 0;
	 $config[61]['user_form']  = 'none';
	 $config[61]['admin_form'] = 'none';
	 $config[61]['conf_form']  = 0;

	 $config[62]['name']       = 'mark';
	 $config[62]['title']      = 'mark';
	 $config[62]['user_mode']  = 0;
	 $config[62]['user_form']  = 'none';
	 $config[62]['admin_form'] = 'none';
	 $config[62]['conf_form']  = 0;

	 $config[63]['name']       = 'rss_xml';
	 $config[63]['title']      = 'rss_xml';
	 $config[63]['user_mode']  = 0;
	 $config[63]['user_form']  = 'none';
	 $config[63]['admin_form'] = 'none';
	 $config[63]['conf_form']  = 0;

	 $config[64]['name']       = 'rss_update';
	 $config[64]['title']      = 'rss_update';
	 $config[64]['user_mode']  = 0;
	 $config[64]['user_form']  = 'none';
	 $config[64]['user_form']  = 'time';
	 $config[64]['conf_form']  = 0;

//---------------------------------------------------------
	return $config;
}

//---------------------------------------------------------
// load
//---------------------------------------------------------
function load()
{
	$this->_cached = $this->get_define();
	return $this->_cached;
}

function get_cache_by_itemid_key($id, $key)
{
	if ( isset( $this->_cached[$id][$key] ) )
	{
		$val = $this->_cached[$id][$key];
		return $val;
	}

	return false;
}

// --- class end ---
}


//=========================================================
// class weblinks_linkitem_define_handler
//=========================================================
class weblinks_linkitem_define_handler
{
	var $_linkitem_handler; 
	var $_linkitem_define;

// cache
	var $_cached_by_itemid = array();
	var $_cached_by_name   = array();

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_linkitem_define_handler( $dirname )
{
	$this->_linkitem_handler =& weblinks_get_handler('linkitem', $dirname);
	$this->_linkitem_define  =& weblinks_linkitem_define::getInstance();
}

function &getInstance( $dirname )
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_linkitem_define_handler( $dirname );
	}

	return $instance;
}

//---------------------------------------------------------
// load
//---------------------------------------------------------
function &load()
{
	$def_arr = $this->_linkitem_define->load();
	$this->_linkitem_handler->load();

	$this->_cached_by_itemid = array();
	$this->_cached_by_name   = array();

	foreach ($def_arr as $id => $def )
	{
		$name       = $this->_linkitem_define->get_cache_by_itemid_key($id, 'name');
		$title_def  = $this->_linkitem_define->get_cache_by_itemid_key($id, 'title');
		$desc       = $this->_linkitem_define->get_cache_by_itemid_key($id, 'description');
		$user_form  = $this->_linkitem_define->get_cache_by_itemid_key($id, 'user_form');
		$admin_form = $this->_linkitem_define->get_cache_by_itemid_key($id, 'admin_form');
		$conf_form  = $this->_linkitem_define->get_cache_by_itemid_key($id, 'conf_form');
		$opt        = $this->_linkitem_define->get_cache_by_itemid_key($id, 'options');
		$title      = $this->_linkitem_handler->get_cache_by_itemid_key($id, 'title');
		$user_mode  = $this->_linkitem_handler->get_cache_by_itemid_key($id, 'user_mode');

		$arr = array(
			'item_id'     => $id,
			'name'        => $name,
 			'title'       => htmlspecialchars($title, ENT_QUOTES),
			'title_def'   => $title_def,
			'description' => $desc,
	 		'user_form'   => $user_form,
	 		'admin_form'  => $admin_form,
	 		'conf_form'   => $conf_form,
	 		'user_mode'   => $user_mode,
	 		'options'     => $opt,
		);

		$this->_cached_by_itemid[ $id ] = $arr;
		$this->_cached_by_name[ $name ] = $arr;
	}

	return $this->_cached_by_itemid;

}

//---------------------------------------------------------
// get cache
//---------------------------------------------------------
function get_by_itemid($id, $key)
{
	if ( isset( $this->_cached_by_itemid[$id][$key] ) )
	{
		$val = $this->_cached_by_itemid[$id][$key];
		return $val;
	}

	return false;
}

function get_by_name($name, $key)
{
	if ( isset( $this->_cached_by_name[$name][$key] ) )
	{
		$val = $this->_cached_by_name[$name][$key];
		return $val;
	}

	return false;
}

function build_caption_by_itemid($id, $flag=0, $extra='')
{
	$mode      = $this->get_by_itemid($id, 'user_mode');
	$title     = $this->get_by_itemid($id, 'title');
	$title_def = $this->get_by_itemid($id, 'title_def');
	$desc      = $this->get_by_itemid($id, 'description');
	$cap       = $this->build_caption($title, $desc, $title_def, $mode, $flag, $extra);
	return $cap;
}

function build_caption($title, $desc='', $title_def='', $mode=0, $flag=0, $extra='')
{
	if ($mode == 2)
	{
		$cap = "<span style='font-weight:bold;'> * $title * </span>";
	}
	else
	{
		$cap = "<span style='font-weight:normal;'>".$title."</span>";
	}

	if ( $flag &&( $title != $title_def ) )
	{
		$cap .= "<br />\n";
		$cap .= "<span style='font-weight:normal;'> ( ".$title_def." ) </span>";
	}

	if ( $extra )
	{
		$cap .= "<br />\n";
		$cap .= "<span style='font-weight:normal;'>".$extra."</span>";
	}

	if ($desc)
	{
		$cap .= "<br /><br />\n";
		$cap .= "<span style='font-weight:normal;'>".$desc."</span>";
	}

	return $cap;
}

// --- class end ---
}

// === class end ===
}

?>