<?php
// $Id: weblinks_link_form_handler.php,v 1.1 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// this is new file
// use new handler
// include class/submit.php

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication
// move from include/submit_form.php

//=========================================================
// WebLinks Module
// 2006-05-15 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_link_form_handler') ) 
{

//=========================================================
// class weblinks_link_form_handler
//=========================================================
class weblinks_link_form_handler extends weblinks_form
{
	var $TEXT_SIZE    =  50;
	var $TEXT_MAX     = 250;
	var $URL_SIZE     =  80;
	var $URL_MAX      = 250;
	var $PASSWD_SIZE  =  20;
	var $PASSWD_MAX   = 100;
	var $TEXTAREA_ROW =   5;
	var $TEXTAREA_COL =  60;
	var $DESC_ROW     =  15;
	var $DESC_COL     =  60;

	var $IMG_CHECKED;
	var $IMG_NO_CHECKED;

	var $_dirname;

	var $_config_handler;
	var $_link_handler;
	var $_modify_handler;
	var $_category_handler;
	var $_catlink_handler;
	var $_broken_handler;
	var $_linkitem_define_handler;

	var $_link_utility;
	var $_system;
	var $_post;
	var $_strings;

// config
	var $_conf_type_desc;
	var $_conf_use_passwd;

// set parameter
	var $_flag_owner        = 0;
	var $_flag_notify_show  = 0;

// local
	var $_link_arr      = array();
	var $_link_orig_arr = array();
	var $_buff          = array();
	var $_buff_hidden   = array();

	var $_flag_admin_caption = false;
	var $_flag_url_visit   = 0;
	var $_flag_desc_type   = 1;
	var $_updateflag_value = 0;
	var $_mode_banner_size = 0;

	var $_conf_desc_option = array(
		'dohtml'   => false,
		'dosmiley' => false,
		'doxcode'  => false,
		'doimage'  => false,
		'dobr'     => false,
	);

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_form_handler( $dirname )
{
	$this->weblinks_form();

	$this->_dirname = $dirname;

	$this->_config_handler   =& weblinks_get_handler( 'config2_basic', $dirname );
	$this->_link_handler     =& weblinks_get_handler( 'link',          $dirname );
	$this->_modify_handler   =& weblinks_get_handler( 'modify',        $dirname );
	$this->_category_handler =& weblinks_get_handler( 'category',      $dirname );
	$this->_catlink_handler  =& weblinks_get_handler( 'catlink',       $dirname );
	$this->_broken_handler   =& weblinks_get_handler( 'broken',        $dirname );
	$this->_linkitem_define_handler =& weblinks_get_handler( 'linkitem_define',  $dirname );

	$this->_link_utility =& weblinks_link_utility::getInstance();
	$this->_system       =& weblinks_system::getInstance();
	$this->_post         =& weblinks_post::getInstance();
	$this->_strings      =& weblinks_strings::getInstance();

	$conf = $this->_config_handler->get_cached();
	$this->_conf_type_desc  = $conf['type_desc'];
	$this->_conf_use_passwd = $conf['use_passwd'];

	$image_checked   = WEBLINKS_URL.'/images/checked.gif';
	$image_nochecked = WEBLINKS_URL.'/images/nochecked.gif';
	$this->IMG_CHECKED    = "<img src='$image_checked'   border='0' alt='checked' />";
	$this->IMG_NO_CHECKED = "<img src='$image_nochecked' border='0' alt='nochecked' />";
}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init()
{
	$this->_category_handler->load();
}

function clear_local()
{
	$this->_link_arr      = array();
	$this->_link_orig_arr = array();
	$this->_buff          = array();
	$this->_buff_hidden   = array();

	$this->_flag_admin_caption = false;
	$this->_flag_url_visit   = 0;
	$this->_flag_desc_type   = 1;
	$this->_updateflag_value = 0;
}

function begin_form()
{
	$this->clear_local();

	$this->_flag_desc_type = $this->_conf_type_desc;
}

function begin_admin_form()
{
	$this->clear_local();
	$this->set_flag_owner(1);
	$this->_flag_admin_caption = true;
	$this->_flag_url_visit = 1;
	$this->_mode_banner_size = 0;

	$this->_conf_desc_option = array(
		'dohtml'   => true,
		'dosmiley' => true,
		'doxcode'  => true,
		'doimage'  => true,
		'dobr'     => true,
	);
}

//---------------------------------------------------------
// show_user_form
//---------------------------------------------------------
function show_user_form($form_mode, $lid=0)
{
	$this->init();
	$this->begin_form();

	$linkitem_arr = $this->_linkitem_define_handler->load();

	$this->_conf_desc_option = $this->_config_handler->has_auth_desc_option();

	$request = $this->_post->get_post_int('request');

// password 
	$passwd_new = $this->_post->get_post_text('passwd_new');
	$passwd_2   = $this->_post->get_post_text('passwd_2');

	list($passwd_old, $flag_passwd, $flag_code)
		= $this->_post->get_post_get_passwd_old();

	if ($flag_code)
	{
		$request = 1;	// passwd match;
	}

	switch ($form_mode)
	{
		case 'modify':
		case 'modify_preview':
			$form_title   = _WLS_REQUESTMOD;
			$submit_value = _EDIT;
			break;

		case 'submit':
		case 'submit_preview':
		default:
			$form_title   = _WLS_SUBMITLINKHEAD;
			$submit_value = _REGISTER;
			break;
	}

	switch ($form_mode)
	{
		case 'modify':
			$link_obj =& $this->_link_handler->get($lid);
			if ( !is_object($link_obj) )
			{
				echo "no link record lid=$lid <br />\n";
				return false;
			}

			$link_arr = $link_obj->getVarAll('e');

// hidden value, when NOT owner
			if ( !$this->_flag_owner )
			{
				list($name, $nameflag) = $link_obj->name_edit_for_others();
				list($mail, $mailflag) = $link_obj->mail_edit_for_others();
				$link_arr['name']     = $name;
				$link_arr['mail']     = $mail;
				$link_arr['nameflag'] = $nameflag;
				$link_arr['mailflag'] = $mailflag;
			}

			$cid_arr = $this->_catlink_handler->get_cid_array_by_lid($lid);
			$notify_value  = 0;
			break;

		case 'submit_preview':
		case 'modify_preview':
			$link_obj =& $this->_link_handler->create();
			$link_obj->set_conf_desc_option( $this->_conf_desc_option );
			$link_obj->assign_vars_post( $_POST );
			$link_arr = $link_obj->getVarAll('f');
			$cid_arr  = $link_obj->get_cid_array_by_post( $_POST );
			$notify_value = $this->_post->get_post_int('notify');
			break;

		case 'submit':
		default:
			$link_obj =& $this->_link_handler->create();
			$link_arr = $link_obj->build_default();

			$cid_arr  = array();
			if ( isset($_GET['cid']) )
			{
				$cid_arr = array($_GET['cid']);
			}

			$notify_value = 1;
			break;
	}

	$this->_link_arr = $link_arr;

	$this->add_hidden('request', $request );

	foreach ($linkitem_arr as $id => $linkitem )
	{
		$name  = $linkitem['name'];
		$form  = $linkitem['user_form'];
		$mode  = $linkitem['user_mode'];
		$opt   = $linkitem['options'];
		$cap   = $this->_build_caption_by_itemid($id);
		$value = $this->get_link_by_name($name);

		if ($mode == 0)
		{
			$form = 'none';
		}

		switch ($form)
		{
			case 'hidden':
				$this->add_hidden($name, $value);
				break;

			case 'text':
				$this->add_text($cap, $name, $value);
				break;

			case 'textarea':
				$this->add_textarea($cap, $name, $value);
				break;

			case 'url':
				$this->add_url( $cap, $name, $value );
				break;

			case 'radio':
				$this->add_radio( $cap, $name, $value, $opt);
				break;

			case 'checkbox':
				$this->add_checkbox( $cap, $name, $value, $opt);
				break;

			case 'lid':
				$this->add_lid($lid);
				break;

			case 'cat':
				$this->add_cat( $cap, $name, $value, $cid_arr );
				break;

			case 'desc':
				$this->add_desc( $cap, $name, $value );
				break;

			case 'rss_url':
				$this->add_rss_url($cap, $name, $value );
				break;

			case 'name':
				$this->add_name( $cap, $name, $value );
				break;

			case 'mail':
				$this->add_mail( $id, $cap, $name, $value );
				break;

			case 'passwd':
				$this->add_passwd( $form_mode, $id, $cap, $name, $value, $passwd_new, $passwd_2, $passwd_old );
				break;

			case 'notify':
				$this->add_notify( $cap, $name, $value, $notify_value, $opt );
				break;

			case 'none':
			default:
				break;
		}
	}

// print form
	$op = 'save';
	$button_name  = 'preview';
	$button_value = _PREVIEW;
	$this->print_form($form_title, $op, $submit_value, $button_name, $button_value );
	return true;

}

function print_form($form_title, $op, $submit_value, $button_name, $button_value )
{
	echo $this->make_form_start();
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', $op);

	$this->display_hidden();

	echo $this->make_table_start();
	echo $this->make_table_title( $form_title );

	$this->display();

	$button1 = $this->make_form_submit('post', $submit_value );
	$button3 = $this->make_form_cancel_button('cancel', _CANCEL);

	$button2 = '';
	if ( $button_name )
	{
		$button2 = $this->make_form_submit($button_name, $button_value);
	}

	$button  = $button1.' '.$button2.' '.$button3;

	echo $this->make_table_line('', $button, 'foot', 'foot');
	echo $this->make_table_end();
	echo $this->make_form_end();

}

//---------------------------------------------------------
// show_admin_form
//---------------------------------------------------------
function show_admin_form($form_mode, $id=0)
{
	$this->init();
	$this->begin_admin_form();

	$linkitem_arr = $this->_linkitem_define_handler->load();

	$lid = 0;
	$mid = 0;
	$desc_disp   = '';
	$flag_label  = false;
	$flag_broken = false;

// password
	$passwd_new = $this->_post->get_post_text('passwd_new');
	$passwd_2   = $this->_post->get_post_text('passwd_2');

	switch ($form_mode)
	{
		case 'modify':
		case 'modify_preview':
			$form_title   = _WLS_MODLINK;
			$submit_value = _WLS_MODIFY;
			$op           = 'modLinkS';
			$button_name  = 'delete_link';
			$button_value = _DELETE;
			$flag_broken  = true;
			break;

		case 'approve':
		case 'approve_preview':
			$form_title   = _WLS_MODREQUESTS;
			$submit_value = _WLS_APPROVE;
			$op           = 'approve';
			$button_name  = 'delete_new';
			$button_value = _WLS_IGNORE;
			break;

		case 'submit':
		case 'submit_preview':
		default:
			$form_title   = _WLS_ADDNEWLINK;
			$submit_value = _WLS_ADD;
			$op           = 'addLinkS';
			$button_name  = '';
			$button_value = '';
			break;
	}

	switch ($form_mode)
	{
		case 'modify':
			$lid = $id;
			$link_obj =& $this->_link_handler->get($lid);
			if ( !is_object($link_obj) )
			{
				echo "no link record lid=$lid <br />\n";
				return false;
			}
			$link_arr  = $link_obj->getVarAll('e');
			$desc_disp = $link_obj->description_disp();
			$cid_arr   = $this->_catlink_handler->get_cid_array_by_lid($lid);
			$this->_updateflag_value = 0;
			$flag_label = true;
			break;

		case 'approve':
			$mid = $id;
			$mod_obj =& $this->_modify_handler->get($mid);
			if ( !is_object($mod_obj) )
			{
				echo "no modify record mid=$mid <br />\n";
				return false;
			}
			$link_arr  = $mod_obj->getVarAll('e');
			$lid       = $mod_obj->get('lid');
			$cid_arr   = $mod_obj->cid_array();
			$link_arr['uid'] = $link_arr['muid'];
			$this->_updateflag_value = 1;
			break;

		case 'submit_preview':
			$link_obj =& $this->_link_handler->create();
			$link_obj->set_conf_desc_option( $this->_conf_desc_option );
			$link_obj->assign_vars_post( $_POST );
			$link_arr  = $link_obj->getVarAll('f');
			$desc_disp = $link_obj->description_disp();
			$cid_arr   = $link_obj->get_cid_array_by_post( $_POST );
			$this->_updateflag_value = $this->_post->get_post_int('updateflag');
			break;

		case 'modify_preview':
			$lid = $this->_post->get_post_int('lid');
			$link_obj =& $this->_link_handler->get($lid);
			$link_obj->set_conf_desc_option( $this->_conf_desc_option );
			$link_obj->assign_vars_post( $_POST );
			$link_arr  = $link_obj->getVarAll('f');
			$desc_disp = $link_obj->description_disp();
			$cid_arr   = $link_obj->get_cid_array_by_post( $_POST );
			if ( isset($link_arr['muid']) )
			{
				$link_arr['uid'] = $link_arr['muid'];
			}
			$this->_updateflag_value = $this->_post->get_post_int('updateflag');
			$flag_label = true;
			break;

		case 'approve_preview':
			$mid = $this->_post->get_post_int('mid');
			$lid = $this->_post->get_post_int('lid');
			$link_obj =& $this->_modify_handler->get($mid);
			$link_obj->set_conf_desc_option( $this->_conf_desc_option );
			$link_obj->assign_vars_post( $_POST );
			$link_arr  = $link_obj->getVarAll('f');
			$desc_disp = $link_obj->description_disp();
			$cid_arr   = $link_obj->get_cid_array_by_post( $_POST );
			$this->_updateflag_value = $this->_post->get_post_int('updateflag');
			break;

		case 'submit':
		default:
			$link_obj =& $this->_link_handler->create();
			$link_arr = $link_obj->build_default();

			$cid_arr  = array();
			if ( isset($_GET['cid']) )
			{
				$cid_arr = array($_GET['cid']);
			}

			$this->_updateflag_value = 1;
			break;
	}

	$this->_link_arr = $link_arr;

	foreach ($linkitem_arr as $id => $linkitem )
	{
		$name  = $linkitem['name'];
		$form  = $linkitem['admin_form'];
		$mode  = $linkitem['user_mode'];
		$opt   = $linkitem['options'];
		$cap   = $this->_build_caption_by_itemid($id);
		$value = $this->get_link_by_name($name);

		switch ($form)
		{
			case 'hidden':
				$this->add_hidden($name, $value);
				break;

			case 'label':
				if ( $flag_label )
				{
					$this->add_label($cap, $value);
				}
				break;

			case 'label_float':
				if ( $flag_label )
				{
					$this->add_label_float($cap, $value);
				}
				break;

			case 'text':
				$this->add_text($cap, $name, $value);
				break;

			case 'textarea':
			case 'admincomment':
				$this->add_textarea($cap, $name, $value);
				break;

			case 'url':
				$this->add_url( $cap, $name, $value );
				break;

			case 'radio':
				$this->add_radio( $cap, $name, $value, $opt);
				break;

			case 'checkbox':
				$this->add_checkbox( $cap, $name, $value, $opt);
				break;

			case 'mid':
				$this->add_admin_id($id, $mid);
				break;

			case 'lid':
				$this->add_admin_id($id, $lid);
				break;

			case 'uid':
				$this->add_admin_uid( $cap, $name, $value );
				break;

			case 'time_create':
				$this->add_admin_time_create( $cap, $name, $value );
				break;

			case 'time_update':
				$this->add_admin_time_update( $cap, $name, $value, $opt );
				break;

			case 'cat':
				$this->add_cat( $cap, $name, $value, $cid_arr );
				break;

			case 'desc':
				$this->add_desc( $cap, $name, $value, $desc_disp );
				break;

			case 'broken':
				if ($flag_broken)
				{
					$this->add_admin_broken( $lid, $cap, $name, $value );
				}
				break;

			case 'banner':
				$this->add_admin_banner( $cap, $name, $value );
				break;

			case 'banner_size':
				$this->add_admin_banner_size( $cap, $name, $value );
				break;

			case 'rss_url':
				$this->add_rss_url($cap, $name, $value );
				break;

			case 'name':
				$this->add_name( $cap, $name, $value );
				break;

			case 'mail':
				$this->add_mail($id, $cap, $name, $value );
				break;

			case 'passwd':
				$this->add_admin_passwd( $form_mode, $id, $cap, $name, $value, $passwd_new, $passwd_2 );
				break;

			case 'notify':
			case 'none':
			default:
				break;
		}
	}

// print form
	$this->print_form($form_title, $op, $submit_value, $button_name, $button_value );
	return true;
}


//---------------------------------------------------------
// show_admin_mod_approve_form
//---------------------------------------------------------
function show_admin_mod_approve_form($form_mode, $mid=0)
{
	$this->init();
	$this->begin_admin_form();

	$linkitem_arr = $this->_linkitem_define_handler->load();

	$form_title   = _WLS_MODREQUESTS;
	$submit_value = _WLS_APPROVE;
	$op           = 'approveModReq';
	$button_name  = 'ignore';
	$button_value = _WLS_IGNORE;

	switch ($form_mode)
	{
		case 'preview':
			$mid = $this->_post->get_post_int('mid');
			$lid = $this->_post->get_post_int('lid');
			$mod_obj =& $this->_modify_handler->get($mid);
			if ( !is_object($mod_obj) )
			{
				echo "no modify record mid=$mid <br />\n";
				return false;
			}
			$mod_obj->assign_vars_post( $_POST );
			$mod_arr   = $mod_obj->getVarAll('f');
			$desc_disp = $mod_obj->description_disp();
			$cid_arr   = $mod_obj->get_cid_array_by_post( $_POST );
			$this->_updateflag_value = $this->_post->get_post_int('updateflag');
			break;

		case 'approve':
		default:
			$mod_obj =& $this->_modify_handler->get($mid);
			if ( !is_object($mod_obj) )
			{
				echo "no modify record mid=$mid <br />\n";
				return false;
			}
			$mod_arr   = $mod_obj->getVarAll('e');
			$lid       = $mod_obj->get('lid');
			$desc_disp = $mod_obj->description_disp();
			$cid_arr   = $mod_obj->cid_array();
			$mod_arr['uid'] = $mod_arr['muid'];
			$this->_updateflag_value = 1;
			break;
	}

	$this->_link_arr = $mod_arr;

	$link_obj =& $this->_link_handler->get($lid);
	if ( !is_object($link_obj) )
	{
		echo "no link record lid=$lid <br />\n";
		return false;
	}

	$this->_link_orig_arr = $link_obj->getVarAll('e');

	foreach ($linkitem_arr as $id => $linkitem )
	{
		$name  = $linkitem['name'];
		$form  = $linkitem['admin_form'];
		$mode  = $linkitem['user_mode'];
		$opt   = $linkitem['options'];
		$cap   = $this->_build_caption_by_itemid($id);
		$value = $this->get_link_by_name($name);
		$orig  = $this->get_link_orig_by_name($name);

		switch ($form)
		{
			case 'hidden':
				$this->add_hidden($name, $value);
				break;

			case 'text':
				$this->add_text($cap, $name, $value);
				$this->add_label('', $orig);
				break;

			case 'textarea':
				$this->add_textarea($cap, $name, $value);
				$this->add_admin_textarea_orig($orig);
				break;

			case 'checkbox':
				$this->add_checkbox( $cap, $name, $value, $opt);
				$this->add_admin_checkbox_orig($cap, $name, $orig, $opt);
				break;

			case 'url':
				$this->add_url( $cap, $name, $value );
				$this->add_admin_url_orig($orig);
				break;

			case 'mid':
				$this->add_admin_id($id, $mid);
				break;

			case 'lid':
				$this->add_admin_id($id, $lid);
				break;

			case 'uid':
				$this->add_admin_uid( $cap, $name, $value );
				$this->add_admin_uid_orig($orig);
				break;

			case 'time_create':
				$this->add_admin_time_create( $cap, $name, $value );
				break;

			case 'time_update':
				$this->add_admin_time_update( $cap, $name, $value, $opt );
				break;

			case 'cat':
				$this->add_cat( $cap, $name, $value, $cid_arr );
				break;

			case 'desc':
				$this->add_desc( $cap, $name, $value, $desc_disp );
				$this->add_admin_textarea_orig($orig);
				break;

			case 'admincomment':
				$this->add_admin_admincomment_orig($cap, $name, $orig);
				break;

			case 'banner':
				$this->add_admin_banner( $cap, $name, $value );
				$this->add_admin_banner_orig( $orig );
				break;

			case 'rss_url':
				$this->add_rss_url($cap, $name, $value );
				$this->add_admin_rss_url_orig($cap, $name, $orig);
				break;

			case 'name':
				$this->add_name( $cap, $name, $value );
				$this->add_admin_name_orig($orig);
				break;

			case 'mail':
				$this->add_mail( $id, $cap, $name, $value );
				$this->add_admin_mail_orig($orig);
				break;

			case 'passwd':
				$this->add_admin_approve_passwd( $cap, $name, $value );
				break;

			case 'notify':
			case 'none':
			default:
				break;
		}
	}

// print form
	$this->print_form($form_title, $op, $submit_value, $button_name, $button_value );
	return true;
}

//---------------------------------------------------------
// get cache
//---------------------------------------------------------
function get_link_by_name($name)
{
	if ( isset( $this->_link_arr[$name] ) )
	{
		$val = $this->_link_arr[$name];
		return $val;
	}
	return false;
}

function get_link_orig_by_name($name)
{
	if ( isset( $this->_link_orig_arr[$name] ) )
	{
		$val = $this->_link_orig_arr[$name];
		return $val;
	}
	return false;
}

//---------------------------------------------------------
// set buffer
//---------------------------------------------------------
function clear_tray()
{
	$this->_tray = array();
}

function add_tray_checkbox($name)
{
	$value   = $this->get_link_by_name($name);
	$options = $this->get_by_name($name, 'options');
	$this->_tray[] = $this->make_form_checkbox_select($name, $value, $options);
}

function get_tray()
{
	$text = '';

	foreach ($this->_tray as $tray)
	{
		$text .= $tray."<br />\n";
	}

	return $text;
}

function clear_buff()
{
	$this->_buff        = array();
	$this->_buff_hidden = array();
}

function add_buff($cap, $text)
{
	$this->_buff[] = array($cap, $text);
}

function add_buff_hidden($text)
{
	$this->_buff_hidden[] = $text;
}

function display()
{
	foreach ($this->_buff as $arr)
	{
		list($cap, $text) = $arr;
		echo $this->make_table_line($cap, $text);
	}
}

function display_hidden()
{
	foreach ($this->_buff_hidden as $text)
	{
		echo $text."\n";
	}
}

//---------------------------------------------------------
// link item
//---------------------------------------------------------
function add_hidden($name, $value)
{
	$text = $this->make_form_hidden($name, $value);
	$this->add_buff_hidden( $text );
}

function add_label($cap, $value)
{
	$text = $this->_build_value_when_empty( $value );
	$this->add_buff( $cap, $text );
}

function add_label_float($cap, $value)
{
	$text = number_format($value, 2);
	$this->add_buff( $cap, $text );
}

function add_text($cap, $name, $value)
{
	$text = $this->make_form_text($name, $value, $this->TEXT_SIZE, $this->TEXT_MAX);
	$this->add_buff( $cap, $text );
}

function add_url($cap, $name, $url)
{
	$text = $this->_build_url($name, $url);
	$this->add_buff( $cap, $text );
}

function add_textarea($cap, $name, $value)
{
	$text = $this->make_form_textarea($name, $value, $this->TEXTAREA_ROW, $this->TEXTAREA_COL);
	$this->add_buff( $cap, $text );
}

function add_radio($cap, $name, $value, $options)
{
	$text = $this->make_form_radio_select($name, $value, $options);
	$this->add_buff( $cap, $text );
}

function add_checkbox($cap, $name, $value, $options)
{
	$text = $this->make_form_checkbox_select($name, $value, $options);
	$this->add_buff( $cap, $text );
}

function add_lid($lid)
{
	$lid = intval($lid);

	if ($lid > 0)
	{
		$this->add_hidden('lid', $lid);
	}
}

function add_cat( $cap, $name, $value, $cid_arr )
{
	$file_popup = XOOPS_URL.'/modules/'.$this->_dirname.'/catlist_popup.php';
	$onclick    = $this->make_xoops_openWithSelfMain($file_popup, "help", 400, 500);

	$text  = '<a href="#catlist" onclick="'.$onclick.'">'._WLS_CATLIST."</a><br />\n";
	$text .= $this->_category_handler->build_selbox_multi( $cid_arr );

	$this->add_buff( $cap, $text );
}

function add_desc( $cap1, $name, $value, $desc_disp='' )
{
	$name_d = 'description_text';

	if ( $this->_flag_desc_type )
	{
		$ele   = new XoopsFormDhtmlTextArea('', $name_d, $value, $this->DESC_ROW, $this->DESC_COL);
		$text1 = $ele->render();

		$cap2 = $this->_build_caption( _WLS_OPTIONS );

		$this->clear_tray();
		$this->add_desc_option_1( 'dohtml' );
		$this->add_desc_option_1( 'dosmiley' );
		$this->add_desc_option_1( 'doxcode' );
		$this->add_desc_option_1( 'doimage' );
		$this->add_desc_option_1( 'dobr' );
		$text2 = $this->get_tray();

		$this->add_buff( $cap1, $text1 );

		if ( $desc_disp )
		{
			$cap0  =  $this->_build_caption( 'view' );
			$text0 = $this->_build_show_textarea( $desc_disp );
			$this->add_buff( $cap0, $text0 );
		}

		$this->add_buff( $cap2, $text2 );
	}
	else
	{
		$text1 = $this->make_form_textarea($name_d, $value, $this->DESC_ROW, $this->DESC_COL);
		$this->add_buff( $cap1, $text1 );

		$this->add_desc_option_0( 'dohtml' );
		$this->add_desc_option_0( 'dosmiley' );
		$this->add_desc_option_0( 'doxcode' );
		$this->add_desc_option_0( 'doimage' );
		$this->add_desc_option_0( 'dobr' );
	}
}

function add_desc_option_0( $name )
{
	if ( $this->_conf_desc_option[$name] )
	{
		$this->add_hidden( $name, 1 );
	}
}

function add_desc_option_1( $name )
{
	if ( $this->_conf_desc_option[$name] )
	{
		$this->add_tray_checkbox( $name );
	}
}

function add_rss_url($cap, $name1, $url)
{
	$name2  = 'rss_flag';
	$value2 = $this->get_link_by_name($name2);
	$opt2   = $this->get_by_name($name2, 'options');

	$text  = $this->_build_url($name1, $url);
	$text .= "<br />\n";
	$text .= $this->make_form_radio_select($name2, $value2, $opt2);

	$this->add_buff( $cap, $text );
}

function add_name( $cap, $name1, $value1 )
{
	$name2  = 'nameflag';
	$value2 = $this->get_link_by_name($name2);
	$opt2   = $this->get_by_name($name2, 'options');

	$text  = $this->make_form_text($name1, $value1, $this->TEXT_SIZE, $this->TEXT_MAX);
	$text .= "<br />\n";
	$text .= $this->make_form_radio_select($name2, $value2, $opt2);

	$this->add_buff( $cap, $text );
}

function add_mail( $id, $cap, $name1, $value1 )
{
	$extra = '';
	if ( !$this->_system->is_user() )
	{
		$extra = "("._WLS_EMAIL_APPROVE.")";
	}

	$cap = $this->_build_caption_by_itemid($id, $extra);

	$name2  = 'mailflag';
	$value2 = $this->get_link_by_name($name2);
	$opt2   = $this->get_by_name($name2, 'options');

	$text  = $this->make_form_text($name1, $value1, $this->TEXT_SIZE, $this->TEXT_MAX);
	$text .= "<br />\n";
	$text .= $this->make_form_radio_select($name2, $value2, $opt2);

	$this->add_buff( $cap, $text );
}

function add_notify( $cap, $name, $value, $notify_value, $opt )
{
	if ( $this->_flag_notify_show )
	{
		$this->add_checkbox($cap, $name, $notify_value, $opt);
	}
}

function add_passwd( $form_mode, $id, $cap, $name, $value, $passwd_new, $passwd_2, $passwd_old  )
{
// no action, if NOT guest
	if ( !$this->_conf_use_passwd || $this->_system->is_user() )
	{
		return;
	}

	$name3 = 'passwd_old';
	$cap2  = $this->_build_caption_by_itemid($id, _US_TYPEPASSTWICE );

	switch ($form_mode)
	{
		case 'modify':
			if ($this->_flag_owner)
			{
				$this->add_passwd_new( $cap2, '', '' );
				$this->add_hidden( $name3, $passwd_old );
			}
			break;

		case 'modify_preview':
			if ($this->_flag_owner)
			{
				$this->add_passwd_new( $cap2, $passwd_new, $passwd_2 );
				$this->add_hidden( $name3, $passwd_old );
			}
			break;

		case 'submit':
		case 'submit_preview':
		default:
			$this->add_passwd_new( $cap, $passwd_new, $passwd_2, true );
			break;
	}
}

function add_passwd_new( $cap1, $value1, $value2, $flag_new=false )
{
	$name1 = 'passwd_new';
	$name2 = 'passwd_2';
	$text1 = $this->make_form_password($name1, $value1, $this->PASSWD_SIZE, $this->PASSWD_MAX);
	$text2 = $this->make_form_password($name2, $value2, $this->PASSWD_SIZE, $this->PASSWD_MAX);
	$cap2  =  $this->_build_caption( _US_VERIFYPASS );

	if ( $flag_new )
	{
		$this->add_buff( $cap1, $text1 );
		$this->add_buff( $cap2, $text2 );
	}
	else
	{
		$this->add_buff( $cap1, $text1.' '.$text2 );
	}
}

//---------------------------------------------------------
// admin item
//---------------------------------------------------------
function add_admin_id($itemid, $id)
{
	if ($id > 0)
	{
		$cap  = $this->_build_caption_by_itemid($itemid);
		$name = $this->get_by_itemid($itemid, 'name');

		$id_s = "<b>".$id."</b>";
		$this->add_label($cap,   $id_s);
		$this->add_hidden($name, $id);
	}
}

function add_admin_uid( $cap1, $name1, $uid )
{
	$link_uname = $this->build_user_link_uname_by_uid($uid);
	$link_email = $this->build_user_link_email_by_uid($uid);
	$value2 = $link_uname."&nbsp;&nbsp;".$link_email;
	$cap2  =  $this->_build_caption( _WLS_SUBMITTER );

	$this->add_text($cap1, $name1, $uid);
	$this->add_label($cap2, $value2);
}

function add_admin_time_create( $cap, $name, $time )
{
	$text = '---';

	if ($time)
	{
		$text = formatTimestamp($time, 'm');
	}

	$this->add_label($cap, $text);
}

function add_admin_time_update( $cap, $name, $time, $opt )
{
	$text = '---';

	if ($time)
	{
		$text  = formatTimestamp($time, 'm');
		$text .= "<br />\n";
		$text .= $this->make_form_radio_select('updateflag', $this->_updateflag_value, $opt);
	}

	$this->add_buff( $cap, $text );
}

function add_admin_broken( $lid, $cap, $name, $value )
{
	$text = $this->make_form_text($name, $value, $this->TEXT_SIZE, $this->TEXT_MAX);

	$broken_count = $this->_broken_handler->get_count_by_lid($lid);
	if ( $broken_count )
	{
		$text .= "<br />\n";
		$text .= $this->_strings->highlight(' Broken Report');
	}

	$this->add_buff( $cap, $text );
}

function add_admin_banner( $cap, $name, $url )
{
	$width  = $this->get_link_by_name('width');
	$height = $this->get_link_by_name('height');
	$text   = $this->_build_url($name, $url);

	if ($url)
	{
		$text .= "<br />\n";
		$text .= $this->make_html_img($url, $width, $height, 0, 'banner');
	}

	$this->add_buff( $cap, $text );
}

function add_admin_banner_size( $cap, $name, $value )
{
	if ( $this->_mode_banner_size )
	{
		$this->add_text( $cap, $name, $value );
	}
	else
	{
		$this->add_label($cap, $value);
	}
}

function add_admin_passwd( $form_mode, $id, $cap, $name, $value, $passwd_new, $passwd_2 )
{
	$name3 = 'passwd_md5';
	$cap2  = $this->_build_caption_by_itemid($id, _US_TYPEPASSTWICE );

	switch ($form_mode)
	{
		case 'modify':
			$this->add_passwd_new( $cap2, '', '' );
			break;

		case 'modify_preview':
			$this->add_passwd_new( $cap2, $passwd_new, $passwd_2 );
			break;

		case 'approve':
		case 'approve_preview':
			$this->add_hidden( $name3, $value );
			break;

		case 'submit':
		case 'submit_preview':
		default:
			$this->add_passwd_new( $cap, $passwd_new, $passwd_2 );
			break;
	}
}

function add_admin_approve_passwd( $cap, $name, $value )
{
	$name3 = 'passwd_md5';
	$this->add_hidden($name3, $value);
}

//---------------------------------------------------------
// admin original item
//---------------------------------------------------------
function add_admin_uid_orig($uid)
{
	$link_uname = $this->build_user_link_uname_by_uid($uid);
	$link_email = $this->build_user_link_email_by_uid($uid);
	$value = $uid."&nbsp;&nbsp;".$link_uname."&nbsp;&nbsp;".$link_email;
	$cap   =  $this->_build_caption( _WLS_OWNER );

	$this->add_label($cap, $value);
}

function add_admin_checkbox_orig($cap, $name, $orig, $opt)
{
	$text = $this->_build_value_checked( $orig, $opt );
	$this->add_buff( '', $text );
}

function add_admin_url_orig($url)
{
	$text  = $url;
	$text .= $this->_build_url_mark($url);
	$this->add_buff( '', $text );
}

function add_admin_banner_orig($url)
{
	$width  = $this->get_link_orig_by_name('width');
	$height = $this->get_link_orig_by_name('height');

	if ( empty($width) || empty($height) )
	{
		list($width, $height) = $this->_link_utility->get_banner_size($url);
	}

	if ($url)
	{
		$text  = $url;
		$text .= $this->_build_url_mark($url);
		$text .= "<br />\n";
		$text .= $this->make_html_img($url, $width, $height, 0, 'banner');
	}
	else
	{
		$text = '---';
	}

	$this->add_buff( '', $text );
}

function add_admin_rss_url_orig($cap, $name1, $url)
{
	$name2  = 'rss_flag';
	$value2 = $this->get_link_by_name($name2);
	$opt2   = $this->get_by_name($name2, 'options');

	if ($url)
	{
		$text  = $url;
		$text .= $this->_build_url_mark($url);
	}
	else
	{
		$text = '---';
	}

	$text .= "<br />\n";
	$text .= $this->_build_value_checked( $value2, $opt2 );
	$this->add_buff( '', $text );
}

function add_admin_name_orig($value1)
{
	$this->add_admin_name_mail_orig($value1, 'nameflag');
}

function add_admin_mail_orig($value1)
{
	$this->add_admin_name_mail_orig($value1, 'mailflag');
}

function add_admin_name_mail_orig($value1, $name2)
{
	$value2 = $this->get_link_by_name($name2);
	$opt2   = $this->get_by_name($name2, 'options');

	$text   = $this->_build_value_when_empty($value1)."<br />";
	$text  .= $this->_build_value_checked($value2, $opt2);
	$this->add_buff( '', $text );
}

function add_admin_textarea_orig($value)
{
	if ( $value == '')
	{
		$text = '---';
	}
	else
	{
		$text = $this->_build_show_textarea($value, 1);
	}

	$this->add_buff( '', $text );
}

function add_admin_admincomment_orig($cap, $name, $orig)
{
	$text  = _WEBLINKS_ADMIN_PRESENT_SAVE."<br />\n";
	$text .= $this->make_form_textarea($name, $orig, $this->TEXTAREA_ROW, $this->TEXTAREA_COL);
	$this->add_buff( $cap, $text );
}

//---------------------------------------------------------
// build item
//---------------------------------------------------------
function _build_url($name, $url)
{
	if ( empty($url) )
	{
		$url = 'http://';
	}

	$text  = $this->make_form_text($name, $url, $this->URL_SIZE, $this->URL_MAX);

	if ($this->_flag_url_visit)
	{
		$text .= $this->_build_url_mark($url);
	}

	return $text;
}

function _build_url_mark($url)
{
	$mark = " ["._WLS_VISIT."] ";
	$text = ' '.$this->make_html_url_link($url, $mark, '_blank');
	return $text;
}

function _build_show_textarea($value, $flag=0)
{
	$text  = "<table border='1' bordercolor='black' cellpadding='0' cellspacing='0' width='100%'>";
	$text .= "<tr><td>\n";

	if ($flag)
	{
		$text .= "<pre>";
	}

	$text .= $value;

	if ($flag)
	{
		$text .= "</pre>";
	}

	$text .= "</td></tr></table>\n";
	return $text;
}

function _build_value_checked($value, $opt_arr, $highlight='' )
{
	$text = '';

	foreach ( $opt_arr as $opt_key => $opt_value )
	{
		if ( $value == $opt_value)
		{
			if ($highlight === $value)
			{
				$text .= $this->IMG_CHECKED;
				$text .= " <span style='color: #ff0000; font-weight: bold'>$opt_key</span>";
			}
			else
			{
				$text .= $this->IMG_CHECKED." ".$opt_key;
			}
		}
		else
		{
			$text .= $this->IMG_NO_CHECKED." <s>".$opt_key."</s>";
		}

		$text .= " ";
	}

	return $text;
}

function _build_value_when_empty( $value )
{
	if ( $value == '')
	{
		return '---';
	}

	return $value;
}

//---------------------------------------------------------
// user_link
//---------------------------------------------------------
function build_user_link_uname_by_uid($uid)
{
	$uname = $this->_system->get_uname_by_uid( $uid );
	$link_uname = $uname;

	if ($uid != 0)
	{
		$url = XOOPS_URL.'/userinfo.php?uid='.$uid;
		$link_uname = $this->_strings->build_html_link_name( $url, $uname, '_blank' );
	}

	return $link_uname;
}

function build_user_link_email_by_uid($uid)
{
	$email = $this->_system->get_email_by_uid( $uid );
	$link_email = '';

	if ( ($uid != 0) && $email )
	{
		$link_email = $this->_strings->build_html_link_email( $email, '', '_blank' );
	}

	return $link_email;
}

//---------------------------------------------------------
// linkitem_define_handler
//---------------------------------------------------------
function load()
{
	$ret =& $this->_linkitem_define_handler->load();
	return $ret;
}

function get_by_itemid($id, $key)
{
	$val = $this->_linkitem_define_handler->get_by_itemid($id, $key);
	return $val;
}

function get_by_name($name, $key)
{
	$val = $this->_linkitem_define_handler->get_by_name($name, $key);
	return $val;
}

function _build_caption_by_itemid($id, $extra='')
{
	$val = $this->_linkitem_define_handler->build_caption_by_itemid($id, $this->_flag_admin_caption, $extra);
	return $val;
}

function _build_caption( $title, $desc='' )
{
	$val = $this->_linkitem_define_handler->build_caption( $title, $desc );
	return $val;
}

//---------------------------------------------------------
// set parameter
//---------------------------------------------------------
function set_notify_show($value)
{
	$this->_flag_notify_show = intval($value);
}

function set_flag_owner($value)
{
	$this->_flag_owner = intval($value);
}

// --- class end ---
}

// === class end ===
}

?>