<?php
// $Id: weblinks_config2_basic_handler.php,v 1.1 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//=========================================================
// WebLinks Module
// 2006-05-15 K.OHWADA
//=========================================================

//---------------------------------------------------------
// TODO
// global $xoopsUser, $xoopsModule;
//---------------------------------------------------------


// === class begin ===
if( !class_exists('weblinks_config2_basic_handler') ) 
{

//=========================================================
// class weblinks_config2_basic_handler
// this class handle MySQL table directly
// this class does not use another class
//=========================================================
class weblinks_config2_basic_handler extends weblinks_db_basic_base
{

// variable
	var $_cached;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_config2_basic_handler( $dirname )
{

	$this->weblinks_db_basic_base( $dirname, 'config2' );

	$this->set_debug_sql(   WEBLINKS_DEBUG_CONFIG2_BASIC_SQL );
	$this->set_debug_error( WEBLINKS_DEBUG_ERROR );

// load config
	$this->load();

}

//=========================================================
// function for MySQL table
//=========================================================
function load()
{
	static $flag_init_load;

	if ( !isset($flag_init_load) ) 
	{
		$flag_init_load = 1;
	
		$arr =& $this->_load_db();

// if not initial
		if ( !is_array($arr) || ( count($arr) == 0 ) )
		{	return false;	}

		$arr['auth_submit_arr']      = unserialize( $arr['auth_submit'] );
		$arr['auth_submit_auto_arr'] = unserialize( $arr['auth_submit_auto'] );
		$arr['auth_modify_arr']      = unserialize( $arr['auth_modify'] );
		$arr['auth_modify_auto_arr'] = unserialize( $arr['auth_modify_auto'] );
		$arr['auth_ratelink_arr']    = unserialize( $arr['auth_ratelink'] );

		$arr['dohtml_arr']    = unserialize( $arr['auth_dohtml'] );
		$arr['dosmiley_arr']  = unserialize( $arr['auth_dosmiley'] );
		$arr['doxcode_arr']   = unserialize( $arr['auth_doxcode'] );
		$arr['doimage_arr']   = unserialize( $arr['auth_doimage'] );
		$arr['dobr_arr']      = unserialize( $arr['auth_dobr'] );

		$arr['rss_site_arr']  = $this->_conv_to_array( $arr['rss_site'] );
		$arr['rss_black_arr'] = $this->_conv_to_array( $arr['rss_black'] );
		$arr['rss_white_arr'] = $this->_conv_to_array( $arr['rss_white'] );

		$this->_cached = $arr;
	}
}

function &_load_db()
{
	$data = array();

	$sql = 'SELECT * FROM '.$this->_table.' ORDER BY conf_id ASC';
	$rows =& $this->get_rows_by_sql($sql);

	if ( is_array($rows) )
	{
		foreach ( $rows as $row ) 
		{
			$data[ $row['conf_name'] ] = $row['conf_value'];
		}
	}

	return $data;
}

function _conv_to_array($str, $pattern="\n")
{
	$str_arr = split($pattern, $str);

	$i = 0;	
	$arr = array();
	foreach ($str_arr as $value)
	{
		$value = trim($value);

		if ($value == '')  continue;

		$arr[$i++] = $value;
	}

	return $arr;
}

//---------------------------------------------------------
// get cache
//---------------------------------------------------------
function &get_cached()
{
	return $this->_cached;
}

function get_cache_by_name($name)
{
	if ( isset( $this->_cached[$name] ) )
	{
		$ret = $this->_cached[$name];
		return $ret;
	}

	return false;
}

//---------------------------------------------------------
// has authority
//---------------------------------------------------------
function has_auth_ratelink()
{
	$ret = $this->has_auth( 'auth_ratelink_arr' );
	return $ret;
}

function has_auth_desc_option()
{
	$arr = array(
		'dohtml'   => $this->has_auth( 'dohtml_arr' ),
		'dosmiley' => $this->has_auth( 'dosmiley_arr' ),
		'doxcode'  => $this->has_auth( 'doxcode_arr' ),
		'doimage'  => $this->has_auth( 'doimage_arr' ),
		'dobr'     => $this->has_auth( 'dobr_arr' ),
	);

	return $arr;
}

function has_auth( $auth_arr_name )
{
	if ( $this->is_xoops_module_admin() )
	{
		return true;
	}

	$auth_arr = $this->get_cache_by_name( $auth_arr_name );
	$groups   = $this->get_xoops_groups();

	if ( array_intersect( $auth_arr, $groups ) )
	{
		return true;
	}

	return false;
}

function show_modify( $rec_uid )
{
	list($is_permit, $is_owner, $show_passwd) =
		$this->has_auth_owner( 'auth_modify_arr', $rec_uid);

	if ( $is_permit || $show_passwd )
	{
		return true;
	}

	return false;
}

function has_auth_owner( $auth_arr_name, $rec_uid, $flag_passwd=false )
{
	$is_permit   = false;
	$is_owner    = false;
	$show_passwd = false;

	$rec_uid    = intval($rec_uid);
	$xoops_uid  = $this->get_xoops_uid();
	$use_passwd = $this->get_cache_by_name( 'use_passwd' );
	$has_auth_uid    = $this->has_auth_uid( $auth_arr_name );
	$has_auth_passwd = $this->has_auth_passwd( $auth_arr_name );

	if ( $this->has_auth( $auth_arr_name ) )
	{
		$is_permit = true;
	}

// uid
	if ( ( $xoops_uid > 0 )&&( $xoops_uid == $rec_uid )&& $has_auth_uid )
	{
		$is_permit = true;
		$is_owner  = true;
	}

// passwd
	if ( ( $xoops_uid == 0 ) && $use_passwd && $has_auth_passwd )
	{
		$show_passwd = true;

		if ( $flag_passwd )
		{
			$is_permit = true;
			$is_owner  = true;
		}
	}

	return array($is_permit, $is_owner, $show_passwd);
}

function has_auth_uid( $auth_arr_name )
{
	$auth_arr = $this->get_cache_by_name( $auth_arr_name );

	if ( in_array( WEBLINKS_ID_AUTH_UID, $auth_arr ) )
	{
		return true;
	}

	return false;
}

function has_auth_passwd( $auth_arr_name )
{
	$auth_arr = $this->get_cache_by_name( $auth_arr_name );

	if ( in_array( WEBLINKS_ID_AUTH_PASSWD, $auth_arr ) )
	{
		return true;
	}

	return false;
}

//---------------------------------------------------------
// xoops system parameter
//---------------------------------------------------------
function is_xoops_module_admin()
{
	global $xoopsUser, $xoopsModule;

	if ( is_object($xoopsUser) && is_object($xoopsModule) )
	{
		if ( $xoopsUser->isAdmin( $xoopsModule->mid() )) 
		{
			return true;
		}
	}

	return false;
}

function get_xoops_uid()
{
	global $xoopsUser;

	$uid = 0;

	if ( is_object($xoopsUser) )
	{
		$uid = $xoopsUser->getVar('uid');
	}

	return $uid;
}

function get_xoops_groups()
{
	global $xoopsUser;

	$groups = array();

	if ( is_object($xoopsUser) )
	{
		$groups = $xoopsUser->getGroups();
	}
	else
	{
		$groups = array( XOOPS_GROUP_ANONYMOUS );
	}

	return $groups;
}

// --- class end ---
}

// === class end ===
}

?>