<?php
// $Id: user_list.php,v 1.6 2006/05/24 01:15:19 ohwada Exp $

// 2006-05-15 K.OHWADA
// new handler
// add class admin_user_list

// 2006-03-15 K.OHWADA
// use weblinks_pagenavi_basic::getInstance()

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//================================================================
// WebLinks Module
// user list
// 2005-01-20 K.OHWADA
//================================================================
include 'admin_header.php';

include_once WEBLINKS_ROOT_PATH.'/class/weblinks_form.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_pagenavi.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_page_frame.php';


//=========================================================
// class admin_user_list
//=========================================================
class admin_user_list extends weblinks_page_frame
{
	var $_MAX_USER = 50;

	var $_system;

	var $_total_lid_array_with_email = 0;
	var $_total_uid_list_with_use    = 0;
	var $_total_uid_list_without_use = 0;

	var $_lid_array_with_email = array();
	var $_uid_list_with_use    = array();
	var $_uid_list_without_use = array();

	var $_logo_img;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_user_list()
{
	$this->weblinks_page_frame();

	$this->_system =& weblinks_system::getInstance();

	$this->set_handler('link', WEBLINKS_DIRNAME);
	$this->set_id_name('lid');
	$this->set_max_sortid(3);
	$this->set_perpage($this->_MAX_USER);
	$this->set_flag_alternate(1);
	$this->set_lang_no_item( _WEBLINKS_USER_NOFOUND );
	$this->set_lang_submit_value( _WEBLINKS_ADMIN_SENDMAIL );
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_user_list();
	}
	return $instance;
}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init()
{
	$this->_lid_array_with_email =& $this->_handler->get_lid_array_with_email();
	$this->_total_lid_array_with_email = count($this->_lid_array_with_email);

	$this->get_uid_list();

	$logo_url = XOOPS_URL.'/images/icons/email.gif';
	$this->_logo_img = $this->_form->make_html_img($logo_url, 0, 0, 0, 'mailto');

}

function get_uid_list()
{
	$this->_total_uid_list_with_use    = 0;
	$this->_total_uid_list_without_use = 0;
	$this->_uid_list_with_use    = array();
	$this->_uid_list_without_use = array();

	$xoops_user_list =& $this->_system->get_user_list();

	foreach ($xoops_user_list as $uid => $value)
	{
		if ($uid > 0)
		{
			$count = $this->_handler->get_count_by_uid($uid);
	
			if ( $count > 0 )
			{
				$this->_uid_list_with_use[] = $uid;
				$this->_total_uid_list_with_use ++;
			}
			else
			{
				$this->_uid_list_without_use[] = $uid;
				$this->_total_uid_list_without_use ++;
			}
		}
	}

}

//---------------------------------------------------------
// handler
//---------------------------------------------------------
function get_table_header()
{
	$input = $this->_form->make_js_checkall();

	switch ($this->_sortid)
	{
		case 3:
		case 2:
			$arr = array(
				$input,
				_WLS_NAME,
				_WLS_SITETITLE,
				_WLS_EMAIL,
			);
			break;

		case 1:
		case 0:
		default:
			$arr = array(
				$input,
				_WLS_LINKID,
				_WLS_NAME,
				_WLS_SITETITLE,
				_WLS_EMAIL,
				_WEBLINKS_SUBMITTER,
				_WEBLINKS_UID_EMAIL,
			);
			break;
	}

	return $arr;
}

function get_total()
{
	switch ($this->_sortid)
	{
		case 3:
			$total = $this->_total_uid_list_without_use;
			break;

		case 2:
			$total = $this->_total_uid_list_with_use;
			break;

		case 1:
		case 0:
		default:
			$total = $this->_total_lid_array_with_email;
			break;
	}

	return $total;
}

function &get_items($limit=0, $start=0)
{
	switch ($this->_sortid)
	{
		case 3:
			$lines = $this->get_uid_list_without_use($limit, $start);
			break;

		case 2:
			$lines = $this->get_uid_list_with_use($limit, $start);
			break;

		case 1:
			$lines = $this->get_lid_array_with_email();
			break;

		case 1:
		case 0:
		default:
			$lines = $this->get_lid_array_with_email($limit, $start);
			break;
	}

	return $lines;
}

function get_lid_array_with_email($limit=0, $start=0)
{
	$arr = array();

	if ( $limit )
	{
		$end = $this->_end;
	}
	else
	{
		$end = $this->_total;
	}

	for ($i=$start; $i<$end; $i++)
	{
		$arr[] = $this->_lid_array_with_email[$i];
	}

	return $arr;
}

function get_uid_list_with_use($limit=0, $start=0)
{
	$arr = array();

	for ($i=$start; $i<$this->_end; $i++)
	{
		$arr[] = $this->_uid_list_with_use[$i];
	}

	return $arr;
}

function get_uid_list_without_use($limit=0, $start=0)
{
	$arr = array();

	for ($i=$start; $i<$this->_end; $i++)
	{
		$arr[] = $this->_uid_list_without_use[$i];
	}

	return $arr;
}

function &get_cols(&$line)
{
	switch ($this->_sortid)
	{
		case 3:
		case 2:
			$arr =& $this->get_cols_uid($line);
			break;

		case 1:
		case 0:
		default:
			$arr =& $this->get_cols_lid($line);
			break;
	}

	return $arr;
}

function &get_cols_lid(&$line)
{
	$submitter_p = '---';

	$lid = $line;

	$obj =& $this->_handler->get($lid);
	$uid      = $obj->getVar('uid',   'n');
	$name_s   = $obj->getVar('name',  's');
	$email_s  = $obj->getVar('mail',  's');
	list($uid_uname_s, $uid_email_s) = $obj->user_name_mail('s');

	$jump_lid = 'link_manage.php?op=modLink&lid=';
	$input_p  = $this->_form->make_js_checkbox($lid);
	$linkid_p = $this->build_html_id_link_by_obj($obj, 'lid', $jump_lid);
	$title_p  = $this->build_html_name_link_by_obj($obj, 'url', 'title', '_blank');
	$email_p  = $this->_form->make_xoops_mailto_with_logo($email_s);

	if ($uid >1)
	{
		$submitter_p = $this->_form->make_xoops_url_userinfo($uid, $uid_uname_s);
	}
	elseif ($uid)
	{
		$submitter_p  = $this->_form->make_xoops_url_userinfo($uid, $uid_uname_s);
		$submitter_p .= ' ('._WEBLINKS_WEBMASTER.') ';
	}

	$uid_email_p = $this->_form->make_xoops_mailto_with_logo($uid_email_s);

	$arr = array(
		$input_p,
		$linkid_p,
		$name_s,
		$title_p,
		$email_p,
		$submitter_p,
		$uid_email_p,
	);

	return $arr;
}

function &get_cols_uid(&$line)
{
	$uid = $line;

	$user = $this->_system->get_user_by_uid( $uid );

	$uname_s = $this->_form->sanitize_html_text( $user['uname'] );
	$email_s = $this->_form->sanitize_html_text( $user['email'] );

	$objs = $this->_handler->get_objects_by_uid($uid);

	$lid_list = '';

	if ( count($objs) > 0 )
	{
		foreach ( $objs as $obj )
		{
			$lid         = $obj->getVar('lid');
			$title_s     = $obj->getVar('title');
			$modlink_url = "link_manage.php?op=modLink&lid=".$lid;

			$lid_list .= $this->_form->make_html_url_link($modlink_url, $title_s);
			$lid_list .= "<br />\n";
		}
	}

	$input_p  = $this->_form->make_js_checkbox($uid);
	$input_p .= $this->build_uname($uid, $uname_s);

	$submitter_p = $this->_form->make_xoops_url_userinfo($uid, $uname_s);
	$email_p     = $this->_form->make_xoops_mailto_with_logo($email_s);

	$arr = array(
		$input_p,
		$submitter_p,
		$lid_list,
		$email_p,
	);

	return $arr;
}

function build_uname($uid, $uname_s)
{
	$input = "<input type='hidden' name='memberslist_uname[".$uid."]' id='memberslist_uname[]' value='".$uname_s."' />";
	return $input;
}


//---------------------------------------------------------
// print
//---------------------------------------------------------
function print_top()
{
	$index_num = sprintf(_WEBLINKS_USER_MAX, $this->_MAX_USER);
	$index_0 = _WEBLINKS_ADMIN_USER_EMAIL.$index_num;
	$index_1 = _WEBLINKS_ADMIN_USER_EMAIL._WEBLINKS_USER_ALL;
	$index_2 = _WEBLINKS_ADMIN_USER_LINK.$index_num;
	$index_3 = _WEBLINKS_ADMIN_USER_NOLINK.$index_num;

	switch ($this->_sortid)
	{
		case 3:
			$title   = $index_3;
			$desc    = _WEBLINKS_ADMIN_USER_LINK_DSC;
			break;

		case 2:
			$title   = $index_2;
			$desc    = _WEBLINKS_ADMIN_USER_LINK_DSC;
			break;

		case 1:
			$title = $index_1;
			$desc  = _WEBLINKS_ADMIN_USER_EMAIL_DSC;
			break;

		case 0:
		default:
			$title = $index_0;
			$desc  = _WEBLINKS_ADMIN_USER_EMAIL_DSC;
			break;
	}

	echo "<h4>"._WEBLINKS_ADMIN_USER_MANAGE."</h4>\n";

	echo "<table width='80%' border='0' cellspacing='1' class='outer'>";
	echo "<tr class='odd'><td>";
	echo "<ul>\n";
	echo "<li><a href='user_list.php?sortid=0'>$index_0</a> (".$this->_total_lid_array_with_email.") </li>\n";
	echo "<li><a href='user_list.php?sortid=1'>$index_1</a> (".$this->_total_lid_array_with_email.") </li>\n";
	echo "<li><a href='user_list.php?sortid=2'>$index_2</a> (".$this->_total_uid_list_with_use.") </li>\n";
	echo "<li><a href='user_list.php?sortid=3'>$index_3</a> (".$this->_total_uid_list_without_use.") </li>\n";
	echo "<ul/>\n";
	echo"</td></tr></table>\n";
	echo"<br /><br />\n";

	echo "<h4>$title</h4>\n";
	echo "$desc<br /><br />\n";
}

function main_proc_extra()
{
	printf(_WEBLINKS_THERE_ARE_USER, $this->_total);
	echo "<br />\n";
	printf(_WEBLINKS_USER_NUM, $this->_start + 1, $this->_end);
	echo "<br /><br />\n";
}

function print_form_begin()
{
	$this->set_flag_form(1);

	switch ($this->_sortid)
	{
		case 3:
		case 2:
			$action = XOOPS_URL.'/modules/system/admin.php';
			echo $this->_form->make_form_start('memberslist', $action);
			echo $this->_form->make_form_token();
			echo $this->_form->make_form_hidden('fct', 'mailusers');
			break;

		case 1:
		case 0:
		default:
			echo $this->_form->make_form_start('memberslist', 'mail_users.php');
			echo $this->_form->make_form_token();
			break;
	}
}

function print_table_submit()
{
	switch ($this->_sortid)
	{
		case 3:
		case 2:
			$colspan = 4;
			break;

		case 1:
		case 0:
		default:
			$colspan = 7;
			break;
	}

	echo $this->build_table_submit($colspan);
}

// --- class end ---
}


//=========================================================
// main
//=========================================================
xoops_cp_header();

weblinks_admin_print_header();
weblinks_admin_print_menu();

$list =& admin_user_list::getInstance();
$list->show();

xoops_cp_footer();
exit();
// --- end of main ---

?>