<?php
// $Id: create_config.php,v 1.4 2006/05/24 01:15:18 ohwada Exp $

// 2006-05-15 K.OHWADA
// use admin_config_file

//================================================================
// WebLinks Module
// create config file for bin/link_check.php
// 2004-10-20 K.OHWADA
//================================================================
include 'admin_header.php';

$config_file  =& admin_config_file::getInstance();

$DIR_CONFIG  = WEBLINKS_ROOT_PATH."/cache";
$FILE_CONFIG = $DIR_CONFIG."/config.php";

xoops_cp_header();

weblinks_admin_print_header();
weblinks_admin_print_menu();

echo "<h3>"._AM_WEBLINKS_CREATE_CONFIG."</h3>\n";
echo "Create config file for bin/link_check.php <br /><br />\n";

if ( is_writable( $DIR_CONFIG ) ) 
{
	$config_file->save_config( $FILE_CONFIG );

	echo "<hr />\n";
	echo "<h4>"._CREATED."</h4>\n";
	echo "<ul>\n";
	echo "<li><a href='../bin/link_check.php?limit=10'>".sprintf(_AM_WEBLINKS_TEST_EXEC, 'bin/link_check.php')."</a></li>\n";
	echo "<li><a href='../bin/rss_refresh_link.php?limit=10'>".sprintf(_AM_WEBLINKS_TEST_EXEC, 'bin/rss_refresh_link.php')."</a></li>\n";
	echo "<li><a href='../bin/rss_refresh_site.php?limit=10'>".sprintf(_AM_WEBLINKS_TEST_EXEC, 'bin/rss_refresh_site.php')."</a></li>\n";
	echo "</ul>\n";
}
else
{
	echo "<h3 style='color: #ff0000'>"._AM_WEBLINKS_WARNING_NOT_WRITABLE."</h3>\n";
	echo "$DIR_CONFIG <br /><br />\n";
}

xoops_cp_footer();
exit();
// === main end ===


//================================================================
// class admin_config_file
//================================================================
class admin_config_file
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_config_file()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_config_file();
	}

	return $instance;
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function save_config($file)
{
	global $xoopsConfig;

	$fp = fopen($file, "w");

	fwrite($fp,"<?php \n");

	$date = date("Y/m/d H:i:s");
	fwrite($fp,"// $date \n\n");

	$this->_write_constant($fp, 'XOOPS_MAINFILE_INCLUDED', 1);
	$this->_write_constant($fp, 'XOOPS_ROOT_PATH');
	$this->_write_constant($fp, 'XOOPS_URL');
	$this->_write_constant($fp, 'XOOPS_DB_TYPE');
	$this->_write_constant($fp, 'XOOPS_DB_PREFIX');
	$this->_write_constant($fp, 'XOOPS_DB_HOST');
	$this->_write_constant($fp, 'XOOPS_DB_USER');
	$this->_write_constant($fp, 'XOOPS_DB_PASS');
	$this->_write_constant($fp, 'XOOPS_DB_NAME');
	$this->_write_constant($fp, 'XOOPS_DB_PCONNECT');
	$this->_write_constant($fp, 'XOOPS_GROUP_ADMIN');
	$this->_write_constant($fp, 'XOOPS_GROUP_USERS');
	$this->_write_constant($fp, 'XOOPS_GROUP_ANONYMOUS');

	fwrite($fp,"\n");

	$this->_write_variable($fp, '$xoops_sitename',  $xoopsConfig['sitename'] );
	$this->_write_variable($fp, '$xoops_adminmail', $xoopsConfig['adminmail'] );
	$this->_write_variable($fp, '$xoops_language',  $xoopsConfig['language'] );

	fwrite($fp,"\n?>");

	fclose($fp);
}

function _write_constant($fp, $key, $value='')
{
	if (empty($value))  $value = constant($key);

	$data = "define('$key', '$value');";
	fwrite($fp,"$data \n");
}

function _write_variable($fp, $key, $value)
{
	$data = "$key = '$value';";
	fwrite($fp,"$data \n");
}

// --- class end ---
}

?>