<?php
// $Id: broken_manage.php,v 1.1 2006/05/24 01:16:13 ohwada Exp $

// 2006-05-15 K.OHWADA
// new handler
// add class admin_broken_manage
// use token ticket

// 2006-03-22 K.OHWADA
// new handler: broken

// 2005-10-14 K.OHWADA
// BUG 3095: the number of links does not change, if delete link
// use del_link_vote_comm_catlink_by_lid($lid)

// 2005-09-04 K.OHWADA
// BUG 2932: dont work correctly when register_long_arrays = off

//=========================================================
// admin broken
// use class weblinksCategory, weblinksLink
// divid this file from index.php
// 2004/01/14 K.OHWADA
//=========================================================

include 'admin_header.php';


//=========================================================
// class admin_broken_manage
//=========================================================
class admin_broken_manage extends weblinks_error
{
	var $_link_edit_handler;
	var $_broken_handler;

	var $_system;
	var $_post;
	var $_form;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_broken_manage()
{
	$this->_link_edit_handler =& weblinks_get_handler('link_edit', WEBLINKS_DIRNAME);
	$this->_broken_handler    =& weblinks_get_handler('broken',    WEBLINKS_DIRNAME);

	$this->_system =& weblinks_system::getInstance();
	$this->_post   =& weblinks_post::getInstance();
	$this->_form   =& weblinks_form::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_broken_manage();
	}
	return $instance;
}

//---------------------------------------------------------
// listBrokenLinks
//---------------------------------------------------------
function listBrokenLinks()
{
	$broken_objs = $this->_broken_handler->get_objects_group_by_lid();
	$totalbrokenlinks = count($broken_objs);

	echo "<h4>"._WLS_BROKENREPORTS." ($totalbrokenlinks)</h4><br />";

   	if ( $totalbrokenlinks == 0 ) 
   	{
		echo _WLS_NOBROKEN;
		echo"</td></tr></table>";
		return;
    } 

    echo "<center>
	"._WLS_IGNOREDESC."<br />
	"._WLS_DELETEDESC."</center><br /><br /><br />";
    $colorswitch="dddddd";
	echo "<table align=\"center\" width=\"90%\">";

    echo "
    <tr>
    <td><b>Link Name</b></td>
    <td><b>" ._WLS_REPORTER."</b></td>
    <td><b>" ._WLS_LINKSUBMITTER."</b></td>
    <td><b>" ._WLS_IGNORE."</b></td>
    <td><b>" ._EDIT."</b></td>
    <td><b>" ._WLS_DELETE."</b></td>
    </tr>";

	foreach ($broken_objs as $broken_obj) 
	{
		$lid    = $broken_obj->getVar('lid');
		$sender = $broken_obj->getVar('sender');
		$ip     = $broken_obj->getVar('ip');
		$uname  = $broken_obj->get_uname();
		$email  = $broken_obj->get_email();

		$flag_link_exist = false;
		$title = '';
		$url   = '';
		$uid   = '';

		$link_obj = $this->_link_edit_handler->get($lid);
		if ( is_object($link_obj) )
		{
			$flag_link_exist = true;
			$title = $link_obj->getVar('title');
			$url   = $link_obj->getVar('url');
			$uid   = $link_obj->getVar('uid');
		}

		$user_param = $this->_system->get_user_by_uid( $uid );
		$owner      = $user_param['uname'];
		$owneremail = $user_param['email'];

		$opt_ignore = array(
			'op'  => 'ignoreBrokenLinks',
			'lid' => $lid,
		);

		$opt_del = array(
			'op'  => 'delBrokenLinks',
			'lid' => $lid,
		);

		if ($flag_link_exist)
   		{
   			echo "<tr><td bgcolor=$colorswitch><a href=$url target='_blank'>$title</a></td>";
   		}
   		else
   		{
   			echo "<tr><td bgcolor=$colorswitch><font color=red>"._WLS_ERRORNOLINK."</font></td>";
   		}

   		if ( $email=='' ) 
   		{
   			echo "<td bgcolor=\"".$colorswitch."\">".$sender." (".$ip.")";
   		} 
		else 
		{
			echo "<td bgcolor=\"".$colorswitch."\"><a href=\"mailto:".$email."\">".$uname."</a> (".$ip.")";
		}
   		
   		echo "</td>";
   		
   		if ( $owneremail == '' ) 
   		{
   			echo "<td bgcolor=\"".$colorswitch."\">".$owner."";	
   		}
   		else 
   		{
   			echo "<td bgcolor=\"".$colorswitch."\"><a href=\"mailto:".$owneremail."\">".$owner."</a>";
   		}

		if ($flag_link_exist)
		{
			echo "</td><td bgcolor='$colorswitch' align='center'>\n";
		 	echo $this->_form->make_form_box_option( "broken_manage.php", "X", $opt_ignore );
			echo "</td><td bgcolor='$colorswitch' align='center'>\n";
			echo myTextForm("link_manage.php?op=modLink&lid=$lid" , "X");
			echo "</td><td align='center' bgcolor='$colorswitch'>\n";
		 	echo $this->_form->make_form_box_option( "broken_manage.php", "X", $opt_del );
			echo "</td>\n";
		}
		else
		{
			echo "</td><td bgcolor='$colorswitch' align='center'>\n";
		 	echo $this->_form->make_form_box_option( "broken_manage.php", "X", $opt_ignore );
			echo "</td>\n";
			echo "<td align='center'>---</td>\n";
			echo "<td align='center'>---</td>\n";
		}

		echo "</tr>\n";

    	if ( $colorswitch == "#dddddd" )
    	{
    		$colorswitch="#ffffff";
    	}
		else
		{
			$colorswitch="#dddddd";
		}
	}

	echo "</table>";

}

//---------------------------------------------------------
// delBrokenLinks
//---------------------------------------------------------
function delBrokenLinks()
{
	$this->_clear_errors();

// BUG 2932: dont work correctly when register_long_arrays = off
	$lid = $this->_post->get_post_int('lid');

	$ret = $this->_broken_handler->delete_by_lid($lid);
	if ( !$ret)
	{
		$this->_set_errors( $this->_link_edit_handler->getErrors() );
	}

// BUG 3095: the number of links does not change, if delete link
	$ret = $this->_link_edit_handler->del_link_vote_comm_catlink_by_lid($lid);
	if (!$ret)
	{
		$this->_set_errors( $this->_link_edit_handler->getErrors() );
	}

	return $this->returnExistError();
}

//---------------------------------------------------------
// ignoreBrokenLinks
//---------------------------------------------------------
function ignoreBrokenLinks()
{
// BUG 2932: dont work correctly when register_long_arrays = off
	$lid = $this->_post->get_post_int('lid');

	$ret = $this->_broken_handler->delete_by_lid($lid);
	if ( !$ret)
	{
		$this-_set_errors( $this->_broken_edit_handler->getErrors() );
		return false;
	}

	return true;
}

//---------------------------------------------------------
// token ticket
//---------------------------------------------------------
function check_token( $name='' )
{
	$ret = $this->_form->check_token($name);
	return $ret;
}

// --- class end ---
}


//=========================================================
// main
//=========================================================
$broken_manage =& admin_broken_manage::getInstance();

$op = 'main';
if     ( isset($_POST['op']) ) $op = $_POST['op'];
elseif ( isset($_GET['op']) )  $op = $_GET['op']; 

switch ($op) 
{
case "delBrokenLinks":
	if ( !( $broken_manage->check_token() ) )
	{
		redirect_header("link_list.php", 5, "Token Error");
		exit();
	}

	$ret = $broken_manage->delBrokenLinks();
	if ($ret)
	{
	    redirect_header("link_list.php", 1, _WLS_LINKDELETED);
	}
	else
	{
		xoops_cp_header();
		xoops_error("DB Error");
		echo $broken_manage->getErrors(1);
		weblinks_admin_print_menu();
		xoops_cp_footer();
	}

	break;

case "ignoreBrokenLinks":
	if ( !( $broken_manage->check_token() ) )
	{
		redirect_header("link_list.php", 5, "Token Error");
		exit();
	}

	$ret = $broken_manage->ignoreBrokenLinks();
	if ($ret)
	{
	    redirect_header("link_list.php", 1, _WLS_BROKENDELETED);
	}
	else
	{
		xoops_cp_header();
		xoops_error("DB Error");
		echo $broken_manage->getErrors(1);
		weblinks_admin_print_menu();
		xoops_cp_footer();
	}

	break;

case 'main':
case "listBrokenLinks":
default:
	xoops_cp_header();
	weblinks_admin_print_header();
	weblinks_admin_print_menu();
	$broken_manage->listBrokenLinks();
	xoops_cp_footer();
	break;

}

exit();
// --- end of main ---

?>