<?php
// $Id: admin_functions.php,v 1.6 2006/05/24 01:15:18 ohwada Exp $

// 2006-05-15 K.OHWADA
// weblinks_admin_print_header()
// weblinks_admin_print_menu()

// 2006-03-22 K.OHWADA
// use new handler: votedata

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication
// from include/functions

//=========================================================
// WebLinks Module
// admin functions
// 2004-12-05 K.OHWADA
//=========================================================
function weblinks_admin_print_header()
{
	echo "<h3>"._MI_WEBLINKS_NAME."</h3>\n";
	echo _MI_WEBLINKS_DESC."<br /><br />\n";
}

function weblinks_admin_print_menu()
{
	$MAX_COL = 4;

	$link_handler   =& weblinks_get_handler('link',      WEBLINKS_DIRNAME);
	$cat_handler    =& weblinks_get_handler('category',  WEBLINKS_DIRNAME);
	$modify_handler =& weblinks_get_handler('modify',    WEBLINKS_DIRNAME );
	$broken_handler =& weblinks_get_handler('broken',    WEBLINKS_DIRNAME );
	$feed_handler   =& weblinks_get_handler('atomfeed',  WEBLINKS_DIRNAME);
	$system         =& weblinks_system::getInstance();
	$strings        =& weblinks_strings::getInstance();

	$total_link  = $link_handler->getCount();
	$total_cat   = $cat_handler->getCount();
	$total_feed  = $feed_handler->getCount();

	$total_brokenlinks = $link_handler->get_count_broken();
	$total_brokenlinks = $strings->highlight_number($total_brokenlinks);

	$total_newlinks = $modify_handler->get_count_new();
	$total_newlinks = $strings->highlight_number($total_newlinks);

	$total_modify = $modify_handler->get_count_mod();
	$total_modify = $strings->highlight_number($total_modify);

	$total_broken = $broken_handler->getCount();
	$total_broken = $strings->highlight_number($total_broken);

	$total_nourl  = $link_handler->get_count_non_url();

	$link_list  = _WEBLINKS_ADMIN_LINK_LIST.     " ($total_link)";
	$cat_list   = _WEBLINKS_ADMIN_CATEGORY_LIST. " ($total_cat)";
	$feed_list  = _WEBLINKS_ADMIN_RSS_MANAGE.    " ($total_feed)";

	$title_link = _WEBLINKS_ADMIN_LINK_MANAGE."<br />"._WEBLINKS_ADMIN_ADD_LINK;

	$title_brokenlinks = _WEBLINKS_ADMIN_LINK_BROKEN." ($total_brokenlinks)";
	$title_newlinks    = _WLS_LINKSWAITING. " ($total_newlinks)";
	$title_modify      = _WLS_MODREQUESTS.  " ($total_modify)";
	$title_broken      = _WLS_BROKENREPORTS." ($total_broken)";

	$mid = $system->get_mid();
	$url_preferences = XOOPS_URL.'/modules/system/admin.php?fct=preferences&amp;op=showmod&amp;mod='.$mid;

	$menu_arr = array(
		_WEBLINKS_ADMIN_MODULE_CONFIG_1 => $url_preferences,
		$cat_list   => 'category_list.php',
		$link_list  => 'link_list.php',
		$feed_list  => 'rss_manage.php',

		_WEBLINKS_ADMIN_MODULE_CONFIG_2  => 'index.php',
		_AM_WEBLINKS_ADD_CATEGORY        => 'category_manage.php',
		_WEBLINKS_ADMIN_ADD_LINK         => 'link_manage.php',
		_AM_WEBLINKS_BULK_IMPORT         => 'bulk_manage.php',

		$title_newlinks           => 'link_manage.php?op=listNewLinks',
		$title_modify             => 'link_manage.php?op=listModReq',
		$title_broken             => 'broken_manage.php',
		$title_brokenlinks        => 'link_list.php?sortid=2',

		_WEBLINKS_ADMIN_LINK_BROKEN_CHECK  => 'link_broken_check.php',
		_WEBLINKS_ADMIN_USER_MANAGE => 'user_list.php',
		_WEBLINKS_ADMIN_SENDMAIL    => 'mail_users.php',
		_WEBLINKS_ADMIN_OTHERFUNC   => 'other.php',

		_GOTO_MODULE => '../index.php'
	);

	weblinks_admin_print_menu_table($menu_arr, $MAX_COL);
}

function weblinks_admin_print_footer()
{

?>
<hr />
<div align="right"><a href="http://linux2.ohwada.net/" target="_blank"><font size="-1">Powered by Happy Linux</font></a></div>
<div align="right"><font size="-1">&copy; 2005, Kenichi OHWADA</font></div>
<?php

}

function weblinks_admin_print_menu_table($menu_arr, $MAX_COL=5)
{
	echo "<table class='outer' cellpadding='4' cellspacing='1'> \n";
	echo "<tr>";

	$col_count  = 0;
	$line_count = 0;
	$class = 'odd';
	foreach ($menu_arr as $name => $url) 
	{
		$class = ($class == 'even') ? 'odd' : 'even';
		echo "<td class='$class' align='center' valign='bottom' width='19%'>";

		if ($name && $url)
		{
			echo "<a href='".$url."'><b>" .$name."</b></a>";
		}

		echo "</td>\n";

		$col_count ++;

		if ( $col_count >= $MAX_COL ) 
		{
			if ($line_count % 2 == 0) 
			{
				$class = 'even';
			}
			else 
			{
				$class = 'odd';
			}

			$col_count = 0;
			$line_count ++;

			echo "</tr>\n";
			echo "<tr>";
		}
	}

	while ($col_count < $MAX_COL) 
	{
		$class = ($class == 'even') ? 'odd' : 'even';
		echo '<td class="'.$class.'">&nbsp;</td>';

		$col_count ++;
	}

	echo "</tr></table>\n";
	echo "<br />\n";
}

//---------------------------------------------------------
// XoopsMultiTokenHandler
//---------------------------------------------------------
function weblinks_admin_check_token( $name='weblinks' )
{
	if ( !class_exists('XoopsMultiTokenHandler') )  return true;
	if( XoopsMultiTokenHandler::quickValidate($name) ) return true;
	return false;
}

?>