<?php
// $Id: submit.php,v 1.7 2006/09/16 04:16:55 ohwada Exp $

// 2006-07-29 K.OHWADA
// REQ: countup xoops post count

// 2006-05-15 K.OHWADA
// add class weblinks_submit()
// use new handler
// use token ticket
// dont use global

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//================================================================
// WebLinks Module
// 2004/01/23 K.OHWADA
//================================================================

//---------------------------------------------------------
// TODO
// anonymous can choice recieve or not email
//---------------------------------------------------------

include "header.php";

include_once XOOPS_ROOT_PATH.'/include/xoopscodes.php';
include_once XOOPS_ROOT_PATH.'/class/xoopsformloader.php';

include_once WEBLINKS_ROOT_PATH.'/class/weblinks_mailer.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_utility.php';
include_once WEBLINKS_ROOT_PATH."/class/weblinks_form.php";
include_once WEBLINKS_ROOT_PATH."/class/weblinks_linkitem_handler.php";
include_once WEBLINKS_ROOT_PATH."/class/weblinks_linkitem_define_handler.php";
include_once WEBLINKS_ROOT_PATH."/class/weblinks_linkitem_store_handler.php";
include_once WEBLINKS_ROOT_PATH."/class/weblinks_sendmail.php";


//=========================================================
// class weblinks_submit
//=========================================================
class weblinks_submit extends weblinks_error
{
	var $_dirname;
	var $_ALLOW_INCREMENT_POST = false;

	var $_config_basic_handler;
	var $_link_view_handler;
	var $_link_edit_handler;
	var $_link_form_handler;
	var $_template;
	var $_myts;
	var $_post;

// config
	var $_conf_check_double;
	var $_has_auth_submit;
	var $_has_auth_submit_auto;
	var $_has_auth_html;

// system
	var $system_is_module_admin;
	var $system_is_user;
	var $system_module_name;
	var $system_uid;
	var $system_uname;
	var $system_email;

// post
	var $_post_notify;
	var $_post_op;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_submit($dirname)
{
	$this->weblinks_error();
	$this->set_debug_print_error( WEBLINKS_DEBUG_ERROR );

	$this->_dirname = $dirname;

	$this->_config_handler     =& weblinks_get_handler( 'config2_basic', WEBLINKS_DIRNAME );
	$this->_link_view_handler  =& weblinks_get_handler( 'link_view',     WEBLINKS_DIRNAME );
	$this->_link_edit_handler  =& weblinks_get_handler( 'link_edit',     WEBLINKS_DIRNAME );
	$this->_link_form_handler  =& weblinks_get_handler( 'link_form',     WEBLINKS_DIRNAME );
	$this->_template =& weblinks_template::getInstance( $dirname );
	$this->_post     =& weblinks_post::getInstance();
	$this->_myts     =& MyTextSanitizer::getInstance();

	$conf = $this->_config_handler->get_cached();
	$this->_conf_check_double = $conf['check_double'];

	$system =& weblinks_system::getInstance();
	$this->system_is_module_admin = $system->is_module_admin();
	$this->system_is_user         = $system->is_user();
	$this->system_module_name     = $system->get_module_name();
	list($this->system_uid, $this->system_uname, $this->system_email, $groups)
		= $system->get_user_param();

}

//---------------------------------------------------------
// check_access
//---------------------------------------------------------
function check_access()
{
	$this->_has_auth_submit      = $this->_link_edit_handler->has_auth_submit();
	$this->_has_auth_submit_auto = $this->_link_edit_handler->has_auth_submit_auto();

// admin
	if ( $this->system_is_module_admin )
	{
		return 1;	// admin
	}

// not permit
	if ( !$this->_has_auth_submit ) 
	{
		if ( $this->system_uid ) 
		{
			return -1;	// not permit
		}
		else
		{
			return -2;	// anonymous
		}
	}

	$this->_link_edit_handler->init();

	return 0;	// OK
}

function get_permit_param()
{
	$ret = array($this->_has_auth_submit_auto, $this->system_is_user);
	return $ret;
}

//---------------------------------------------------------
// submit_form
//---------------------------------------------------------
function print_submit_form()
{
	$this->print_submit_header();
	$this->print_submit_comment();

	$this->show_user_form('submit');
}

function show_user_form($form_mode)
{
	$notify_show = 0;

	if ( !$this->_has_auth_submit_auto )
	{
		$notify_show = 1;
	}

	$this->_link_form_handler->set_notify_show( $notify_show );
	$this->_link_form_handler->show_user_form($form_mode);
}

//---------------------------------------------------------
// preview
//---------------------------------------------------------
function print_preview()
{
	$this->print_submit_header();
	echo "<hr />\n";

// check form
	if ( !( $this->check_form_addlink() ) ) 
	{
		echo $this->_link_edit_handler->get_error_msg_addlink();
	}
	else
	{
		echo "<h4>"._PREVIEW."</h4>\n";
		$arr_preview = $this->_link_view_handler->build_preview( $_POST );
		echo $this->_template->fetch_link_single( $arr_preview );
	}

	echo "<hr />\n";
	$this->print_submit_comment();

	$this->show_user_form('submit_preview');
}

//---------------------------------------------------------
// post
//---------------------------------------------------------
function check_form_addlink()
{
	$ret = $this->_link_edit_handler->check_form_addlink( $_POST );
	return $ret;
}

function print_post_error()
{
	$this->print_submit_header();
	echo "<hr />\n";

	echo $this->_link_edit_handler->get_error_msg_addlink();
	echo "<hr>\n";

	$this->print_submit_comment();

	$this->show_user_form('submit_preview');
}

function post_auto_approve()
{
	$newid = $this->_link_edit_handler->add_link( $_POST );
	if (!$newid)
	{
		$this->_set_errors( $this->_link_edit_handler->getErrors() );
		return false;
	}

// REQ: countup xoops post count
//-----
	global $xoopsUser;
	if ( $this->_ALLOW_INCREMENT_POST && is_object($xoopsUser) ) 
	{
		$xoopsUser->incrementPost();
	}
//-----

	return $newid;
}

function post_approve()
{
	$newid = $this->_link_edit_handler->add_link_to_modify( $_POST );
	if (!$newid)
	{
		$this->_set_errors( $this->_link_edit_handler->getErrors() );
		return false;
	}

	return $newid;
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function get_post_get()
{
	$op = '';
	if     (isset($_POST['post']))     $op = 'post';
	elseif (isset($_POST['preview']))  $op = 'preview';

	$notify  = $this->_post->get_post_int('notify');

	$this->_post_op     = $op;
	$this->_post_notify = $notify;

	return array($op, $notify);
}

function print_submit_header()
{
	echo '<link rel="stylesheet" type="text/css" media="all" href="'.WEBLINKS_URL.'/weblinks.css" />'."\n";
	echo '&nbsp;';
	echo '<a href="'.XOOPS_URL.'/">'._HOME.'</a> &gt;&gt;';
	echo '<a href="'.WEBLINKS_URL.'/">'.$this->system_module_name.'</a> &gt;&gt;';
	echo '<span class="weblinks_bold">'._WLS_SUBMIT_NEW_LINK.'</span><br /><br />'."\n";
}

function print_submit_comment()
{
	echo '<div style="width: 100%; margin: 5px; padding: 5px;">'."\n";
	echo "<ul>\n";

// check_double
	if ( $this->_conf_check_double )
	{
		echo "<li>"._WLS_SUBMITONCE."</li>\n";
	}

	echo "<li>"._WLS_DONTABUSE."</li>\n";
	echo "<li>"._WLS_TAKESHOT."</li>\n";

	if ( !$this->_has_auth_submit_auto )
	{
		echo "<li>". _WLS_ALLPENDING."</li>\n";
	}

// indispensable item
	echo "<li>"._WLS_SUBMIT_INDISPENSABLE."</li>\n";

// user comment
	echo "<li>"._WLS_SUBMIT_USER_COMMENT."</li>\n";

	echo "</ul></div><br />\n";
}

//---------------------------------------------------------
// event tags
//---------------------------------------------------------
function build_tags_addlink($newid)
{
	list($tags, $cid) = $this->_link_edit_handler->build_tags_addlink($newid);
	return array($tags, $cid);
}

//---------------------------------------------------------
// token ticket
//---------------------------------------------------------
function check_token()
{
	$ret = $this->_link_edit_handler->check_token();
	return $ret;
}

// --- class end ---
}


//=========================================================
// main
//=========================================================

$weblinks_submit   =& new weblinks_submit( WEBLINKS_DIRNAME );
$weblinks_sendmail =& weblinks_sendmail::getInstance( WEBLINKS_DIRNAME );

$FLAG_EVENT_ANONYMOUS = 1;	// send email for anonymous

// check permit
$check = $weblinks_submit->check_access();

if ( $check == -1 ) 
{
	redirect_header('index.php', 1, _NOPERM);
	exit();
}

if ( $check == -2 ) 
{
	redirect_header( XOOPS_URL.'/user.php', 2, _WLS_MUSTREGFIRST);
	exit();
}

if ( $check == 1 )
{
	$url = './admin/link_manage.php?op=addLink';

// REQ 3110: Add in this category
	if ( isset($_GET['cid']) )
	{
		$url .= '&amp;cid='.$_GET['cid'];
	}

	redirect_header($url, 2, _WLS_GOTOADMIN);	
}

// start
list($op, $notify)                = $weblinks_submit->get_post_get();
list($has_auto_approve, $is_user) = $weblinks_submit->get_permit_param();

// Notify of new link (anywhere) and new link in category.
$notification_handler =& xoops_gethandler('notification');

// save to DB
if ( $op == 'post' )
{
	if( !( $weblinks_submit->check_token() ) ) 
	{
		redirect_header("index.php", 5, "Token Error");
		exit();
	}

	if ( !( $weblinks_submit->check_form_addlink() ) )
	{
		include XOOPS_ROOT_PATH.'/header.php';
		$weblinks_submit->print_post_error();
		include XOOPS_ROOT_PATH.'/footer.php';
		exit();
	}

// auto approve
	if ( $has_auto_approve )
	{
// insert link
		$newid = $weblinks_submit->post_auto_approve();
		if (!$newid)
		{
			redirect_header('index.php', 5, "DB Error");
			exit();
		}

// notification
		list($tags, $cid) = $weblinks_submit->build_tags_addlink($newid);
		$notification_handler->triggerEvent('global', 0, 'new_link', $tags);
		$notification_handler->triggerEvent('category', $cid, 'new_link', $tags);

// redirect to single link
		redirect_header('singlelink.php?lid='.$newid, 2, _WLS_RECEIVED.'<br />'._WLS_ISAPPROVED.'');
	}

// approve
	else
	{
// insert link	
// bug fix: approve notify mail dont send

		$modify_newid = $weblinks_submit->post_approve();
		if (!$modify_newid)
		{
			redirect_header('index.php', 5, "DB Error");
			exit();
		}

// send email to admin, new link notification for user
		list($tags, $cid) = $weblinks_submit->build_tags_addlink($modify_newid);
		$tags['WAITINGLINKS_URL'] = WEBLINKS_URL.'/admin/link_manage.php?op=listNewLinks';
		$notification_handler->triggerEvent('global', 0, 'link_edit', $tags);
		$notification_handler->triggerEvent('category', $cid, 'link_edit', $tags);

// register to waiting notification for user
		if ($notify) 
		{
			include_once XOOPS_ROOT_PATH . '/include/notification_constants.php';

// bug fix: approve notify mail dont send
			$notification_handler->subscribe('link', $modify_newid, 'approve', XOOPS_NOTIFICATION_MODE_SENDONCETHENDELETE);
		}

// send email to admin, new link notification for anonymous
// REQ 3028: send new link email to admin
// TODO: anonymous can choice recieve or not email

		if ( $FLAG_EVENT_ANONYMOUS && !$is_user && !empty($_POST['mail']) )
		{
			$ret = $weblinks_sendmail->send_newlink_to_admin();
			if (!$ret)
			{
				$msg = _WLS_RECEIVED."<br />Mail Error";
				redirect_header('index.php', 5, $msg);
			}
		}

		redirect_header('index.php', 1, _WLS_RECEIVED);
	}
}

// preview mode
elseif ($op == 'preview')
{
	include XOOPS_ROOT_PATH.'/header.php';
	$weblinks_submit->print_preview();
	include XOOPS_ROOT_PATH.'/footer.php';
}

// submit form
else 
{
	include XOOPS_ROOT_PATH.'/header.php';
	$weblinks_submit->print_submit_form();
	include XOOPS_ROOT_PATH.'/footer.php';
}

exit();
// --- end of main ---

?>